/* Program tacg - a command line tool for Restriction Enzyme digests of DNA  */
/* Copyright  1996 Harry J Mangalam, University of California, Irvine (mangalam@uci.edu, 714 824 4824) */

/* The use of this software (except that by Harald T. Alvestrand, which is described in 'udping.c')
   is bound by the notice that appears in the file 'tacg.h' which should accompany this file.  In the event 
   that 'tacg.h' is not bundled with this file, please contact the author.
*/

#include <stdio.h>
#include <ctype.h>
#include <string.h> 
#include <stdlib.h>
#include "tacg.h" /* contains all the defines, includes, function prototypes for both main() and functions */

/* Usage() just spits out a few lines about how to use the program - shouldn't be more than 
        the smallest terminal screen that program is expected to see - say, 80x25. */
void Usage(void) {
fprintf (stderr, "Usage:   tacg -flag option -flag option ... <infile >outfile\n"
"tacg uses stdin/stdout/stderr; uses redirection or pipes for input and output;\n"
"needs input specifier (| or <); output to screen (default), >file, | nextcmd\n"
"NB: -L produces lots of output; DON'T pipe to lpr; you'll kill a forest!! \n"
"flag option    explanation (* = default; # = an integer)\n"
"-f   {0,1*}    form (or topology) of DNA - 0 (zero) for circular; 1 for linear\n"
"-n   {4*-8}    magnitude of recognition site; 4 = all, 5 = 5,6,7....\n"
"-o   {0,1*,3,5} overhang - 5=5', 3=3', 0 for blunt, 1(d) for all\n"
"-m/M {#}       minimum (-m) and/or Maximum (-M) # cuts/RE; 0* for all\n"
"-b   {#}       beginning of DNA subsequence; 1* for 1st base of sequence\n"
"-e   {#}       end of DNA subsequence; 0* for last base of sequence\n"
"-t/T {0,1*,3,6} frames of translation with 1 (-t) or 3 (-T) letter codes.\n"
"-w   {#}       output width in bp's (>=60, <=210, truncated to a # mod 15\n"
"-v             asks for version of the program\n"
"-h             asks for (this) brief help page\n"
"-q             (quiet) DISallows sending diagnostic info back to author\n"
"-C   {0*-7}    Codon Usage table to use for translation:\n"
"        0 - Universal;           1 - Mito_Vertebrates;  2 - Mito_Drosophila;\n"
"        3 - Mito_S_Cervisiae;    4 - Mito_S_Pombe;      5 - Mito_N_crassa;\n"
"        6 - Mito_Higher_Plants;  7 - Ciliates\n"
"-F   {0*,1,2,3} print/sort Fragments; 0*-omit; 1-unsorted; 2-sorted; 3-both\n"
"-L             print a Linear map\n"
"-g   {10,100}  prints a gel map w/ cutoff of 10 or 100 bp.\n"
"-l             prints a GCG-style ladder map.\n"
"-s             prints the the actual cut sites in tabular form\n"
"-R {alt rebase file} specifies alternative rebase file in GCG format\n"
"examples: tacg -f 0 -n 6 -t 3 -s -F 3 -l <input.seq.file >output.file (to file)\n"
"          tacg -f 0 -l  -n 5 -t 3 -F 2 <input.seq.file  (to stdout/screen)\n"
"          readseq -f=8 input.seq -p | tacg -m 3 -T 1 -s  |grep HindIII >out\n"
"          tail +49 bigseqfile.genbank | tacg -n 6 -F 2 -l -L >outfile\n"
"for more help, try 'man tacg'. Type 'Ctrl+C' if the program seems locked.\n\n");
}  



