/* Program tacg - a command line tool for Restriction Enzyme digests of DNA  */
/* Copyright  1996 Harry J Mangalam, University of California, Irvine (mangalam@uci.edu, 714 824 4824) */

/* The use of this software (except that by Harald T. Alvestrand, which is described in 'udping.c')
   is bound by the notice that appears in the file 'tacg.h' which should accompany this file.  In the event 
   that 'tacg.h' is not bundled with this file, please contact the author.
*/

#include <stdio.h>
#include <ctype.h>
#include <string.h> 
#include <stdlib.h>
#include "tacg.h" /* contains all the defines, includes, function prototypes for both main() and functions */

/* SearchPaths () takes a filename and examines various environment variables to locate that filename.  If it can 
   find the file, it returns the full path name; if not, it returns NULL */
char  *SearchPaths (char *InputFileName, char *FileType4Err){

   int i, File_Found;
   char *FileToFind, *tacglib;
   static char *Env_Vars[] = {"PWD",     "$PWD (Current Directory)",
                              "HOME",    "$HOME (Home Directory)", 
                              "TACGLIB", "$TACGLIB (TACG library)"};

  FileToFind = (char *) calloc (150, sizeof(char)); 

/* specify an alternative input file - this is constructed so that if the name starts */
/* with a '/', '~', or  '.' , assume it's a valid path name; otherwise 1st look in */
/* $PWD, then in $HOME, then in $TACGLIB */

/* 1st, see if it can be opened without any searching, regardless of what it starts with */
   strcpy(FileToFind, InputFileName);  
   if ((fopen(FileToFind,"r")) != NULL) { /* grab and check the next entry as the alt rebase file name */
   fprintf(stderr,"Found %s file \"%s\"!!\n",FileType4Err, FileToFind);
    File_Found = 1; 
  } else {  /* see if it's in either in the current directory $PWD (1st) $HOME (2nd) or $TACGLIB (3rd) */
      /* is it in $PWD ? */
      i=0;
      while (i < 5) {
         tacglib = getenv(Env_Vars[i++]);
         if (tacglib != NULL) { 
            strcpy(FileToFind, tacglib); /* should overwrite FileToFind with tacglib */
            strcat(FileToFind, "/"); /* to allow strcpy'ing the path and the file together correctly */
            strcat(FileToFind, InputFileName); /* copy the file name in behind it */
            if ((fopen(FileToFind,"r")) == NULL) { /* if ! here, print err and check next env var */
               fprintf(stderr,"Hmmm.. %s file \'%s' not found in %s.\n", FileType4Err, FileToFind, Env_Vars[i]);
               File_Found = 0;   
               i++;                                       
            } else {
               fprintf(stderr,"Found alternative %s file '%s' in %s.\n",FileType4Err, FileToFind, Env_Vars[i]);
               i=100; File_Found = 1;
            }
         } else fprintf(stderr, "Hmmm... %s isn't defined so I can't find it there!\n\n", Env_Vars[i++] );
      }
   }

   if (File_Found == 0) FileToFind = NULL;
   return FileToFind;
}
