;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; NOTE: This test was ported using port_passes_tests_to_lit.py and could be cleaned up.

;; RUN: foreach %s %t wasm-opt --code-pushing -tnh -S -o - | filecheck %s

(module
  ;; CHECK:      (type $0 (func (param i32 i32)))

  ;; CHECK:      (type $1 (func))

  ;; CHECK:      (func $div (param $x i32) (param $y i32)
  ;; CHECK-NEXT:  (local $temp i32)
  ;; CHECK-NEXT:  (block $block
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (local.get $y)
  ;; CHECK-NEXT:    (then
  ;; CHECK-NEXT:     (return)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $temp
  ;; CHECK-NEXT:    (i32.div_u
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (local.get $temp)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $div (param $x i32) (param $y i32)
    (local $temp i32)
    (block $block
      ;; This division might trap (if x is 0). But with tnh we can assume that
      ;; won't happen, and push it past the condition.
      (local.set $temp
        (i32.div_u
          (i32.const 1)
          (local.get $x)
        )
      )
      (if
        (local.get $y)
        (then
          (return)
        )
      )
      (drop
        (local.get $temp)
      )
    )
  )

  ;; CHECK:      (func $unreachable-value
  ;; CHECK-NEXT:  (local $x i32)
  ;; CHECK-NEXT:  (local.tee $x
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $unreachable-value
    (local $x i32)
    ;; We should not push this into the if. (If we did, we'd need to refinalize
    ;; the block, or we'd error; instead, leave this to DCE.)
    (local.set $x
      (unreachable)
    )
    (if
      (i32.const 0)
      (then
        (drop
          (local.get $x)
        )
      )
    )
  )
)
