# -*- coding: utf-8 -*-
r"""
Laue Monochromator
------------------

Bending of a single crystal Laue Monochromator
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Files in ``\examples\withRaycing\03_LaueMono``

This example shows the reflectivity of a bent 200-µm-thick Si111 Laue crystal
at various bending radii and energies. Watch how the band width is growing and
the flux is lowering in going to smaller radii.

+----------------+----------------+----------------+----------------+
|  *E* = 9 keV   |  *E* = 16 keV  |  *E* = 25 keV  |  *E* = 36 keV  |
+================+================+================+================+
|      |E09|     |      |E16|     |      |E25|     |      |E36|     |
+----------------+----------------+----------------+----------------+

.. |E09| animation:: _images/BentLaueSCM09keV
.. |E16| animation:: _images/BentLaueSCM16keV
.. |E25| animation:: _images/BentLaueSCM25keV
   :loc: upper-right-corner
.. |E36| animation:: _images/BentLaueSCM36keV
   :loc: upper-right-corner

Double bent-crystal Laue monochromator (beam cleaner)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

This example shows the beam images and rocking curves of a bent 200-µm-thick
Si111 double Laue crystal monochromator (similar to the *beam cleaner*
[Karanfil2004]_) at various bending radii and energies.

.. [Karanfil2004] C. Karanfil, D. Chapman, C. U. Segre and G. Bunker, *A device
   for selecting and rejecting X-ray harmonics in synchrotron radiation beams*,
   J. Synchrotron Rad. **11** (2004) 393-8.

Beam images at various detuning angles of the second crystal, *R* = 25 m, *E* ~
9 keV. Watch how the energy band becomes split and the flux goes down in going
away from the parallel positioning (*dθ* = 0).

.. animation:: _images/BentLaueDCM09keV

Flux vs. detuning angle of the second crystal (rocking curves)

+----------------+----------------+----------------+----------------+
|  *E* = 9 keV   |  *E* = 16 keV  |  *E* = 25 keV  |  *E* = 36 keV  |
+================+================+================+================+
|     |rc09|     |     |rc16|     |     |rc25|     |     |rc36|     |
+----------------+----------------+----------------+----------------+

.. |rc09| animation:: _images/BentLaueDCM_rc09keV
.. |rc16| animation:: _images/BentLaueDCM_rc16keV
.. |rc25| animation:: _images/BentLaueDCM_rc25keV
   :loc: upper-right-corner
.. |rc36| animation:: _images/BentLaueDCM_rc36keV
   :loc: upper-right-corner
"""
pass
