// StarPlot - A program for interactively viewing 3D maps of stellar positions.
// Copyright (C) 2000  Kevin B. McCarty
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


//
// gtkviewer.cc - wrapper class for the GTK GUI.
//

#include "gtkviewer.h"
#include <string>
using std::string;

// utility function to draw text; returns text width in pixels
unsigned int
GTKViewer::draw_text_helper(const char * text, unsigned int x, unsigned int y)
{
  PangoLayout *pl = gtk_widget_create_pango_layout (widget, text);
  int width, height;
  pango_layout_get_pixel_size (pl, &width, &height);
  gdk_draw_layout (pm, gc, x, y - height + 3, pl);
  g_object_unref (pl);
  return width;
}


void
GTKViewer::draw_text_with_greek(const string &text,
				unsigned int x, unsigned int y)
{
  int i = 1;
  string text2, text3 = text;
  
  while (i < NUM_GREEK_LETTERS && !
	 starstrings::compare_n(text, Greek[i].name, Greek[i].name.size()))
    i++;
  if (i < NUM_GREEK_LETTERS) {
    text2 = text.substr(Greek[i].name.size());
    x += draw_text_helper(Greek[i].utf8, x, y);
	
    // now check for superscript
    if (text2[0] == '(') {
      string superscript = text2.substr(text2.find_first_of('(') + 1);
      superscript = superscript.substr(0, superscript.find_first_of(')'));
      x += draw_text_helper(superscript, x, y - 5);
      text3 = text2.substr(text2.find_first_of(')') + 1);
    }
    else
      text3 = text2;
  }

  draw_text_helper(text3, x, y);
  return;
}

void
GTKViewer::drawtext_vertical(const std::string &text, unsigned int x,
                             unsigned int y)
{
  const char *posn, *ctext;
  int i = 0;

  if (!g_utf8_validate (text.c_str(), -1, 0))
    ctext = g_locale_to_utf8 (text.c_str(), -1, 0, 0, 0);
  else
    ctext = text.c_str();

  // print one Unicode character at a time
  for (posn = ctext; *posn; posn = g_utf8_find_next_char (posn, 0), i++) {
    char utf8char[8] = { 0 };
    g_utf8_strncpy (utf8char, posn, 1);
    draw_text_helper(std::string(utf8char), x, y + 16 * i);
  }
}

void
GTKViewer::drawstar(unsigned int xc, unsigned int yc, int radius)
{
  // GDK's small circles are very ugly, hence this function will make
  // its own antialiased circles for stars with radius < 6 pixels.
  if (radius <= 0) return;
  else {
    static GdkGC *border_gc = gdk_gc_new (pm);
    color_t border_color = DIM(drawing_color);
    gdk_rgb_gc_set_foreground(border_gc, border_color);
    gdk_rgb_gc_set_background(border_gc, border_color);

    switch (radius) {
      case 1:
	gdk_draw_rectangle (pm, border_gc, true, xc - 1, yc - 1, 3, 3);
	gdk_draw_line (pm, gc, xc, yc - 1, xc, yc + 1);
	gdk_draw_line (pm, gc, xc - 1, yc, xc + 1, yc);
	break;
      case 2:
	gdk_draw_rectangle (pm, border_gc, true, xc - 2, yc - 1, 5, 3);
	gdk_draw_rectangle (pm, border_gc, true, xc - 1, yc - 2, 3, 5);
	gdk_draw_rectangle (pm, gc, true, xc - 1, yc - 1, 3, 3);
	break;
      case 3:
	gdk_draw_rectangle (pm, border_gc, true, xc - 3, yc - 1, 7, 3);
	gdk_draw_rectangle (pm, border_gc, true, xc - 1, yc - 3, 3, 7);
	gdk_draw_rectangle (pm, border_gc, true, xc - 2, yc - 2, 5, 5);
	gdk_draw_rectangle (pm, gc, true, xc - 2, yc - 1, 5, 3);
	gdk_draw_rectangle (pm, gc, true, xc - 1, yc - 2, 3, 5);
	break;
      default:
	gdk_draw_arc (pm, gc, true, xc - radius, yc - radius,
		      radius * 2, radius * 2, /*angle1*/ 0, /*angle2*/ 360*64);
	gdk_draw_arc (pm, border_gc, false, xc - radius, yc - radius,
		      radius * 2, radius * 2, /*angle1*/ 0, /*angle2*/ 360*64);
    }
  }
}

