
#include <ctype.h> 
#include <fli.h>
#include <stdio.h>
#include <string.h> 

int fli_lookup_color (char const *col, int *r, int *g, int *b)
{
    register FILE
	*f;
    char
	buf [200];
    register int
	ret;
    int
	red, green, blue;
    register char
	*cp;

    /* try to open the file */ 
    if (! (f = fopen (FLI_RGB_DATABASE, "r")) )
	return (1);

    /* assume color not found */
    ret = 2;

    while (1)
    {
	fgets (buf, 199, f);
	if (feof (f))
	    break;

	/* scan for RGB components */ 
	if (sscanf (buf, "%d %d %d", &red, &green, &blue) < 3)
	    continue;

	/* advance to first character */ 
	cp = buf;
	while (! isalpha (*cp) && *cp)
	    cp++;
	if (! *cp)
	    continue;

	if (! strncmp (col, cp, strlen (col)) )
	{
	    *r = red;
	    *g = green;
	    *b = blue;
	    ret = 0;
	    break;
	}
    }

    /* close the file, return */
    fclose (f);
    return (ret);
}
