
/*
 * procps.c
 *
 * Lawrence Kesteloot
 * June 8th, 1994
 *
 * Quicky replacement for "ps" -- This uses the /proc filesystem
 *
 * Make sure to have this line in your /etc/fstab:
 *
 *    proc		/proc	procfs	rw	0	0
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>

#define MAXPROC 256

#define MAJOR(x)		((x) >> 8)
#define MINOR(x)		((x) & 0xff)

struct process {
	char	name[128];
	int	pid;
	int	ppid;
	int	gid;
	int	pgid;
	int	ttymajor;
	int	ttyminor;
	char	tty[32];
} p[MAXPROC];

int nump;

int main (int argc, char *argv[])
{
	DIR		*dirp;
	struct dirent	*dp;
	FILE		*f;
	char		fn[128], buf[512];
	int		i, j;
	struct process	tempp;
	struct stat	st;

	nump = 0;

	dirp = opendir ("/proc");
	if (dirp == NULL) {
		fprintf (stderr, "/proc does not exist.\n");
		exit (1);
	}

	/*
	 * Get a list of processes.
	 */

	for (dp = readdir (dirp); dp != NULL; dp = readdir (dirp)) {
		if (isdigit (dp->d_name[0])) {
			sprintf (fn, "/proc/%s/status", dp->d_name);
			f = fopen (fn, "r");
			if (f == NULL) {
				/* Process died */
				continue;
			}
			fgets (buf, 512, f);
			sscanf (buf, "%s %d %d %d %d %d,%d",
				p[nump].name,
				&p[nump].pid,
				&p[nump].ppid,
				&p[nump].gid,
				&p[nump].pgid,
				&p[nump].ttymajor,
				&p[nump].ttyminor);
			fclose (f);
			strcpy (p[nump].tty, "<none>");
			nump++;
		}
	}
	closedir (dirp);

	/*
	 * Find the tty name.
	 */

	dirp = opendir ("/dev");
	for (dp = readdir (dirp); dp != NULL; dp = readdir (dirp)) {
		sprintf (fn, "/dev/%s", dp->d_name);
		stat (fn, &st);
		if (S_ISCHR (st.st_mode)) {
			for (i = 0; i < nump; i++) {
				if (p[i].ttymajor == MAJOR (st.st_rdev) &&
				    p[i].ttyminor == MINOR (st.st_rdev)) {
					sprintf (p[i].tty, "/dev/%s",
						dp->d_name);
				}
			}
		}
	}

	/*
	 * Sort by process ID.
	 */

	for (i = 0; i < nump - 1; i++) {
		for (j = i + 1; j < nump; j++) {
			if (p[j].pid < p[i].pid) {
				tempp = p[i];
				p[i] = p[j];
				p[j] = tempp;
			}
		}
	}

	/*
	 * Print out.
	 */

	printf ("%-8s%-8s%-8s%-8s%-15s%s\n",
		"pid", "ppid", "gid", "pgid", "tty", "name");
	for (i = 0; i < nump; i++) {
		printf ("%-8d%-8d%-8d%-8d%-15s%s\n",
			p[i].pid,
			p[i].ppid,
			p[i].gid,
			p[i].pgid,
			p[i].tty,
			p[i].name);
	}

	return 0;
}
