/*	$OpenBSD: cosh.c,v 1.1 2009/04/09 01:24:43 martynas Exp $	*/

/*
 * Copyright (c) 2009 Gaston H. Gonnet <gonnet@inf.ethz.ch>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/* This program was generated automatically by a program written
   by Gaston H. Gonnet on enigma on 2002-09-01 17:29:13.
   Do not edit, rerun the original maple program.       */
#include "header.h"
#define DBL_MAX_EXP 1024
#define N 1331
#define F cosh
#define Fs "cosh"
#define Fn fpaccuracy_cosh

static struct input_point { double arg_m, val, eps;
	int arg_e, val_e; } input_points[N] = {
 -6243314768165360.,4503599627370901.,.052842325082602236839,-43,-971,
 -6243314768165359.,9007199254740778.,.105684650131313781083,-43,-970,
 -6243314768165349.,9007199254730538.,.105684656195249555615,-43,-970,
 -6243314768164400.,9007199253758762.,.105738205931081010647,-43,-970,
 -6243314768069474.,9007199156554539.,-.359155672558888708604,-43,-970,
 -6243314758582472.,9007189441869835.,.413784844360260244941,-43,-970,
 -6243313862843034.,9006272252385836.,-.210060427227841147163,-43,-970,
 -6118372863830534.,6402687238285444.,-.310642431481599566121,-43,-950,
 -6118372863822594.,6402687232505908.,-.352461194469589299637,-43,-950,
 -6118372863767014.,6402687192049156.,-.499115584326286594129,-43,-950,
 -6118372863763044.,6402687189159388.,-.499808959225495233590,-43,-950,
 -6118372863762882.,6402687189041467.,.496160216884263055050,-43,-950,
 -5516350644834823.,7662101879271875.,.499424903300491283096,-43,-851,
 -5516350644834773.,7662101879228321.,.492777263542115118884,-43,-851,
 -5516350644834698.,7662101879162990.,.482806268109296421721,-43,-851,
 -5516350644834224.,7662101878750098.,.499802462109254259076,-43,-851,
 -5516350644833625.,7662101878228322.,-.499784446894911288826,-43,-851,
 -5516350644828209.,7662101873510552.,-.497775217567062928445,-43,-851,
 -5516350644795713.,7662101845203932.,-.424717725499005689058,-43,-851,
 -5516350644793005.,7662101842845047.,-.413909199326120865122,-43,-851,
 -5353889512863459.,4896010505527014.,.499931061075717776903,-43,-825,
 -5353889512862356.,4896010504913072.,-.482893615934384168089,-43,-825,
 -5353889512862338.,4896010504903053.,-.498025202518124182633,-43,-825,
 -5353889512862271.,4896010504865760.,-.498792594613803975758,-43,-825,
 -5353889512862137.,4896010504791173.,.499673473379225037899,-43,-825,
 -5353889512859560.,4896010503356785.,-.499754310408817377501,-43,-825,
 -4789820378197109.,6847422516035807.,-.496279424116389755772,-43,-732,
 -4789820378187930.,6847422508890306.,-.468496419274235698843,-43,-732,
 -4789820378187917.,6847422508880186.,-.472046945985701388315,-43,-732,
 -4789820378187826.,6847422508809346.,-.496900214179883909873,-43,-732,
 -4789820378187813.,6847422508799225.,.499549378761815344603,-43,-732,
 -4789820378185561.,6847422507046130.,-.499880039932849993094,-43,-732,
 -4789820378184435.,6847422506169582.,-.499426437102531297762,-43,-732,
 -4789820378147539.,6847422477447455.,-.427814539214933615434,-43,-732,
 -4679751055989864.,6600123655966303.,-.499211191499061609455,-43,-714,
 -4679751055986736.,6600123653619217.,-.499787545775505563939,-43,-714,
 -4679751055985581.,6600123652752565.,.499571246965473390749,-43,-714,
 -4679751055985558.,6600123652735308.,-.485721751323911721835,-43,-714,
 -4667961105458214.,6910351832381160.,.499884959787066895968,-43,-712,
 -4667961105457628.,6910351831920789.,.496143122121442396614,-43,-712,
 -4667961105457602.,6910351831900363.,.478912966187662657582,-43,-712,
 -4667961105457581.,6910351831883866.,-.458080577220753570850,-43,-712,
 -4667961105457516.,6910351831832800.,.498844419005444226398,-43,-712,
 -4667961105456357.,6910351830922272.,-.499921912389501383825,-43,-712,
 -4667961105442660.,6910351820161689.,-.490060542468160265146,-43,-712,
 -4630681347717618.,6383304230100903.,.450513143503157357442,-43,-706,
 -4630681347717598.,6383304230086389.,.497070456272426550262,-43,-706,
 -4630681347717555.,6383304230055184.,.497168790475684752598,-43,-706,
 -4630681347716523.,6383304229306264.,.499574575364982797645,-43,-706,
 -4630681347716308.,6383304229150240.,-.499913159813731196283,-43,-706,
 -4630681347706127.,6383304221761912.,-.494545358061482981754,-43,-706,
 -4630681347695946.,6383304214373584.,-.480625967884703003663,-43,-706,
 -8965037602643141.,5181459806963614.,.499936680711823015527,-44,-682,
 -8965037602641776.,5181459806561578.,.469941652698040120671,-44,-682,
 -8965037602641761.,5181459806557160.,.491590232265368774472,-44,-682,
 -8965037602641479.,5181459806474102.,.498584229244239965489,-44,-682,
 -8965037602641432.,5181459806460259.,.499750024849701342919,-44,-682,
 -8965037602638845.,5181459805698306.,-.499854353763673527851,-44,-682,
 -8965037602614825.,5181459798623650.,-.493923468254210366008,-44,-682,
 -8361959343273779.,7549004931347942.,-.494824431996516161606,-44,-632,
 -8361959343253177.,7549004922507392.,-.447621765943794848108,-44,-632,
 -8361959343253168.,7549004922503530.,-.448860896458781934253,-44,-632,
 -8361959343252925.,7549004922399256.,-.482316673524570694213,-44,-632,
 -8361959343252799.,7549004922345188.,-.499663546440287736692,-44,-632,
 -8361959343251990.,7549004921998037.,-.499921148041403441250,-44,-632,
 -8361959343226165.,7549004910916239.,-.491102939573283629392,-44,-632,
 -7077148271408190.,5863905218312725.,-.497003479166242162052,-44,-527,
 -7077148271394652.,5863905213800179.,-.499788067571862706063,-44,-527,
 -7077148271391548.,5863905212765539.,.499915126306432632908,-44,-527,
 -7077148271390426.,5863905212391550.,-.499502910037378052181,-44,-527,
 -7077148271390423.,5863905212390550.,-.472763354096814765575,-44,-527,
 -7077148271357703.,5863905201484175.,-.489863158091418680805,-44,-527,
 -6650655769588343.,5963605207559906.,-.497762802347218115742,-44,-492,
 -6650655769577971.,5963605204043884.,-.499713533002672323069,-44,-492,
 -6650655769573147.,5963605202408587.,.498542848959435654476,-44,-492,
 -6650655769573057.,5963605202378078.,.244783236541543828666,-44,-492,
 -6650655769573027.,5963605202367908.,.493530067087252365114,-44,-492,
 -6650655769573026.,5963605202367570.,-.498178371595880911404,-44,-492,
 -6650655769572785.,5963605202285873.,-.499911532314636958982,-44,-492,
 -6650655769556624.,5963605196807428.,-.497397506920443730156,-44,-492,
 -6524937861114491.,4811030367099833.,-.498812457306522441544,-44,-482,
 -6524937861106824.,4811030365003097.,-.499863603088138426717,-44,-482,
 -6524937861103021.,4811030363963070.,-.499915519627393003794,-44,-482,
 -6524937861102960.,4811030363946387.,.499822529372608340673,-44,-482,
 -6524937861102289.,4811030363762885.,.496944886075146520305,-44,-482,
 -6524937861102167.,4811030363729521.,.496422430174589875289,-44,-482,
 -6524937861102146.,4811030363723779.,-.487274034794927492823,-44,-482,
 -6524937861102127.,4811030363718582.,.479857740901762248035,-44,-482,
 -6250030537099773.,6597061091649786.,-.459285167053900089665,-44,-459,
 -6250030537037968.,6597061068472941.,.058524283471882303532,-44,-459,
 -6250030537037790.,6597061068406191.,.146533955568613899645,-44,-459,
 -6250030537037110.,6597061068151191.,.482756898810139621408,-44,-459,
 -6250030537037075.,6597061068138067.,-.499937241803389384847,-44,-459,
 -6250030537020895.,6597061062070575.,-.496889421661624170892,-44,-459,
 -6114225761932221.,5999256403094332.,-.493702362490013106137,-44,-448,
 -6114225761915284.,5999256397318506.,-.499279896875015031476,-44,-448,
 -6114225761909145.,5999256395224994.,.499658217545351897029,-44,-448,
 -6114225761906788.,5999256394421214.,.498304357100496170941,-44,-448,
 -6114225761906734.,5999256394402800.,-.486876013798068521997,-44,-448,
 -6114225761906733.,5999256394402458.,.494879905792443144576,-44,-448,
 -6114225761906514.,5999256394327775.,.499426763090545280546,-44,-448,
 -6075304253400759.,5252191711062859.,-.494233000438651572890,-44,-445,
 -6075304253374880.,5252191703336618.,-.499611939659861567396,-44,-445,
 -6075304253374699.,5252191703282579.,.491928003975111213591,-44,-445,
 -6075304253374661.,5252191703271234.,.495676792038614483641,-44,-445,
 -6075304253374623.,5252191703259889.,.499425604607875961178,-44,-445,
 -6075304253372748.,5252191702700104.,-.499780181330064558198,-44,-445,
 -6075304253370616.,5252191702063590.,-.499871283761013811893,-44,-445,
 -5883024195997067.,6166580717660834.,-.498314403528208425391,-44,-429,
 -5883024195984673.,6166580713316371.,-.499944903826193310669,-44,-429,
 -5883024195984182.,6166580713144261.,-.499381679174957887932,-44,-429,
 -5883024195984148.,6166580713132342.,.496584180202394531343,-44,-429,
 -5883024195984131.,6166580713126383.,.494567118528686956018,-44,-429,
 -5883024195981202.,6166580712099683.,-.499933600272112167959,-44,-429,
 -5883024195912290.,6166580687943992.,-.448574415199830178213,-44,-429,
 -5701287883562775.,6591881948312705.,-.492708360004144215670,-44,-414,
 -5701287883540723.,6591881940049708.,-.499792907638473437075,-44,-414,
 -5701287883537237.,6591881938743486.,-.499874044743543922602,-44,-414,
 -5701287883536630.,6591881938516040.,-.499287990476483769399,-44,-414,
 -5701287883536613.,6591881938509670.,-.486091892458462709398,-44,-414,
 -5701287883536596.,6591881938503300.,-.472895788284880572856,-44,-414,
 -5701287883520414.,6591881932439822.,-.497200746879446292406,-44,-414,
 -5696749128557056.,5092864957438880.,.499951718012481167348,-44,-414,
 -5696749128555741.,5092864957058193.,.449355889268833146346,-44,-414,
 -5696749128555729.,5092864957054719.,.499084423374689393391,-44,-414,
 -5696749128555608.,5092864957019691.,-.499486058645252253954,-44,-414,
 -5696749128553557.,5092864956425934.,.499988127114343030313,-44,-414,
 -5696749128539561.,5092864952374151.,-.497851536290372317378,-44,-414,
 -5696749128536062.,5092864951361205.,-.496807777094792211208,-44,-414,
 -5638498817029594.,5944280983562912.,-.461940763534553940796,-44,-409,
 -5638498816970164.,5944280963481916.,-.499870303108722805995,-44,-409,
 -5638498816966651.,5944280962294897.,-.496253375373954018788,-44,-409,
 -5638498816966642.,5944280962291855.,.464473530902303902777,-44,-409,
 -5638498816966548.,5944280962260093.,.498732422768788623912,-44,-409,
 -5638498816966370.,5944280962199948.,.499776321266437917475,-44,-409,
 -5638498816965377.,5944280961864420.,.499993056834717467497,-44,-409,
 -5505190638565440.,6229872943225625.,-.482304839692664955083,-44,-398,
 -5505190638524914.,6229872928874262.,.499982869455655179976,-44,-398,
 -5505190638524804.,6229872928835308.,.499584974303608508908,-44,-398,
 -5505190638523704.,6229872928445768.,.495619419168435080956,-44,-398,
 -5505190638523539.,6229872928387337.,.495026686694943640457,-44,-398,
 -5505190638523515.,6229872928378838.,.440395062171379210993,-44,-398,
 -5505190638519862.,6229872927085212.,-.499858261266539026145,-44,-398,
 -5420430315892106.,6445096941756021.,-.499887944696836659661,-44,-391,
 -5420430315891987.,6445096941712424.,-.499949788521320029530,-44,-391,
 -5420430315889369.,6445096940753289.,.498764258583781058100,-44,-391,
 -5420430315888785.,6445096940539334.,.473286786950168772534,-44,-391,
 -5420430315888774.,6445096940535304.,.498491902724077983987,-44,-391,
 -5220990584968046.,5037139715523998.,-.497624887315354518478,-44,-375,
 -5220990584951415.,5037139710762073.,-.499883057743929156024,-44,-375,
 -5220990584951022.,5037139710649546.,-.499160429171066417032,-44,-375,
 -5220990584950955.,5037139710630362.,-.491403394353753353718,-44,-375,
 -5220990584950946.,5037139710627785.,-.445585279632839246421,-44,-375,
 -5220990584950891.,5037139710612037.,-.498918994359488672419,-44,-375,
 -5220990584947290.,5037139709580969.,-.499806524151255929048,-44,-375,
 -5220990584934915.,5037139706037657.,-.497915258136391633900,-44,-375,
 -4674746968038891.,5801443769053527.,-.498217306259717154212,-44,-330,
 -4674746968027980.,5801443765455364.,-.499944166214375475228,-44,-330,
 -4674746968025689.,5801443764699851.,.499885077417835483953,-44,-330,
 -4674746968025145.,5801443764520454.,.499422495561364356793,-44,-330,
 -4674746968025092.,5801443764502976.,.482833606759471419698,-44,-330,
 -8493093674416151.,5354293373536599.,.499972783745731756131,-45,-295,
 -8493093674414282.,5354293373252178.,.499376029405043844147,-45,-295,
 -8493093674413833.,5354293373183851.,-.499159944911752283629,-45,-295,
 -8493093674413805.,5354293373179590.,-.487932760751850663825,-45,-295,
 -8493093674405908.,5354293371977839.,-.499901942939061814747,-45,-295,
 -8493093674272749.,5354293351713946.,-.456978311836164101139,-45,-295,
 -7542952159268998.,5506849710981740.,-.499976920203892214192,-45,-256,
 -7542952159265802.,5506849710481520.,.492815481075281434009,-45,-256,
 -7542952159265798.,5506849710480894.,.436486088270032388170,-45,-256,
 -7542952159265767.,5506849710476042.,.499933296442608073282,-45,-256,
 -7402687662027206.,6542497797107338.,-.499680417798739116234,-45,-250,
 -7402687662026912.,6542497797052669.,-.497253691651403634783,-45,-250,
 -7402687662026716.,6542497797016223.,-.495635620434740547729,-45,-250,
 -7402687662026696.,6542497797012504.,-.475062336446038375745,-45,-250,
 -7402687662026677.,6542497797008970.,.494482285301316605365,-45,-250,
 -7402687662025991.,6542497796881410.,-.499852725199635071252,-45,-250,
 -7402687662024776.,6542497796655481.,.499982769230336142870,-45,-250,
 -7402687661955560.,6542497783784838.,-.486630193867293102687,-45,-250,
 -5533987403460993.,8490909837316888.,-.499784051037183453974,-45,-173,
 -5533987403453592.,8490909835530832.,.499981351907065240409,-45,-173,
 -5533987403453267.,8490909835452401.,.494034518682252858641,-45,-173,
 -5533987403453233.,8490909835444196.,.404181661066307329550,-45,-173,
 -5533987403453221.,8490909835441300.,.490115948506677718780,-45,-173,
 -5533987403453080.,8490909835407273.,.499843899914579910492,-45,-173,
 -5533987403424500.,8490909828510172.,-.497164798278943750606,-45,-173,
 -8816008732654722.,7548914371931220.,-.499821982338286642100,-46,-127,
 -8816008732643233.,7548914370698719.,.499992327200145713941,-46,-127,
 -8816008732639906.,7548914370341811.,-.499936832272867950318,-46,-127,
 -8816008732639143.,7548914370259959.,-.488797077144212128527,-46,-127,
 -8816008732639114.,7548914370256847.,.491967098814853837992,-46,-127,
 -8816008732639020.,7548914370246763.,.498582022805599080446,-46,-127,
 -7458231406760163.,8451538560158338.,-.499427954995625163088,-46,-99,
 -7458231406760134.,8451538560154854.,.496560693929822678536,-46,-99,
 -7458231406760076.,8451538560147888.,.488537996086910727849,-46,-99,
 -7458231406760066.,8451538560146687.,.452672014280505141608,-46,-99,
 -7458231406759912.,8451538560128192.,-.499664083984990986160,-46,-99,
 -7458231406759661.,8451538560098046.,-.499900105445848979805,-46,-99,
 -7458231406713043.,8451538554499057.,-.498046854650079490535,-46,-99,
 -7458231406624045.,8451538543810078.,-.484208827243449380332,-46,-99,
 -7247003435980301.,6720800171728859.,-.499794224686711002082,-46,-95,
 -7247003435965027.,6720800170270064.,.499950909350490044688,-46,-95,
 -7247003435963223.,6720800170097768.,-.499927343560740695300,-46,-95,
 -7247003435962802.,6720800170057558.,.499547380554647844326,-46,-95,
 -7247003435962501.,6720800170028810.,.496796677580991686919,-46,-95,
 -7247003435962491.,6720800170027855.,.413648815805354899755,-46,-95,
 -7247003435962381.,6720800170017349.,.499022345231231825374,-46,-95,
 -7247003435940312.,6720800167909577.,-.499659843595399461720,-46,-95,
 -5622313485444599.,5423987981236720.,-.499960449850076872159,-46,-62,
 -5622313485435543.,5423987980538688.,-.498810733235236617831,-46,-62,
 -5622313485435467.,5423987980532829.,.458796468700884263015,-46,-62,
 -5622313485435455.,5423987980531905.,-.495265551467690956038,-46,-62,
 -5622313485435304.,5423987980520265.,.499454041557854902704,-46,-62,
 -5622313485432474.,5423987980302130.,.499832491487752396629,-46,-62,
 -5622313485431342.,5423987980214876.,.499986327808417314346,-46,-62,
 -5622313485391005.,5423987977105721.,-.498916187336958533550,-46,-62,
 -7183204151116525.,6992709483144679.,.490568203648402927683,-47,-20,
 -7183204151116474.,6992709483142145.,.494915674206994197569,-47,-20,
 -7183204151116423.,6992709483139611.,.499263145683846691165,-47,-20,
 -7183204151116184.,6992709483127737.,-.499971240454677817845,-47,-20,
 -7183204151112274.,6992709482933464.,-.499995363447746245753,-47,-20,
 -4831095367903619.,6473146689471517.,.127793186259825304625,-47,4,
 -4831095367903554.,6473146689468527.,.487010673157346082388,-47,4,
 -4831095367903552.,6473146689468435.,.498063518929935325584,-47,4,
 -4831095367902647.,6473146689426810.,.499476365155271459188,-47,4,
 -4831095367902285.,6473146689410161.,-.499958421408147584546,-47,4,
 -4831095367895228.,6473146689085578.,-.499981050654600833709,-47,4,
 -4831095367863381.,6473146687620792.,-.499739014126657974824,-47,4,
 -6476946479458197.,5164231957494715.,-.499971424297302422332,-48,20,
 -6476946479431125.,5164231956998024.,-.499577717051919811588,-48,20,
 -6476946479431004.,5164231956995804.,-.491116925767321788154,-48,20,
 -6476946479430955.,5164231956994905.,-.495955117454969437396,-48,20,
 -6476946479430906.,5164231956994005.,.499206691013884345874,-48,20,
 -6476946479429471.,5164231956967678.,-.499625991566088971192,-48,20,
 -6476946479417893.,5164231956755256.,-.499958920238474981898,-48,20,
 -6476946479417066.,5164231956740083.,-.499982366510154472168,-48,20,
 -7016733804641895.,8895966829730461.,-.499999915786940342698,-49,36,
 -7016733804640817.,8895966829713426.,-.499619104102476182469,-49,36,
 -7016733804640665.,8895966829711024.,-.466170230072081369472,-49,36,
 -7016733804640655.,8895966829710866.,-.490285435705239162919,-49,36,
 -7016733804640650.,8895966829710786.,.497656961479234592425,-49,36,
 -5544508544501175.,5206157935361732.,-.499969325610191050605,-49,39,
 -5544508544423899.,5206157934647083.,.499977868442926974880,-49,39,
 -5544508544423649.,5206157934644772.,-.498572792815051966053,-49,39,
 -5544508544423641.,5206157934644698.,-.482526413958353866708,-49,39,
 -5544508544423609.,5206157934644402.,-.418340898521047717106,-49,39,
 -5263775657348749.,6323719379597360.,-.470027310482980373433,-49,40,
 -5263775657348736.,6323719379597213.,.498606681722017066643,-49,40,
 -5263775657348067.,6323719379589698.,.499848285131311020010,-49,40,
 -5263775657343221.,6323719379535262.,.499873679012219480850,-49,40,
 -5263775657318991.,6323719379263083.,-.499992322622894839843,-49,40,
 -5067862284394044.,8930234663656590.,.499995606377145566166,-49,41,
 -5067862284384784.,8930234663509696.,.499960479970874909384,-49,41,
 -5067862284382341.,8930234663470942.,.499735632922062291455,-49,41,
 -5067862284381829.,8930234663462820.,.498869865581824379756,-49,41,
 -5067862284381690.,8930234663460616.,-.497458925448497452657,-49,41,
 -5067862284380154.,8930234663436249.,.499943822868588304999,-49,41,
 -4925871372206596.,6939405823318554.,-.499995518781840901042,-49,41,
 -4925871372192795.,6939405823148430.,.499947709628118238307,-49,41,
 -4925871372192486.,6939405823144622.,-.499908596699585792012,-49,41,
 -4925871372192477.,6939405823144511.,-.441651984231194158455,-49,41,
 -4925871372185740.,6939405823061464.,.499992757746818098815,-49,41,
 -4837866588169186.,5935126035485938.,-.499993263951866015864,-49,41,
 -4837866588169046.,5935126035484461.,.493866430238402972835,-49,41,
 -4837866588169022.,5935126035484208.,.464242377850734273209,-49,41,
 -4837866588169011.,5935126035484092.,.492331353843324583998,-49,41,
 -4720078277082580.,4814605977661064.,-.499591692314027817399,-49,41,
 -4720078277082475.,4814605977660165.,.492384944428820681259,-49,41,
 -4720078277082437.,4814605977659840.,.499005060624652631555,-49,41,
 -4720078277081827.,4814605977654624.,-.499987807965981414189,-49,41,
 -4720078277054033.,4814605977416917.,-.499994580985302454763,-49,41,
 -8886660217099020.,5889658259297368.,-.499983226646116811914,-50,42,
 -8886660217069721.,5889658259144103.,-.499985700454732947754,-50,42,
 -8886660217066869.,5889658259129184.,-.499951597388308251441,-50,42,
 -8886660217061165.,5889658259099346.,-.499883277882148743476,-50,42,
 -8886660217059633.,5889658259091332.,-.492852279920161358304,-50,42,
 -8886660217059607.,5889658259091195.,.499434147032303889573,-50,42,
 -8757940169999925.,5253379812529674.,-.499989862074179850822,-50,42,
 -8757940169988505.,5253379812476389.,-.499899795882797669859,-50,42,
 -8757940169979369.,5253379812433761.,-.499827353791426496010,-50,42,
 -8757940169978911.,5253379812431624.,-.498948056324255866046,-50,42,
 -8757940169978827.,5253379812431232.,-.437651416519781518911,-50,42,
 -8757940169978782.,5253379812431022.,-.404813930898213190356,-50,42,
 -8757940169978456.,5253379812429500.,.499742076299759835947,-50,42,
 -8757940169946480.,5253379812280302.,.499998468573146342210,-50,42,
 -8535358698054710.,8622084258793145.,.499996354223268948421,-50,43,
 -8535358698045843.,8622084258725243.,-.499971277788210110529,-50,43,
 -8535358698042709.,8622084258701242.,.499814735005290455779,-50,43,
 -8535358698041256.,8622084258690116.,-.494540993257455123318,-50,43,
 -8535358698041218.,8622084258689825.,-.496458073363453460650,-50,43,
 -8535358698041142.,8622084258689242.,.499707766454014505024,-50,43,
 -8298192411034277.,6984413385311917.,-.443345330560915994008,-50,43,
 -8298192411034262.,6984413385311824.,-.494350184690992684306,-50,43,
 -8298192411033967.,6984413385309994.,-.497445648997235158822,-50,43,
 -8298192411033731.,6984413385308530.,-.499922020097000434391,-50,43,
 -8298192411030496.,6984413385288462.,-.499968855721708558133,-50,43,
 -8298192411027261.,6984413385268393.,.499984366314154422573,-50,43,
 -8298192410964267.,6984413384877617.,-.499987673867993010854,-50,43,
 -8244336335603565.,6658187117794335.,-.499998026974882675680,-50,43,
 -8244336335567397.,6658187117580450.,-.499956142442522292937,-50,43,
 -8244336335566899.,6658187117577505.,-.499126055269460167009,-50,43,
 -8244336335566760.,6658187117576683.,-.496886331910311528174,-50,43,
 -8244336335566749.,6658187117576617.,.452931200158414745977,-50,43,
 -8244336335566540.,6658187117575381.,.499464309584966251892,-50,43,
 -8244336335551774.,6658187117488060.,.499981128532153307136,-50,43,
 -7846976255498413.,4678235656827312.,-.499993475066582938084,-50,43,
 -7846976255478484.,4678235656744504.,.499989113575786961077,-50,43,
 -7846976255461437.,4678235656673672.,.499925205110035804958,-50,43,
 -7846976255461276.,4678235656673004.,-.471272671473240893186,-50,43,
 -7846976255461263.,4678235656672950.,-.487580574547219740324,-50,43,
 -7846976255461250.,4678235656672895.,.496111522379425103186,-50,43,
 -7846976255461192.,4678235656672655.,-.499723737478714594719,-50,43,
 -7846976255458555.,4678235656661697.,.499973167946691271905,-50,43,
 -7668040568180572.,7981622708436956.,-.499992768334469692776,-50,44,
 -7668040568132204.,7981622708094071.,-.499874834787749295621,-50,44,
 -7668040568132103.,7981622708093355.,-.497745066000217241006,-50,44,
 -7668040568132081.,7981622708093199.,-.457677195562730846948,-50,44,
 -7668040568132058.,7981622708093035.,.493302850806990583270,-50,44,
 -7668040568127512.,7981622708060809.,-.499945310030979594104,-50,44,
 -7668040568125166.,7981622708044178.,-.499980495672280219249,-50,44,
 -7570200877287364.,7317310673969412.,.499940197920420767722,-50,44,
 -7570200877285771.,7317310673959059.,.499513750256290874208,-50,44,
 -7570200877285769.,7317310673959047.,-.498603545965091232172,-50,44,
 -7570200877285665.,7317310673958371.,-.400702949445143624127,-50,44,
 -7570200877285573.,7317310673957773.,-.314098575548531165897,-50,44,
 -7570200877280459.,7317310673924536.,.499975067674809930545,-50,44,
 -7570200877273554.,7317310673879661.,-.499989787351242384747,-50,44,
 -7570200877217252.,7317310673513751.,-.499982596433817056522,-50,44,
 -6983805627860130.,8693443238858879.,-.499999777736651329992,-50,45,
 -6983805627814549.,8693443238506936.,-.499985975502782471731,-50,45,
 -6983805627809207.,8693443238465689.,-.499961486161464661123,-50,45,
 -6983805627808859.,8693443238463001.,.499665724351755489322,-50,45,
 -6983805627808737.,8693443238462060.,-.494717839582050836700,-50,45,
 -6983805627808730.,8693443238462005.,.456424087080581215658,-50,45,
 -6967621294077025.,8569373569964147.,-.499987556201778515528,-50,45,
 -6967621294030063.,8569373569606716.,-.499880270604314005407,-50,45,
 -6967621294030027.,8569373569606442.,-.498347028177551531034,-50,45,
 -6967621294029523.,8569373569602606.,-.476881633282970130698,-50,45,
 -6967621294029433.,8569373569601921.,-.473048526871098910096,-50,45,
 -6967621294029428.,8569373569601882.,.471608867931166112560,-50,45,
 -6967621294028762.,8569373569596813.,.499973857103351595205,-50,45,
 -6967621294022239.,8569373569547167.,-.499988710565340841186,-50,45,
 -6615287761648223.,6266783723389420.,-.499996258475112666570,-50,45,
 -6615287761647859.,6266783723387393.,.499904710498979334389,-50,45,
 -6615287761645857.,6266783723376250.,.499360051564788477096,-50,45,
 -6615287761645675.,6266783723375237.,.499310538098740620482,-50,45,
 -6615287761645638.,6266783723375032.,-.440259967366086183267,-50,45,
 -6615287761645622.,6266783723374943.,-.495209375132563841071,-50,45,
 -6585707430242324.,6104285548305327.,-.484754324661005523709,-50,45,
 -6585707430242305.,6104285548305224.,-.495242300591960298266,-50,45,
 -6585707430242203.,6104285548304671.,-.498914592402106739956,-50,45,
 -6585707430241916.,6104285548303115.,-.499443491638321979953,-50,45,
 -6585707430241629.,6104285548301559.,-.499972390477894883143,-50,45,
 -6585707430239722.,6104285548291219.,.499997619292524000618,-50,45,
 -5638731028508581.,5265049803090430.,-.499990232746871232479,-50,46,
 -5638731028505110.,5265049803074199.,.499943937144628112642,-50,46,
 -5638731028492383.,5265049803014689.,.499702988195042586887,-50,46,
 -5638731028491914.,5265049803012497.,-.490798531525505490795,-50,46,
 -5638731028491908.,5265049803012468.,.453885884006376230338,-50,46,
 -5638731028491877.,5265049803012324.,-.498577969076519573524,-50,46,
 -5638731028462048.,5265049802872846.,.499995699665972076151,-50,46,
 -5534229527508387.,4798405793378645.,.499640789501145630009,-50,46,
 -5534229527508211.,4798405793377895.,.496379230715326885698,-50,46,
 -5534229527508192.,4798405793377815.,-.469881960282948143657,-50,46,
 -5534229527507794.,4798405793376119.,-.499984802985332673413,-50,46,
 -5534229527499821.,4798405793342142.,.499990285980998587380,-50,46,
 -5534229527462416.,4798405793182746.,-.499997947305605434723,-50,46,
 -5402948249602198.,8540707420680334.,-.499987065011528474747,-50,47,
 -5402948249555460.,8540707420325842.,.499983828484787303874,-50,47,
 -5402948249546227.,8540707420255813.,.499958423571301989181,-50,47,
 -5402948249545081.,8540707420247122.,-.499828075299840964330,-50,47,
 -5402948249542281.,8540707420225885.,-.497561194134730218104,-50,47,
 -5402948249542269.,8540707420225793.,.486734235469651321490,-50,47,
 -5402948249542257.,8540707420225702.,.471029665075003051032,-50,47,
 -5402948249542216.,8540707420225392.,-.499294283766058321803,-50,47,
 -5379832785877681.,8367172636446718.,-.499999055683928136433,-50,47,
 -5379832785864805.,8367172636351043.,-.499963529484329155764,-50,47,
 -5379832785864438.,8367172636348316.,-.490099189266483270359,-50,47,
 -5379832785864431.,8367172636348263.,.496464980719063972682,-50,47,
 -5379832785864359.,8367172636347729.,-.498874985125106747705,-50,47,
 -4831850099948337.,5143460617548304.,.487752791517590559105,-50,47,
 -4831850099948330.,5143460617548273.,-.478448973307552401718,-50,47,
 -4831850099948277.,5143460617548030.,.491737664451387994442,-50,47,
 -4831850099948157.,5143460617547482.,.499707410362803595104,-50,47,
 -4831850099946648.,5143460617540591.,.499926970185818173592,-50,47,
 -4831850099946145.,5143460617538295.,-.499999841153354916342,-50,47,
 -4802568026215744.,5011465635498064.,-.499996664999188690137,-50,47,
 -4802568026186255.,5011465635366857.,.499912432023077074758,-50,47,
 -4802568026185741.,5011465635364571.,-.450613046128315647211,-50,47,
 -4802568026185732.,5011465635364531.,-.494493842429055281027,-50,47,
 -4802568026185594.,5011465635363916.,.499333947666369155918,-50,47,
 -4802568026184637.,5011465635359659.,-.499990723296148267148,-50,47,
 -4682712477329302.,4505604613804427.,.499998812943811082449,-50,47,
 -4682712477306039.,4505604613711379.,.499993846608857617313,-50,47,
 -4682712477301832.,4505604613694552.,.223373629282876509355,-50,47,
 -4682712477301786.,4505604613694368.,.231283178003029729359,-50,47,
 -4682712477300630.,4505604613689744.,.430053578744074310787,-50,47,
 -4682712477300229.,4505604613688140.,.499004211944616783561,-50,47,
 -4682712477300223.,4505604613688117.,-.499964107753778447181,-50,47,
 -4681019096820415.,8997672952849880.,-.499856067201481478555,-50,48,
 -4681019096820338.,8997672952849264.,.452818631431594835564,-50,48,
 -4681019096820334.,8997672952849233.,-.497691773833069520071,-50,48,
 -4681019096813949.,8997672952798232.,-.499926032778261362607,-50,48,
 -4681019096807483.,8997672952746584.,-.499995701597313168595,-50,48,
 -4561872225366603.,8094622759436659.,.496894138481819515632,-50,48,
 -4561872225366576.,8094622759436465.,.498619021912198857442,-50,48,
 -4561872225366549.,8094622759436272.,-.499656094652766748330,-50,48,
 -4561872225365393.,8094622759427966.,-.499879599512441200152,-50,48,
 -4561872225364815.,8094622759423813.,-.499991348742322598952,-50,48,
 -4561872225346843.,8094622759294681.,.499995256910491854975,-50,48,
 -6156088788838611.,8701540531990260.,-.499999262400582798333,-51,50,
 -6156088788838183.,8701540531988619.,.499870634492641749227,-51,50,
 -6156088788834117.,8701540531973039.,.498634670656866147851,-51,50,
 -6156088788833731.,8701540531971560.,.433096776892667099256,-51,50,
 -6156088788833701.,8701540531971445.,.479816629719629375229,-51,50,
 -6156088788833689.,8701540531971399.,.498504570850846736842,-51,50,
 -5647124200222959.,6957872598582359.,.499998069335807888101,-51,50,
 -5647124200220479.,6957872598574797.,.499800932650039974840,-51,50,
 -5647124200218060.,6957872598567422.,-.499584895365536747835,-51,50,
 -5647124200218040.,6957872598567361.,-.483457452818762311011,-51,50,
 -5647124200217999.,6957872598567235.,.499603804403841218602,-51,50,
 -5642922688546544.,6945073480024996.,.499993822311452836396,-51,50,
 -5642922688543620.,6945073480016098.,-.499924380074737817944,-51,50,
 -5642922688542883.,6945073480013854.,.489494323839194820372,-51,50,
 -5642922688542837.,6945073480013714.,.491547594393089101042,-51,50,
 -5642922688542653.,6945073480013154.,.499760676637648530601,-51,50,
 -5642922688533881.,6945073479986458.,-.499993848640181265200,-51,50,
 -5213169472822023.,5756059254623593.,-.485911956141791758031,-51,50,
 -5213169472822021.,5756059254623588.,-.499564476616284456171,-51,50,
 -5213169472820849.,5756059254620650.,-.499941473888040853249,-51,50,
 -5213169472799461.,5756059254567034.,-.499995139990692484805,-51,50,
 -8724415468946421.,7975271891675484.,.499995517319147739044,-52,51,
 -8724415468929820.,7975271891647282.,.499899158794961793900,-52,51,
 -8724415468928472.,7975271891644992.,.499529915236084176642,-52,51,
 -8724415468928223.,7975271891644569.,.495010670769635524930,-52,51,
 -8724415468924511.,7975271891638263.,.499928603542070943668,-52,51,
 -8724415468913893.,7975271891620225.,.499987526284834967928,-52,51,
 -8099766831116405.,6987540618489811.,-.499946669391345529428,-52,51,
 -8099766831116309.,6987540618489669.,.497847901220517088002,-52,51,
 -8099766831115925.,6987540618489105.,.489026183699717815998,-52,51,
 -8099766831115893.,6987540618489058.,.488291040575277617540,-52,51,
 -8099766831113683.,6987540618485813.,-.499979780602875244738,-52,51,
 -8099766831112322.,6987540618483814.,-.499996335251418908346,-52,51,
 -6700063144980784.,5238640701733832.,-.499935249448330501935,-52,51,
 -6700063144980685.,5238640701733728.,-.476423135843152340948,-52,51,
 -6700063144980605.,5238640701733644.,-.497827488483583294814,-52,51,
 -6700063144949949.,5238640701701447.,-.499975298613165928013,-52,51,
 -6700063144931448.,5238640701682016.,-.499999210235302693734,-52,51,
 -6254473773345003.,4795550871078184.,.499999167649725169768,-52,51,
 -6254473773334379.,4795550871068197.,-.499975419321837595897,-52,51,
 -6254473773275947.,4795550871013263.,-.499835170640446435830,-52,51,
 -6254473773271370.,4795550871008959.,.499799343159699161349,-52,51,
 -6254473773271320.,4795550871008912.,.493022355135925631918,-52,51,
 -6254473773270635.,4795550871008269.,-.499822380730251180531,-52,51,
 -8245673680828457.,6526263500829415.,.499947398287596964780,-53,52,
 -8245673680828375.,6526263500829372.,.499695210867583475828,-53,52,
 -8245673680827309.,6526263500828813.,.496416774456629542030,-53,52,
 -8245673680827185.,6526263500828748.,.471645173979489266040,-53,52,
 -8245673680827166.,6526263500828739.,-.491827893835447140399,-53,52,
 -8245673680827145.,6526263500828727.,.495912399632288511981,-53,52,
 -8245673680820545.,6526263500825267.,-.499995365893181856469,-53,52,
 -8242701861937643.,6524705454050369.,-.499989152126607534141,-53,52,
 -8242701861729357.,6524705453941195.,-.499940350410856688633,-53,52,
 -8242701861721346.,6524705453936996.,-.499938403744924259834,-53,52,
 -8242701861718448.,6524705453935477.,-.499063899735194707876,-53,52,
 -8242701861718034.,6524705453935260.,-.498938970535810767190,-53,52,
 -8178102513332180.,6491012945006904.,-.499995985108853313847,-53,52,
 -8178102513290567.,6491012944985307.,.499980790114483331919,-53,52,
 -8178102513290517.,6491012944985282.,-.448641062618341636559,-53,52,
 -8178102513290515.,6491012944985281.,-.486585936727650474886,-53,52,
 -8178102513290488.,6491012944985267.,-.498841737203288469213,-53,52,
 -8003544517573701.,6401635464227793.,.499998457234171278177,-53,52,
 -8003544517553222.,6401635464217449.,.495611615716139570630,-53,52,
 -8003544517553202.,6401635464217439.,.393551567056580364975,-53,52,
 -8003544517553125.,6401635464217401.,-.499379620282427901409,-53,52,
 -8003544517552929.,6401635464217302.,-.499568097143246976232,-53,52,
 -8003544517552537.,6401635464217104.,-.499945050855791338473,-53,52,
 -8003544517536566.,6401635464209037.,-.499996897032731538071,-53,52,
 -7834633035949477.,6317438440555928.,.498596627381543855343,-53,52,
 -7834633035949231.,6317438440555808.,-.499668869091939550358,-53,52,
 -7834633035948125.,6317438440555263.,.499999264707447359388,-53,52,
 -7546489395530079.,6178919966200913.,-.499988491590803478257,-53,52,
 -7546489395529436.,6178919966200610.,.499984184019189444350,-53,52,
 -7546489395524935.,6178919966198496.,.499792914170823998186,-53,52,
 -7546489395523715.,6178919966197923.,.498185860623013380504,-53,52,
 -7546489395523649.,6178919966197892.,.499738265926118044293,-53,52,
 -7546489395456645.,6178919966166423.,-.499998457953293323780,-53,52,
 -7532060552269350.,6172151046777684.,.499671759178428127453,-53,52,
 -7532060552269175.,6172151046777602.,.499023232124015984838,-53,52,
 -7532060552269079.,6172151046777558.,-.484189674144843344087,-53,52,
 -7532060552269000.,6172151046777520.,.498374705071933719806,-53,52,
 -7532060552267918.,6172151046777014.,-.499920759278347877662,-53,52,
 -7532060552263272.,6172151046774837.,-.499995367666610107941,-53,52,
 -7165093878956314.,6005275203526650.,.499990608703774815424,-53,52,
 -7165093878945451.,6005275203521859.,.499915957069863027148,-53,52,
 -7165093878940134.,6005275203519514.,.498774754073446236603,-53,52,
 -7165093878940100.,6005275203519500.,-.496530643870145346927,-53,52,
 -7165093878940032.,6005275203519470.,-.487141439757071810088,-53,52,
 -7165093878939481.,6005275203519227.,-.499296565239985209869,-53,52,
 -7165093878938633.,6005275203518853.,-.499854725648910126057,-53,52,
 -7165093878916907.,6005275203509270.,.499996008252197542444,-53,52,
 -7017962821202702.,5941183073803213.,-.499998313432538330021,-53,52,
 -7017962821159790.,5941183073784752.,-.499993424576137281384,-53,52,
 -7017962821159353.,5941183073784563.,.499983322398951904995,-53,52,
 -7017962821149302.,5941183073780239.,.499448506685808070361,-53,52,
 -7017962821146350.,5941183073778970.,-.468671955144732691930,-53,52,
 -7017962821146336.,5941183073778964.,-.491555995273844921296,-53,52,
 -7017962821146329.,5941183073778960.,.497001984661604346480,-53,52,
 -7017962821146243.,5941183073778923.,.499285738154559628869,-53,52,
 -6848882081836112.,5869486054436035.,-.499987088697575904747,-53,52,
 -6848882081660115.,5869486054362486.,-.499960323617606504530,-53,52,
 -6848882081658763.,5869486054361921.,-.499636240179231456625,-53,52,
 -6848882081658696.,5869486054361893.,-.498880534857470493007,-53,52,
 -6848882081658562.,5869486054361837.,-.497369124212974268704,-53,52,
 -6848882081657478.,5869486054361383.,.499932138063397285617,-53,52,
 -6471417749984994.,5716852579179082.,.499984888587396568737,-53,52,
 -6471417749983889.,5716852579178651.,-.499512948843149318093,-53,52,
 -6471417749983866.,5716852579178642.,-.491357700209567867020,-53,52,
 -6471417749983848.,5716852579178634.,.471546407416739270427,-53,52,
 -6471417749983646.,5716852579178555.,.499692504113529559592,-53,52,
 -6471417749937172.,5716852579160386.,.499998015623627592636,-53,52,
 -6320301642428664.,5658575598221067.,-.499981299625563514900,-53,52,
 -6320301642428267.,5658575598220915.,.498765866865387317304,-53,52,
 -6320301642428217.,5658575598220896.,.480975837456966596630,-53,52,
 -6320301642368799.,5658575598198297.,-.499983387108846485314,-53,52,
 -6150458818223083.,5594977082458783.,-.499286874270788407284,-53,52,
 -6150458818223045.,5594977082458768.,.494800913418900538636,-53,52,
 -6150458818223007.,5594977082458754.,.488888701108689067730,-53,52,
 -6150458818222999.,5594977082458752.,-.459724396219763815824,-53,52,
 -6150458818222402.,5594977082458532.,-.499976784343105975128,-53,52,
 -6150458818141214.,5594977082428608.,-.499994791496311579697,-53,52,
 -5840746347509331.,5484109679795431.,-.499995235308016774164,-53,52,
 -5840746347509213.,5484109679795390.,-.496913231969087299483,-53,52,
 -5840746347509193.,5484109679795383.,-.445543400894599189584,-53,52,
 -5840746347503491.,5484109679793401.,.499995439544697220558,-53,52,
 -5301224375154125.,5306391761497969.,.499782879003916970748,-53,52,
 -5301224375153926.,5306391761497907.,.498714440656277449709,-53,52,
 -5301224375142917.,5306391761494477.,.499908224745938820969,-53,52,
 -5301224375134511.,5306391761491859.,-.499997760555601318003,-53,52,
 -5286632173782529.,5301852330730806.,.499995427832543784759,-53,52,
 -5286632173738303.,5301852330717069.,.499987874826962941135,-53,52,
 -5286632173730998.,5301852330714801.,-.499809860232136916382,-53,52,
 -5286632173730866.,5301852330714759.,.499783117071972485119,-53,52,
 -5286632173730734.,5301852330714718.,.499376094377220551561,-53,52,
 -5286632173726040.,5301852330713261.,-.499946363436865115689,-53,52,
 -5158589873384194.,5262615595068558.,-.499997850158857276856,-53,52,
 -5158589873359597.,5262615595061123.,-.499992395290853244960,-53,52,
 -5158589873358717.,5262615595060857.,-.499910888677464884051,-53,52,
 -5158589873357837.,5262615595060591.,-.499829382013843715547,-53,52,
 -5158589873357804.,5262615595060581.,-.474826325512980736643,-53,52,
 -5158589873357794.,5262615595060578.,-.497552672027856796685,-53,52,
 -4827510902891409.,5166072474388769.,-.499996972673636685491,-53,52,
 -4827510902875907.,5166072474384412.,.499940907074895199931,-53,52,
 -4827510902874302.,5166072474383962.,-.498646351953107616084,-53,52,
 -4827510902874277.,5166072474383954.,.476453534979217791411,-53,52,
 -4827510902874270.,5166072474383953.,-.490518496679723962694,-53,52,
 -4827510902874181.,5166072474383928.,-.499162899200282809189,-53,52,
 -4827510902874060.,5166072474383894.,-.499679446446525710858,-53,52,
 -4827510902870124.,5166072474382788.,-.499953247270450338216,-53,52,
 -4827510902862373.,5166072474380610.,-.499984298803576593744,-53,52,
 -4504722288324968.,5078668422840897.,.499978909567507821089,-53,52,
 -4504722288290757.,5078668422831982.,-.499978059605902849114,-53,52,
 -4504722288290239.,5078668422831846.,.499934901407553636139,-53,52,
 -4504722288288685.,5078668422831441.,.499673784548704654777,-53,52,
 -4504722288288497.,5078668422831393.,-.496496801006980213171,-53,52,
 -4504722288288493.,5078668422831391.,.461031484406752657604,-53,52,
 -4504722288279008.,5078668422828919.,.499978274537895508455,-53,52,
 -7868743568004848.,4940110690624440.,-.499996470271260888958,-54,52,
 -7868743567949900.,4940110690618247.,-.499992745704510094083,-54,52,
 -7868743567941746.,4940110690617327.,.490726308406879428533,-54,52,
 -7868743567941719.,4940110690617324.,.447649219183763974502,-54,52,
 -7868743567941684.,4940110690617321.,-.497080340920258060184,-54,52,
 -7868743567941613.,4940110690617313.,-.499246019988359761092,-54,52,
 -7868743567941125.,4940110690617257.,.499953256278031650219,-54,52,
 -7501948289009369.,4899791670364095.,-.499997914593055364643,-54,52,
 -7501948289008865.,4899791670364040.,.498492637379065459589,-54,52,
 -7501948289004833.,4899791670363608.,.486417053294102794886,-54,52,
 -7501948289004413.,4899791670363563.,.485159179966035212714,-54,52,
 -7485075199937771.,4897985937895343.,.499996476192357298761,-54,52,
 -7485075199918340.,4897985937893266.,.498290195875718218479,-54,52,
 -7485075199918265.,4897985937893258.,.481454831210532405412,-54,52,
 -7485075199918209.,4897985937893252.,.495551092260582359756,-54,52,
 -7485075199918050.,4897985937893235.,.499860119170803601527,-54,52,
 -7485075199910388.,4897985937892416.,.499959265447649999268,-54,52,
 -7485075199907834.,4897985937892143.,.499992314403500642689,-54,52,
 -7250793807649725.,4873356845993420.,.499997792167614663514,-54,52,
 -7250793807613697.,4873356845989697.,-.499973034541522129791,-54,52,
 -7250793807595683.,4873356845987835.,-.499958440586378674989,-54,52,
 -7250793807594048.,4873356845987665.,.499820834725158600050,-54,52,
 -7250793807593671.,4873356845987627.,-.468425778851745612321,-54,52,
 -7250793807593661.,4873356845987625.,.497933727419453095482,-54,52,
 -7250793807593632.,4873356845987623.,-.499623704394062159671,-54,52,
 -6713742225384212.,4820002618886339.,.499997952248943582036,-54,52,
 -6713742225366644.,4820002618884665.,-.499635471927577929307,-54,52,
 -6713742225366560.,4820002618884656.,.491486499415922993706,-54,52,
 -6713742225366476.,4820002618884648.,.482608470759528717934,-54,52,
 -6713742225364840.,4820002618884493.,-.499825515908395862177,-54,52,
 -6713742225363036.,4820002618884320.,.499984440159123329183,-54,52,
 -6300104505916805.,4781832049740321.,.499995859685727729972,-54,52,
 -6300104505905093.,4781832049739277.,-.499824220683787331691,-54,52,
 -6300104505904611.,4781832049739233.,.493864877827915069028,-54,52,
 -6300104505904499.,4781832049739224.,-.499302800525722023675,-54,52,
 -6300104505899534.,4781832049738781.,-.499994970213292406956,-54,52,
 -5733088875683310.,4733600811347966.,.499960362986713142590,-54,52,
 -5733088875678181.,4733600811347551.,.499906777813672855740,-54,52,
 -5733088875677934.,4733600811347532.,-.485473069230208802095,-54,52,
 -5733088875677872.,4733600811347526.,.497953851754867510223,-54,52,
 -5733088875677699.,4733600811347513.,-.499903288076800465385,-54,52,
 -5733088875667441.,4733600811346682.,.499989542800408090742,-54,52,
 -5733088875630574.,4733600811343699.,.499994331836212140713,-54,52,
 -5586017142901596.,4721858497059219.,-.499836996328784799736,-54,52,
 -5586017142901431.,4721858497059206.,-.496866361650989102067,-54,52,
 -5586017142901304.,4721858497059195.,.499359520798250712363,-54,52,
 -5586017142900263.,4721858497059113.,.499919706867400815948,-54,52,
 -5586017142896556.,4721858497058821.,.499993299462634831844,-54,52,
 -5586017142855487.,4721858497055586.,.499999348528522224997,-54,52,
 -5137347928755616.,4687977823215297.,.499995993679518519097,-54,52,
 -5137347928742470.,4687977823214347.,.499858532377384978625,-54,52,
 -5137347928742249.,4687977823214332.,-.470781234750811398327,-54,52,
 -5137347928742235.,4687977823214331.,-.482495971129949396180,-54,52,
 -5137347928742221.,4687977823214330.,-.494210707509084562627,-54,52,
 -5137347928741958.,4687977823214311.,-.499994683773740417191,-54,52,
 -5130840493918146.,4687507867094144.,.499999378013501423809,-54,52,
 -5130840493903625.,4687507867093097.,-.499984721594440323962,-54,52,
 -5130840493895547.,4687507867092513.,.499955259296155521442,-54,52,
 -5130840493893912.,4687507867092395.,.499819318429929795684,-54,52,
 -5130840493893815.,4687507867092388.,.499199632642749342659,-54,52,
 -5130840493893801.,4687507867092387.,.488800915106466480031,-54,52,
 -5130840493893787.,4687507867092386.,.478402197570186448525,-54,52,
 -5046807759991977.,4681494090352273.,.490651298292529514721,-54,52,
 -5046807759991963.,4681494090352272.,.497234999429504645830,-54,52,
 -5046807759991808.,4681494090352261.,.498697404874775398646,-54,52,
 -5046807759991653.,4681494090352251.,-.499840189679607264671,-54,52,
 -5046807759986185.,4681494090351863.,-.499863202511796689428,-54,52,
 -5046807759956111.,4681494090349729.,-.499989765378951575483,-54,52,
 -5046807759953377.,4681494090349534.,.499998729552836046073,-54,52,
 -5010504700974749.,4678927591081369.,.499997823536357428029,-54,52,
 -5010504700961460.,4678927591080433.,.492684208846597022516,-54,52,
 -5010504700961446.,4678927591080433.,-.493402207782781750501,-54,52,
 -5010504700961162.,4678927591080413.,-.496869516549569602835,-54,52,
 -5010504700960878.,4678927591080392.,.499663174684805447781,-54,52,
 -5010504700959728.,4678927591080311.,.499707523004902689894,-54,52,
 -5010504700952828.,4678927591079825.,.499973613325911680828,-54,52,
 -8612971451614389.,4632901128904568.,.499995185726210857061,-55,52,
 -8612971451601627.,4632901128904184.,-.499987636595398202671,-55,52,
 -8612971451598047.,4632901128904075.,.499703751699620358064,-55,52,
 -8612971451595362.,4632901128903994.,.499472292950902771119,-55,52,
 -8612971451595130.,4632901128903988.,-.499430388027294580404,-55,52,
 -8612971451595097.,4632901128903987.,-.494963959028488080737,-55,52,
 -8612971451595064.,4632901128903986.,-.490497530029677694367,-55,52,
 -6842835487568892.,4585071473649437.,.499994353167189719390,-55,52,
 -6842835487550009.,4585071473648987.,-.498616824271658630093,-55,52,
 -6842835487549925.,4585071473648984.,.495140346789521790530,-55,52,
 -6842835487549885.,4585071473648984.,-.460213381276574011196,-55,52,
 -6842835487549883.,4585071473648983.,.492018932320121347071,-55,52,
 -6842835487549674.,4585071473648979.,-.499704296825135830596,-55,52,
 -6842835487548711.,4585071473648956.,-.499845300013968675006,-55,52,
 -6842835487547748.,4585071473648933.,-.499986303199525856823,-55,52,
 -6298970528354555.,4572603799520462.,-.499995941991681887759,-55,52,
 -6298970528344084.,4572603799520231.,.499819935366161212783,-55,52,
 -6298970528341489.,4572603799520174.,.499487799215738399028,-55,52,
 -6298970528341488.,4572603799520174.,.477522353305858415372,-55,52,
 -6298970528336208.,4572603799520058.,.499967949188656322696,-55,52,
 -6070752678071695.,4567682594080166.,.499214291210415066291,-55,52,
 -6070752678071652.,4567682594080166.,-.410749974644536435678,-55,52,
 -6070752678071648.,4567682594080166.,-.495397813328717639977,-55,52,
 -6070752678071317.,4567682594080158.,.499993535555482796220,-55,52,
 -6070752678055912.,4567682594079833.,-.499995196461797176727,-55,52,
 -6002783559881637.,4566252361603206.,.499996624514547914916,-55,52,
 -6002783559861852.,4566252361602793.,-.458124808337722479212,-55,52,
 -6002783559861850.,4566252361602793.,-.499970461249743070881,-55,52,
 -6002783559854633.,4566252361602641.,.499991005815587472552,-55,52,
 -5777052993637214.,4561619030812311.,-.499988962962151757345,-55,52,
 -5777052993623900.,4561619030812043.,-.499846159699358678332,-55,52,
 -5777052993623105.,4561619030812026.,.497458446644063210953,-55,52,
 -5777052993623055.,4561619030812025.,.490999616854415553478,-55,52,
 -5777052993622956.,4561619030812023.,.498211133870939110244,-55,52,
 -5777052993622658.,4561619030812017.,.499716508324924961322,-55,52,
 -5777052993621267.,4561619030811990.,-.499968136417610335658,-55,52,
 -5777052993596030.,4561619030811482.,-.499997883164490626965,-55,52,
 -4966294589209959.,4546452777593379.,-.499998062439521960731,-55,52,
 -4966294589204810.,4546452777593289.,.499992238071379682123,-55,52,
 -4966294589199661.,4546452777593200.,.499982538675139243668,-55,52,
 -4966294589199256.,4546452777593193.,.499593350826004533621,-55,52,
 -4966294589198967.,4546452777593189.,-.495746094330187269210,-55,52,
 -4966294589198961.,4546452777593188.,.400544436220206312069,-55,52,
 -4966294589198909.,4546452777593188.,-.498270965676377368470,-55,52,
 -4966294589198851.,4546452777593186.,.499204162977444314545,-55,52,
 -7922455085971660.,4530847165997180.,-.499986390785640219232,-56,52,
 -7922455085967884.,4530847165997154.,-.499585355526130964350,-56,52,
 -7922455085967739.,4530847165997153.,-.497980972551140097766,-56,52,
 -7922455085967738.,4530847165997152.,.495133540434894385704,-56,52,
 -7922455085967704.,4530847165997152.,.261026981960067342888,-56,52,
 -7922455085967303.,4530847165997149.,.499946689359977444720,-56,52,
 -7922455085941742.,4530847165996974.,-.499986874317810744538,-56,52,
 -7518049176487624.,4505131720724319.,.499851238691416043035,-58,52,
 -7518049176487586.,4505131720724319.,.484362420559222107725,-58,52,
 -7518049176487039.,4505131720724319.,.261404959551070715354,-58,52,
 -7518049176486943.,4505131720724319.,.222275313743426075229,-58,52,
 -7518049176485171.,4505131720724319.,-.499992731789258156222,-58,52,
 -7518049176453277.,4505131720724305.,.499997649605865280595,-58,52,
 -5034345543218301.,4504286612544905.,-.087752309102376406699,-58,52,
 -5034345543218197.,4504286612544905.,-.116136643825913754172,-58,52,
 -5034345543216969.,4504286612544905.,-.451290134599945014642,-58,52,
 -5034345543216793.,4504286612544905.,-.499325162593610548624,-58,52,
 -5034345543216791.,4504286612544905.,-.499871015184447647314,-58,52,
 -5034345543165495.,4504286612544891.,-.499898264903020206629,-58,52,
 -5034345542982295.,4504286612544841.,-.499995584161891897238,-58,52,
 -4503599627370496.,4503599627370496.,0.000000000000000000000,-1074,52,
 0.,4503599627370496.,0.000000000000000000000,0,52,
 4503599627370496.,4503599627370496.,0.000000000000000000000,-1074,52,
 5835457316479768.,4503830378477215.,.499999511639893811506,-59,52,
 5835457316503937.,4503830378477217.,.411442204264803490376,-59,52,
 5835457316503944.,4503830378477217.,.411995810075900436266,-59,52,
 5835457316504368.,4503830378477217.,.445528504919488111454,-59,52,
 5835457316505039.,4503830378477217.,.498595576240359434994,-59,52,
 5835457316505057.,4503830378477218.,-.499980865959676719675,-59,52,
 5835457316517701.,4503830378477218.,.499989401971567113373,-59,52,
 8328945592803082.,4511122976265158.,-.499995799046069966277,-57,52,
 8328945592817470.,4511122976265183.,.499951119550920471490,-57,52,
 8328945592820237.,4511122976265189.,-.499920083963671982611,-57,52,
 8328945592820790.,4511122976265189.,.499382852233285761758,-57,52,
 8328945592820791.,4511122976265190.,-.498810090015905936225,-57,52,
 8328945592820819.,4511122976265190.,-.448212472993273391550,-57,52,
 8328945592820908.,4511122976265190.,-.287384333171333100824,-57,52,
 8328945592841819.,4511122976265228.,-.499999705970907838871,-57,52,
 6916394610522188.,4524361340935612.,.499998185369534695260,-56,52,
 6916394610526349.,4524361340935638.,-.499749457598156726951,-56,52,
 6916394610526639.,4524361340935639.,.242637753058346401072,-56,52,
 6916394610526680.,4524361340935639.,.488975255254616549028,-56,52,
 6916394610526682.,4524361340935640.,-.499008281223614137993,-56,52,
 6916394610527514.,4524361340935644.,.499840543832722374317,-56,52,
 7664074856375585.,4529097216352621.,.499838306067960376961,-56,52,
 7664074856376585.,4529097216352628.,.159904079185900297067,-56,52,
 7664074856376634.,4529097216352628.,.486247302068701770989,-56,52,
 7664074856376636.,4529097216352628.,.499567433614938610329,-56,52,
 7664074856378588.,4529097216352642.,-.499984177256242679808,-56,52,
 7664074856389699.,4529097216352716.,-.499993372064710707475,-56,52,
 7664074856400810.,4529097216352789.,.499997433234507061110,-56,52,
 5852820566561476.,4563154257661648.,.499996099170357218551,-55,52,
 5852820566563094.,4563154257661681.,.499881808282878410382,-55,52,
 5852820566564712.,4563154257661714.,.499767517404602458962,-55,52,
 5852820566564761.,4563154257661715.,.499146009213747561912,-55,52,
 5852820566564906.,4563154257661718.,.456490525791879452477,-55,52,
 5852820566564908.,4563154257661718.,.497281484641233512548,-55,52,
 6575998564310792.,4578824074855026.,-.499738823153342419601,-55,52,
 6575998564310965.,4578824074855029.,.469221195012876805660,-55,52,
 6575998564310966.,4578824074855029.,.492163160435803235233,-55,52,
 6575998564311010.,4578824074855031.,-.498390360955430371433,-55,52,
 6575998564321166.,4578824074855264.,-.499789525531101899310,-55,52,
 6575998564361921.,4578824074856199.,-.499988709768599026220,-55,52,
 6575998564364144.,4578824074856250.,-.499999574194867640076,-55,52,
 6847582036549561.,4585184879271240.,-.499999877884064044460,-55,52,
 6847582036550607.,4585184879271265.,-.499962634222496980103,-55,52,
 6847582036560021.,4585184879271490.,-.499627441094479934526,-55,52,
 6847582036561067.,4585184879271515.,-.499590197394265433199,-55,52,
 6847582036561318.,4585184879271520.,.499462716725577064602,-55,52,
 6847582036561319.,4585184879271521.,-.476636674054821524202,-55,52,
 7706116167838655.,4607008166212156.,.499994747124924295720,-55,52,
 7706116167864824.,4607008166212862.,-.499802424480109899607,-55,52,
 7706116167865084.,4607008166212869.,-.495329470385502006709,-55,52,
 7706116167865121.,4607008166212870.,-.498539088456634459827,-55,52,
 7706116167866383.,4607008166212904.,-.499904980501540386955,-55,52,
 7706116167867942.,4607008166212945.,.499992463485655170101,-55,52,
 8687303334617413.,4635153411183071.,-.499967854299768374331,-55,52,
 8687303334619976.,4635153411183148.,.499921623176942550135,-55,52,
 8687303334621783.,4635153411183203.,.492430513476026124885,-55,52,
 8687303334621816.,4635153411183204.,.496720935933173691841,-55,52,
 8687303334621849.,4635153411183206.,-.498988641609674852611,-55,52,
 8687303334622309.,4635153411183220.,-.499788813418673913430,-55,52,
 8687303334627435.,4635153411183375.,.499990141647820162436,-55,52,
 8687303334672419.,4635153411184745.,-.499998829218157119187,-55,52,
 4579785905290235.,4649924605679017.,.499995218448327371624,-54,52,
 4579785905371363.,4649924605684229.,.499981214822996056587,-54,52,
 4579785905373978.,4649924605684397.,.498452316141922534746,-54,52,
 4579785905374009.,4649924605684399.,.490021189618948713731,-54,52,
 4579785905374087.,4649924605684405.,-.498934548083956763384,-54,52,
 4579785905374445.,4649924605684428.,-.499526267283353377519,-54,52,
 4579785905374803.,4649924605684450.,.499882013519086430117,-54,52,
 4994576600381600.,4677807528209301.,.499940110394941621029,-54,52,
 4994576600383352.,4677807528209424.,.499309048069236514443,-54,52,
 4994576600383680.,4677807528209448.,-.473411835740247787347,-54,52,
 4994576600383694.,4677807528209449.,-.490540166146715657512,-54,52,
 4994576600383708.,4677807528209449.,.492331503446819297586,-54,52,
 4994576600383936.,4677807528209465.,.499098693970500522228,-54,52,
 4994576600386329.,4677807528209633.,.499949075257675159214,-54,52,
 4994576600405245.,4677807528210961.,.499984937932211521662,-54,52,
 4994576600414703.,4677807528211626.,-.499997128796358971289,-54,52,
 7423882302187867.,4891473205414471.,-.499994383586205019194,-54,52,
 7423882302188688.,4891473205414557.,.499867888308075406750,-54,52,
 7423882302191151.,4891473205414818.,.499454704051875667425,-54,52,
 7423882302191302.,4891473205414835.,-.499352600379857712244,-54,52,
 7423882302209666.,4891473205416781.,-.499997224203809430614,-54,52,
 8012612783800355.,4956483412447216.,-.499997403152691746505,-54,52,
 8012612783816952.,4956483412449122.,.499981535779185425162,-54,52,
 8012612783817422.,4956483412449177.,-.496885964231980883117,-54,52,
 8012612783817448.,4956483412449179.,.490521365554733931286,-54,52,
 8012612783817509.,4956483412449186.,.499438562362066908279,-54,52,
 8633994769867430.,5030843467107112.,-.438898653271923127508,-54,52,
 8633994769867454.,5030843467107115.,-.451832103639655962520,-54,52,
 8633994769867542.,5030843467107126.,-.499254754987933294658,-54,52,
 8633994769867775.,5030843467107155.,-.499817002307224219543,-54,52,
 8633994769869631.,5030843467107385.,.499996169291052132901,-54,52,
 8633994769880301.,5030843467108713.,.499999694547718671388,-54,52,
 8675324062254537.,5036000601052381.,-.499701236111730188930,-54,52,
 8675324062254697.,5036000601052401.,-.483358673734845779717,-54,52,
 8675324062254865.,5036000601052422.,-.466198983238689587776,-54,52,
 8675324062255760.,5036000601052534.,-.499782774933332662075,-54,52,
 8675324062259429.,5036000601052992.,.499972608741127619363,-54,52,
 8675324062381809.,5036000601068302.,.499990132107544512989,-54,52,
 4733303198939710.,5139882574443420.,.499979465073926823485,-53,52,
 4733303198943728.,5139882574444525.,.499897543700205903155,-53,52,
 4733303198944008.,5139882574444603.,-.496623844510712547008,-53,52,
 4733303198944408.,5139882574444713.,-.491654399089122767992,-53,52,
 4733303198944419.,5139882574444716.,-.466517739339885837478,-53,52,
 4733303199012154.,5139882574463343.,.499995870978938451048,-53,52,
 5018163383776848.,5220806376565162.,-.499905839923612407583,-53,52,
 5018163383776899.,5220806376565176.,.453293785805852664502,-53,52,
 5018163383776906.,5220806376565179.,-.494306265564599850503,-53,52,
 5018163383781848.,5220806376566628.,-.499942532317123440348,-53,52,
 5018163383789348.,5220806376568827.,-.499997567890917789151,-53,52,
 5184012179842902.,5270321034320674.,.499944179765244842684,-53,52,
 5184012179843310.,5270321034320799.,-.499511354446287136438,-53,52,
 5184012179843922.,5270321034320985.,-.498694655743309252382,-53,52,
 5184012179843945.,5270321034320991.,.491532115613649593557,-53,52,
 5184012179857636.,5270321034325152.,.499998497717575424793,-53,52,
 5359027492695953.,5324510475155138.,.499998299510738245866,-53,52,
 5359027492701106.,5324510475156764.,-.499961137976493370888,-53,52,
 5359027492704702.,5324510475157897.,.499679046016496229515,-53,52,
 5359027492704721.,5324510475157903.,.491334541985342664011,-53,52,
 5359027492706259.,5324510475158389.,-.499920573721033819107,-53,52,
 5488415439820225.,5365863775409127.,.499981193795409163160,-53,52,
 5488415439822269.,5365863775409790.,-.499916957115925363749,-53,52,
 5488415439823257.,5365863775410109.,.488390590389988767638,-53,52,
 5488415439823263.,5365863775410111.,.431639421650343368529,-53,52,
 5488415439823291.,5365863775410121.,-.499866032467970344969,-53,52,
 5488415439840066.,5365863775415553.,.499991375613659848075,-53,52,
 5488415439859907.,5365863775421980.,-.499998416531312868036,-53,52,
 5668948148607397.,5425415531547069.,-.499997125129829197896,-53,52,
 5668948148614724.,5425415531549529.,.499962681239664229315,-53,52,
 5668948148616293.,5425415531550056.,.497224444527950397925,-53,52,
 5668948148616299.,5425415531550059.,-.487489659627418955354,-53,52,
 5668948148616326.,5425415531550068.,-.418703128326551253007,-53,52,
 5668948148616424.,5425415531550100.,.497633170469600377367,-53,52,
 5668948148617079.,5425415531550320.,.499676800195064493281,-53,52,
 5668948148617210.,5425415531550365.,-.499914473856399839796,-53,52,
 5949535300107952.,5522307319226663.,-.497941272214359247089,-53,52,
 5949535300107966.,5522307319226667.,.469410230674402371559,-53,52,
 5949535300108014.,5522307319226685.,-.499670330849742222636,-53,52,
 5949535300109178.,5522307319227098.,-.499873947762234770312,-53,52,
 5949535300114967.,5522307319229151.,.499972498361594018980,-53,52,
 5949535300119592.,5522307319230793.,-.499977437238298793838,-53,52,
 5949535300217912.,5522307319265678.,-.499993885883254137048,-53,52,
 6402079148328611.,5689913795619902.,-.499999768434560434002,-53,52,
 6402079148348633.,5689913795627632.,-.499979749835480788906,-53,52,
 6402079148376296.,5689913795638312.,-.498453693464315885433,-53,52,
 6402079148376314.,5689913795638318.,.450902033300605402793,-53,52,
 6402079148377086.,5689913795638617.,-.498952352093606139251,-53,52,
 6402079148378666.,5689913795639227.,-.499949669220875503293,-53,52,
 6402079148378824.,5689913795639287.,.499950599076027044166,-53,52,
 6710148704139553.,5812203442175372.,.499994694743764470997,-53,52,
 6710148704142713.,5812203442176662.,-.499983127910416245604,-53,52,
 6710148704144407.,5812203442177353.,-.498072504696946428034,-53,52,
 6710148704144608.,5812203442177434.,.492118779416996957036,-53,52,
 6710148704144635.,5812203442177446.,-.494273436149566256548,-53,52,
 6710148704145064.,5812203442177620.,.499716916522047804424,-53,52,
 6710148704145873.,5812203442177951.,-.499960949849219205981,-53,52,
 7103100048439793.,5978075568300094.,-.499996705518185136916,-53,52,
 7103100048443759.,5978075568301825.,-.499733867369160050604,-53,52,
 7103100048445262.,5978075568302480.,.499609311385016308734,-53,52,
 7319052364923764.,6074057399419796.,.499990426577816036454,-53,52,
 7319052364943848.,6074057399428884.,.499913785389575794999,-53,52,
 7319052364945448.,6074057399429608.,.499111026984034139259,-53,52,
 7319052364945764.,6074057399429751.,.488952482221604464958,-53,52,
 7319052364945775.,6074057399429756.,.466446963258489981791,-53,52,
 7319052364945806.,6074057399429770.,.493931409817034268649,-53,52,
 7319052364945848.,6074057399429789.,.498910337412596140440,-53,52,
 7319052364973574.,6074057399442335.,.499999568960418074472,-53,52,
 7719367433303314.,6261259316531482.,-.499976842036077061597,-53,52,
 7719367433303519.,6261259316531581.,-.499871005587663031032,-53,52,
 7719367433307004.,6261259316533264.,-.498071785468396468599,-53,52,
 7719367433307824.,6261259316533660.,-.497648439421761344116,-53,52,
 7719367433307880.,6261259316533687.,-.453717088958146948554,-53,52,
 7719367433307882.,6261259316533688.,-.487862397870156243934,-53,52,
 7719367433312715.,6261259316536021.,.499998617161088443297,-53,52,
 8108726220150774.,6455200747855937.,.499989509398755307966,-53,52,
 8108726220155016.,6455200747858116.,-.499730027749181493509,-53,52,
 8108726220156987.,6455200747859127.,.484841588080150931140,-53,52,
 8108726220156989.,6455200747859129.,-.488284163704746034018,-53,52,
 8108726220157026.,6455200747859148.,-.491110571725282482234,-53,52,
 8108726220157137.,6455200747859205.,-.499589795786238267713,-53,52,
 8108726220172356.,6455200747867019.,-.499997993564752848050,-53,52,
 8145371468091486.,6474069254444266.,.497776098211963227579,-53,52,
 8145371468091513.,6474069254444280.,.439418209994461969762,-53,52,
 8145371468091517.,6474069254444283.,-.495153329000718454224,-53,52,
 8145371468091639.,6474069254444346.,-.499585268353108050197,-53,52,
 8145371468093901.,6474069254445514.,-.499790569901103431982,-53,52,
 8145371468096163.,6474069254446682.,-.499995871040795408826,-53,52,
 8201755169934593.,6503310416106886.,-.499939198867907178205,-53,52,
 8201755169934737.,6503310416106961.,-.495144732081097188124,-53,52,
 8201755169934783.,6503310416106984.,.464720167031706300122,-53,52,
 8201755169934785.,6503310416106986.,-.493546576485124483168,-53,52,
 8201755169951486.,6503310416115685.,-.499988302600062858379,-53,52,
 8201755169957117.,6503310416118617.,.499995334572638592714,-53,52,
 8344755511712701.,6578617262851499.,-.499999990601207506619,-53,52,
 8344755511733460.,6578617262862551.,-.499967754576355394242,-53,52,
 8344755511738152.,6578617262865049.,-.499864119914996149108,-53,52,
 8344755511738708.,6578617262865345.,-.487916630267342528273,-53,52,
 8344755511738723.,6578617262865352.,.498017204885369485839,-53,52,
 8344755511738862.,6578617262865427.,-.498995922698631301549,-53,52,
 8344755511751873.,6578617262872354.,-.499987304218155386061,-53,52,
 8529988344615063.,6678632514923626.,-.499997726079020948568,-53,52,
 8529988344636797.,6678632514935526.,-.497335686471594778607,-53,52,
 8529988344636839.,6678632514935548.,.498896567438485499539,-53,52,
 8529988344637365.,6678632514935836.,.499329080705597777337,-53,52,
 8529988344638154.,6678632514936268.,.499977850648971394760,-53,52,
 8529988344647443.,6678632514941355.,-.499988654998467427332,-53,52,
 8538353789943208.,6683215722758579.,-.499996086006580536238,-53,52,
 8538353789951825.,6683215722763302.,.496433865783495945625,-53,52,
 8538353789951836.,6683215722763309.,-.473165678198936953302,-53,52,
 8538353789951991.,6683215722763394.,-.499341070677613476344,-53,52,
 8538353789952188.,6683215722763501.,.499648914368473182405,-53,52,
 8538353789953142.,6683215722764024.,.499833918139419525666,-53,52,
 8538353789954096.,6683215722764548.,-.499981078014661510960,-53,52,
 9007199254729088.,6949417371949566.,-.499960886896832082030,-53,52,
 9007199254740024.,6949417371955992.,-.499834048619439588110,-53,52,
 9007199254740766.,6949417371956427.,.499808793192956567527,-53,52,
 9007199254740960.,6949417371956541.,.494324576639554203444,-53,52,
 9007199254740991.,6949417371956560.,-.290056921881567029040,-53,52,
 4503599627370497.,6949417371956561.,.472744868584135284771,-52,52,
 4503599627370520.,6949417371956589.,-.497627677608332700024,-52,52,
 4503599627378585.,6949417371966066.,.499999070859877236398,-52,52,
 4837845937970728.,7361733100900373.,-.499992214007234145688,-52,52,
 4837845938025548.,7361733100971259.,-.499986115443986373176,-52,52,
 4837845938038272.,7361733100987712.,-.499911577895793050897,-52,52,
 4837845938038777.,7361733100988364.,.499541240155804044724,-52,52,
 4837845938038835.,7361733100988439.,.497498197482507604771,-52,52,
 4837845938040234.,7361733100990248.,.499942737508604835472,-52,52,
 5224512518066698.,7889483912492031.,.492901409492157314698,-52,52,
 5224512518066714.,7889483912492055.,-.493424813535386277557,-52,52,
 5224512518066787.,7889483912492160.,-.493538206097290310531,-52,52,
 5224512518069707.,7889483912496360.,-.498073906873687662331,-52,52,
 5224512518070948.,7889483912498144.,.499998421300655221789,-52,52,
 5321124250683315.,8030271915074490.,.499427856527920539006,-52,52,
 5321124250683378.,8030271915074584.,-.495647071892128499257,-52,52,
 5321124250683399.,8030271915074615.,-.494005381365128974615,-52,52,
 5321124250683401.,8030271915074617.,.458531922494594372055,-52,52,
 5321124250685148.,8030271915077196.,.499866844567809604961,-52,52,
 5321124250685759.,8030271915078099.,-.499986825789947985789,-52,52,
 5321124250719870.,8030271915128455.,.499999415920792106627,-52,52,
 5931051093837703.,9007199254714087.,.000011075617049383857,-52,52,
 5931051093853191.,9007199254740913.,.002918648811222767012,-52,52,
 5931051093853221.,9007199254740965.,-.035557124122866220779,-52,52,
 5931051093853236.,9007199254740991.,-.054795010589760834567,-52,52,
 5931051093853237.,4503599627370496.,.338627898489558205281,-52,51,
 5931051093853609.,4503599627370819.,-.499921893683869190337,-52,51,
 5931051093856520.,4503599627373340.,-.499971476001471174195,-52,51,
 5931051093878248.,4503599627392157.,-.499997979463261330244,-52,51,
 6467001089609565.,5000770232426510.,.499996003829847824088,-52,51,
 6467001089645124.,5000770232461766.,-.496366654406199009273,-52,51,
 6467001089645125.,5000770232461766.,.495084276089530536396,-52,51,
 6467001089645128.,5000770232461769.,.469437067576720652746,-52,51,
 6467001089645241.,5000770232461882.,-.496607786404169030117,-52,51,
 6467001089646528.,5000770232463158.,-.499260238159081412909,-52,51,
 6467001089646879.,5000770232463506.,-.499983634021361838878,-52,51,
 6467001089655184.,5000770232471739.,.499994145108018662522,-52,51,
 7770194761460789.,6521760332430129.,-.499994552204457403962,-52,51,
 7770194761464766.,6521760332435533.,.499715833194814786778,-52,51,
 7770194761464805.,6521760332435587.,-.496766765464798842257,-52,51,
 7770194761465621.,6521760332436695.,.499905016538530818503,-52,51,
 8853480284534136.,8197834161354742.,.499998657636993562389,-52,51,
 8853480284572429.,8197834161421765.,.499992932661261368175,-52,51,
 8853480284574956.,8197834161426188.,.426402102254961609099,-52,51,
 8853480284574976.,8197834161426223.,.431755558296864419538,-52,51,
 8853480284575196.,8197834161426608.,.490643574768465803313,-52,51,
 8853480284575232.,8197834161426672.,-.499720204352500579307,-52,51,
 8853480284576165.,8197834161428305.,-.499981479721505738831,-52,51,
 9007199254736922.,8471711556222183.,.499996820437803778008,-52,51,
 9007199254740958.,8471711556229503.,-.495700147737558538107,-52,51,
 9007199254740990.,8471711556229561.,-.465933622185498843489,-52,51,
 9007199254740991.,8471711556229562.,.347496581738009913814,-52,51,
 4503599627370497.,8471711556229568.,-.212212806491461308152,-51,51,
 4503599627370680.,8471711556230232.,-.496758170458745195581,-51,51,
 4503599627371283.,8471711556232419.,-.499932238217305219454,-51,51,
 4503599627382638.,8471711556273601.,.499998987321236341495,-51,51,
 4646447207242103.,9007199254554490.,.499998053305875967185,-51,51,
 4646447207290254.,9007199254740979.,-.478900772919726845206,-51,51,
 4646447207290257.,9007199254740990.,.140049265702513257508,-51,51,
 4646447207290258.,4503599627370497.,.006516305954965088897,-51,50,
 4646447207290262.,4503599627370505.,-.247517001630192188749,-51,50,
 4646447207290388.,4503599627370749.,-.249566190555372253333,-51,50,
 4646447207290884.,4503599627371709.,.250303669050767041154,-51,50,
 4646447207291876.,4503599627373630.,.250043388918563936431,-51,50,
 4646447207295781.,4503599627381192.,.250026871285531251957,-51,50,
 4646447207303591.,4503599627396316.,.249993876651030662531,-51,50,
 6234466683503380.,9007199254740837.,-.498759560416169662751,-51,50,
 6234466683503412.,9007199254740963.,.497303370682860936936,-51,50,
 6234466683503413.,9007199254740967.,.465930337279734953064,-51,50,
 6234466683503419.,9007199254740991.,.277692136861016353326,-51,50,
 6234466683503420.,4503599627370498.,-.376840448271048598024,-51,49,
 6234466683503890.,4503599627371430.,.250496702095575327459,-51,49,
 6234466683505930.,4503599627375478.,.250002633620368032439,-51,49,
 6534651015199035.,5141101734029589.,-.499999777429247926850,-51,49,
 6534651015225752.,5141101734090219.,.499991148448846619712,-51,49,
 6534651015230422.,5141101734100818.,-.499860645946957615961,-51,49,
 6534651015230938.,5141101734101988.,.499727465493522881032,-51,49,
 6534651015231350.,5141101734102923.,.483894717457654926598,-51,49,
 6534651015231428.,5141101734103100.,.495460362266356593077,-51,49,
 6534651015231454.,5141101734103159.,.499315577203961279492,-51,49,
 6623841828929846.,5347595755739987.,.499998414249337659389,-51,49,
 6623841828972054.,5347595755839667.,-.497837785513706266451,-51,49,
 6623841828972065.,5347595755839692.,.479915811248492609279,-51,49,
 6623841828972101.,5347595755839777.,.498018491562035690004,-51,49,
 6623841828972325.,5347595755840306.,.499546280210347828370,-51,49,
 6623841828973044.,5347595755842004.,.499985923595270215391,-51,49,
 6623841828977629.,5347595755852833.,-.499992137406012016090,-51,49,
 6693732543055589.,5515253126126363.,-.499999556196339905005,-51,49,
 6693732543070850.,5515253126163546.,-.499841113868401545299,-51,49,
 6693732543070889.,5515253126163641.,-.477430643767937578145,-51,49,
 6693732543070905.,5515253126163680.,-.493877630392909673854,-51,49,
 6693732543071519.,5515253126165175.,.499969258084156642412,-51,49,
 7898550557397854.,4700645223521874.,-.499994022808832850047,-51,48,
 7898550557404886.,4700645223536527.,-.499971184224682876796,-51,48,
 7898550557407035.,4700645223541005.,-.499821988487118884774,-51,48,
 7898550557407620.,4700645223542223.,.499753293550867358679,-51,48,
 7898550557407799.,4700645223542596.,.492785730340409474224,-51,48,
 7898550557407811.,4700645223542621.,.497905223310603175710,-51,48,
 7898550557437897.,4700645223605313.,.499994434811243943237,-51,48,
 8474845626780662.,6069442169650527.,-.499985662517539751555,-51,48,
 8474845626784369.,6069442169660508.,-.499859670847495124928,-51,48,
 8474845626784408.,6069442169660613.,-.493384107319235621324,-51,48,
 8474845626784525.,6069442169660928.,-.473957416723533412524,-51,48,
 8474845626787611.,6069442169669236.,.499980770203675030927,-51,48,
 8474845626843668.,6069442169820168.,.499999910812279555178,-51,48,
 4907776204982580.,5502147286555827.,.499997954628723148755,-50,47,
 4907776204996101.,5502147286621882.,-.499930385669050230379,-50,47,
 4907776205000608.,5502147286643900.,-.499906322766951943213,-50,47,
 4907776205001349.,5502147286647519.,.499653887716097366305,-50,47,
 4907776205001375.,5502147286647647.,-.482817683802622487082,-50,47,
 4907776205001384.,5502147286647690.,.484788310672350411988,-50,47,
 5448610385727236.,8894158164052448.,-.499980331072365869091,-50,47,
 5448610385773937.,8894158164421320.,.499955354246563894765,-50,47,
 5448610385775732.,8894158164435499.,-.494543718217296342584,-50,47,
 5448610385775742.,8894158164435577.,.491559351080209969337,-50,47,
 5448610385775752.,8894158164435656.,.477662420378417906625,-50,47,
 5448610385775880.,8894158164436667.,.499781707457447056239,-50,47,
 5448610385779046.,8894158164461675.,-.499986514611624199972,-50,47,
 5569985055006364.,4953219233384640.,-.499983102051429463132,-50,46,
 5569985055108039.,4953219233831897.,.499975281575670888042,-50,46,
 5569985055108766.,4953219233835095.,.499148967664550360217,-50,46,
 5569985055108949.,4953219233835900.,.497565452933868390488,-50,46,
 5569985055108959.,4953219233835944.,.486549960329405045045,-50,46,
 5569985055108969.,4953219233835988.,.475534467725332439702,-50,46,
 5569985055109310.,4953219233837488.,.499906170160296964572,-50,46,
 7464505152240009.,6661645343471095.,-.499990479460657162218,-50,44,
 7464505152277408.,6661645343692373.,.499992021133896071281,-50,44,
 7464505152281346.,6661645343715674.,-.499955916407175636857,-50,44,
 7464505152285080.,6661645343737766.,.491459700058981904091,-50,44,
 7464505152285104.,6661645343737908.,.492475762105068660233,-50,44,
 7464505152285272.,6661645343738902.,.499588196512430392726,-50,44,
 7464505152285284.,6661645343738974.,-.499903772452796820166,-50,44,
 7573800345510658.,7340741262650818.,-.499970432810278354175,-50,44,
 7573800345510683.,7340741262650980.,.496760849680594878434,-50,44,
 7573800345510756.,7340741262651456.,.447216194574658494376,-50,44,
 7573800345510758.,7340741262651469.,.486954697174930165501,-50,44,
 7573800345516471.,7340741262688717.,.499987469385563670042,-50,44,
 7573800345537886.,7340741262828341.,-.499993901767229558335,-50,44,
 7724960656347081.,8395508117246906.,-.499116205150917021651,-50,44,
 7724960656347092.,8395508117246988.,-.475495827510087603492,-50,44,
 7724960656347208.,8395508117247853.,-.499135481430738636191,-50,44,
 7724960656351145.,8395508117277210.,-.499732993122209587785,-50,44,
 7724960656352923.,8395508117290467.,.499997196536571103956,-50,44,
 7788342745744418.,8881685095300496.,.499997627444520232506,-50,44,
 7788342745746158.,8881685095314222.,.499668174939380434512,-50,44,
 7788342745746436.,8881685095316416.,-.495786758610495387427,-50,44,
 7788342745746445.,8881685095316487.,-.499236738464572079810,-50,44,
 4542341907339422.,7022211662856702.,.499977423319358759624,-49,42,
 4542341907341188.,7022211662878731.,.497917677317308585514,-49,42,
 4542341907341207.,7022211662878969.,-.497008219913987431674,-49,42,
 4542341907341245.,7022211662879443.,-.486860014352582143035,-49,42,
 4542341907341591.,7022211662883759.,-.499721088558299858840,-49,42,
 4542341907342378.,7022211662893575.,.499927287216852424931,-49,42,
 4542341907419042.,7022211663849879.,-.499952188334691099921,-49,42,
 4564032971364046.,7298065279113091.,-.499983053371904118355,-49,42,
 4564032971383472.,7298065279364929.,-.499980539334920156869,-49,42,
 4564032971402898.,7298065279616767.,-.499969334994567769127,-49,42,
 4564032971403009.,7298065279618206.,-.499763336397350542812,-49,42,
 4564032971403010.,7298065279618218.,.464202483411121197839,-49,42,
 4694545676306502.,4601117480685111.,.499997909426242098224,-49,41,
 4694545676312194.,4601117480731633.,.499955318864364923711,-49,41,
 4694545676315040.,4601117480754894.,.499934199977828089378,-49,41,
 4694545676315548.,4601117480759046.,.498524961329434926433,-49,41,
 4945710919737051.,7188325623296342.,-.499999896902468880930,-49,41,
 4945710919749360.,7188325623453515.,.499962530660116711094,-49,41,
 4945710919752053.,7188325623487902.,.499873527269249062764,-49,41,
 4945710919753144.,7188325623501834.,-.487537158439035412816,-49,41,
 4945710919753196.,7188325623502498.,-.497936200530158943789,-49,41,
 4945710919753209.,7188325623502663.,.499464038956643468977,-49,41,
 4945710919753590.,7188325623507529.,-.499805863612293129692,-49,41,
 5043885832655678.,8557875242312002.,.499993917239716987180,-49,41,
 5043885832659483.,8557875242369846.,-.499888250339496144489,-49,41,
 5043885832660028.,8557875242378131.,-.497243219993533580869,-49,41,
 5043885832660216.,8557875242380988.,.448623324445145454659,-49,41,
 5043885832660236.,8557875242381292.,.485417637739470895975,-49,41,
 5043885832660246.,8557875242381445.,-.496185205609315799440,-49,41,
 5043885832689705.,8557875242829276.,-.499989705392142014896,-49,41,
 5359395441741372.,7494447404588835.,-.499998948521156916982,-49,40,
 5359395441747967.,7494447404676633.,-.499837033000684638914,-49,40,
 5359395441748162.,7494447404679228.,.498651469922180395896,-49,40,
 5359395441748178.,7494447404679442.,-.496344345182691824392,-49,40,
 5359395441748226.,7494447404680081.,-.481331790460984686847,-49,40,
 5359395441748229.,7494447404680120.,.457106494210931104678,-49,40,
 5359395441751963.,7494447404729830.,.499958314182522417654,-49,40,
 5417777045983376.,8313402414882149.,-.499999098571969556454,-49,40,
 5417777045993977.,8313402415038700.,-.499870947275204111019,-49,40,
 5417777045994347.,8313402415044164.,-.499300436908078564221,-49,40,
 5417777045995599.,8313402415062652.,.497224668050994176225,-49,40,
 5417777045995616.,8313402415062904.,-.454100470017243957087,-49,40,
 5417777045995642.,8313402415063288.,-.497303622342238326430,-49,40,
 5417777046000921.,8313402415141246.,-.499974067468689664549,-49,40,
 5396865810819085.,7123663344871206.,-.499968818931443439354,-48,26,
 5396865810830673.,7123663345164479.,-.499978757533046260989,-48,26,
 5396865810842261.,7123663345457752.,-.499976622423644042760,-48,26,
 5396865810847035.,7123663345578573.,.497093699128169654620,-48,26,
 5396865810847048.,7123663345578903.,-.494535557776653072837,-48,26,
 5396865810847155.,7123663345581610.,.497439020583972301293,-48,26,
 5396865810847995.,7123663345602869.,.499856307027622197044,-48,26,
 7965945805096429.,8002183149656719.,-.499786367402641454799,-48,13,
 7965945805096692.,8002183149664195.,.449649617845319015704,-48,13,
 7965945805096713.,8002183149664792.,.468425875523719811147,-48,13,
 7965945805096748.,8002183149665787.,.499719638420036186289,-48,13,
 7965945805100583.,8002183149774815.,-.499948734720221626187,-48,13,
 7965945805102660.,8002183149833862.,.499970735192562919012,-48,13,
 7965945805175518.,8002183151905177.,-.499689640550705184286,-48,13,
 4742590337501440.,6902912729958547.,-.499791597756691988853,-47,5,
 4742590337529418.,6902912731330815.,.499995944890535838764,-47,5,
 4742590337535213.,6902912731615050.,-.499906729618965351299,-47,5,
 4742590337536210.,6902912731663951.,-.499371117623517187373,-47,5,
 4742590337536480.,6902912731677193.,.499770983349898577492,-47,5,
 4742590337538744.,6902912731788238.,.499985748240312226939,-47,5,
 7812346276767154.,4773890120435627.,.499999223549589327066,-47,-27,
 7812346276767758.,4773890120456115.,.499795477880875491108,-47,-27,
 7812346276773949.,4773890120666117.,.497712154369573678518,-47,-27,
 7812346276774704.,4773890120691727.,.497458722508517073853,-47,-27,
 7812346276774729.,4773890120692576.,-.489304633812435224223,-47,-27,
 7812346276774742.,4773890120693016.,.477578420960201485716,-47,-27,
 7812346276786872.,4773890121104473.,-.499984259957419659942,-47,-27,
 8537085079154113.,6428300279494627.,-.499786505797731951695,-47,-34,
 8537085079189908.,6428300281129593.,-.498739060923929303068,-47,-34,
 8537085079189945.,6428300281131283.,-.493373885442317404204,-47,-34,
 8537085079189954.,6428300281131694.,-.410987761609338846542,-47,-34,
 8537085079190272.,6428300281146218.,.499988630696702111159,-47,-34,
 7887937924523939.,7407705720475554.,-.498709669735366824573,-46,-108,
 7887937924555848.,7407705723834609.,-.499924082026958885715,-46,-108,
 7887937924562782.,7407705724564550.,-.499955180450885535513,-46,-108,
 7887937924565517.,7407705724852462.,.484621125066195505260,-46,-108,
 7887937924565543.,7407705724855200.,-.499803324367340099474,-46,-108,
 7887937924566955.,7407705725003840.,.499916555920218348053,-46,-108,
 7976418890558873.,6511804223309966.,-.486803229067335768622,-46,-110,
 7976418890693585.,6511804235775986.,-.499926238038002742702,-46,-110,
 7976418890700425.,6511804236408947.,.498975119506248740861,-46,-110,
 7976418890700451.,6511804236411353.,.494877493507082416526,-46,-110,
 7976418890700503.,6511804236416165.,.486682244175667908551,-46,-110,
 7976418890700516.,6511804236417368.,.484633432398422227535,-46,-110,
 7976418890700908.,6511804236453643.,.499777058580786193667,-46,-110,
 7976418890702370.,6511804236588935.,-.499864063559603630815,-46,-110,
 7976418890704811.,6511804236814821.,-.499942600236516785424,-46,-110,
 8046222506214430.,8779666513224927.,.499994955997590156290,-46,-111,
 8046222506214614.,8779666513247885.,-.451995819086715668690,-46,-111,
 8046222506214627.,8779666513249507.,-.486647338969034067781,-46,-111,
 8046222506214687.,8779666513256993.,-.492731273004470103160,-46,-111,
 8046222506214747.,8779666513264479.,-.498815200656963822130,-46,-111,
 6421234419882807.,5526901623081647.,-.495807702859459976745,-45,-210,
 6421234419926133.,5526901629887468.,-.455020184386152560929,-45,-210,
 6421234419926156.,5526901629891080.,.476799843816789748820,-45,-210,
 6421234419926192.,5526901629896736.,-.499481846428508736774,-45,-210,
 6421234419928847.,5526901630313793.,.499759446866686612616,-45,-210,
 6421234419931883.,5526901630790701.,-.499939623526242841926,-45,-210,
 6756582954602484.,4649433839470792.,.499415698389671490689,-45,-224,
 6756582954603126.,4649433839555629.,.497996524024508381845,-45,-224,
 6756582954603202.,4649433839565673.,-.492825581059961912677,-45,-224,
 6756582954604341.,4649433839716185.,.499987837578218607871,-45,-224,
 6756582954614910.,4649433841112825.,-.499740261372253343229,-45,-224,
 8636315524956833.,4901912698559709.,-.499613649465461798330,-45,-301,
 8636315524970754.,4901912700499192.,.499642077986144354495,-45,-301,
 8636315524970888.,4901912700517861.,.478591304076595080281,-45,-301,
 8636315524970913.,4901912700521344.,.497051988455977950220,-45,-301,
 8636315524971892.,4901912700657739.,.499974334795339818199,-45,-301,
 8636315524996214.,4901912704046299.,-.498728346812131777995,-45,-301,
 4505638334066944.,6356350718455076.,-.497923161792008441519,-44,-316,
 4505638334076126.,6356350721772686.,-.499669921115817928843,-44,-316,
 4505638334080717.,6356350723431491.,-.499893957904720324758,-44,-316,
 4505638334081118.,6356350723576378.,.499453578118113417080,-44,-316,
 4505638334081137.,6356350723583244.,-.483120895583154692273,-44,-316,
 4505638334096154.,6356350729009137.,-.497690124073156378095,-44,-316,
 4582746875109235.,7954075502389043.,-.494718295771110974393,-44,-322,
 4582746875109257.,7954075502398990.,-.484118768121196167207,-44,-322,
 4582746875109264.,7954075502402154.,.473799266012428640856,-44,-322,
 4582746875109403.,7954075502465001.,.495314776025352590582,-44,-322,
 4582746875110638.,7954075503023390.,.499449206848737918913,-44,-322,
 4582746875110828.,7954075503109297.,-.499911247597312729022,-44,-322,
 4582746875129791.,7954075511683168.,-.494571849021118208244,-44,-322,
 4582746875136112.,7954075514541125.,-.490738280149710491757,-44,-322,
 4848965914897291.,7079808463743031.,-.483179027637735954009,-44,-344,
 4848965914935530.,7079808479131953.,.499773963740814494046,-44,-344,
 4848965914935614.,7079808479165759.,-.496643933337750456507,-44,-344,
 4848965914935639.,7079808479175820.,-.483673038204358235689,-44,-344,
 4848965914935648.,7079808479179441.,.480996487543705495554,-44,-344,
 4848965914940002.,7079808480931668.,-.499773439889881079648,-44,-344,
 5186340917188073.,5621926320879560.,-.496818148560891880119,-44,-372,
 5186340917201646.,5621926325217077.,-.499778686535376369589,-44,-372,
 5186340917205897.,5621926326575566.,.499761255281790672949,-44,-372,
 5186340917206717.,5621926326837614.,-.499584003788401578012,-44,-372,
 5186340917206789.,5621926326860623.,-.494647882232333169203,-44,-372,
 5399152085230348.,7691275701060621.,-.497497063478143760459,-44,-389,
 5399152085240766.,7691275705615354.,-.499842756744819005237,-44,-389,
 5399152085244531.,7691275707261406.,-.499163054224787022532,-44,-389,
 5399152085244541.,7691275707265777.,.484902965192620932403,-44,-389,
 5399152085244556.,7691275707272335.,.461001998978455143262,-44,-389,
 5399152085244657.,7691275707316493.,-.499931027948111264922,-44,-389,
 5534403477927994.,8195778799077288.,.495250284874012107452,-44,-400,
 5534403477928002.,8195778799081016.,-.496052382435343531306,-44,-400,
 5534403477928115.,8195778799133660.,-.498202377135870301116,-44,-400,
 5534403477928228.,8195778799186303.,.499647966312127623532,-44,-400,
 5534403477929608.,8195778799829212.,.499971476982226414338,-44,-400,
 5534403477930068.,8195778800043516.,-.499909478949758014236,-44,-400,
 5534403477940301.,8195778804810826.,-.497986329962504082513,-44,-400,
 5534403477981693.,8195778824094369.,-.461815381781028886350,-44,-400,
 5547653687336403.,8702925765059417.,.483577404165047872501,-44,-401,
 5547653687336457.,8702925765086132.,-.497475354147246911776,-44,-401,
 5547653687336555.,8702925765134612.,.499873553173188902284,-44,-401,
 5547653687341833.,8702925767745661.,-.499650625774321675009,-44,-401,
 5547653687347111.,8702925770356709.,-.498391439237077559301,-44,-401,
 5557937445668162.,7807431727934700.,.499849859029571352155,-44,-402,
 5557937445668343.,7807431728015029.,-.498888921814914452944,-44,-402,
 5557937445668524.,7807431728095357.,-.497626876192002082109,-44,-402,
 5557937445668534.,7807431728099795.,-.486507402065637299142,-44,-402,
 5557937445668544.,7807431728104233.,-.475387925416555266442,-44,-402,
 5557937445669781.,7807431728653215.,-.499889206976388931447,-44,-402,
 5557937445673738.,7807431730409336.,-.499590813995173003903,-44,-402,
 5557937445685609.,7807431735677699.,-.496325615504508218765,-44,-402,
 5632072767865983.,8250700900944252.,-.499909879133974005525,-44,-408,
 5632072767867007.,8250700901424506.,-.499555298872912508873,-44,-408,
 5632072767867008.,8250700901424974.,.498491936059843061216,-44,-408,
 5632072767867045.,8250700901442327.,.426239647313394222575,-44,-408,
 5632072767867183.,8250700901507049.,.156758459847635463887,-44,-408,
 5632072767871104.,8250700903345991.,-.499810089078719565251,-44,-408,
 5632072767881858.,8250700908389596.,-.497129610021902175684,-44,-408,
 6581541848035283.,7507381152160504.,-.498402689001539306386,-44,-486,
 6581541848041496.,7507381154811872.,-.499630590871741037118,-44,-486,
 6581541848046665.,7507381157017717.,.499095702545655263196,-44,-486,
 6581541848046716.,7507381157039482.,-.495109805030649724449,-44,-486,
 6581541848046759.,7507381157057832.,-.451008517295751079114,-44,-486,
 6581541848046767.,7507381157061246.,-.489315249512789341267,-44,-486,
 6581541848047187.,7507381157240478.,.499583489370896278834,-44,-486,
 6581541848047709.,7507381157463240.,-.499922113980503472743,-44,-486,
 6968330978519075.,6181700943535965.,-.496788908801628130171,-44,-518,
 6968330978536938.,6181700949812826.,.499307063831386590867,-44,-518,
 6968330978536974.,6181700949825477.,-.496103874476665069500,-44,-518,
 6968330978537010.,6181700949838127.,-.491514786898214389742,-44,-518,
 6968330978537375.,6181700949966383.,.499459368363976546908,-44,-518,
 6968330978538686.,6181700950427054.,.499939168625938942144,-44,-518,
 6968330978539123.,6181700950580612.,-.499893269065342434562,-44,-518,
 6968330978552197.,6181700955174672.,-.497692717301887855346,-44,-518,
 7761973902128715.,6556152117765510.,.499969887708502287544,-44,-583,
 7761973902129074.,6556152117899301.,-.497789377863418856338,-44,-583,
 7761973902129080.,6556152117901537.,-.453183659941044711724,-44,-583,
 7761973902138086.,6556152121257840.,-.499141386949237484992,-44,-583,
 7913771579840985.,8947164558816602.,.498380270945586509408,-44,-595,
 7913771579841031.,8947164558839998.,-.480178562588342259347,-44,-595,
 7913771579841128.,8947164558889330.,.499817141116101480227,-44,-595,
 7913771579845326.,8947164561024381.,-.499695796129591403574,-44,-595,
 7913771579981046.,8947164630049866.,-.216601222637963473255,-44,-595,
 8808344494359725.,5749013029932587.,-.498822382396512294085,-44,-669,
 8808344494366584.,5749013032174064.,-.499861746475929277697,-44,-669,
 8808344494370919.,5749013033590714.,-.435189668485412639521,-44,-669,
 8808344494370929.,5749013033593982.,-.499630621141919610756,-44,-669,
 8808344494372605.,5749013034141688.,-.499908040847537708067,-44,-669,
 8808344494379464.,5749013036383165.,-.499306322705319969752,-44,-669,
 4625564355619192.,7135614685389964.,-.447670891014023556079,-43,-705,
 4625564355652837.,7135614712683645.,-.498304484284059041467,-43,-705,
 4625564355652868.,7135614712708792.,.491323990110166058559,-43,-705,
 4625564355652877.,7135614712716094.,-.479429016852182303834,-43,-705,
 4625564355652939.,7135614712766389.,.499828249284759064112,-43,-705,
 4625564355653999.,7135614713626289.,-.499912035141272052599,-43,-705,
 4625564355658820.,7135614717537207.,-.498366810719193825149,-43,-705,
 4664178663129294.,8990368397329646.,-.499913302412312910009,-43,-711,
 4664178663129941.,8990368397990935.,.499930978410657163987,-43,-711,
 4664178663130380.,8990368398439631.,.496761829193857582381,-43,-711,
 4664178663130403.,8990368398463139.,.487484791810139979832,-43,-711,
 4664178663130415.,8990368398475405.,-.473877116336351092721,-43,-711,
 4664178663130588.,8990368398652225.,.499823900673506824988,-43,-711,
 4664178663171118.,8990368440077394.,-.403739920530770586750,-43,-711,
 4887831931625084.,7214847005082417.,-.492974961196899834386,-43,-748,
 4887831931636918.,7214847014789056.,-.499956758558979066773,-43,-748,
 4887831931637364.,7214847015154879.,.481275963574088102956,-43,-748,
 4887831931637377.,7214847015165543.,-.487880651964880483734,-43,-748,
 4887831931637437.,7214847015214757.,-.499372519466327569769,-43,-748,
 4887831931652059.,7214847027208206.,-.489931195956647269708,-43,-748,
 4989511469972917.,5767646392879129.,.499053860038163566568,-43,-765,
 4989511469972985.,5767646392923717.,.471660230514392274199,-43,-765,
 4989511469972995.,5767646392930275.,-.473544685931227234128,-43,-765,
 4989511469973063.,5767646392974862.,.499062079932118746087,-43,-765,
 4989511469977005.,5767646395559653.,.499884660194432438479,-43,-765,
 4989511469989269.,5767646403601226.,-.490148269325651514879,-43,-765,
 4989511469989707.,5767646403888425.,-.489584937633964372021,-43,-765,
 5128618859971983.,5076175952917505.,.499825834294403903218,-43,-788,
 5128618859972195.,5076175953039850.,-.489109882525163575443,-43,-788,
 5128618859972205.,5076175953045620.,.454808316864871650437,-43,-788,
 5128618859972216.,5076175953051968.,.493118343771638611527,-43,-788,
 5128618859972322.,5076175953113140.,.498651737163190770803,-43,-788,
 5128618859977047.,5076175955839912.,-.499228861082758637753,-43,-788,
 5353579675879775.,4726553566564203.,.499993384924382331011,-43,-825,
 5353579675880069.,4726553566722183.,.496917551041868116698,-43,-825,
 5353579675880360.,4726553566878551.,.453061976454965328861,-43,-825,
 5353579675880363.,4726553566880163.,.493846997471758422877,-43,-825,
 5353579675895418.,4726553574969922.,-.493064786104045750761,-43,-825,
 5884039778457535.,4738512154109118.,-.394671283661082662327,-43,-912,
 5884039778485760.,4738512169314108.,-.471686402944823646552,-43,-912,
 5884039778513985.,4738512184519098.,-.499911583311221520904,-43,-912,
 5884039778516104.,4738512185660617.,-.498821604725491767551,-43,-912,
 5884039778516179.,4738512185701019.,.486120549917476234036,-43,-912,
 5884039778516196.,4738512185710177.,.496040819529227613208,-43,-912,
 5884039778516707.,4738512185985457.,-.499876931867516303060,-43,-912,
 6243313862843034.,9006272252385836.,-.210060427227841147163,-43,-970,
 6243314758582472.,9007189441869835.,.413784844360260244941,-43,-970,
 6243314768069474.,9007199156554539.,-.359155672558888708604,-43,-970,
 6243314768164400.,9007199253758762.,.105738205931081010647,-43,-970,
 6243314768165349.,9007199254730538.,.105684656195249555615,-43,-970,
 6243314768165359.,9007199254740778.,.105684650131313781083,-43,-970,
 6243314768165360.,4503599627370901.,.052842325082602236839,-43,-971 };
#include "trailer.h"
