<!-- NOTE: README.md is generated from src/README.md -->

# @codemirror/lang-javascript [![NPM version](https://img.shields.io/npm/v/@codemirror/lang-javascript.svg)](https://www.npmjs.org/package/@codemirror/lang-javascript)

[ [**WEBSITE**](https://codemirror.net/) | [**ISSUES**](https://github.com/codemirror/dev/issues) | [**FORUM**](https://discuss.codemirror.net/c/next/) | [**CHANGELOG**](https://github.com/codemirror/lang-javascript/blob/main/CHANGELOG.md) ]

This package implements JavaScript language support for the
[CodeMirror](https://codemirror.net/) code editor.

The [project page](https://codemirror.net/) has more information, a
number of [examples](https://codemirror.net/examples/) and the
[documentation](https://codemirror.net/docs/).

This code is released under an
[MIT license](https://github.com/codemirror/lang-javascript/tree/main/LICENSE).

We aim to be an inclusive, welcoming community. To make that explicit,
we have a [code of
conduct](http://contributor-covenant.org/version/1/1/0/) that applies
to communication around the project.

## Usage

```javascript
import {EditorView, basicSetup} from "codemirror"
import {javascript} from "@codemirror/lang-javascript"

const view = new EditorView({
  parent: document.body,
  doc: `console.log("Hello world")`,
  extensions: [basicSetup, javascript()]
})
```

## API Reference

@javascript

@javascriptLanguage
@typescriptLanguage
@jsxLanguage
@tsxLanguage
@autoCloseTags

@snippets
@typescriptSnippets
@localCompletionSource
@completionPath
@scopeCompletionSource

@esLint
