/*
 * Contributed by Stephane Eranian <eranian@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * This file is part of libpfm, a performance monitoring support library for
 * applications on Linux.
 *
 * PMU: gnr_unc_imc (GraniteRapids Uncore IMC)
 * Based on Intel JSON event table version   : 1.06
 * Based on Intel JSON event table published : 01/17/2025
 */

static const intel_x86_umask_t gnr_imc_unc_m_act_count[]={
  { .uname   = "ALL",
    .udesc   = "Counts the number of DRAM Activate commands sent on this channel.  Activate commands are issued to open up a page on the DRAM devices so that it can be read or written to with a CAS.  One can calculate the number of Page Misses by subtracting the number of Page Miss precharges from the number of Activates.",
    .ucode   = 0xf700ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "RD",
    .udesc   = "Read transaction on Page Empty or Page Miss : Counts the number of DRAM Activate commands sent on this channel.  Activate commands are issued to open up a page on the DRAM devices so that it can be read or written to with a CAS.  One can calculate the number of Page Misses by subtracting the number of Page Miss precharges from the number of Activates. (experimental)",
    .ucode   = 0xf100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UFILL",
    .udesc   = "Underfill Read transaction on Page Empty or Page Miss : Counts the number of DRAM Activate commands sent on this channel.  Activate commands are issued to open up a page on the DRAM devices so that it can be read or written to with a CAS.  One can calculate the number of Page Misses by subtracting the number of Page Miss precharges from the number of Activates. (experimental)",
    .ucode   = 0xf400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WR",
    .udesc   = "Write transaction on Page Empty or Page Miss : Counts the number of DRAM Activate commands sent on this channel.  Activate commands are issued to open up a page on the DRAM devices so that it can be read or written to with a CAS.  One can calculate the number of Page Misses by subtracting the number of Page Miss precharges from the number of Activates. (experimental)",
    .ucode   = 0xf200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t gnr_imc_unc_m_cas_count_sch0[]={
  { .uname   = "ALL",
    .udesc   = "CAS count for SubChannel 0, all CAS operations",
    .ucode   = 0xff00ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "RD",
    .udesc   = "CAS count for SubChannel 0, all reads",
    .ucode   = 0xcf00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RD_REG",
    .udesc   = "CAS count for SubChannel 0 regular reads",
    .ucode   = 0xc100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RD_UNDERFILL",
    .udesc   = "CAS count for SubChannel 0 underfill reads",
    .ucode   = 0xc400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WR",
    .udesc   = "CAS count for SubChannel 0, all writes",
    .ucode   = 0xf000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WR_NONPRE",
    .udesc   = "CAS count for SubChannel 0 regular writes (experimental)",
    .ucode   = 0xd000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WR_PRE",
    .udesc   = "CAS count for SubChannel 0 auto-precharge writes (experimental)",
    .ucode   = 0xe000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t gnr_imc_unc_m_cas_count_sch1[]={
  { .uname   = "ALL",
    .udesc   = "CAS count for SubChannel 1, all CAS operations",
    .ucode   = 0xff00ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "RD",
    .udesc   = "CAS count for SubChannel 1, all reads",
    .ucode   = 0xcf00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RD_REG",
    .udesc   = "CAS count for SubChannel 1 regular reads",
    .ucode   = 0xc100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RD_UNDERFILL",
    .udesc   = "CAS count for SubChannel 1 underfill reads",
    .ucode   = 0xc400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WR",
    .udesc   = "CAS count for SubChannel 1, all writes",
    .ucode   = 0xf000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WR_NONPRE",
    .udesc   = "CAS count for SubChannel 1 regular writes (experimental)",
    .ucode   = 0xd000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WR_PRE",
    .udesc   = "CAS count for SubChannel 1 auto-precharge writes (experimental)",
    .ucode   = 0xe000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t gnr_imc_unc_m_powerdown_cycles[]={
  { .uname   = "SCH0_RANK0",
    .udesc   = "Number of cycles a given rank is in Power Down Mode (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SCH0_RANK1",
    .udesc   = "Number of cycles a given rank is in Power Down Mode (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SCH0_RANK2",
    .udesc   = "Number of cycles a given rank is in Power Down Mode (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SCH0_RANK3",
    .udesc   = "Number of cycles a given rank is in Power Down Mode (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SCH1_RANK0",
    .udesc   = "Number of cycles a given rank is in Power Down Mode (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SCH1_RANK1",
    .udesc   = "Number of cycles a given rank is in Power Down Mode (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SCH1_RANK2",
    .udesc   = "Number of cycles a given rank is in Power Down Mode (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SCH1_RANK3",
    .udesc   = "Number of cycles a given rank is in Power Down Mode (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t gnr_imc_unc_m_pre_count[]={
  { .uname   = "ALL",
    .udesc   = "Counts the number of DRAM Precharge commands sent on this channel.",
    .ucode   = 0xff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PGT",
    .udesc   = "Precharge due to (?) : Counts the number of DRAM Precharge commands sent on this channel.",
    .ucode   = 0xf800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RD",
    .udesc   = "Counts the number of DRAM Precharge commands sent on this channel. (experimental)",
    .ucode   = 0xf100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UFILL",
    .udesc   = "Counts the number of DRAM Precharge commands sent on this channel. (experimental)",
    .ucode   = 0xf400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WR",
    .udesc   = "Counts the number of DRAM Precharge commands sent on this channel. (experimental)",
    .ucode   = 0xf200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t gnr_imc_unc_m_rdb_inserts[]={
  { .uname   = "SCH0",
    .udesc   = "Read buffer inserts on subchannel 0",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SCH1",
    .udesc   = "Read buffer inserts on subchannel 1",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t gnr_imc_unc_m_rpq_inserts[]={
  { .uname   = "PCH0",
    .udesc   = "Counts the number of allocations into the Read Pending Queue.  This queue is used to schedule reads out to the memory controller and to track the requests.  Requests allocate into the RPQ soon after they enter the memory controller, and need credits for an entry in this buffer before being sent from the HA to the iMC.  They deallocate after the CAS command has been issued to memory.  This includes both ISOCH and non-ISOCH requests. (experimental)",
    .ucode   = 0x5000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PCH1",
    .udesc   = "Counts the number of allocations into the Read Pending Queue.  This queue is used to schedule reads out to the memory controller and to track the requests.  Requests allocate into the RPQ soon after they enter the memory controller, and need credits for an entry in this buffer before being sent from the HA to the iMC.  They deallocate after the CAS command has been issued to memory.  This includes both ISOCH and non-ISOCH requests. (experimental)",
    .ucode   = 0xa000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SCH0_PCH0",
    .udesc   = "Read Pending Queue inserts for subchannel 0, pseudochannel 0",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SCH0_PCH1",
    .udesc   = "Read Pending Queue inserts for subchannel 0, pseudochannel 1",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SCH1_PCH0",
    .udesc   = "Read Pending Queue inserts for subchannel 1, pseudochannel 0",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SCH1_PCH1",
    .udesc   = "Read Pending Queue inserts for subchannel 1, pseudochannel 1",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t gnr_imc_unc_m_self_refresh[]={
  { .uname   = "ENTER_SUCCESS",
    .udesc   = "Number of cycles all ranks were in SR subevent1 - # of times all ranks went into SR subevent2 -# of times  ps_sr_active asserted (SRE) subevent3 - # of times ps_sr_active deasserted (SRX) subevent4 - # of times PS-&>Refresh ps_sr_req asserted (SRE) subevent5 - # of times PS-&>Refresh ps_sr_req deasserted (SRX) subevent6 - # of cycles PSCtrlr FSM was in FATAL (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ENTER_SUCCESS_CYCLES",
    .udesc   = "Number of cycles all ranks were in SR (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t gnr_imc_unc_m_wpq_inserts[]={
  { .uname   = "PCH0",
    .udesc   = "Write Pending Queue Allocations (experimental)",
    .ucode   = 0x5000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PCH1",
    .udesc   = "Write Pending Queue Allocations (experimental)",
    .ucode   = 0xa000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SCH0_PCH0",
    .udesc   = "Write Pending Queue inserts for subchannel 0, pseudochannel 0",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SCH0_PCH1",
    .udesc   = "Write Pending Queue inserts for subchannel 0, pseudochannel 1",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SCH1_PCH0",
    .udesc   = "Write Pending Queue inserts for subchannel 1, pseudochannel 0",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SCH1_PCH1",
    .udesc   = "Write Pending Queue inserts for subchannel 1, pseudochannel 1",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_entry_t intel_gnr_unc_imc_pe[]={
  { .name   = "UNC_M_ACT_COUNT",
    .desc   = "DRAM Activate Count",
    .code   = 0x0002,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(gnr_imc_unc_m_act_count),
    .umasks = gnr_imc_unc_m_act_count,
  },
  { .name   = "UNC_M_CAS_COUNT_SCH0",
    .desc   = "CAS count for SubChannel 0 regular reads",
    .code   = 0x0005,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(gnr_imc_unc_m_cas_count_sch0),
    .umasks = gnr_imc_unc_m_cas_count_sch0,
  },
  { .name   = "UNC_M_CAS_COUNT_SCH1",
    .desc   = "CAS count for SubChannel 1 regular reads",
    .code   = 0x0006,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(gnr_imc_unc_m_cas_count_sch1),
    .umasks = gnr_imc_unc_m_cas_count_sch1,
  },
  { .name   = "UNC_M_CLOCKTICKS",
    .desc   = "Number of DRAM DCLK clock cycles while the event is enabled.  DCLK is 1/4 of DRAM data rate.",
    .code   = 0x0001,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M_HCLOCKTICKS",
    .desc   = "Number of DRAM HCLK clock cycles while the event is enabled (experimental)",
    .code   = 0x0001,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M_POWERDOWN_CYCLES",
    .desc   = "Number of cycles a given rank is in Power Down Mode",
    .code   = 0x0047,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(gnr_imc_unc_m_powerdown_cycles),
    .umasks = gnr_imc_unc_m_powerdown_cycles,
  },
  { .name   = "UNC_M_POWER_CHANNEL_PPD_CYCLES",
    .desc   = "Number of cycles a given rank is in Power Down Mode and all pages are closed (experimental)",
    .code   = 0x0088,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M_PRE_COUNT",
    .desc   = "DRAM Precharge commands.",
    .code   = 0x0003,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(gnr_imc_unc_m_pre_count),
    .umasks = gnr_imc_unc_m_pre_count,
  },
  { .name   = "UNC_M_RDB_INSERTS",
    .desc   = "Read buffer inserts on subchannel 0",
    .code   = 0x0017,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(gnr_imc_unc_m_rdb_inserts),
    .umasks = gnr_imc_unc_m_rdb_inserts,
  },
  { .name   = "UNC_M_RDB_OCCUPANCY_SCH0",
    .desc   = "Read buffer occupancy on subchannel 0",
    .code   = 0x001a,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M_RDB_OCCUPANCY_SCH1",
    .desc   = "Read buffer occupancy on subchannel 1",
    .code   = 0x001b,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M_RPQ_INSERTS",
    .desc   = "Read Pending Queue inserts for subchannel 0, pseudochannel 0",
    .code   = 0x0010,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(gnr_imc_unc_m_rpq_inserts),
    .umasks = gnr_imc_unc_m_rpq_inserts,
  },
  { .name   = "UNC_M_RPQ_OCCUPANCY_SCH0_PCH0",
    .desc   = "Read pending queue occupancy for subchannel 0, pseudochannel 0",
    .code   = 0x0080,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M_RPQ_OCCUPANCY_SCH0_PCH1",
    .desc   = "Read pending queue occupancy for subchannel 0, pseudochannel 1",
    .code   = 0x0081,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M_RPQ_OCCUPANCY_SCH1_PCH0",
    .desc   = "Read pending queue occupancy for subchannel 1, pseudochannel 0",
    .code   = 0x0082,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M_RPQ_OCCUPANCY_SCH1_PCH1",
    .desc   = "Read pending queue occupancy for subchannel 1, pseudochannel 1",
    .code   = 0x0083,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M_SELF_REFRESH",
    .desc   = "Number of cycles all ranks were in SR",
    .code   = 0x0043,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(gnr_imc_unc_m_self_refresh),
    .umasks = gnr_imc_unc_m_self_refresh,
  },
  { .name   = "UNC_M_WPQ_INSERTS",
    .desc   = "Write Pending Queue inserts for subchannel 0, pseudochannel 0",
    .code   = 0x0022,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(gnr_imc_unc_m_wpq_inserts),
    .umasks = gnr_imc_unc_m_wpq_inserts,
  },
  { .name   = "UNC_M_WPQ_OCCUPANCY_SCH0_PCH0",
    .desc   = "Write pending queue occupancy for subchannel 0, pseudochannel 0",
    .code   = 0x0084,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M_WPQ_OCCUPANCY_SCH0_PCH1",
    .desc   = "Write pending queue occupancy for subchannel 0, pseudochannel 1",
    .code   = 0x0085,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M_WPQ_OCCUPANCY_SCH1_PCH0",
    .desc   = "Write pending queue occupancy for subchannel 1, pseudochannel 0",
    .code   = 0x0086,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M_WPQ_OCCUPANCY_SCH1_PCH1",
    .desc   = "Write pending queue occupancy for subchannel 1, pseudochannel 1",
    .code   = 0x0087,
    .modmsk = GNR_UNC_IMC_ATTRS,
    .cntmsk = 0xfull,
  },
};
/* 22 events available */
