#include "passwd.h"

#ifdef GETUSERSHELL
/*
 * change the shell
 */
chsh(p)
struct passwd *p;		/* pointer to password structure */
{
	char buf[BUFSIZ];		/* buffer for new shell */
	register char *s;		/* pointer to system shells */

	/*
	 * display the current shell
	 */
	printf("Changing login shell for %s.\nOld shell: %s\nNew shell: ",
						    p->pw_name, p->pw_shell);
	(void) fflush(stdout);

	/*
	 * read the response
	 */
	if (mgets(buf, BUFSIZ, stdin) == 0 || buf[0] == '\0'){
		printf("Login shell unchanged.\n");
		exit(0);
	}

	/*
	 * see if it's legal
	 */
	while((s = GETUSERSHELL()) != NULL)
		if (strcmp(s, buf) == 0)
			break;

	/*
	 * it's not; reject it
	 */
	if (s == NULL){
		printf("%s is unacceptable as a new shell.\n", buf);
		exit(0);
	}

	/*
	 * it is -- update the record
	 */
	p->pw_shell = s;
	(void) update_pwd(p);

	/*
	 * bye
	 */
	exit(0);
}
#endif
