/*
 * signal handling
 */
#include "passwd.h"
#include <signal.h>

/*
 * signal handling routines
 */
void (*trap[NSIG])();		/* values returned by signal() */

/*
 * grab initial values of all signals
 */
initsig()
{
	register int i;		/* counter in a for loop */

	for(i = 0; i < NSIG; i++)
		trap[i] =  signal(i, SIG_DFL);
}

/*
 * disable ALL signal trapping
 */
sigoff()
{
	register int i;		/* counter in a for loop */

	for(i = 0; i < NSIG; i++)
		(void) signal(i, SIG_IGN);
}

/*
 * restore to the initial setting all signals
 */
sigon()
{
	register int i;		/* counter in a for loop */

	for(i = 0; i < NSIG; i++)
		(void) signal(i, trap[i]);

}

#ifdef ALLOWCORE

/*
 * if you are allowing core dumps, this subroutine
 * (designed to disable core dumping) is a no-op
 */
nocore()
{
}

#else

/*
 * the trapper
 */
trapsig(n)
int n;
{
	char sigmsg[BUFSIZ];

	SPRINTF(sigmsg, "Caught signal #%d -- no change.", n);
	pwexit(sigmsg);
}

/*
 * trap signals causing core dumps
 * and terminate gracefully
 */
nocore()
{
	register int i;		/* counter in a for loop */

	for(i = 0; i < NSIG; i++)
		(void) signal(i, trapsig);
}

#endif
