use strict;
use warnings;

package Passwd::Keyring::Auto::App::Command::create_config;
# ABSTRACT: creates initial config file

use Passwd::Keyring::Auto::App -command;

sub abstract { 'create initial version of the config file' }

sub usage_desc { '%c %o <ModuleName>' }

sub usage { "TODO usage" }

sub description { "TODO description" }

sub opt_spec {
  [ 'profile|p=s',  'name of the profile to use',
    { default => 'default' }  ],

  [ 'provider|P=s', 'name of the profile provider to use',
    { default => 'Default' }  ],

  # [ 'module|m=s@', 'module(s) to create; may be given many times'         ],
}

sub validate_args {
  my ($self, $opt, $args) = @_;

  require MooseX::Types::Perl;

  $self->usage_error('dzil add takes one or more arguments') if @$args < 1;

  for my $name ( @$args ) {
    $self->usage_error("$name is not a valid module name")
      unless MooseX::Types::Perl::is_ModuleName($name);
  }
}

sub execute {
  my ($self, $opt, $arg) = @_;
}

1;
