/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.pde.internal.PDE;

public abstract class BaseProject
extends PlatformObject
implements IProjectNature {
    private IProject project;

    protected void addToBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand builderCommand = this.getBuilderCommand(description, builderID);
        if (builderCommand == null) {
            ICommand command = description.newCommand();
            command.setBuilderName(builderID);
            this.setBuilderCommand(description, command);
        }
    }

    private ICommand getBuilderCommand(IProjectDescription description, String builderId) throws CoreException {
        ICommand[] commands = description.getBuildSpec();
        for (int i = 0; i < commands.length; ++i) {
            if (!commands[i].getBuilderName().equals(builderId)) continue;
            return commands[i];
        }
        return null;
    }

    public IProject getProject() {
        return this.project;
    }

    protected IWorkspace getWorkspace() {
        return PDE.getWorkspace();
    }

    protected void removeFromBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        for (int i = 0; i < commands.length; ++i) {
            if (!commands[i].getBuilderName().equals(builderID)) continue;
            ICommand[] newCommands = new ICommand[commands.length - 1];
            System.arraycopy(commands, 0, newCommands, 0, i);
            System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
            description.setBuildSpec(newCommands);
            return;
        }
    }

    private void setBuilderCommand(IProjectDescription description, ICommand newCommand) throws CoreException {
        ICommand[] newCommands;
        ICommand[] oldCommands = description.getBuildSpec();
        ICommand oldBuilderCommand = this.getBuilderCommand(description, newCommand.getBuilderName());
        if (oldBuilderCommand == null) {
            newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 0, oldCommands.length);
            newCommands[oldCommands.length] = newCommand;
        } else {
            int max = oldCommands.length;
            for (int i = 0; i < max; ++i) {
                if (oldCommands[i] != oldBuilderCommand) continue;
                oldCommands[i] = newCommand;
                break;
            }
            newCommands = oldCommands;
        }
        description.setBuildSpec(newCommands);
        this.getProject().setDescription(description, null);
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

