/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.site;

import java.io.PrintWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.isite.ISiteBuild;
import org.eclipse.pde.internal.core.isite.ISiteBuildFeature;
import org.eclipse.pde.internal.core.site.SiteBuildObject;
import org.w3c.dom.Node;

public class SiteBuildFeature
extends SiteBuildObject
implements ISiteBuildFeature {
    private String id;
    private String version;
    private IFeature feature;

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setId(String id) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.id;
        this.id = id;
        this.firePropertyChanged("id", oldValue, id);
    }

    public void setVersion(String version) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.version;
        this.version = version;
        this.firePropertyChanged("version", oldValue, version);
    }

    protected void parse(Node node) {
        this.id = this.getNodeAttribute(node, "id");
        this.version = this.getNodeAttribute(node, "version");
    }

    public IFeature getReferencedFeature() {
        if (this.feature == null) {
            WorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
            IFeatureModel[] models = manager.getFeatureModels();
            for (int i = 0; i < models.length; ++i) {
                IFeatureModel model = models[i];
                IFeature feature = model.getFeature();
                if (!feature.getId().equals(this.id) || !feature.getVersion().equals(this.version)) continue;
                this.feature = feature;
                break;
            }
        }
        return this.feature;
    }

    public void setReferencedFeature(IFeature feature) {
        this.feature = feature;
        if (feature != null) {
            this.id = feature.getId();
            this.version = feature.getVersion();
        }
    }

    protected void reset() {
        this.id = null;
        this.version = null;
        this.feature = null;
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("id")) {
            this.setId(newValue != null ? newValue.toString() : null);
        } else if (name.equals("version")) {
            this.setVersion(newValue != null ? newValue.toString() : null);
        } else {
            super.restoreProperty(name, oldValue, newValue);
        }
    }

    public void write(String indent, PrintWriter writer) {
        writer.print(indent);
        writer.print("<feature");
        if (this.id != null) {
            writer.print(" id=\"" + this.id + "\"");
        }
        if (this.version != null) {
            writer.print(" version=\"" + this.version + "\"");
        }
        writer.println("/>");
    }

    public String getTargetURL() {
        ISiteBuild siteBuild = this.getSiteBuild();
        IPath featureLocation = siteBuild.getFeatureLocation();
        String jar = this.id + "_" + this.version + ".jar";
        return featureLocation.append(jar).toString();
    }
}

