/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.plugin.PluginExtensionPoint;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.elements.ElementLabelProvider;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.pde.internal.ui.wizards.BaseWizardSelectionPage;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.wizards.WizardCollectionElement;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.internal.ui.wizards.WizardNode;
import org.eclipse.pde.internal.ui.wizards.extension.ExtensionTreeSelectionPage;
import org.eclipse.pde.internal.ui.wizards.extension.NewExtensionTemplateWizard;
import org.eclipse.pde.internal.ui.wizards.extension.NewExtensionWizard;
import org.eclipse.pde.ui.IBasePluginWizard;
import org.eclipse.pde.ui.IExtensionWizard;
import org.eclipse.pde.ui.templates.ITemplateSection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class PointSelectionPage
extends BaseWizardSelectionPage {
    private TableViewer fPointListViewer;
    private TableViewer fTemplateViewer;
    private IPluginBase fPluginBase;
    private Button fFilterCheck;
    private IPluginExtensionPoint fCurrentPoint;
    private HashSet fAvailableImports;
    private Action showDetailsAction;
    private IProject project;
    private Label templateLabel;
    private ExtensionTreeSelectionPage wizardsPage;
    private IPluginExtension fNewExtension;
    private ShowDescriptionAction fShowDescriptionAction;
    private WizardCollectionElement templateCollection;
    private WizardCollectionElement wizardCollection;
    private NewExtensionWizard wizard;

    public PointSelectionPage(IProject project, IPluginBase model, WizardCollectionElement element, WizardCollectionElement templates, NewExtensionWizard wizard) {
        super("pointSelectionPage", PDEPlugin.getResourceString("NewExtensionWizard.PointSelectionPage.title"));
        this.fPluginBase = model;
        this.wizardCollection = element;
        this.templateCollection = templates;
        this.wizard = wizard;
        this.project = project;
        this.fAvailableImports = PluginSelectionDialog.getExistingImports(model);
        this.setTitle(PDEPlugin.getResourceString("NewExtensionWizard.PointSelectionPage.title"));
        this.setDescription(PDEPlugin.getResourceString("NewExtensionWizard.PointSelectionPage.desc"));
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.makeActions();
    }

    public void createControl(Composite parent) {
        final TabFolder tabFolder = new TabFolder(parent, 0x800000);
        TabItem firstTab = new TabItem(tabFolder, 0);
        firstTab.setText(PDEPlugin.getResourceString("PointSelectionPage.tab1"));
        TabItem secondTab = new TabItem(tabFolder, 0);
        secondTab.setText(PDEPlugin.getResourceString("PointSelectionPage.tab2"));
        secondTab.setControl(this.createWizardsPage((Composite)tabFolder));
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PointSelectionPage.this.updateTabSelection(tabFolder.getSelectionIndex());
            }
        });
        Composite outerContainer = new Composite((Composite)tabFolder, 0);
        firstTab.setControl((Control)outerContainer);
        GridLayout layout = new GridLayout();
        outerContainer.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        outerContainer.setLayoutData((Object)gd);
        Composite pointContainer = new Composite(outerContainer, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pointContainer.setLayout((Layout)layout);
        gd = new GridData(1808);
        pointContainer.setLayoutData((Object)gd);
        Label pointLabel = new Label(pointContainer, 0);
        pointLabel.setText(PDEPlugin.getResourceString("NewExtensionWizard.PointSelectionPage.availExtPoints.label"));
        this.fPointListViewer = new TableViewer(pointContainer, 2816);
        this.fPointListViewer.setContentProvider((IContentProvider)new PointContentProvider());
        this.fPointListViewer.setLabelProvider((IBaseLabelProvider)new PointLabelProvider());
        this.fPointListViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fPointListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (PointSelectionPage.this.canFinish()) {
                    PointSelectionPage.this.finish();
                    PointSelectionPage.this.wizard.getShell().close();
                    PointSelectionPage.this.wizard.dispose();
                    PointSelectionPage.this.wizard.setContainer(null);
                }
            }
        });
        this.fPointListViewer.setSorter(ListUtil.NAME_SORTER);
        gd = new GridData(1808);
        gd.heightHint = 150;
        this.fPointListViewer.getTable().setLayoutData((Object)gd);
        Composite templateComposite = new Composite(outerContainer, 0);
        layout = new GridLayout();
        layout.marginHeight = 9;
        layout.marginWidth = 0;
        templateComposite.setLayout((Layout)layout);
        gd = new GridData(768);
        templateComposite.setLayoutData((Object)gd);
        this.templateLabel = new Label(templateComposite, 0);
        this.templateLabel.setText(PDEPlugin.getResourceString("NewExtensionWizard.PointSelectionPage.contributedTemplates.title"));
        gd = new GridData(768);
        this.templateLabel.setLayoutData((Object)gd);
        SashForm templateSashForm = new SashForm(templateComposite, 256);
        templateSashForm.setLayout((Layout)new GridLayout());
        gd = new GridData(1808);
        gd.heightHint = 80;
        templateSashForm.setLayoutData((Object)gd);
        Composite wizardComposite = new Composite((Composite)templateSashForm, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        wizardComposite.setLayout((Layout)layout);
        gd = new GridData(1808);
        wizardComposite.setLayoutData((Object)gd);
        this.fTemplateViewer = new TableViewer(wizardComposite, 2816);
        this.fTemplateViewer.setContentProvider((IContentProvider)new TemplateContentProvider());
        this.fTemplateViewer.setLabelProvider((IBaseLabelProvider)ElementLabelProvider.INSTANCE);
        this.fTemplateViewer.setSorter(ListUtil.NAME_SORTER);
        this.fTemplateViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        gd = new GridData(1808);
        this.fTemplateViewer.getTable().setLayoutData((Object)gd);
        TableItem[] selection = this.fPointListViewer.getTable().getSelection();
        if (selection != null && selection.length > 0) {
            this.fTemplateViewer.setInput((Object)((IPluginExtensionPoint)selection[0]));
        }
        this.fTemplateViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (PointSelectionPage.this.canFlipToNextPage()) {
                    PointSelectionPage.this.advanceToNextPage();
                }
            }
        });
        Composite descriptionComposite = new Composite((Composite)templateSashForm, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        descriptionComposite.setLayout((Layout)layout);
        gd = new GridData(1808);
        descriptionComposite.setLayoutData((Object)gd);
        this.createDescriptionIn(descriptionComposite);
        this.fFilterCheck = new Button(outerContainer, 32);
        this.fFilterCheck.setText(PDEPlugin.getResourceString("NewExtensionWizard.PointSelectionPage.filterCheck"));
        gd = new GridData(768);
        this.fFilterCheck.setLayoutData((Object)gd);
        this.fFilterCheck.setSelection(true);
        this.fFilterCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PointSelectionPage.this.fPointListViewer.refresh();
            }
        });
        this.getContainer().getShell().setSize(500, 500);
        this.createMenuManager();
        this.initialize();
        this.setControl((Control)tabFolder);
        Dialog.applyDialogFont((Control)outerContainer);
        WorkbenchHelp.setHelp((Control)outerContainer, (String)"org.eclipse.pde.doc.user.add_extensions_schema_based");
    }

    private Control createWizardsPage(Composite parent) {
        this.wizardsPage = new ExtensionTreeSelectionPage(this.wizardCollection, null, PDEPlugin.getResourceString("PointSelectionPage.categories"));
        this.wizardsPage.createControl(parent);
        this.wizardsPage.setWizard((IWizard)this.wizard);
        this.wizardsPage.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        this.wizardsPage.init(this.project, this.fPluginBase);
        return this.wizardsPage.getControl();
    }

    private void createMenuManager() {
        MenuManager mgr = new MenuManager();
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PointSelectionPage.this.fillContextMenu(manager);
            }
        });
        mgr.setRemoveAllWhenShown(true);
        Control control = this.fPointListViewer.getControl();
        Menu menu = mgr.createContextMenu(control);
        control.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.showDetailsAction);
        ISelection selection = this.fPointListViewer.getSelection();
        IPluginExtensionPoint point = (IPluginExtensionPoint)((IStructuredSelection)selection).getFirstElement();
        this.showDetailsAction.setEnabled(point != null);
    }

    public void advanceToNextPage() {
        this.getContainer().showPage(this.getNextPage());
    }

    public boolean canFlipToNextPage() {
        return this.getNextPage() != null;
    }

    public boolean canFinish() {
        IStructuredSelection ssel;
        ISelection selection;
        if (this.fTemplateViewer != null && (selection = this.fTemplateViewer.getSelection()) instanceof IStructuredSelection && !(ssel = (IStructuredSelection)selection).isEmpty()) {
            return false;
        }
        return this.fPointListViewer != null && (selection = this.fPointListViewer.getSelection()) instanceof IStructuredSelection && !(ssel = (IStructuredSelection)selection).isEmpty();
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        this.wizardsPage.dispose();
        super.dispose();
    }

    public boolean finish() {
        String point = this.fCurrentPoint.getFullId();
        try {
            IPluginExtension extension = this.fPluginBase.getModel().getFactory().createExtension();
            extension.setPoint(point);
            this.fPluginBase.add(extension);
            String pluginID = this.fCurrentPoint.getPluginBase().getId();
            if (!this.fAvailableImports.contains(pluginID)) {
                IPluginModelBase modelBase = (IPluginModelBase)this.fPluginBase.getModel();
                IPluginImport importNode = modelBase.getPluginFactory().createImport();
                importNode.setId(pluginID);
                this.fPluginBase.add(importNode);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return true;
    }

    private void doShowDescription() {
        if (this.fShowDescriptionAction == null) {
            this.fShowDescriptionAction = new ShowDescriptionAction(this.fCurrentPoint);
        } else {
            this.fShowDescriptionAction.setExtensionPoint(this.fCurrentPoint);
        }
        BusyIndicator.showWhile((Display)this.fPointListViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                PointSelectionPage.this.fShowDescriptionAction.run();
            }
        });
    }

    public IPluginExtension getNewExtension() {
        return this.fNewExtension;
    }

    protected void initialize() {
        this.fPointListViewer.addFilter((ViewerFilter)new PointFilter());
        this.fPointListViewer.setInput((Object)PDECore.getDefault().getModelManager());
        this.fPointListViewer.getTable().setFocus();
    }

    private void makeActions() {
        this.showDetailsAction = new Action(){

            public void run() {
                PointSelectionPage.this.doShowDescription();
            }
        };
        this.showDetailsAction.setText(PDEPlugin.getResourceString("NewExtensionWizard.PointSelectionPage.showDetails"));
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        this.setDescription("");
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            if (ssel != null && !ssel.isEmpty()) {
                if (ssel.getFirstElement() instanceof IPluginExtensionPoint) {
                    this.fCurrentPoint = (IPluginExtensionPoint)ssel.getFirstElement();
                    this.fTemplateViewer.setInput((Object)this.fCurrentPoint);
                    if (this.fAvailableImports.contains(this.fCurrentPoint.getPluginBase().getId())) {
                        this.setMessage(null);
                    } else {
                        this.setMessage(PDEPlugin.getResourceString("NewExtensionWizard.PointSelectionPage.message"), 1);
                    }
                    this.setDescription(PDEPlugin.getFormattedMessage("NewExtensionWizard.PointSelectionPage.pluginDescription", this.fCurrentPoint.getFullId()));
                    this.setDescriptionText("");
                    this.templateLabel.setText(PDEPlugin.getFormattedMessage("NewExtensionWizard.PointSelectionPage.contributedTemplates.label", this.fCurrentPoint.getFullId()));
                    this.setSelectedNode(null);
                    this.setPageComplete(true);
                } else if (ssel.getFirstElement() instanceof WizardElement) {
                    WizardElement wizardSelection = (WizardElement)ssel.getFirstElement();
                    this.setSelectedNode(this.createWizardNode(wizardSelection));
                    this.setDescriptionText(wizardSelection.getDescription());
                    this.setDescription(PDEPlugin.getFormattedMessage("NewExtensionWizard.PointSelectionPage.templateDescription", wizardSelection.getLabel()));
                    this.setPageComplete(false);
                }
            } else {
                this.setSelectedNode(null);
                this.setPageComplete(false);
            }
        }
        this.getContainer().updateButtons();
    }

    private void updateTabSelection(int index) {
        if (index == 0) {
            ISelection selection = this.fTemplateViewer.getSelection();
            if (!selection.isEmpty()) {
                this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.fTemplateViewer, selection));
            } else {
                this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.fPointListViewer, this.fPointListViewer.getSelection()));
            }
        } else {
            ISelectionProvider provider = this.wizardsPage.getSelectionProvider();
            this.selectionChanged(new SelectionChangedEvent(provider, provider.getSelection()));
        }
    }

    protected IWizardNode createWizardNode(WizardElement element) {
        return new WizardNode(this, element){

            public IBasePluginWizard createWizard() throws CoreException {
                IExtensionWizard wizard = this.createWizard(this.wizardElement);
                wizard.init(PointSelectionPage.this.project, PointSelectionPage.this.fPluginBase.getPluginModel());
                return wizard;
            }

            protected IExtensionWizard createWizard(WizardElement element) throws CoreException {
                if (element.isTemplate()) {
                    IConfigurationElement template = element.getTemplateElement();
                    if (template == null) {
                        return null;
                    }
                    ITemplateSection section = (ITemplateSection)template.createExecutableExtension("class");
                    return new NewExtensionTemplateWizard(section);
                }
                return (IExtensionWizard)element.createExecutableExtension();
            }
        };
    }

    class PointLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        PointLabelProvider() {
        }

        public String getText(Object obj) {
            return this.getColumnText(obj, 0);
        }

        public String getColumnText(Object obj, int index) {
            PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
            if (provider.isFullNameModeEnabled()) {
                return provider.getText((IPluginExtensionPoint)obj);
            }
            return ((IPluginExtensionPoint)obj).getFullId();
        }

        public Image getImage(Object obj) {
            return this.getColumnImage(obj, 0);
        }

        public Image getColumnImage(Object obj, int index) {
            int flag;
            IPluginExtensionPoint exp = (IPluginExtensionPoint)obj;
            int n = flag = PointSelectionPage.this.fAvailableImports.contains(exp.getPluginBase().getId()) ? 0 : 2;
            if (((TemplateContentProvider)PointSelectionPage.this.fTemplateViewer.getContentProvider()).getElements(exp).length > 0) {
                return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_NEWEXP_WIZ_TOOL, flag);
            }
            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_EXT_POINT_OBJ, flag);
        }
    }

    class PointContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        PointContentProvider() {
        }

        public Object[] getElements(Object parent) {
            HashSet<IPluginExtensionPoint> extPoints = new HashSet<IPluginExtensionPoint>();
            PluginModelManager manager = (PluginModelManager)parent;
            IPluginModelBase[] plugins = manager.getPlugins();
            for (int i = 0; i < plugins.length; ++i) {
                IPluginExtensionPoint[] points = plugins[i].getPluginBase().getExtensionPoints();
                for (int j = 0; j < points.length; ++j) {
                    extPoints.add(points[j]);
                }
            }
            return extPoints.toArray();
        }
    }

    class TemplateContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        TemplateContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IPluginExtensionPoint) {
                PluginExtensionPoint point = (PluginExtensionPoint)inputElement;
                ArrayList<WizardElement> result = new ArrayList<WizardElement>();
                if (PointSelectionPage.this.templateCollection.getWizards() != null) {
                    Object[] wizards = PointSelectionPage.this.templateCollection.getWizards().getChildren();
                    for (int i = 0; i < wizards.length; ++i) {
                        String wizardContributorId = ((WizardElement)wizards[i]).getContributingId();
                        if (wizardContributorId == null || point == null || point.getFullId() == null || !(wizards[i] instanceof WizardElement) || !wizardContributorId.equals(point.getFullId())) continue;
                        result.add((WizardElement)wizards[i]);
                    }
                    return result.toArray();
                }
            }
            return new Object[0];
        }
    }

    class PointFilter
    extends ViewerFilter {
        PointFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!PointSelectionPage.this.fFilterCheck.getSelection()) {
                return true;
            }
            IPluginExtensionPoint point = (IPluginExtensionPoint)element;
            return PointSelectionPage.this.fAvailableImports.contains(point.getPluginBase().getId());
        }
    }
}

