/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.subscribers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.TeamStatus;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.ISubscriberChangeListener;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.internal.core.Policy;

public abstract class Subscriber {
    private List listeners = new ArrayList(1);

    public abstract String getName();

    public abstract boolean isSupervised(IResource var1) throws TeamException;

    public abstract IResource[] members(IResource var1) throws TeamException;

    public abstract IResource[] roots();

    public abstract SyncInfo getSyncInfo(IResource var1) throws TeamException;

    public abstract IResourceVariantComparator getResourceComparator();

    public abstract void refresh(IResource[] var1, int var2, IProgressMonitor var3) throws TeamException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ISubscriberChangeListener listener) {
        List list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ISubscriberChangeListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectOutOfSync(IResource[] resources, int depth, SyncInfoSet set, IProgressMonitor monitor) {
        try {
            monitor.beginTask(null, 100 * resources.length);
            for (int i = 0; i < resources.length; ++i) {
                IResource resource = resources[i];
                IProgressMonitor subMonitor = Policy.subMonitorFor(monitor, 100);
                subMonitor.beginTask(null, -1);
                this.collect(resource, depth, set, subMonitor);
                subMonitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTeamResourceChange(final ISubscriberChangeEvent[] deltas) {
        ISubscriberChangeListener[] allListeners;
        List list = this.listeners;
        synchronized (list) {
            allListeners = this.listeners.toArray(new ISubscriberChangeListener[this.listeners.size()]);
        }
        for (int i = 0; i < allListeners.length; ++i) {
            final ISubscriberChangeListener listener = allListeners[i];
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.subscriberResourceChanged(deltas);
                }
            });
        }
    }

    private void collect(IResource resource, int depth, SyncInfoSet set, IProgressMonitor monitor) {
        Policy.checkCanceled(monitor);
        if (resource.getType() != 1 && depth != 0) {
            try {
                IResource[] members = this.members(resource);
                for (int i = 0; i < members.length; ++i) {
                    this.collect(members[i], depth == 2 ? 2 : 0, set, monitor);
                }
            }
            catch (TeamException e) {
                set.addError(new TeamStatus(4, "org.eclipse.team.core", 2, Policy.bind("SubscriberEventHandler.8", resource.getFullPath().toString(), e.getMessage()), (Throwable)((Object)e), resource));
            }
        }
        monitor.subTask(Policy.bind("SubscriberEventHandler.2", resource.getFullPath().toString()));
        try {
            SyncInfo info = this.getSyncInfo(resource);
            if (info == null || info.getKind() == 0) {
                set.remove(resource);
            } else {
                set.add(info);
            }
        }
        catch (TeamException e) {
            set.addError(new TeamStatus(4, "org.eclipse.team.core", 1, Policy.bind("SubscriberEventHandler.9", resource.getFullPath().toString(), e.getMessage()), (Throwable)((Object)e), resource));
        }
        monitor.worked(1);
    }
}

