/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.structuremergeviewer;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.util.Assert;

public class Differencer {
    public static final int NO_CHANGE = 0;
    public static final int ADDITION = 1;
    public static final int DELETION = 2;
    public static final int CHANGE = 3;
    public static final int CHANGE_TYPE_MASK = 3;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int CONFLICTING = 12;
    public static final int DIRECTION_MASK = 12;
    public static final int PSEUDO_CONFLICT = 16;

    public Object findDifferences(boolean threeWay, IProgressMonitor pm, Object data, Object ancestor, Object left, Object right) {
        List l;
        Node root = new Node();
        int code = this.traverse(threeWay, root, pm, threeWay ? ancestor : null, left, right);
        if (code != 0 && (l = root.fChildren).size() > 0) {
            Node first = (Node)l.get(0);
            return first.visit(this, data, 0);
        }
        return null;
    }

    private int traverse(boolean threeWay, Node parent, IProgressMonitor pm, Object ancestor, Object left, Object right) {
        Object[] ancestorChildren = this.getChildren(ancestor);
        Object[] rightChildren = this.getChildren(right);
        Object[] leftChildren = this.getChildren(left);
        int code = 0;
        Node node = new Node(parent, ancestor, left, right);
        boolean content = true;
        if ((threeWay && ancestorChildren != null || !threeWay) && rightChildren != null && leftChildren != null) {
            int i;
            HashSet<Object> allSet = new HashSet<Object>(20);
            HashMap<Object, Object> ancestorSet = null;
            HashMap<Object, Object> rightSet = null;
            HashMap<Object, Object> leftSet = null;
            if (ancestorChildren != null) {
                ancestorSet = new HashMap<Object, Object>(10);
                for (i = 0; i < ancestorChildren.length; ++i) {
                    Object ancestorChild = ancestorChildren[i];
                    ancestorSet.put(ancestorChild, ancestorChild);
                    allSet.add(ancestorChild);
                }
            }
            if (rightChildren != null) {
                rightSet = new HashMap<Object, Object>(10);
                for (i = 0; i < rightChildren.length; ++i) {
                    Object rightChild = rightChildren[i];
                    rightSet.put(rightChild, rightChild);
                    allSet.add(rightChild);
                }
            }
            if (leftChildren != null) {
                leftSet = new HashMap<Object, Object>(10);
                for (i = 0; i < leftChildren.length; ++i) {
                    Object leftChild = leftChildren[i];
                    leftSet.put(leftChild, leftChild);
                    allSet.add(leftChild);
                }
            }
            Iterator e = allSet.iterator();
            while (e.hasNext()) {
                Object rightChild;
                Object leftChild;
                Object ancestorChild;
                int c;
                Object keyChild = e.next();
                content = false;
                if (pm != null) {
                    if (pm.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    this.updateProgress(pm, keyChild);
                }
                if (((c = this.traverse(threeWay, node, pm, ancestorChild = ancestorSet != null ? ancestorSet.get(keyChild) : null, leftChild = leftSet != null ? leftSet.get(keyChild) : null, rightChild = rightSet != null ? rightSet.get(keyChild) : null)) & 3) == 0) continue;
                code |= 3;
                code |= c & 0xC;
            }
        }
        if (content) {
            code = this.compare(threeWay, ancestor, left, right);
        }
        node.fCode = code;
        return code;
    }

    protected Object visit(Object data, int result, Object ancestor, Object left, Object right) {
        return new DiffNode((IDiffContainer)data, result, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
    }

    private int compare(boolean threeway, Object ancestor, Object left, Object right) {
        int description = 0;
        if (threeway) {
            if (ancestor == null) {
                if (left == null) {
                    if (right == null) {
                        Assert.isTrue((boolean)false);
                    } else {
                        description = 9;
                    }
                } else if (right == null) {
                    description = 5;
                } else {
                    description = 13;
                    if (this.contentsEqual(left, right)) {
                        description |= 0x10;
                    }
                }
            } else if (left == null) {
                description = right == null ? 30 : (this.contentsEqual(ancestor, right) ? 6 : 15);
            } else if (right == null) {
                description = this.contentsEqual(ancestor, left) ? 10 : 15;
            } else {
                boolean ay = this.contentsEqual(ancestor, left);
                boolean am = this.contentsEqual(ancestor, right);
                if (!ay || !am) {
                    if (ay && !am) {
                        description = 11;
                    } else if (!ay && am) {
                        description = 7;
                    } else {
                        description = 15;
                        if (this.contentsEqual(left, right)) {
                            description |= 0x10;
                        }
                    }
                }
            }
        } else if (left == null) {
            if (right == null) {
                Assert.isTrue((boolean)false);
            } else {
                description = 1;
            }
        } else if (right == null) {
            description = 2;
        } else if (!this.contentsEqual(left, right)) {
            description = 3;
        }
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean contentsEqual(Object input1, Object input2) {
        block32: {
            block28: {
                block31: {
                    block27: {
                        block25: {
                            block26: {
                                if (input1 == input2) {
                                    return true;
                                }
                                is1 = this.getStream(input1);
                                is2 = this.getStream(input2);
                                if (is1 == null && is2 == null) {
                                    return true;
                                }
                                try {
                                    try {
                                        if (is1 == null || is2 == null) {
                                            var5_5 = false;
                                            var9_8 = null;
                                            if (is1 == null) break block25;
                                            break block26;
                                        }
                                        do {
                                            c1 = is1.read();
                                            c2 = is2.read();
                                            if (c1 != -1 || c2 != -1) continue;
                                            var7_19 = true;
                                            break block27;
                                        } while (c1 == c2);
                                        break block28;
                                    }
                                    catch (IOException ex) {
                                        var9_11 = null;
                                        if (is1 != null) {
                                            try {
                                                is1.close();
                                            }
                                            catch (IOException ex) {
                                                // empty catch block
                                            }
                                        }
                                        if (is2 == null) return false;
                                        try {
                                            is2.close();
                                            return false;
                                        }
                                        catch (IOException ex) {
                                            return false;
                                        }
                                    }
                                }
                                catch (Throwable var8_20) {
                                    block30: {
                                        var9_12 = null;
                                        if (is1 != null) {
                                            ** try [egrp 2[TRYBLOCK] [8 : 124->131)] { 
lbl45:
                                            // 1 sources

                                            is1.close();
                                            break block30;
lbl47:
                                            // 1 sources

                                            catch (IOException ex) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (is2 == null) throw var8_20;
                                    ** try [egrp 3[TRYBLOCK] [9 : 138->146)] { 
lbl52:
                                    // 1 sources

                                    is2.close();
                                    throw var8_20;
lbl54:
                                    // 1 sources

                                    catch (IOException ex) {
                                        // empty catch block
                                    }
                                    throw var8_20;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [8 : 124->131)] { 
lbl59:
                            // 1 sources

                            is1.close();
                            break block25;
lbl61:
                            // 1 sources

                            catch (IOException ex) {
                                // empty catch block
                            }
                        }
                        if (is2 == null) return var5_5;
                        ** try [egrp 3[TRYBLOCK] [9 : 138->146)] { 
lbl66:
                        // 1 sources

                        is2.close();
                        return var5_5;
lbl68:
                        // 1 sources

                        catch (IOException ex) {
                            // empty catch block
                        }
                        return var5_5;
                    }
                    var9_9 = null;
                    if (is1 != null) {
                        ** try [egrp 2[TRYBLOCK] [8 : 124->131)] { 
lbl75:
                        // 1 sources

                        is1.close();
                        break block31;
lbl77:
                        // 1 sources

                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                }
                if (is2 == null) return var7_19;
                ** try [egrp 3[TRYBLOCK] [9 : 138->146)] { 
lbl82:
                // 1 sources

                is2.close();
                return var7_19;
lbl84:
                // 1 sources

                catch (IOException ex) {
                    // empty catch block
                }
                return var7_19;
            }
            var9_10 = null;
            if (is1 != null) {
                ** try [egrp 2[TRYBLOCK] [8 : 124->131)] { 
lbl91:
                // 1 sources

                is1.close();
                break block32;
lbl93:
                // 1 sources

                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        if (is2 == null) return false;
        try {}
        catch (IOException ex) {}
        is2.close();
        return false;
        return false;
    }

    private InputStream getStream(Object o) {
        if (o instanceof IStreamContentAccessor) {
            try {
                return ((IStreamContentAccessor)o).getContents();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Object[] getChildren(Object input) {
        if (input instanceof IStructureComparator) {
            return ((IStructureComparator)input).getChildren();
        }
        return null;
    }

    protected void updateProgress(IProgressMonitor progressMonitor, Object node) {
        if (node instanceof ITypedElement) {
            String name = ((ITypedElement)node).getName();
            String fmt = Utilities.getString("Differencer.progressFormat");
            String msg = MessageFormat.format(fmt, name);
            progressMonitor.subTask(msg);
        }
    }

    static class Node {
        List fChildren;
        int fCode;
        Object fAncestor;
        Object fLeft;
        Object fRight;

        Node() {
        }

        Node(Node parent, Object ancestor, Object left, Object right) {
            parent.add(this);
            this.fAncestor = ancestor;
            this.fLeft = left;
            this.fRight = right;
        }

        void add(Node child) {
            if (this.fChildren == null) {
                this.fChildren = new ArrayList();
            }
            this.fChildren.add(child);
        }

        Object visit(Differencer d, Object parent, int level) {
            if (this.fCode == 0) {
                return null;
            }
            Object data = d.visit(parent, this.fCode, this.fAncestor, this.fLeft, this.fRight);
            if (this.fChildren != null) {
                Iterator i = this.fChildren.iterator();
                while (i.hasNext()) {
                    Node n = (Node)i.next();
                    n.visit(d, data, level + 1);
                }
            }
            return data;
        }
    }
}

