/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.ActiveEditorAction;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;

public class PinEditorAction
extends ActiveEditorAction {
    private IPropertyListener propListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == -257) {
                EditorSite site = (EditorSite)source;
                PinEditorAction.this.setChecked(!site.getReuseEditor());
            }
        }
    };

    public PinEditorAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.getString("PinEditorAction.text"), window);
        this.setActionDefinitionId("org.eclipse.ui.window.pinEditor");
        this.setToolTipText(WorkbenchMessages.getString("PinEditorAction.toolTip"));
        this.setId("org.eclipse.ui.internal.PinEditorAction");
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_PIN_EDITOR"));
        this.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_PIN_EDITOR_DISABLED"));
    }

    public void run() {
        if (this.getWorkbenchWindow() == null) {
            return;
        }
        IEditorPart editor = this.getActiveEditor();
        if (editor != null) {
            ((EditorSite)editor.getEditorSite()).setReuseEditor(!this.isChecked());
        }
    }

    protected void updateState() {
        if (this.getWorkbenchWindow() == null || this.getActivePage() == null) {
            this.setChecked(false);
            this.setEnabled(false);
            return;
        }
        IEditorPart editor = this.getActiveEditor();
        boolean enabled = editor != null;
        this.setEnabled(enabled);
        if (enabled) {
            EditorSite site = (EditorSite)editor.getEditorSite();
            this.setChecked(!site.getReuseEditor());
        } else {
            this.setChecked(false);
        }
    }

    protected void editorActivated(IEditorPart part) {
        super.editorActivated(part);
        if (part != null) {
            ((EditorSite)part.getEditorSite()).addPropertyListener(this.propListener);
        }
    }

    protected void editorDeactivated(IEditorPart part) {
        super.editorDeactivated(part);
        if (part != null) {
            ((EditorSite)part.getEditorSite()).removePropertyListener(this.propListener);
        }
    }

    public void dispose() {
        this.editorDeactivated(this.getActiveEditor());
        super.dispose();
    }
}

