/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.AbstractGroupMarker;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.PluginActionContributionItem;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;

public abstract class PluginActionBuilder
extends RegistryReader {
    public static final String TAG_MENU = "menu";
    public static final String TAG_ACTION = "action";
    public static final String TAG_SEPARATOR = "separator";
    public static final String TAG_GROUP_MARKER = "groupMarker";
    public static final String TAG_FILTER = "filter";
    public static final String TAG_VISIBILITY = "visibility";
    public static final String TAG_ENABLEMENT = "enablement";
    public static final String TAG_SELECTION = "selection";
    public static final String ATT_TARGET_ID = "targetID";
    public static final String ATT_ID = "id";
    public static final String ATT_LABEL = "label";
    public static final String ATT_ENABLES_FOR = "enablesFor";
    public static final String ATT_NAME = "name";
    public static final String ATT_PATH = "path";
    protected String targetID;
    protected String targetContributionTag;
    protected BasicContribution currentContribution;
    protected ArrayList cache;

    public final void contribute(IMenuManager menu, IToolBarManager toolbar, boolean appendIfMissing) {
        if (this.cache == null) {
            return;
        }
        for (int i = 0; i < this.cache.size(); ++i) {
            BasicContribution contribution = (BasicContribution)this.cache.get(i);
            contribution.contribute(menu, appendIfMissing, toolbar, appendIfMissing);
        }
    }

    protected abstract ActionDescriptor createActionDescriptor(IConfigurationElement var1);

    protected BasicContribution createContribution() {
        return new BasicContribution();
    }

    protected String getTargetID(IConfigurationElement element) {
        String value = element.getAttribute(ATT_TARGET_ID);
        return value != null ? value : "???";
    }

    protected void readContributions(String id, String tag, String extensionPoint) {
        this.cache = null;
        this.currentContribution = null;
        this.targetID = id;
        this.targetContributionTag = tag;
        this.readRegistry(Platform.getExtensionRegistry(), "org.eclipse.ui", extensionPoint);
    }

    protected boolean readElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals("objectContribution")) {
            return true;
        }
        if (tag.equals(this.targetContributionTag)) {
            String id;
            if (!(this.targetID == null || (id = this.getTargetID(element)) != null && id.equals(this.targetID))) {
                return true;
            }
            this.currentContribution = this.createContribution();
            this.readElementChildren(element);
            if (this.cache == null) {
                this.cache = new ArrayList(4);
            }
            this.cache.add(this.currentContribution);
            this.currentContribution = null;
            return true;
        }
        if (tag.equals(TAG_MENU)) {
            this.currentContribution.addMenu(element);
            return true;
        }
        if (tag.equals(TAG_ACTION)) {
            this.currentContribution.addAction(this.createActionDescriptor(element));
            return true;
        }
        return false;
    }

    protected static class BasicContribution {
        protected ArrayList menus;
        protected ArrayList actions;

        protected BasicContribution() {
        }

        public void addMenu(IConfigurationElement element) {
            if (this.menus == null) {
                this.menus = new ArrayList(1);
            }
            this.menus.add(element);
        }

        public void addAction(ActionDescriptor desc) {
            if (this.actions == null) {
                this.actions = new ArrayList(3);
            }
            this.actions.add(desc);
        }

        public void contribute(IMenuManager menu, boolean menuAppendIfMissing, IToolBarManager toolbar, boolean toolAppendIfMissing) {
            int i;
            if (this.menus != null && menu != null) {
                for (i = 0; i < this.menus.size(); ++i) {
                    IConfigurationElement menuElement = (IConfigurationElement)this.menus.get(i);
                    IPluginContribution pc = new IPluginContribution(this, menuElement){
                        private final /* synthetic */ IConfigurationElement val$menuElement;
                        private final /* synthetic */ BasicContribution this$0;
                        {
                            this.this$0 = this$0;
                            this.val$menuElement = val$menuElement;
                        }

                        public String getLocalId() {
                            return this.val$menuElement.getAttribute("id");
                        }

                        public String getPluginId() {
                            return this.val$menuElement.getDeclaringExtension().getNamespace();
                        }
                    };
                    if (WorkbenchActivityHelper.filterItem(pc)) continue;
                    this.contributeMenu(menuElement, menu, menuAppendIfMissing);
                }
            }
            if (this.actions != null) {
                for (i = 0; i < this.actions.size(); ++i) {
                    ActionDescriptor ad = (ActionDescriptor)this.actions.get(i);
                    if (WorkbenchActivityHelper.filterItem(ad)) continue;
                    if (menu != null) {
                        this.contributeMenuAction(ad, menu, menuAppendIfMissing);
                    }
                    if (toolbar == null) continue;
                    this.contributeToolbarAction(ad, toolbar, toolAppendIfMissing);
                }
            }
        }

        protected void contributeMenu(IConfigurationElement menuElement, IMenuManager mng, boolean appendIfMissing) {
            IMenuManager newMenu;
            IContributionItem sep;
            String id = menuElement.getAttribute(PluginActionBuilder.ATT_ID);
            String label = menuElement.getAttribute(PluginActionBuilder.ATT_LABEL);
            String path = menuElement.getAttribute(PluginActionBuilder.ATT_PATH);
            if (label == null) {
                WorkbenchPlugin.log("Invalid Menu Extension (label == null): " + id);
                return;
            }
            String group = null;
            if (path != null) {
                int loc = path.lastIndexOf(47);
                if (loc != -1) {
                    group = path.substring(loc + 1);
                    path = path.substring(0, loc);
                } else {
                    group = path;
                    path = null;
                }
            }
            IMenuManager parent = mng;
            if (path != null && (parent = mng.findMenuUsingPath(path)) == null) {
                WorkbenchPlugin.log("Invalid Menu Extension (Path is invalid): " + id);
                return;
            }
            if (group == null) {
                group = "additions";
            }
            if ((sep = parent.find(group)) == null) {
                if (appendIfMissing) {
                    this.addGroup((IContributionManager)parent, group);
                } else {
                    WorkbenchPlugin.log("Invalid Menu Extension (Group is invalid): " + id);
                    return;
                }
            }
            if ((newMenu = parent.findMenuUsingPath(id)) == null) {
                newMenu = new MenuManager(label, id);
            }
            try {
                this.insertAfter((IContributionManager)parent, group, (IContributionItem)newMenu);
            }
            catch (IllegalArgumentException e) {
                WorkbenchPlugin.log("Invalid Menu Extension (Group is missing): " + id);
            }
            newMenu = parent.findMenuUsingPath(id);
            if (newMenu == null) {
                WorkbenchPlugin.log("Could not find new menu: " + id);
            }
            IConfigurationElement[] children = menuElement.getChildren();
            for (int i = 0; i < children.length; ++i) {
                String childName = children[i].getName();
                if (childName.equals(PluginActionBuilder.TAG_SEPARATOR)) {
                    this.contributeSeparator(newMenu, children[i]);
                    continue;
                }
                if (!childName.equals(PluginActionBuilder.TAG_GROUP_MARKER)) continue;
                this.contributeGroupMarker(newMenu, children[i]);
            }
        }

        protected void contributeMenuAction(ActionDescriptor ad, IMenuManager menu, boolean appendIfMissing) {
            IContributionItem sep;
            String mpath = ad.getMenuPath();
            String mgroup = ad.getMenuGroup();
            if (mpath == null && mgroup == null) {
                return;
            }
            IMenuManager parent = menu;
            if (mpath != null && (parent = parent.findMenuUsingPath(mpath)) == null) {
                WorkbenchPlugin.log("Invalid Menu Extension (Path is invalid): " + ad.getId());
                return;
            }
            if (mgroup == null) {
                mgroup = "additions";
            }
            if ((sep = parent.find(mgroup)) == null) {
                if (appendIfMissing) {
                    this.addGroup((IContributionManager)parent, mgroup);
                } else {
                    WorkbenchPlugin.log("Invalid Menu Extension (Group is invalid): " + ad.getId());
                    return;
                }
            }
            try {
                this.insertAfter((IContributionManager)parent, mgroup, ad.getAction());
            }
            catch (IllegalArgumentException e) {
                WorkbenchPlugin.log("Invalid Menu Extension (Group is missing): " + ad.getId());
            }
        }

        protected void contributeSeparator(IMenuManager menu, IConfigurationElement element) {
            String id = element.getAttribute(PluginActionBuilder.ATT_NAME);
            if (id == null || id.length() <= 0) {
                return;
            }
            IContributionItem sep = menu.find(id);
            if (sep != null) {
                return;
            }
            this.insertMenuGroup(menu, (AbstractGroupMarker)new Separator(id));
        }

        protected void contributeGroupMarker(IMenuManager menu, IConfigurationElement element) {
            String id = element.getAttribute(PluginActionBuilder.ATT_NAME);
            if (id == null || id.length() <= 0) {
                return;
            }
            IContributionItem marker = menu.find(id);
            if (marker != null) {
                return;
            }
            this.insertMenuGroup(menu, (AbstractGroupMarker)new GroupMarker(id));
        }

        protected void contributeToolbarAction(ActionDescriptor ad, IToolBarManager toolbar, boolean appendIfMissing) {
            String tId = ad.getToolbarId();
            String tgroup = ad.getToolbarGroupId();
            if (tId == null && tgroup == null) {
                return;
            }
            if (tgroup == null) {
                tgroup = "additions";
            }
            IContributionItem sep = null;
            sep = toolbar.find(tgroup);
            if (sep == null) {
                if (appendIfMissing) {
                    this.addGroup((IContributionManager)toolbar, tgroup);
                } else {
                    WorkbenchPlugin.log("Invalid Toolbar Extension (Group is invalid): " + ad.getId());
                    return;
                }
            }
            try {
                this.insertAfter((IContributionManager)toolbar, tgroup, ad.getAction());
            }
            catch (IllegalArgumentException e) {
                WorkbenchPlugin.log("Invalid Toolbar Extension (Group is missing): " + ad.getId());
            }
        }

        protected void insertMenuGroup(IMenuManager menu, AbstractGroupMarker marker) {
            menu.add((IContributionItem)marker);
        }

        protected void insertAfter(IContributionManager mgr, String refId, PluginAction action) {
            this.insertAfter(mgr, refId, (IContributionItem)new PluginActionContributionItem(action));
        }

        protected void insertAfter(IContributionManager mgr, String refId, IContributionItem item) {
            mgr.insertAfter(refId, item);
        }

        protected void addGroup(IContributionManager mgr, String name) {
            mgr.add((IContributionItem)new Separator(name));
        }
    }
}

