/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWT;
import org.eclipse.ui.commands.CategoryEvent;
import org.eclipse.ui.commands.CommandEvent;
import org.eclipse.ui.commands.CommandManagerEvent;
import org.eclipse.ui.commands.ICategory;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandManagerListener;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.IKeyConfiguration;
import org.eclipse.ui.commands.KeyConfigurationEvent;
import org.eclipse.ui.commands.NotDefinedException;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.commands.ActiveKeyConfigurationDefinition;
import org.eclipse.ui.internal.commands.Category;
import org.eclipse.ui.internal.commands.CategoryDefinition;
import org.eclipse.ui.internal.commands.Command;
import org.eclipse.ui.internal.commands.CommandDefinition;
import org.eclipse.ui.internal.commands.CommandRegistryEvent;
import org.eclipse.ui.internal.commands.ExtensionCommandRegistry;
import org.eclipse.ui.internal.commands.ICommandRegistry;
import org.eclipse.ui.internal.commands.ICommandRegistryListener;
import org.eclipse.ui.internal.commands.IMutableCommandManager;
import org.eclipse.ui.internal.commands.IMutableCommandRegistry;
import org.eclipse.ui.internal.commands.KeyConfiguration;
import org.eclipse.ui.internal.commands.KeyConfigurationDefinition;
import org.eclipse.ui.internal.commands.KeySequenceBindingDefinition;
import org.eclipse.ui.internal.commands.KeySequenceBindingMachine;
import org.eclipse.ui.internal.commands.Match;
import org.eclipse.ui.internal.commands.PreferenceCommandRegistry;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.KeySequence;

public final class MutableCommandManager
implements IMutableCommandManager {
    public static boolean DEBUG_COMMAND_EXECUTION = false;
    public static boolean DEBUG_HANDLERS = false;
    public static String DEBUG_HANDLERS_COMMAND_ID = null;
    public static final String SEPARATOR = "_";
    private Map activeContextIds = new HashMap();
    private String activeKeyConfigurationId = null;
    private String activeLocale = null;
    private String activePlatform = null;
    private Map categoriesById = new WeakHashMap();
    private Set categoriesWithListeners = new HashSet();
    private Map categoryDefinitionsById = new HashMap();
    private Map commandDefinitionsById = new HashMap();
    private List commandManagerListeners;
    private ICommandRegistry commandRegistry;
    private Map commandsById = new WeakHashMap();
    private Set commandsWithListeners = new HashSet();
    private Set definedCategoryIds = new HashSet();
    private Set definedCommandIds = new HashSet();
    private Set definedHandlers = new HashSet();
    private Set definedKeyConfigurationIds = new HashSet();
    private Map handlersByCommandId = new HashMap();
    private Map keyConfigurationDefinitionsById = new HashMap();
    private Map keyConfigurationsById = new WeakHashMap();
    private Set keyConfigurationsWithListeners = new HashSet();
    private KeySequenceBindingMachine keySequenceBindingMachine = new KeySequenceBindingMachine();
    private Map keySequenceBindingsByCommandId = new HashMap();
    private IMutableCommandRegistry mutableCommandRegistry;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$eclipse$ui$commands$IHandler;

    static String[] extend(String[] strings) {
        String[] strings2 = new String[strings.length + 1];
        System.arraycopy(strings, 0, strings2, 0, strings.length);
        return strings2;
    }

    static String[] getPath(String string, String separator) {
        if (string == null || separator == null) {
            return new String[0];
        }
        ArrayList<String> strings = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        if ((string = string.trim()).length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, separator);
            while (stringTokenizer.hasMoreElements()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(separator);
                }
                stringBuffer.append(((String)stringTokenizer.nextElement()).trim());
                strings.add(stringBuffer.toString());
            }
        }
        Collections.reverse(strings);
        strings.add("");
        return strings.toArray(new String[strings.size()]);
    }

    static boolean isKeyConfigurationDefinitionChildOf(String ancestor, String id, Map keyConfigurationDefinitionsById) {
        HashSet<String> visited = new HashSet<String>();
        while (id != null && !visited.contains(id)) {
            KeyConfigurationDefinition keyConfigurationDefinition = (KeyConfigurationDefinition)keyConfigurationDefinitionsById.get(id);
            visited.add(id);
            if (keyConfigurationDefinition == null || !Util.equals(id = keyConfigurationDefinition.getParentId(), ancestor)) continue;
            return true;
        }
        return false;
    }

    static boolean validateKeySequence(KeySequence keySequence) {
        if (keySequence == null) {
            return false;
        }
        List keyStrokes = keySequence.getKeyStrokes();
        int size = keyStrokes.size();
        return size != 0 && size <= 4 && keySequence.isComplete();
    }

    static void validateKeySequenceBindingDefinitions(Collection keySequenceBindingDefinitions) {
        Iterator iterator = keySequenceBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            KeySequenceBindingDefinition keySequenceBindingDefinition = (KeySequenceBindingDefinition)iterator.next();
            String keyConfigurationId = keySequenceBindingDefinition.getKeyConfigurationId();
            KeySequence keySequence = keySequenceBindingDefinition.getKeySequence();
            if (keyConfigurationId != null && keySequence != null && MutableCommandManager.validateKeySequence(keySequence)) continue;
            iterator.remove();
        }
    }

    public MutableCommandManager() {
        this(new ExtensionCommandRegistry(Platform.getExtensionRegistry()), new PreferenceCommandRegistry(WorkbenchPlugin.getDefault().getPreferenceStore()));
    }

    public MutableCommandManager(ICommandRegistry commandRegistry, IMutableCommandRegistry mutableCommandRegistry) {
        if (commandRegistry == null || mutableCommandRegistry == null) {
            throw new NullPointerException();
        }
        this.commandRegistry = commandRegistry;
        this.mutableCommandRegistry = mutableCommandRegistry;
        String systemLocale = Locale.getDefault().toString();
        this.activeLocale = systemLocale != null ? systemLocale : "";
        String systemPlatform = SWT.getPlatform();
        this.activePlatform = systemPlatform != null ? systemPlatform : "";
        this.commandRegistry.addCommandRegistryListener(new ICommandRegistryListener(){

            public void commandRegistryChanged(CommandRegistryEvent commandRegistryEvent) {
                MutableCommandManager.this.readRegistry();
            }
        });
        this.mutableCommandRegistry.addCommandRegistryListener(new ICommandRegistryListener(){

            public void commandRegistryChanged(CommandRegistryEvent commandRegistryEvent) {
                MutableCommandManager.this.readRegistry();
            }
        });
        this.readRegistry();
    }

    public void addCommandManagerListener(ICommandManagerListener commandManagerListener) {
        if (commandManagerListener == null) {
            throw new NullPointerException();
        }
        if (this.commandManagerListeners == null) {
            this.commandManagerListeners = new ArrayList();
        }
        if (!this.commandManagerListeners.contains(commandManagerListener)) {
            this.commandManagerListeners.add(commandManagerListener);
        }
    }

    private void calculateKeySequenceBindings() {
        String[] activeKeyConfigurationIds = MutableCommandManager.extend(this.getKeyConfigurationIds(this.activeKeyConfigurationId));
        String[] activeLocales = MutableCommandManager.extend(MutableCommandManager.getPath(this.activeLocale, SEPARATOR));
        String[] activePlatforms = MutableCommandManager.extend(MutableCommandManager.getPath(this.activePlatform, SEPARATOR));
        this.keySequenceBindingMachine.setActiveContextIds(this.activeContextIds);
        this.keySequenceBindingMachine.setActiveKeyConfigurationIds(activeKeyConfigurationIds);
        this.keySequenceBindingMachine.setActiveLocales(activeLocales);
        this.keySequenceBindingMachine.setActivePlatforms(activePlatforms);
        this.keySequenceBindingsByCommandId = this.keySequenceBindingMachine.getKeySequenceBindingsByCommandId();
    }

    private void fireCommandManagerChanged(CommandManagerEvent commandManagerEvent) {
        if (commandManagerEvent == null) {
            throw new NullPointerException();
        }
        if (this.commandManagerListeners != null) {
            for (int i = 0; i < this.commandManagerListeners.size(); ++i) {
                ((ICommandManagerListener)this.commandManagerListeners.get(i)).commandManagerChanged(commandManagerEvent);
            }
        }
    }

    public Set getActiveContextIds() {
        return this.activeContextIds.keySet();
    }

    public String getActiveKeyConfigurationId() {
        return this.activeKeyConfigurationId;
    }

    public String getActiveLocale() {
        return this.activeLocale;
    }

    public String getActivePlatform() {
        return this.activePlatform;
    }

    public ICategory getCategory(String categoryId) {
        if (categoryId == null) {
            throw new NullPointerException();
        }
        Category category = (Category)this.categoriesById.get(categoryId);
        if (category == null) {
            category = new Category(this.categoriesWithListeners, categoryId);
            this.updateCategory(category);
            this.categoriesById.put(categoryId, category);
        }
        return category;
    }

    public ICommand getCommand(String commandId) {
        if (commandId == null) {
            throw new NullPointerException();
        }
        Command command = (Command)this.commandsById.get(commandId);
        if (command == null) {
            command = new Command(this.commandsWithListeners, commandId);
            this.updateCommand(command);
            this.commandsById.put(commandId, command);
        }
        return command;
    }

    public ICommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    public Set getDefinedCategoryIds() {
        return Collections.unmodifiableSet(this.definedCategoryIds);
    }

    public Set getDefinedCommandIds() {
        return Collections.unmodifiableSet(this.definedCommandIds);
    }

    public Set getDefinedHandlers() {
        return Collections.unmodifiableSet(this.definedHandlers);
    }

    public Set getDefinedKeyConfigurationIds() {
        return Collections.unmodifiableSet(this.definedKeyConfigurationIds);
    }

    public Map getHandlersByCommandId() {
        return Collections.unmodifiableMap(this.handlersByCommandId);
    }

    public IKeyConfiguration getKeyConfiguration(String keyConfigurationId) {
        if (keyConfigurationId == null) {
            throw new NullPointerException();
        }
        KeyConfiguration keyConfiguration = (KeyConfiguration)this.keyConfigurationsById.get(keyConfigurationId);
        if (keyConfiguration == null) {
            keyConfiguration = new KeyConfiguration(this.keyConfigurationsWithListeners, keyConfigurationId);
            this.updateKeyConfiguration(keyConfiguration);
            this.keyConfigurationsById.put(keyConfigurationId, keyConfiguration);
        }
        return keyConfiguration;
    }

    String[] getKeyConfigurationIds(String keyConfigurationId) {
        ArrayList<String> strings = new ArrayList<String>();
        while (keyConfigurationId != null) {
            strings.add(keyConfigurationId);
            try {
                keyConfigurationId = this.getKeyConfiguration(keyConfigurationId).getParentId();
            }
            catch (NotDefinedException eNotDefined) {
                return new String[0];
            }
        }
        return strings.toArray(new String[strings.size()]);
    }

    IMutableCommandRegistry getMutableCommandRegistry() {
        return this.mutableCommandRegistry;
    }

    public Map getPartialMatches(KeySequence keySequence) {
        HashMap<KeySequence, String> map = new HashMap<KeySequence, String>();
        Iterator iterator = this.keySequenceBindingMachine.getMatchesByKeySequence().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            KeySequence keySequence2 = (KeySequence)entry.getKey();
            Match match = (Match)entry.getValue();
            if (!keySequence2.startsWith(keySequence, false)) continue;
            map.put(keySequence2, match.getCommandId());
        }
        return Collections.unmodifiableMap(map);
    }

    public String getPerfectMatch(KeySequence keySequence) {
        Match match = (Match)this.keySequenceBindingMachine.getMatchesByKeySequence().get(keySequence);
        return match != null ? match.getCommandId() : null;
    }

    public boolean isPartialMatch(KeySequence keySequence) {
        Iterator iterator = this.keySequenceBindingMachine.getMatchesByKeySequence().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            KeySequence keySequence2 = (KeySequence)entry.getKey();
            if (!keySequence2.startsWith(keySequence, false)) continue;
            return true;
        }
        return false;
    }

    public boolean isPerfectMatch(KeySequence keySequence) {
        return this.getPerfectMatch(keySequence) != null;
    }

    private void notifyCategories(Map categoryEventsByCategoryId) {
        Iterator iterator = categoryEventsByCategoryId.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String categoryId = (String)entry.getKey();
            CategoryEvent categoryEvent = (CategoryEvent)entry.getValue();
            Category category = (Category)this.categoriesById.get(categoryId);
            if (category == null) continue;
            category.fireCategoryChanged(categoryEvent);
        }
    }

    private void notifyCommands(Map commandEventsByCommandId) {
        Iterator iterator = commandEventsByCommandId.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String commandId = (String)entry.getKey();
            CommandEvent commandEvent = (CommandEvent)entry.getValue();
            Command command = (Command)this.commandsById.get(commandId);
            if (command == null) continue;
            command.fireCommandChanged(commandEvent);
        }
    }

    private void notifyKeyConfigurations(Map keyConfigurationEventsByKeyConfigurationId) {
        Iterator iterator = keyConfigurationEventsByKeyConfigurationId.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String keyConfigurationId = (String)entry.getKey();
            KeyConfigurationEvent keyConfigurationEvent = (KeyConfigurationEvent)entry.getValue();
            KeyConfiguration keyConfiguration = (KeyConfiguration)this.keyConfigurationsById.get(keyConfigurationId);
            if (keyConfiguration == null) continue;
            keyConfiguration.fireKeyConfigurationChanged(keyConfigurationEvent);
        }
    }

    private void readRegistry() {
        ActiveKeyConfigurationDefinition activeKeyConfigurationDefinition;
        ArrayList categoryDefinitions = new ArrayList();
        categoryDefinitions.addAll(this.commandRegistry.getCategoryDefinitions());
        categoryDefinitions.addAll(this.mutableCommandRegistry.getCategoryDefinitions());
        HashMap categoryDefinitionsById = new HashMap(CategoryDefinition.categoryDefinitionsById(categoryDefinitions, false));
        this.definedHandlers.addAll(this.commandRegistry.getHandlers());
        Iterator iterator = categoryDefinitionsById.values().iterator();
        while (iterator.hasNext()) {
            CategoryDefinition categoryDefinition = (CategoryDefinition)iterator.next();
            String name = categoryDefinition.getName();
            if (name != null && name.length() != 0) continue;
            iterator.remove();
        }
        ArrayList commandDefinitions = new ArrayList();
        commandDefinitions.addAll(this.commandRegistry.getCommandDefinitions());
        commandDefinitions.addAll(this.mutableCommandRegistry.getCommandDefinitions());
        HashMap commandDefinitionsById = new HashMap(CommandDefinition.commandDefinitionsById(commandDefinitions, false));
        Iterator iterator2 = commandDefinitionsById.values().iterator();
        while (iterator2.hasNext()) {
            CommandDefinition commandDefinition = (CommandDefinition)iterator2.next();
            String name = commandDefinition.getName();
            if (name != null && name.length() != 0) continue;
            iterator2.remove();
        }
        ArrayList keyConfigurationDefinitions = new ArrayList();
        keyConfigurationDefinitions.addAll(this.commandRegistry.getKeyConfigurationDefinitions());
        keyConfigurationDefinitions.addAll(this.mutableCommandRegistry.getKeyConfigurationDefinitions());
        HashMap keyConfigurationDefinitionsById = new HashMap(KeyConfigurationDefinition.keyConfigurationDefinitionsById(keyConfigurationDefinitions, false));
        Iterator<Object> iterator3 = keyConfigurationDefinitionsById.values().iterator();
        while (iterator3.hasNext()) {
            KeyConfigurationDefinition keyConfigurationDefinition = (KeyConfigurationDefinition)iterator3.next();
            String name = keyConfigurationDefinition.getName();
            if (name != null && name.length() != 0) continue;
            iterator3.remove();
        }
        iterator3 = commandDefinitionsById.values().iterator();
        while (iterator3.hasNext()) {
            CommandDefinition commandDefinition = (CommandDefinition)iterator3.next();
            String categoryId = commandDefinition.getCategoryId();
            if (categoryId == null || categoryDefinitionsById.containsKey(categoryId)) continue;
            iterator3.remove();
        }
        iterator3 = keyConfigurationDefinitionsById.keySet().iterator();
        while (iterator3.hasNext()) {
            if (MutableCommandManager.isKeyConfigurationDefinitionChildOf(null, (String)iterator3.next(), keyConfigurationDefinitionsById)) continue;
            iterator3.remove();
        }
        ArrayList activeKeyConfigurationDefinitions = new ArrayList();
        activeKeyConfigurationDefinitions.addAll(this.commandRegistry.getActiveKeyConfigurationDefinitions());
        activeKeyConfigurationDefinitions.addAll(this.mutableCommandRegistry.getActiveKeyConfigurationDefinitions());
        String activeKeyConfigurationId = null;
        if (!activeKeyConfigurationDefinitions.isEmpty() && (activeKeyConfigurationId = (activeKeyConfigurationDefinition = (ActiveKeyConfigurationDefinition)activeKeyConfigurationDefinitions.get(activeKeyConfigurationDefinitions.size() - 1)).getKeyConfigurationId()) != null && !keyConfigurationDefinitionsById.containsKey(activeKeyConfigurationId)) {
            activeKeyConfigurationId = null;
        }
        if (activeKeyConfigurationId == null && !keyConfigurationDefinitionsById.isEmpty()) {
            TreeSet sortedSet = new TreeSet(keyConfigurationDefinitionsById.keySet());
            activeKeyConfigurationId = (String)sortedSet.first();
        }
        this.categoryDefinitionsById = categoryDefinitionsById;
        this.commandDefinitionsById = commandDefinitionsById;
        this.keyConfigurationDefinitionsById = keyConfigurationDefinitionsById;
        boolean activeKeyConfigurationIdChanged = false;
        if (!Util.equals(this.activeKeyConfigurationId, activeKeyConfigurationId)) {
            this.activeKeyConfigurationId = activeKeyConfigurationId;
            activeKeyConfigurationIdChanged = true;
        }
        boolean definedCategoryIdsChanged = false;
        HashSet definedCategoryIds = new HashSet(categoryDefinitionsById.keySet());
        Set previouslyDefinedCategoryIds = null;
        if (!((Object)definedCategoryIds).equals(this.definedCategoryIds)) {
            previouslyDefinedCategoryIds = this.definedCategoryIds;
            this.definedCategoryIds = definedCategoryIds;
            definedCategoryIdsChanged = true;
        }
        boolean definedCommandIdsChanged = false;
        HashSet definedCommandIds = new HashSet(commandDefinitionsById.keySet());
        Set previouslyDefinedCommandIds = null;
        if (!((Object)definedCommandIds).equals(this.definedCommandIds)) {
            previouslyDefinedCommandIds = this.definedCommandIds;
            this.definedCommandIds = definedCommandIds;
            definedCommandIdsChanged = true;
        }
        boolean definedKeyConfigurationIdsChanged = false;
        HashSet definedKeyConfigurationIds = new HashSet(keyConfigurationDefinitionsById.keySet());
        Set previouslyDefinedKeyConfigurationIds = null;
        if (!((Object)definedKeyConfigurationIds).equals(this.definedKeyConfigurationIds)) {
            previouslyDefinedKeyConfigurationIds = this.definedKeyConfigurationIds;
            this.definedKeyConfigurationIds = definedKeyConfigurationIds;
            definedKeyConfigurationIdsChanged = true;
        }
        ArrayList commandRegistryKeySequenceBindingDefinitions = new ArrayList(this.commandRegistry.getKeySequenceBindingDefinitions());
        MutableCommandManager.validateKeySequenceBindingDefinitions(commandRegistryKeySequenceBindingDefinitions);
        ArrayList mutableCommandRegistryKeySequenceBindingDefinitions = new ArrayList(this.mutableCommandRegistry.getKeySequenceBindingDefinitions());
        MutableCommandManager.validateKeySequenceBindingDefinitions(mutableCommandRegistryKeySequenceBindingDefinitions);
        this.keySequenceBindingMachine.setKeySequenceBindings0(mutableCommandRegistryKeySequenceBindingDefinitions);
        this.keySequenceBindingMachine.setKeySequenceBindings1(commandRegistryKeySequenceBindingDefinitions);
        this.calculateKeySequenceBindings();
        Map categoryEventsByCategoryId = this.updateCategories(this.categoriesById.keySet());
        Map commandEventsByCommandId = this.updateCommands(this.commandsById.keySet());
        Map keyConfigurationEventsByKeyConfigurationId = this.updateKeyConfigurations(this.keyConfigurationsById.keySet());
        if (activeKeyConfigurationIdChanged || definedCategoryIdsChanged || definedCommandIdsChanged || definedKeyConfigurationIdsChanged) {
            this.fireCommandManagerChanged(new CommandManagerEvent(this, false, activeKeyConfigurationIdChanged, false, false, definedCategoryIdsChanged, definedCommandIdsChanged, definedKeyConfigurationIdsChanged, previouslyDefinedCategoryIds, previouslyDefinedCommandIds, previouslyDefinedKeyConfigurationIds));
        }
        if (categoryEventsByCategoryId != null) {
            this.notifyCategories(categoryEventsByCategoryId);
        }
        if (commandEventsByCommandId != null) {
            this.notifyCommands(commandEventsByCommandId);
        }
        if (keyConfigurationEventsByKeyConfigurationId != null) {
            this.notifyKeyConfigurations(keyConfigurationEventsByKeyConfigurationId);
        }
    }

    public void removeCommandManagerListener(ICommandManagerListener commandManagerListener) {
        if (commandManagerListener == null) {
            throw new NullPointerException();
        }
        if (this.commandManagerListeners != null) {
            this.commandManagerListeners.remove(commandManagerListener);
        }
    }

    public void setActiveContextIds(Map activeContextIds) {
        boolean commandManagerChanged = false;
        Map commandEventsByCommandId = null;
        if (!((Object)this.activeContextIds).equals(activeContextIds)) {
            this.activeContextIds = activeContextIds;
            commandManagerChanged = true;
            this.calculateKeySequenceBindings();
            commandEventsByCommandId = this.updateCommands(this.commandsById.keySet());
        }
        if (commandManagerChanged) {
            this.fireCommandManagerChanged(new CommandManagerEvent(this, true, false, false, false, false, false, false, null, null, null));
        }
        if (commandEventsByCommandId != null) {
            this.notifyCommands(commandEventsByCommandId);
        }
    }

    public void setActiveKeyConfigurationId(String activeKeyConfigurationId) {
        boolean commandManagerChanged = false;
        Map commandEventsByCommandId = null;
        Map keyConfigurationEventsByKeyConfigurationId = null;
        if (!Util.equals(this.activeKeyConfigurationId, activeKeyConfigurationId)) {
            this.activeKeyConfigurationId = activeKeyConfigurationId;
            commandManagerChanged = true;
            this.calculateKeySequenceBindings();
            commandEventsByCommandId = this.updateCommands(this.commandsById.keySet());
            keyConfigurationEventsByKeyConfigurationId = this.updateKeyConfigurations(this.keyConfigurationsById.keySet());
        }
        if (commandManagerChanged) {
            this.fireCommandManagerChanged(new CommandManagerEvent(this, false, true, false, false, false, false, false, null, null, null));
        }
        if (commandEventsByCommandId != null) {
            this.notifyCommands(commandEventsByCommandId);
        }
        if (keyConfigurationEventsByKeyConfigurationId != null) {
            this.notifyKeyConfigurations(keyConfigurationEventsByKeyConfigurationId);
        }
    }

    public void setActiveLocale(String activeLocale) {
        boolean commandManagerChanged = false;
        Map commandEventsByCommandId = null;
        if (!Util.equals(this.activeLocale, activeLocale)) {
            this.activeLocale = activeLocale;
            commandManagerChanged = true;
            this.calculateKeySequenceBindings();
            commandEventsByCommandId = this.updateCommands(this.commandsById.keySet());
        }
        if (commandManagerChanged) {
            this.fireCommandManagerChanged(new CommandManagerEvent(this, false, false, true, false, false, false, false, null, null, null));
        }
        if (commandEventsByCommandId != null) {
            this.notifyCommands(commandEventsByCommandId);
        }
    }

    public void setActivePlatform(String activePlatform) {
        boolean commandManagerChanged = false;
        Map commandEventsByCommandId = null;
        if (!Util.equals(this.activePlatform, activePlatform)) {
            this.activePlatform = activePlatform;
            commandManagerChanged = true;
            this.calculateKeySequenceBindings();
            commandEventsByCommandId = this.updateCommands(this.commandsById.keySet());
        }
        if (commandManagerChanged) {
            this.fireCommandManagerChanged(new CommandManagerEvent(this, false, false, false, true, false, false, false, null, null, null));
        }
        if (commandEventsByCommandId != null) {
            this.notifyCommands(commandEventsByCommandId);
        }
    }

    public void setHandlersByCommandId(Map handlersByCommandId) {
        handlersByCommandId = Util.safeCopy(handlersByCommandId, class$java$lang$String == null ? (class$java$lang$String = MutableCommandManager.class$("java.lang.String")) : class$java$lang$String, class$org$eclipse$ui$commands$IHandler == null ? (class$org$eclipse$ui$commands$IHandler = MutableCommandManager.class$("org.eclipse.ui.commands.IHandler")) : class$org$eclipse$ui$commands$IHandler, false, true);
        boolean commandManagerChanged = false;
        Map commandEventsByCommandId = null;
        if (!Util.equals(handlersByCommandId, this.handlersByCommandId)) {
            this.handlersByCommandId = handlersByCommandId;
            commandManagerChanged = true;
            commandEventsByCommandId = this.updateCommands(this.commandsById.keySet());
        }
        if (commandEventsByCommandId != null) {
            this.notifyCommands(commandEventsByCommandId);
        }
    }

    private Map updateCategories(Collection categoryIds) {
        TreeMap<String, CategoryEvent> categoryEventsByCategoryId = new TreeMap<String, CategoryEvent>();
        Iterator iterator = categoryIds.iterator();
        while (iterator.hasNext()) {
            CategoryEvent categoryEvent;
            String categoryId = (String)iterator.next();
            Category category = (Category)this.categoriesById.get(categoryId);
            if (category == null || (categoryEvent = this.updateCategory(category)) == null) continue;
            categoryEventsByCategoryId.put(categoryId, categoryEvent);
        }
        return categoryEventsByCategoryId;
    }

    private CategoryEvent updateCategory(Category category) {
        CategoryDefinition categoryDefinition = (CategoryDefinition)this.categoryDefinitionsById.get(category.getId());
        boolean definedChanged = category.setDefined(categoryDefinition != null);
        boolean descriptionChanged = category.setDescription(categoryDefinition != null ? categoryDefinition.getDescription() : null);
        boolean nameChanged = category.setName(categoryDefinition != null ? categoryDefinition.getName() : null);
        if (definedChanged || descriptionChanged || nameChanged) {
            return new CategoryEvent(category, definedChanged, nameChanged);
        }
        return null;
    }

    private CommandEvent updateCommand(Command command) {
        CommandDefinition commandDefinition = (CommandDefinition)this.commandDefinitionsById.get(command.getId());
        boolean categoryIdChanged = command.setCategoryId(commandDefinition != null ? commandDefinition.getCategoryId() : null);
        boolean definedChanged = command.setDefined(commandDefinition != null);
        boolean descriptionChanged = command.setDescription(commandDefinition != null ? commandDefinition.getDescription() : null);
        IHandler handler = (IHandler)this.handlersByCommandId.get(command.getId());
        boolean handlerChanged = command.setHandler(handler);
        SortedSet keySequenceBindings = (SortedSet)this.keySequenceBindingsByCommandId.get(command.getId());
        boolean keySequenceBindingsChanged = command.setKeySequenceBindings(keySequenceBindings != null ? new ArrayList(keySequenceBindings) : Collections.EMPTY_LIST);
        boolean nameChanged = command.setName(commandDefinition != null ? commandDefinition.getName() : null);
        if (categoryIdChanged || definedChanged || descriptionChanged || keySequenceBindingsChanged || nameChanged) {
            return new CommandEvent(command, false, categoryIdChanged, definedChanged, descriptionChanged, handlerChanged, keySequenceBindingsChanged, nameChanged, null);
        }
        return null;
    }

    private Map updateCommands(Collection commandIds) {
        TreeMap<String, CommandEvent> commandEventsByCommandId = new TreeMap<String, CommandEvent>();
        Iterator iterator = commandIds.iterator();
        while (iterator.hasNext()) {
            CommandEvent commandEvent;
            String commandId = (String)iterator.next();
            Command command = (Command)this.commandsById.get(commandId);
            if (command == null || (commandEvent = this.updateCommand(command)) == null) continue;
            commandEventsByCommandId.put(commandId, commandEvent);
        }
        return commandEventsByCommandId;
    }

    private KeyConfigurationEvent updateKeyConfiguration(KeyConfiguration keyConfiguration) {
        boolean activeChanged = keyConfiguration.setActive(Util.equals(this.activeKeyConfigurationId, keyConfiguration.getId()));
        KeyConfigurationDefinition keyConfigurationDefinition = (KeyConfigurationDefinition)this.keyConfigurationDefinitionsById.get(keyConfiguration.getId());
        boolean definedChanged = keyConfiguration.setDefined(keyConfigurationDefinition != null);
        boolean descriptionChanged = keyConfiguration.setDescription(keyConfigurationDefinition != null ? keyConfigurationDefinition.getDescription() : null);
        boolean nameChanged = keyConfiguration.setName(keyConfigurationDefinition != null ? keyConfigurationDefinition.getName() : null);
        boolean parentIdChanged = keyConfiguration.setParentId(keyConfigurationDefinition != null ? keyConfigurationDefinition.getParentId() : null);
        if (activeChanged || definedChanged || descriptionChanged || nameChanged || parentIdChanged) {
            return new KeyConfigurationEvent(keyConfiguration, activeChanged, definedChanged, nameChanged, parentIdChanged);
        }
        return null;
    }

    private Map updateKeyConfigurations(Collection keyConfigurationIds) {
        TreeMap<String, KeyConfigurationEvent> keyConfigurationEventsByKeyConfigurationId = new TreeMap<String, KeyConfigurationEvent>();
        Iterator iterator = keyConfigurationIds.iterator();
        while (iterator.hasNext()) {
            KeyConfigurationEvent keyConfigurationEvent;
            String keyConfigurationId = (String)iterator.next();
            KeyConfiguration keyConfiguration = (KeyConfiguration)this.keyConfigurationsById.get(keyConfigurationId);
            if (keyConfiguration == null || (keyConfigurationEvent = this.updateKeyConfiguration(keyConfiguration)) == null) continue;
            keyConfigurationEventsByKeyConfigurationId.put(keyConfigurationId, keyConfigurationEvent);
        }
        return keyConfigurationEventsByKeyConfigurationId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

