/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.File;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.PreferenceErrorDialog;
import org.eclipse.ui.internal.dialogs.PreferenceImportExportFileSelectionPage;

public class PreferenceImportExportWizard
extends Wizard {
    private final boolean export;
    private PreferenceImportExportFileSelectionPage fileSelectionPage;
    private final PreferenceDialog parent;
    private boolean success;
    private String selectedFilePath;
    private File selectedFile;
    private long lastModified;

    public PreferenceImportExportWizard(boolean exportWizard, PreferenceDialog parentDialog) {
        this.export = exportWizard;
        this.parent = parentDialog;
        if (exportWizard) {
            this.setWindowTitle(WorkbenchMessages.getString("ImportExportPages.exportWindowTitle"));
        } else {
            this.setWindowTitle(WorkbenchMessages.getString("ImportExportPages.importWindowTitle"));
        }
    }

    public void addPages() {
        super.addPages();
        this.fileSelectionPage = new PreferenceImportExportFileSelectionPage(this.export);
        this.addPage((IWizardPage)this.fileSelectionPage);
    }

    public boolean canFinish() {
        return this.fileSelectionPage.canFinish();
    }

    public boolean performFinish() {
        this.success = true;
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                PreferenceImportExportWizard.this.success = PreferenceImportExportWizard.this.saveAllPages();
                if (!PreferenceImportExportWizard.this.success) {
                    return;
                }
                Path path = new Path(PreferenceImportExportWizard.this.selectedFilePath);
                if (PreferenceImportExportWizard.this.export) {
                    PreferenceImportExportWizard.this.success = PreferenceImportExportWizard.this.exportFile((IPath)path);
                    if (!PreferenceImportExportWizard.this.success) {
                        return;
                    }
                } else {
                    PreferenceImportExportWizard.this.success = PreferenceImportExportWizard.this.importFile((IPath)path);
                    if (!PreferenceImportExportWizard.this.success) {
                        return;
                    }
                }
            }
        });
        if (!this.success) {
            return this.success;
        }
        this.showMessageDialog();
        WorkbenchPlugin.getDefault().getDialogSettings().put("PreferenceImportExportFileSelectionPage.filePath", this.fileSelectionPage.getPath());
        return true;
    }

    private boolean saveAllPages() {
        Iterator nodes = this.parent.getPreferenceManager().getElements(0).iterator();
        while (nodes.hasNext()) {
            IPreferenceNode node = (IPreferenceNode)nodes.next();
            IPreferencePage page = node.getPage();
            if (page == null || page.performOk()) continue;
            return false;
        }
        this.selectedFilePath = this.fileSelectionPage.getPath();
        this.selectedFile = new File(this.selectedFilePath);
        this.lastModified = this.selectedFile.lastModified();
        return true;
    }

    private boolean exportFile(IPath path) {
        if (this.selectedFile.exists() && !MessageDialog.openConfirm((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.saveTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.existsErrorMessage", new Object[]{this.selectedFilePath}))) {
            return false;
        }
        try {
            Preferences.exportPreferences((IPath)path);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.saveErrorTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.saveErrorMessage", new Object[]{this.selectedFilePath}), (IStatus)e.getStatus());
            return false;
        }
        return true;
    }

    private boolean importFile(IPath path) {
        int result;
        IStatus status = Preferences.validatePreferenceVersions((IPath)path);
        if (status.getSeverity() == 4) {
            ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.loadErrorTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.verifyErrorMessage", new Object[]{this.selectedFilePath}), (IStatus)status);
            return false;
        }
        if (status.getSeverity() == 2 && (result = PreferenceErrorDialog.openError(this.getShell(), WorkbenchMessages.getString("WorkbenchPreferenceDialog.loadErrorTitle"), WorkbenchMessages.format("WorkbenchPreferenceDialog.verifyWarningMessage", new Object[]{this.selectedFilePath}), status)) != 0) {
            return false;
        }
        try {
            Preferences.importPreferences((IPath)path);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.loadErrorTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.loadErrorMessage", new Object[]{this.selectedFilePath}), (IStatus)e.getStatus());
            return false;
        }
        return true;
    }

    private void showMessageDialog() {
        if (!this.export) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.loadTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.loadMessage", new Object[]{this.selectedFilePath}));
        } else if (this.selectedFile.exists() && this.selectedFile.lastModified() != this.lastModified) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.saveTitle"), (String)WorkbenchMessages.format("WorkbenchPreferenceDialog.saveMessage", new Object[]{this.selectedFilePath}));
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.saveErrorTitle"), (String)WorkbenchMessages.getString("WorkbenchPreferenceDialog.noPreferencesMessage"));
        }
    }
}

