/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathDirectory;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJar;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;

public class FileSystem
implements INameEnvironment,
SuffixConstants {
    Classpath[] classpaths;
    String[] knownFileNames;

    public FileSystem(String[] classpathNames, String[] initialFileNames, String encoding) {
        this(classpathNames, initialFileNames, encoding, null);
    }

    public FileSystem(String[] classpathNames, String[] initialFileNames, String encoding, int[] classpathDirectoryModes) {
        int i;
        int classpathSize = classpathNames.length;
        this.classpaths = new Classpath[classpathSize];
        String[] pathNames = new String[classpathSize];
        int problemsOccured = 0;
        for (i = 0; i < classpathSize; ++i) {
            try {
                File file = new File(this.convertPathSeparators(classpathNames[i]));
                if (file.isDirectory()) {
                    if (file.exists()) {
                        this.classpaths[i] = classpathDirectoryModes == null ? new ClasspathDirectory(file, encoding) : new ClasspathDirectory(file, encoding, classpathDirectoryModes[i]);
                        pathNames[i] = ((ClasspathDirectory)this.classpaths[i]).path;
                    }
                } else {
                    String lowercaseClasspathName = classpathNames[i].toLowerCase();
                    if (lowercaseClasspathName.endsWith(".jar") || lowercaseClasspathName.endsWith(".zip")) {
                        this.classpaths[i] = this.getClasspathJar(file);
                        pathNames[i] = classpathNames[i].substring(0, classpathNames[i].lastIndexOf(46));
                    }
                }
            }
            catch (IOException e) {
                this.classpaths[i] = null;
            }
            if (this.classpaths[i] != null) continue;
            ++problemsOccured;
        }
        if (problemsOccured > 0) {
            Classpath[] newPaths = new Classpath[classpathSize - problemsOccured];
            String[] newNames = new String[classpathSize - problemsOccured];
            int current = 0;
            for (int i2 = 0; i2 < classpathSize; ++i2) {
                if (this.classpaths[i2] == null) continue;
                newPaths[current] = this.classpaths[i2];
                newNames[current++] = pathNames[i2];
            }
            classpathSize = newPaths.length;
            this.classpaths = newPaths;
            pathNames = newNames;
        }
        this.knownFileNames = new String[initialFileNames.length];
        i = initialFileNames.length;
        while (--i >= 0) {
            String fileName = initialFileNames[i];
            String matchingPathName = null;
            if (fileName.lastIndexOf(".") != -1) {
                fileName = fileName.substring(0, fileName.lastIndexOf(46));
            }
            fileName = this.convertPathSeparators(fileName);
            for (int j = 0; j < classpathSize; ++j) {
                if (!fileName.startsWith(pathNames[j])) continue;
                matchingPathName = pathNames[j];
            }
            if (matchingPathName == null) {
                this.knownFileNames[i] = fileName;
                continue;
            }
            this.knownFileNames[i] = fileName.substring(matchingPathName.length());
        }
    }

    public void cleanup() {
        int max = this.classpaths.length;
        for (int i = 0; i < max; ++i) {
            this.classpaths[i].reset();
        }
    }

    private String convertPathSeparators(String path) {
        return File.separatorChar == '/' ? path.replace('\\', '/') : path.replace('/', '\\');
    }

    private NameEnvironmentAnswer findClass(String qualifiedTypeName, char[] typeName) {
        String qp2;
        int length = this.knownFileNames.length;
        for (int i = 0; i < length; ++i) {
            if (!qualifiedTypeName.equals(this.knownFileNames[i])) continue;
            return null;
        }
        String qualifiedBinaryFileName = qualifiedTypeName + ".class";
        String qualifiedPackageName = qualifiedTypeName.length() == typeName.length ? "" : qualifiedBinaryFileName.substring(0, qualifiedTypeName.length() - typeName.length - 1);
        String string = qp2 = File.separatorChar == '/' ? qualifiedPackageName : qualifiedPackageName.replace('/', File.separatorChar);
        if (qualifiedPackageName == qp2) {
            int length2 = this.classpaths.length;
            for (int i = 0; i < length2; ++i) {
                NameEnvironmentAnswer answer = this.classpaths[i].findClass(typeName, qualifiedPackageName, qualifiedBinaryFileName);
                if (answer == null) continue;
                return answer;
            }
        } else {
            String qb2 = qualifiedBinaryFileName.replace('/', File.separatorChar);
            int length3 = this.classpaths.length;
            for (int i = 0; i < length3; ++i) {
                NameEnvironmentAnswer answer;
                Classpath p = this.classpaths[i];
                NameEnvironmentAnswer nameEnvironmentAnswer = answer = p instanceof ClasspathJar ? p.findClass(typeName, qualifiedPackageName, qualifiedBinaryFileName) : p.findClass(typeName, qp2, qb2);
                if (answer == null) continue;
                return answer;
            }
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[][] compoundName) {
        if (compoundName != null) {
            return this.findClass(new String(CharOperation.concatWith(compoundName, '/')), compoundName[compoundName.length - 1]);
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        if (typeName != null) {
            return this.findClass(new String(CharOperation.concatWith(packageName, typeName, '/')), typeName);
        }
        return null;
    }

    public ClasspathJar getClasspathJar(File file) throws IOException {
        return new ClasspathJar(new ZipFile(file), true);
    }

    public boolean isPackage(char[][] compoundName, char[] packageName) {
        String qp2;
        String qualifiedPackageName = new String(CharOperation.concatWith(compoundName, packageName, '/'));
        String string = qp2 = File.separatorChar == '/' ? qualifiedPackageName : qualifiedPackageName.replace('/', File.separatorChar);
        if (qualifiedPackageName == qp2) {
            int length = this.classpaths.length;
            for (int i = 0; i < length; ++i) {
                if (!this.classpaths[i].isPackage(qualifiedPackageName)) continue;
                return true;
            }
        } else {
            int length = this.classpaths.length;
            for (int i = 0; i < length; ++i) {
                Classpath p = this.classpaths[i];
                if (!(p instanceof ClasspathJar ? p.isPackage(qualifiedPackageName) : p.isPackage(qp2))) continue;
                return true;
            }
        }
        return false;
    }

    static interface Classpath {
        public NameEnvironmentAnswer findClass(char[] var1, String var2, String var3);

        public boolean isPackage(String var1);

        public void reset();
    }
}

