/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.IRequestQuery;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class AddMethodStubOperation
implements IWorkspaceRunnable {
    private IType fType;
    private IMethod[] fMethods;
    private IMethod[] fCreatedMethods;
    private boolean fDoSave;
    private IRequestQuery fOverrideQuery;
    private IRequestQuery fReplaceQuery;
    private boolean fOverrideAll;
    private boolean fReplaceAll;
    private CodeGenerationSettings fSettings;

    public AddMethodStubOperation(IType type, IMethod[] methods, CodeGenerationSettings settings, IRequestQuery overrideQuery, IRequestQuery replaceQuery, boolean save) {
        this.fType = type;
        this.fMethods = methods;
        this.fCreatedMethods = null;
        this.fDoSave = save;
        this.fOverrideQuery = overrideQuery;
        this.fReplaceQuery = replaceQuery;
        this.fSettings = settings;
    }

    private boolean queryOverrideFinalMethods(IMethod inheritedMethod) throws OperationCanceledException {
        if (!this.fOverrideAll) {
            switch (this.fOverrideQuery.doQuery((IMember)inheritedMethod)) {
                case 0: {
                    throw new OperationCanceledException();
                }
                case 1: {
                    return false;
                }
                case 3: {
                    this.fOverrideAll = true;
                }
            }
        }
        return true;
    }

    private boolean queryReplaceMethods(IMethod method) throws OperationCanceledException {
        if (!this.fReplaceAll) {
            switch (this.fReplaceQuery.doQuery((IMember)method)) {
                case 0: {
                    throw new OperationCanceledException();
                }
                case 1: {
                    return false;
                }
                case 3: {
                    this.fReplaceAll = true;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.setTaskName(CodeGenerationMessages.getString("AddMethodStubOperation.description"));
            monitor.beginTask("", this.fMethods.length + 2);
            this.fOverrideAll = this.fOverrideQuery == null;
            this.fReplaceAll = this.fReplaceQuery == null;
            IMethod[] existingMethods = this.fType.getMethods();
            ArrayList<IMethod> createdMethods = new ArrayList<IMethod>();
            ImportsStructure imports = new ImportsStructure(this.fType.getCompilationUnit(), this.fSettings.importOrder, this.fSettings.importThreshold, true);
            String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)this.fType);
            int indent = StubUtility.getIndentUsed((IJavaElement)this.fType) + 1;
            StubUtility.GenStubSettings genStubSetting = new StubUtility.GenStubSettings(this.fSettings);
            ICompilationUnit cu = this.fType.getCompilationUnit();
            String typeName = this.fType.getElementName();
            ITypeHierarchy typeHierarchy = this.fType.newSupertypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            for (int i = 0; i < this.fMethods.length; ++i) {
                Object var20_22;
                block17: {
                    block16: {
                        block15: {
                            try {
                                String content;
                                IMethod curr = this.fMethods[i];
                                for (int k = 0; k < createdMethods.size(); ++k) {
                                    IMethod meth = (IMethod)createdMethods.get(k);
                                    if (!JavaModelUtil.isSameMethodSignature(meth.getElementName(), meth.getParameterTypes(), meth.isConstructor(), curr)) continue;
                                }
                                IMethod overwrittenMethod = JavaModelUtil.findMethodImplementationInHierarchy(typeHierarchy, this.fType, curr.getElementName(), curr.getParameterTypes(), curr.isConstructor());
                                if (overwrittenMethod == null) {
                                    genStubSetting.callSuper = false;
                                    genStubSetting.methodOverwrites = false;
                                    genStubSetting.noBody = this.fType.isInterface();
                                    genStubSetting.methodModifiers = curr.getFlags();
                                    content = StubUtility.genStub(cu, typeName, curr, this.fType, genStubSetting, imports);
                                } else {
                                    int flags = overwrittenMethod.getFlags();
                                    if ((Flags.isFinal((int)flags) || Flags.isPrivate((int)flags)) && !this.queryOverrideFinalMethods(overwrittenMethod)) {
                                        var20_22 = null;
                                        break block15;
                                    }
                                    genStubSetting.callSuper = true;
                                    genStubSetting.methodOverwrites = true;
                                    IMethod declaration = JavaModelUtil.findMethodDeclarationInHierarchy(typeHierarchy, this.fType, curr.getElementName(), curr.getParameterTypes(), curr.isConstructor());
                                    content = StubUtility.genStub(cu, typeName, overwrittenMethod, declaration.getDeclaringType(), genStubSetting, imports);
                                }
                                IJavaElement sibling = null;
                                IMethod existing = JavaModelUtil.findMethod(curr.getElementName(), curr.getParameterTypes(), curr.isConstructor(), existingMethods);
                                if (existing != null) {
                                    if (!this.queryReplaceMethods(existing)) {
                                        break block16;
                                    }
                                    sibling = StubUtility.findNextSibling((IJavaElement)existing);
                                    existing.delete(false, null);
                                } else if (curr.isConstructor() && existingMethods.length > 0) {
                                    sibling = existingMethods[0];
                                }
                                String formattedContent = CodeFormatterUtil.format(4, content, indent, null, lineDelim, this.fType.getJavaProject()) + lineDelim;
                                IMethod newMethod = this.fType.createMethod(formattedContent, sibling, true, null);
                                createdMethods.add(newMethod);
                                break block17;
                            }
                            catch (Throwable throwable) {
                                var20_22 = null;
                                monitor.worked(1);
                                if (!monitor.isCanceled()) throw throwable;
                                throw new OperationCanceledException();
                            }
                        }
                        monitor.worked(1);
                        if (!monitor.isCanceled()) continue;
                        throw new OperationCanceledException();
                    }
                    var20_22 = null;
                    monitor.worked(1);
                    if (!monitor.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
                var20_22 = null;
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            int nCreated = createdMethods.size();
            if (nCreated <= 0) return;
            imports.create(this.fDoSave, null);
            monitor.worked(1);
            this.fCreatedMethods = createdMethods.toArray(new IMethod[nCreated]);
            return;
        }
        finally {
            monitor.done();
        }
    }

    public IMethod[] getCreatedMethods() {
        return this.fCreatedMethods;
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

