/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.builder.AdditionalTypeCollection;
import org.eclipse.jdt.internal.core.builder.ClasspathDirectory;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import org.eclipse.jdt.internal.core.builder.StringSet;
import org.eclipse.jdt.internal.core.util.SimpleLookupTable;

public class State {
    String javaProjectName;
    ClasspathMultiDirectory[] sourceLocations;
    ClasspathLocation[] binaryLocations;
    SimpleLookupTable references;
    SimpleLookupTable typeLocators;
    int buildNumber;
    long lastStructuralBuildTime;
    SimpleLookupTable structuralBuildTimes;
    private String[] knownPackageNames;
    private long previousStructuralBuildTime;
    private StringSet structurallyChangedTypes;
    public static int MaxStructurallyChangedTypes = 100;
    static final byte VERSION = 8;
    static final byte SOURCE_FOLDER = 1;
    static final byte BINARY_FOLDER = 2;
    static final byte EXTERNAL_JAR = 3;
    static final byte INTERNAL_JAR = 4;

    State() {
    }

    protected State(JavaBuilder javaBuilder) {
        this.knownPackageNames = null;
        this.previousStructuralBuildTime = -1L;
        this.structurallyChangedTypes = null;
        this.javaProjectName = javaBuilder.currentProject.getName();
        this.sourceLocations = javaBuilder.nameEnvironment.sourceLocations;
        this.binaryLocations = javaBuilder.nameEnvironment.binaryLocations;
        this.references = new SimpleLookupTable(7);
        this.typeLocators = new SimpleLookupTable(7);
        this.buildNumber = 0;
        this.lastStructuralBuildTime = System.currentTimeMillis();
        this.structuralBuildTimes = new SimpleLookupTable(3);
    }

    void copyFrom(State lastState) {
        this.knownPackageNames = null;
        this.previousStructuralBuildTime = lastState.previousStructuralBuildTime;
        this.structurallyChangedTypes = lastState.structurallyChangedTypes;
        this.buildNumber = lastState.buildNumber + 1;
        this.lastStructuralBuildTime = lastState.lastStructuralBuildTime;
        this.structuralBuildTimes = lastState.structuralBuildTimes;
        try {
            this.references = (SimpleLookupTable)lastState.references.clone();
            this.typeLocators = (SimpleLookupTable)lastState.typeLocators.clone();
        }
        catch (CloneNotSupportedException e) {
            int i;
            this.references = new SimpleLookupTable(lastState.references.elementSize);
            Object[] keyTable = lastState.references.keyTable;
            Object[] valueTable = lastState.references.valueTable;
            int l = keyTable.length;
            for (i = 0; i < l; ++i) {
                if (keyTable[i] == null) continue;
                this.references.put(keyTable[i], valueTable[i]);
            }
            this.typeLocators = new SimpleLookupTable(lastState.typeLocators.elementSize);
            keyTable = lastState.typeLocators.keyTable;
            valueTable = lastState.typeLocators.valueTable;
            l = keyTable.length;
            for (i = 0; i < l; ++i) {
                if (keyTable[i] == null) continue;
                this.typeLocators.put(keyTable[i], valueTable[i]);
            }
        }
    }

    char[][] getDefinedTypeNamesFor(String typeLocator) {
        Object c = this.references.get(typeLocator);
        if (c instanceof AdditionalTypeCollection) {
            return ((AdditionalTypeCollection)c).definedTypeNames;
        }
        return null;
    }

    StringSet getStructurallyChangedTypes(State prereqState) {
        if (prereqState != null && prereqState.previousStructuralBuildTime > 0L) {
            long previous;
            Object o = this.structuralBuildTimes.get(prereqState.javaProjectName);
            long l = previous = o == null ? 0L : (Long)o;
            if (previous == prereqState.previousStructuralBuildTime) {
                return prereqState.structurallyChangedTypes;
            }
        }
        return null;
    }

    boolean isDuplicateLocator(String qualifiedTypeName, String typeLocator) {
        String existing = (String)this.typeLocators.get(qualifiedTypeName);
        return existing != null && !existing.equals(typeLocator);
    }

    boolean isKnownPackage(String qualifiedPackageName) {
        if (this.knownPackageNames == null) {
            ArrayList<String> names = new ArrayList<String>(this.typeLocators.elementSize);
            Object[] keyTable = this.typeLocators.keyTable;
            int l = keyTable.length;
            for (int i = 0; i < l; ++i) {
                if (keyTable[i] == null) continue;
                String packageName = (String)keyTable[i];
                int last = packageName.lastIndexOf(47);
                String string = packageName = last == -1 ? null : packageName.substring(0, last);
                while (packageName != null && !names.contains(packageName)) {
                    names.add(packageName);
                    last = packageName.lastIndexOf(47);
                    packageName = last == -1 ? null : packageName.substring(0, last);
                }
            }
            this.knownPackageNames = new String[names.size()];
            names.toArray(this.knownPackageNames);
        }
        int l = this.knownPackageNames.length;
        for (int i = 0; i < l; ++i) {
            if (!this.knownPackageNames[i].equals(qualifiedPackageName)) continue;
            return true;
        }
        return false;
    }

    void record(String typeLocator, char[][][] qualifiedRefs, char[][] simpleRefs, char[] mainTypeName, ArrayList typeNames) {
        if (typeNames.size() == 1 && CharOperation.equals(mainTypeName, (char[])typeNames.get(0))) {
            this.references.put(typeLocator, new ReferenceCollection(qualifiedRefs, simpleRefs));
        } else {
            char[][] definedTypeNames = new char[typeNames.size()][];
            typeNames.toArray((T[])definedTypeNames);
            this.references.put(typeLocator, new AdditionalTypeCollection(definedTypeNames, qualifiedRefs, simpleRefs));
        }
    }

    void recordLocatorForType(String qualifiedTypeName, String typeLocator) {
        this.knownPackageNames = null;
        int start = typeLocator.indexOf(qualifiedTypeName, 0);
        if (start > 0) {
            qualifiedTypeName = typeLocator.substring(start, start + qualifiedTypeName.length());
        }
        this.typeLocators.put(qualifiedTypeName, typeLocator);
    }

    void recordStructuralDependency(IProject prereqProject, State prereqState) {
        if (prereqState != null && prereqState.lastStructuralBuildTime > 0L) {
            this.structuralBuildTimes.put(prereqProject.getName(), new Long(prereqState.lastStructuralBuildTime));
        }
    }

    void removeLocator(String typeLocatorToRemove) {
        this.knownPackageNames = null;
        this.references.removeKey(typeLocatorToRemove);
        this.typeLocators.removeValue(typeLocatorToRemove);
    }

    void removePackage(IResourceDelta sourceDelta) {
        IResource resource = sourceDelta.getResource();
        switch (resource.getType()) {
            case 2: {
                IResourceDelta[] children = sourceDelta.getAffectedChildren();
                int l = children.length;
                for (int i = 0; i < l; ++i) {
                    this.removePackage(children[i]);
                }
                return;
            }
            case 1: {
                IPath typeLocatorPath = resource.getProjectRelativePath();
                if (!Util.isJavaFileName(typeLocatorPath.lastSegment())) break;
                this.removeLocator(typeLocatorPath.toString());
            }
        }
    }

    void removeQualifiedTypeName(String qualifiedTypeNameToRemove) {
        this.knownPackageNames = null;
        this.typeLocators.removeKey(qualifiedTypeNameToRemove);
    }

    static State read(IProject project, DataInputStream in) throws IOException {
        int i;
        int i2;
        int i3;
        if (JavaBuilder.DEBUG) {
            System.out.println("About to read state...");
        }
        if (8 != in.readByte()) {
            if (JavaBuilder.DEBUG) {
                System.out.println("Found non-compatible state version... answered null");
            }
            return null;
        }
        State newState = new State();
        newState.javaProjectName = in.readUTF();
        if (!project.getName().equals(newState.javaProjectName)) {
            if (JavaBuilder.DEBUG) {
                System.out.println("Project's name does not match... answered null");
            }
            return null;
        }
        newState.buildNumber = in.readInt();
        newState.lastStructuralBuildTime = in.readLong();
        int length = in.readInt();
        newState.sourceLocations = new ClasspathMultiDirectory[length];
        for (int i4 = 0; i4 < length; ++i4) {
            IProject sourceFolder = project;
            IProject outputFolder = project;
            String folderName = in.readUTF();
            if (folderName.length() > 0) {
                sourceFolder = project.getFolder(folderName);
            }
            if ((folderName = in.readUTF()).length() > 0) {
                outputFolder = project.getFolder(folderName);
            }
            ClasspathMultiDirectory md = (ClasspathMultiDirectory)ClasspathLocation.forSourceFolder((IContainer)sourceFolder, (IContainer)outputFolder, State.readNames(in), State.readNames(in));
            if (in.readBoolean()) {
                md.hasIndependentOutputFolder = true;
            }
            newState.sourceLocations[i4] = md;
        }
        length = in.readInt();
        newState.binaryLocations = new ClasspathLocation[length];
        IWorkspaceRoot root = project.getWorkspace().getRoot();
        block11: for (i3 = 0; i3 < length; ++i3) {
            switch (in.readByte()) {
                case 1: {
                    newState.binaryLocations[i3] = newState.sourceLocations[in.readInt()];
                    continue block11;
                }
                case 2: {
                    Path path = new Path(in.readUTF());
                    IFolder outputFolder = path.segmentCount() == 1 ? root.getProject(path.toString()) : root.getFolder((IPath)path);
                    newState.binaryLocations[i3] = ClasspathLocation.forBinaryFolder((IContainer)outputFolder, in.readBoolean());
                    continue block11;
                }
                case 3: {
                    newState.binaryLocations[i3] = ClasspathLocation.forLibrary(in.readUTF());
                    continue block11;
                }
                case 4: {
                    newState.binaryLocations[i3] = ClasspathLocation.forLibrary(root.getFile((IPath)new Path(in.readUTF())));
                }
            }
        }
        length = in.readInt();
        newState.structuralBuildTimes = new SimpleLookupTable(length);
        for (i3 = 0; i3 < length; ++i3) {
            newState.structuralBuildTimes.put(in.readUTF(), new Long(in.readLong()));
        }
        length = in.readInt();
        String[] internedTypeLocators = new String[length];
        for (i2 = 0; i2 < length; ++i2) {
            internedTypeLocators[i2] = in.readUTF();
        }
        length = in.readInt();
        newState.typeLocators = new SimpleLookupTable(length);
        for (i2 = 0; i2 < length; ++i2) {
            newState.recordLocatorForType(in.readUTF(), internedTypeLocators[in.readInt()]);
        }
        char[][] internedSimpleNames = ReferenceCollection.internSimpleNames(State.readNames(in), false);
        length = in.readInt();
        Object internedQualifiedNames = new char[length][][];
        for (i = 0; i < length; ++i) {
            int qLength = in.readInt();
            char[][] qName = new char[qLength][];
            for (int j = 0; j < qLength; ++j) {
                qName[j] = internedSimpleNames[in.readInt()];
            }
            internedQualifiedNames[i] = qName;
        }
        internedQualifiedNames = ReferenceCollection.internQualifiedNames(internedQualifiedNames);
        length = in.readInt();
        newState.references = new SimpleLookupTable(length);
        for (i = 0; i < length; ++i) {
            String typeLocator = internedTypeLocators[in.readInt()];
            ReferenceCollection collection = null;
            switch (in.readByte()) {
                case 1: {
                    char[][] additionalTypeNames = State.readNames(in);
                    char[][][] qualifiedNames = new char[in.readInt()][][];
                    int m = qualifiedNames.length;
                    for (int j = 0; j < m; ++j) {
                        qualifiedNames[j] = internedQualifiedNames[in.readInt()];
                    }
                    char[][] simpleNames = new char[in.readInt()][];
                    int m2 = simpleNames.length;
                    for (int j = 0; j < m2; ++j) {
                        simpleNames[j] = internedSimpleNames[in.readInt()];
                    }
                    collection = new AdditionalTypeCollection(additionalTypeNames, qualifiedNames, simpleNames);
                    break;
                }
                case 2: {
                    char[][][] qNames = new char[in.readInt()][][];
                    int m = qNames.length;
                    for (int j = 0; j < m; ++j) {
                        qNames[j] = internedQualifiedNames[in.readInt()];
                    }
                    char[][] sNames = new char[in.readInt()][];
                    int m3 = sNames.length;
                    for (int j = 0; j < m3; ++j) {
                        sNames[j] = internedSimpleNames[in.readInt()];
                    }
                    collection = new ReferenceCollection(qNames, sNames);
                }
            }
            newState.references.put(typeLocator, collection);
        }
        if (JavaBuilder.DEBUG) {
            System.out.println("Successfully read state for " + newState.javaProjectName);
        }
        return newState;
    }

    private static char[][] readNames(DataInputStream in) throws IOException {
        int length = in.readInt();
        char[][] names = new char[length][];
        for (int i = 0; i < length; ++i) {
            int nLength = in.readInt();
            char[] name = new char[nLength];
            for (int j = 0; j < nLength; ++j) {
                name[j] = in.readChar();
            }
            names[i] = name;
        }
        return names;
    }

    void tagAsNoopBuild() {
        this.buildNumber = -1;
    }

    boolean wasNoopBuild() {
        return this.buildNumber == -1;
    }

    void tagAsStructurallyChanged() {
        this.previousStructuralBuildTime = this.lastStructuralBuildTime;
        this.structurallyChangedTypes = new StringSet(7);
        this.lastStructuralBuildTime = System.currentTimeMillis();
    }

    boolean wasStructurallyChanged(IProject prereqProject, State prereqState) {
        if (prereqState != null) {
            long previous;
            Object o = this.structuralBuildTimes.get(prereqProject.getName());
            long l = previous = o == null ? 0L : (Long)o;
            if (previous == prereqState.lastStructuralBuildTime) {
                return false;
            }
        }
        return true;
    }

    void wasStructurallyChanged(String typeName) {
        if (this.structurallyChangedTypes != null) {
            if (this.structurallyChangedTypes.elementSize > MaxStructurallyChangedTypes) {
                this.structurallyChangedTypes = null;
            } else {
                this.structurallyChangedTypes.add(typeName);
            }
        }
    }

    void write(DataOutputStream out) throws IOException {
        int i;
        int l;
        Object[] valueTable;
        Object[] keyTable;
        int i2;
        out.writeByte(8);
        out.writeUTF(this.javaProjectName);
        out.writeInt(this.buildNumber);
        out.writeLong(this.lastStructuralBuildTime);
        int length = this.sourceLocations.length;
        out.writeInt(length);
        for (i2 = 0; i2 < length; ++i2) {
            ClasspathMultiDirectory md = this.sourceLocations[i2];
            out.writeUTF(md.sourceFolder.getProjectRelativePath().toString());
            out.writeUTF(md.binaryFolder.getProjectRelativePath().toString());
            this.writeNames(md.inclusionPatterns, out);
            this.writeNames(md.exclusionPatterns, out);
            out.writeBoolean(md.hasIndependentOutputFolder);
        }
        length = this.binaryLocations.length;
        out.writeInt(length);
        block1: for (i2 = 0; i2 < length; ++i2) {
            ClasspathLocation c = this.binaryLocations[i2];
            if (c instanceof ClasspathMultiDirectory) {
                out.writeByte(1);
                int m = this.sourceLocations.length;
                for (int j = 0; j < m; ++j) {
                    if (this.sourceLocations[j] != c) continue;
                    out.writeInt(j);
                    continue block1;
                }
                continue;
            }
            if (c instanceof ClasspathDirectory) {
                out.writeByte(2);
                ClasspathDirectory cd = (ClasspathDirectory)c;
                out.writeUTF(cd.binaryFolder.getFullPath().toString());
                out.writeBoolean(cd.isOutputFolder);
                continue;
            }
            ClasspathJar jar = (ClasspathJar)c;
            if (jar.resource == null) {
                out.writeByte(3);
                out.writeUTF(jar.zipFilename);
                continue;
            }
            out.writeByte(4);
            out.writeUTF(jar.resource.getFullPath().toString());
        }
        length = this.structuralBuildTimes.elementSize;
        out.writeInt(length);
        if (length > 0) {
            keyTable = this.structuralBuildTimes.keyTable;
            valueTable = this.structuralBuildTimes.valueTable;
            int l2 = keyTable.length;
            for (i2 = 0; i2 < l2; ++i2) {
                if (keyTable[i2] == null) continue;
                --length;
                out.writeUTF((String)keyTable[i2]);
                out.writeLong((Long)valueTable[i2]);
            }
            if (JavaBuilder.DEBUG && length != 0) {
                System.out.println("structuralBuildNumbers table is inconsistent");
            }
        }
        length = this.references.elementSize;
        out.writeInt(length);
        ArrayList<String> internedTypeLocators = new ArrayList<String>(length);
        if (length > 0) {
            keyTable = this.references.keyTable;
            l = keyTable.length;
            for (int i3 = 0; i3 < l; ++i3) {
                if (keyTable[i3] == null) continue;
                --length;
                String key = (String)keyTable[i3];
                out.writeUTF(key);
                internedTypeLocators.add(key);
            }
            if (JavaBuilder.DEBUG && length != 0) {
                System.out.println("references table is inconsistent");
            }
        }
        length = this.typeLocators.elementSize;
        out.writeInt(length);
        if (length > 0) {
            keyTable = this.typeLocators.keyTable;
            valueTable = this.typeLocators.valueTable;
            l = keyTable.length;
            for (int i4 = 0; i4 < l; ++i4) {
                if (keyTable[i4] == null) continue;
                --length;
                out.writeUTF((String)keyTable[i4]);
                out.writeInt(internedTypeLocators.indexOf(valueTable[i4]));
            }
            if (JavaBuilder.DEBUG && length != 0) {
                System.out.println("typeLocators table is inconsistent");
            }
        }
        ArrayList<char[][]> internedQualifiedNames = new ArrayList<char[][]>(31);
        ArrayList<char[]> internedSimpleNames = new ArrayList<char[]>(31);
        valueTable = this.references.valueTable;
        int l3 = valueTable.length;
        for (int i5 = 0; i5 < l3; ++i5) {
            if (valueTable[i5] == null) continue;
            ReferenceCollection collection = (ReferenceCollection)valueTable[i5];
            char[][][] qNames = collection.qualifiedNameReferences;
            int m = qNames.length;
            for (int j = 0; j < m; ++j) {
                char[][] qName = qNames[j];
                if (internedQualifiedNames.contains(qName)) continue;
                internedQualifiedNames.add(qName);
                int n = qName.length;
                for (int k = 0; k < n; ++k) {
                    char[] sName = qName[k];
                    if (internedSimpleNames.contains(sName)) continue;
                    internedSimpleNames.add(sName);
                }
            }
            char[][] sNames = collection.simpleNameReferences;
            int m2 = sNames.length;
            for (int j = 0; j < m2; ++j) {
                char[] sName = sNames[j];
                if (internedSimpleNames.contains(sName)) continue;
                internedSimpleNames.add(sName);
            }
        }
        char[][] internedArray = new char[internedSimpleNames.size()][];
        internedSimpleNames.toArray((T[])internedArray);
        this.writeNames(internedArray, out);
        length = internedQualifiedNames.size();
        out.writeInt(length);
        for (i = 0; i < length; ++i) {
            char[][] qName = (char[][])internedQualifiedNames.get(i);
            int qLength = qName.length;
            out.writeInt(qLength);
            for (int j = 0; j < qLength; ++j) {
                out.writeInt(internedSimpleNames.indexOf(qName[j]));
            }
        }
        length = this.references.elementSize;
        out.writeInt(length);
        if (length > 0) {
            keyTable = this.references.keyTable;
            int l4 = keyTable.length;
            for (i = 0; i < l4; ++i) {
                if (keyTable[i] == null) continue;
                --length;
                out.writeInt(internedTypeLocators.indexOf(keyTable[i]));
                ReferenceCollection collection = (ReferenceCollection)valueTable[i];
                if (collection instanceof AdditionalTypeCollection) {
                    out.writeByte(1);
                    AdditionalTypeCollection atc = (AdditionalTypeCollection)collection;
                    this.writeNames(atc.definedTypeNames, out);
                } else {
                    out.writeByte(2);
                }
                char[][][] qNames = collection.qualifiedNameReferences;
                int qLength = qNames.length;
                out.writeInt(qLength);
                for (int j = 0; j < qLength; ++j) {
                    out.writeInt(internedQualifiedNames.indexOf(qNames[j]));
                }
                char[][] sNames = collection.simpleNameReferences;
                int sLength = sNames.length;
                out.writeInt(sLength);
                for (int j = 0; j < sLength; ++j) {
                    out.writeInt(internedSimpleNames.indexOf(sNames[j]));
                }
            }
            if (JavaBuilder.DEBUG && length != 0) {
                System.out.println("references table is inconsistent");
            }
        }
    }

    private void writeNames(char[][] names, DataOutputStream out) throws IOException {
        int length = names == null ? 0 : names.length;
        out.writeInt(length);
        for (int i = 0; i < length; ++i) {
            char[] name = names[i];
            int nLength = name.length;
            out.writeInt(nLength);
            for (int j = 0; j < nLength; ++j) {
                out.writeChar(name[j]);
            }
        }
    }

    public String toString() {
        return "State for " + this.javaProjectName + " (#" + this.buildNumber + " @ " + new Date(this.lastStructuralBuildTime) + ")";
    }
}

