/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatch;
import org.eclipse.jdt.internal.core.util.SimpleLookupTable;

public class PossibleMatchSet {
    private SimpleLookupTable rootsToPossibleMatches = new SimpleLookupTable(5);
    private int elementCount = 0;

    public void add(PossibleMatch possibleMatch) {
        IPath path = possibleMatch.openable.getPackageFragmentRoot().getPath();
        ObjectVector possibleMatches = (ObjectVector)this.rootsToPossibleMatches.get(path);
        if (possibleMatches != null) {
            if (possibleMatches.contains(possibleMatch)) {
                return;
            }
        } else {
            possibleMatches = new ObjectVector();
            this.rootsToPossibleMatches.put(path, possibleMatches);
        }
        possibleMatches.add(possibleMatch);
        ++this.elementCount;
    }

    public PossibleMatch[] getPossibleMatches(IPackageFragmentRoot[] roots) {
        Object[] result = new PossibleMatch[this.elementCount];
        int index = 0;
        int length = roots.length;
        for (int i = 0; i < length; ++i) {
            ObjectVector possibleMatches = (ObjectVector)this.rootsToPossibleMatches.get(roots[i].getPath());
            if (possibleMatches == null) continue;
            possibleMatches.copyInto(result, index);
            index += possibleMatches.size();
        }
        if (index < this.elementCount) {
            Object[] objectArray = result;
            result = new PossibleMatch[index];
            System.arraycopy(objectArray, 0, result, 0, index);
        }
        return result;
    }

    public void reset() {
        this.rootsToPossibleMatches = new SimpleLookupTable(5);
        this.elementCount = 0;
    }
}

