/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.FilteredPreferenceDialog;
import org.eclipse.ui.internal.dialogs.PreferenceImportExportWizard;

public class WorkbenchPreferenceDialog
extends FilteredPreferenceDialog {
    private static final int LOAD_ID = 1025;
    private static final int SAVE_ID = 1026;
    static final String FILE_PATH_SETTING = "PreferenceImportExportFileSelectionPage.filePath";

    public WorkbenchPreferenceDialog(Shell parentShell, PreferenceManager manager) {
        super(parentShell, manager);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.loadPressed();
                return;
            }
            case 1026: {
                this.savePressed();
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        this.createButton(parent, 1025, WorkbenchMessages.getString("WorkbenchPreferenceDialog.load"), false);
        this.createButton(parent, 1026, WorkbenchMessages.getString("WorkbenchPreferenceDialog.save"), false);
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        super.createButtonsForButtonBar(parent);
    }

    protected void loadPressed() {
        PreferenceImportExportWizard wizard = new PreferenceImportExportWizard(false, this);
        IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = workbenchSettings.getSection(FILE_PATH_SETTING);
        if (wizardSettings == null) {
            wizardSettings = workbenchSettings.addNewSection(FILE_PATH_SETTING);
        }
        wizard.setDialogSettings(wizardSettings);
        Shell parent = this.getShell();
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        dialog.create();
        Shell shell = dialog.getShell();
        shell.setSize(Math.max(500, shell.getSize().x), 500);
        Point childSize = shell.getSize();
        Point parentSize = parent.getSize();
        Point childLocation = new Point((parentSize.x - childSize.x) / 2, (parentSize.y - childSize.y) / 2);
        shell.setLocation(parent.toDisplay(childLocation));
        int returnCode = dialog.open();
        if (returnCode == 0) {
            this.close();
        }
    }

    protected void savePressed() {
        PreferenceImportExportWizard wizard = new PreferenceImportExportWizard(true, this);
        IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = workbenchSettings.getSection(FILE_PATH_SETTING);
        if (wizardSettings == null) {
            wizardSettings = workbenchSettings.addNewSection("ExportPreferencesWizard");
        }
        wizard.setDialogSettings(wizardSettings);
        wizard.setForcePreviousAndNextButtons(true);
        Shell parent = this.getShell();
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        dialog.create();
        Shell shell = dialog.getShell();
        shell.setSize(Math.max(500, shell.getSize().x), 500);
        Point childSize = shell.getSize();
        Point parentSize = parent.getSize();
        Point childLocation = new Point((parentSize.x - childSize.x) / 2, (parentSize.y - childSize.y) / 2);
        shell.setLocation(parent.toDisplay(childLocation));
        dialog.open();
    }
}

