/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.build.JARFileFilter;
import org.eclipse.pde.internal.ui.editor.plugin.JarSelectionValidator;
import org.eclipse.pde.internal.ui.editor.plugin.NewRuntimeLibraryDialog;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.RenameDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class LibrarySection
extends TableSection
implements IModelChangedListener {
    public static final String SECTION_TITLE = "ManifestEditor.LibrarySection.title";
    public static final String SECTION_DESC = "ManifestEditor.LibrarySection.desc";
    public static final String SECTION_FDESC = "ManifestEditor.LibrarySection.fdesc";
    public static final String SECTION_ADD = "NewManifestEditor.LibrarySection.add";
    public static final String SECTION_NEW = "NewManifestEditor.LibrarySection.new";
    public static final String SECTION_UP = "ManifestEditor.LibrarySection.up";
    public static final String SECTION_DOWN = "ManifestEditor.LibrarySection.down";
    public static final String POPUP_NEW_LIBRARY = "ManifestEditor.LibrarySection.newLibrary";
    public static final String POPUP_DELETE = "Actions.delete.label";
    public static final String NEW_LIBRARY_ENTRY = "ManifestEditor.LibrarySection.newLibraryEntry";
    private RenameAction renameAction;
    private TableViewer libraryTable;
    static /* synthetic */ Class class$org$eclipse$core$resources$IFile;

    public LibrarySection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{PDEPlugin.getResourceString(SECTION_NEW), PDEPlugin.getResourceString(SECTION_ADD), PDEPlugin.getResourceString(SECTION_UP), PDEPlugin.getResourceString(SECTION_DOWN)});
        this.getSection().setText(PDEPlugin.getResourceString(SECTION_TITLE));
        IPluginModelBase model = (IPluginModelBase)page.getPDEEditor().getAggregateModel();
        boolean fragment = model.isFragmentModel();
        if (fragment) {
            this.getSection().setDescription(PDEPlugin.getResourceString(SECTION_FDESC));
        } else {
            this.getSection().setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        }
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        IModel model = (IModel)this.getPage().getModel();
        tablePart.setEditable(model.isEditable());
        this.createViewerPartControl(container, 65536, 2, toolkit);
        this.libraryTable = tablePart.getTableViewer();
        this.libraryTable.setContentProvider((IContentProvider)new TableContentProvider());
        this.libraryTable.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        toolkit.paintBordersFor(container);
        tablePart.setButtonEnabled(2, false);
        tablePart.setButtonEnabled(3, false);
        section.setClient((Control)container);
        this.initialize();
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        if (this.getPage().getModel().isEditable()) {
            this.updateDirectionalButtons();
        }
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNew();
                break;
            }
            case 1: {
                this.handleAdd();
                break;
            }
            case 2: {
                this.handleUp();
                break;
            }
            case 3: {
                this.handleDown();
            }
        }
    }

    protected void entryModified(Object entry, String newValue) {
        Item item = (Item)entry;
        final IPluginLibrary library = (IPluginLibrary)item.getData();
        try {
            if (newValue.equals(library.getName())) {
                return;
            }
            library.setName(newValue);
            this.markDirty();
            this.commit(false);
            this.libraryTable.getTable().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    LibrarySection.this.libraryTable.update((Object)library, null);
                }
            });
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    public boolean setFormInput(Object object) {
        if (object instanceof IPluginLibrary) {
            this.libraryTable.setSelection((ISelection)new StructuredSelection(object), true);
            return true;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager manager) {
        IModel model = (IModel)this.getPage().getModel();
        ISelection selection = this.libraryTable.getSelection();
        Action newAction = new Action(PDEPlugin.getResourceString(POPUP_NEW_LIBRARY)){

            public void run() {
                LibrarySection.this.handleAdd();
            }
        };
        newAction.setEnabled(model.isEditable());
        manager.add((IAction)newAction);
        if (!selection.isEmpty()) {
            manager.add((IContributionItem)new Separator());
            this.renameAction = new RenameAction();
            this.renameAction.setEnabled(model.isEditable());
            manager.add((IAction)this.renameAction);
            Action deleteAction = new Action(PDEPlugin.getResourceString(POPUP_DELETE)){

                public void run() {
                    LibrarySection.this.handleDelete();
                }
            };
            deleteAction.setEnabled(model.isEditable());
            manager.add((IAction)deleteAction);
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void handleDelete() {
        Object object = ((IStructuredSelection)this.libraryTable.getSelection()).getFirstElement();
        if (object != null && object instanceof IPluginLibrary) {
            IPluginLibrary ep = (IPluginLibrary)object;
            IPluginBase plugin = ep.getPluginBase();
            try {
                plugin.remove(ep);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void handleDown() {
        Table table = this.getTablePart().getTableViewer().getTable();
        int index = table.getSelectionIndex();
        if (index == table.getItemCount() - 1) {
            return;
        }
        this.swap(index, index + 1);
    }

    private void handleUp() {
        int index = this.getTablePart().getTableViewer().getTable().getSelectionIndex();
        if (index < 1) {
            return;
        }
        this.swap(index, index - 1);
    }

    public void swap(int index1, int index2) {
        Table table = this.getTablePart().getTableViewer().getTable();
        IPluginLibrary l1 = (IPluginLibrary)table.getItem(index1).getData();
        IPluginLibrary l2 = (IPluginLibrary)table.getItem(index2).getData();
        try {
            IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
            IPluginBase pluginBase = model.getPluginBase();
            pluginBase.swap(l1, l2);
            this.refresh();
            this.updateDirectionalButtons();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleNew() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        NewRuntimeLibraryDialog dialog = new NewRuntimeLibraryDialog(this.getPage().getSite().getShell(), model.getPluginBase().getLibraries());
        dialog.create();
        dialog.getShell().setText(PDEPlugin.getResourceString(NEW_LIBRARY_ENTRY));
        SWTUtil.setDialogSize((Dialog)dialog, 250, 175);
        if (dialog.open() == 0) {
            String libName = dialog.getLibraryName();
            if (libName == null || libName.length() == 0) {
                return;
            }
            try {
                IPluginLibrary library = model.getPluginFactory().createLibrary();
                library.setName(libName);
                library.setExported(true);
                model.getPluginBase().add(library);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void handleAdd() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getPage().getSite().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        Class[] acceptedClasses = new Class[]{class$org$eclipse$core$resources$IFile == null ? (class$org$eclipse$core$resources$IFile = LibrarySection.class$("org.eclipse.core.resources.IFile")) : class$org$eclipse$core$resources$IFile};
        dialog.setValidator((ISelectionStatusValidator)new LibrarySelectionValidator(acceptedClasses, true));
        dialog.setTitle(PDEPlugin.getResourceString("BuildEditor.ClasspathSection.jarsTitle"));
        dialog.setMessage(PDEPlugin.getResourceString("LibrarySection.jarsMessage"));
        IPluginLibrary[] libraries = ((IPluginModelBase)this.getPage().getModel()).getPluginBase().getLibraries();
        HashSet<Path> set = new HashSet<Path>();
        for (int i = 0; i < libraries.length; ++i) {
            set.add(new Path(ClasspathUtilCore.expandLibraryName((String)libraries[i].getName())));
        }
        dialog.addFilter((ViewerFilter)new LibraryFilter(set));
        dialog.setInput((Object)((IModel)this.getPage().getModel()).getUnderlyingResource().getProject());
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
            for (int i = 0; i < elements.length; ++i) {
                IResource elem = (IResource)elements[i];
                IPath path = elem.getProjectRelativePath();
                if (elem instanceof IFolder) {
                    path = path.addTrailingSeparator();
                }
                IPluginLibrary library = model.getPluginFactory().createLibrary();
                try {
                    library.setName(path.toString());
                    library.setExported(true);
                    model.getPluginBase().add(library);
                    continue;
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        }
    }

    public void initialize() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        this.libraryTable.setInput((Object)model.getPluginBase());
        this.getTablePart().setButtonEnabled(0, model.isEditable());
        this.getTablePart().setButtonEnabled(1, model.isEditable());
        this.getTablePart().setButtonEnabled(2, false);
        this.getTablePart().setButtonEnabled(3, false);
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void refresh() {
        this.libraryTable.setSelection(null);
        this.libraryTable.refresh();
        super.refresh();
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.markStale();
            return;
        }
        Object changeObject = event.getChangedObjects()[0];
        if (changeObject instanceof IPluginLibrary) {
            if (event.getChangeType() == 1) {
                this.libraryTable.add(changeObject);
            } else if (event.getChangeType() == 2) {
                this.libraryTable.remove(changeObject);
            } else if (event.getChangedProperty() == null) {
                this.libraryTable.update(changeObject, null);
            }
        } else if (changeObject.equals(this.libraryTable.getInput())) {
            this.markStale();
        } else if (changeObject instanceof IPluginElement && ((IPluginElement)changeObject).getParent() instanceof IPluginLibrary) {
            this.libraryTable.update((Object)((IPluginElement)changeObject).getParent(), null);
        }
    }

    public void setFocus() {
        this.libraryTable.getTable().setFocus();
    }

    private void updateDirectionalButtons() {
        Table table = this.libraryTable.getTable();
        TableItem[] selection = table.getSelection();
        boolean hasSelection = selection.length > 0;
        boolean canMove = table.getItemCount() > 1;
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(2, canMove && hasSelection && table.getSelectionIndex() > 0);
        tablePart.setButtonEnabled(3, canMove && hasSelection && table.getSelectionIndex() < table.getItemCount() - 1);
    }

    protected void doPaste(Object target, Object[] objects) {
    }

    protected boolean canPaste(Object target, Object[] objects) {
        return objects[0] instanceof IPluginLibrary;
    }

    private void doRename() {
        TableViewer viewer = this.getTablePart().getTableViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        if (selection.size() == 1 && this.isEditable()) {
            Object obj = selection.getFirstElement();
            String oldName = "";
            if (obj instanceof IPluginLibrary) {
                oldName = ((IPluginLibrary)obj).getName();
            }
            IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
            IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
            String[] libNames = new String[libraries.length];
            for (int i = 0; i < libNames.length; ++i) {
                libNames[i] = libraries[i].getName();
            }
            RenameDialog dialog = new RenameDialog(this.getTablePart().getControl().getShell(), false, libNames, oldName);
            dialog.create();
            dialog.getShell().setText(PDEPlugin.getResourceString("EditableTablePart.renameTitle"));
            SWTUtil.setDialogSize((Dialog)dialog, 300, 150);
            if (dialog.open() == 0) {
                this.entryModified(this.doFindItem(obj), dialog.getNewName());
            }
        }
    }

    private Widget doFindItem(Object element) {
        TableItem[] children = this.getTablePart().getTableViewer().getTable().getItems();
        for (int i = 0; i < children.length; ++i) {
            TableItem item = children[i];
            Object data = item.getData();
            if (data == null || !data.equals(element)) continue;
            return item;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TableContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object parent) {
            IPluginModelBase model = (IPluginModelBase)LibrarySection.this.getPage().getModel();
            return model.getPluginBase().getLibraries();
        }
    }

    class LibrarySelectionValidator
    extends JarSelectionValidator {
        public LibrarySelectionValidator(Class[] acceptedTypes, boolean allowMultipleSelection) {
            super(acceptedTypes, allowMultipleSelection);
        }

        public boolean isValid(Object element) {
            if (element instanceof IFolder) {
                return true;
            }
            return super.isValid(element);
        }
    }

    class LibraryFilter
    extends JARFileFilter {
        public LibraryFilter(HashSet set) {
            super(set);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            if (element instanceof IFolder) {
                return this.isPathValid(((IFolder)element).getProjectRelativePath());
            }
            if (element instanceof IFile) {
                return this.isFileValid(((IFile)element).getProjectRelativePath());
            }
            return false;
        }
    }

    class RenameAction
    extends Action {
        public RenameAction() {
            super(PDEPlugin.getResourceString("EditableTablePart.renameAction"));
        }

        public void run() {
            LibrarySection.this.doRename();
        }
    }
}

