/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.AbstractRemoveActionDelegate;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;

public class RemoveBreakpointAction
extends AbstractRemoveActionDelegate {
    public void run(IAction action) {
        IStructuredSelection selection = this.getSelection();
        final Iterator itr = selection.iterator();
        final MultiStatus ms = new MultiStatus(DebugUIPlugin.getUniqueIdentifier(), 5012, ActionMessages.getString("RemoveBreakpointAction.Breakpoint(s)_removal_failed_3"), null);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                while (itr.hasNext()) {
                    try {
                        Object next = itr.next();
                        if (!(next instanceof IBreakpoint)) continue;
                        IBreakpoint breakpoint = (IBreakpoint)next;
                        breakpointManager.removeBreakpoint(breakpoint, true);
                    }
                    catch (CoreException ce) {
                        ms.merge(ce.getStatus());
                    }
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null, 0, null);
        }
        catch (CoreException ce) {
            ms.merge(ce.getStatus());
        }
        if (!ms.isOK()) {
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                DebugUIPlugin.errorDialog(window.getShell(), ActionMessages.getString("RemoveBreakpointAction.Removing_a_breakpoint_4"), ActionMessages.getString("RemoveBreakpointAction.Exceptions_occurred_attempting_to_remove_a_breakpoint._5"), (IStatus)ms);
            } else {
                DebugUIPlugin.log((IStatus)ms);
            }
        }
    }

    protected void doAction(Object element) {
    }
}

