/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.identicator;

import com.mchange.v1.identicator.IdHashKey;
import com.mchange.v1.identicator.Identicator;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

final class WeakIdHashKey
extends IdHashKey {
    Ref keyRef;
    int hash;

    public WeakIdHashKey(Object keyObj, Identicator id, ReferenceQueue rq) {
        super(id);
        if (keyObj == null) {
            throw new UnsupportedOperationException("Collection does not accept nulls!");
        }
        this.keyRef = new Ref(keyObj, rq);
        this.hash = id.hash(keyObj);
    }

    public Ref getInternalRef() {
        return this.keyRef;
    }

    public Object getKeyObj() {
        return this.keyRef.get();
    }

    public boolean equals(Object o) {
        if (o instanceof WeakIdHashKey) {
            WeakIdHashKey other = (WeakIdHashKey)o;
            if (this.keyRef == other.keyRef) {
                return true;
            }
            Object myKeyObj = this.keyRef.get();
            Object oKeyObj = other.keyRef.get();
            if (myKeyObj == null || oKeyObj == null) {
                return false;
            }
            return this.id.identical(myKeyObj, oKeyObj);
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    class Ref
    extends WeakReference {
        public Ref(Object referant, ReferenceQueue rq) {
            super(referant, rq);
        }

        WeakIdHashKey getKey() {
            return WeakIdHashKey.this;
        }
    }
}

