import java.io.*; import java.sql.*;

/*
 * Install.java
 *
 * Created on 16. Dezember 2005, 10:12
 */

/**
 *
 * This class is the installation routine. It requires InstallConnection.java.
 * The program sets up the data base and lets the user chose data base name,
 * user name and password.
 *
 * @author  Olle Nebendahl
 */
class Install
{
    
    public static void main(String[] args) throws Exception
    {
        BufferedReader in = new BufferedReader(new InputStreamReader( System.in ) );

        
        System.out.println("SlidePoolCMS4talks installation");
        System.out.println("");
        System.out.println("");
        System.out.println("requirements:");
        System.out.println("- mysql version 4.1.10 or greater (4.1.10 tested and recommmanded)");
        System.out.println("- properly installed jdbc-driver");
        System.out.println("- Java 1.5 (hopefully 1.4 wil work, too)");
        System.out.println("");
        System.out.println("");
        System.out.println("Please enter some data to access Your data base management system");
        System.out.println("NOTE: The following data will NOT be stored and");
        System.out.println("      will only used during installation process!");
        System.out.println("");
        System.out.println("Please enter Your data base management root name");
        System.out.println("or any other database user account with ");
        System.out.println("data base creation rights:");
        System.out.println("Leave blank for default \"root\"");
        String DBROOTUSER = in.readLine();
        if(DBROOTUSER.equals(""))DBROOTUSER="root";
        
        System.out.println("");
        System.out.println("Please enter Your data base management user \""+DBROOTUSER+"`s\" password:");
        //debug mode
        System.out.println("Leave blank for default \"\"");
        String DBROOTPWD = in.readLine();
        if(DBROOTPWD.equals(""))DBROOTPWD="";
        
        System.out.println("");
        System.out.println("");
        System.out.println("In the following you have to provide some preferences");
        System.out.println("to complete Your installation.");
        System.out.println("NOTE: The following data will be stored in the file");
        System.out.println("      SlidePool.ini. They will be encrypted and ");
        System.out.println("      look like ujD'ÈmwF .");
        System.out.println("");
        System.out.println("Please enter Your database driver for java`s name:");
        System.out.println("Enter blank for default \"org.gjt.mm.mysql.Driver\"");//
        String DBDriverName = in.readLine();
        if(DBDriverName.equals(""))DBDriverName="org.gjt.mm.mysql.Driver";

        System.out.println("Please enter Your database management location:");
        System.out.println("Enter blank for default \"jdbc:mysql://localhost:3306/\"");
        String DBMS = in.readLine();
        if(DBMS.equals(""))DBMS="jdbc:mysql://localhost:3306/";
        
        System.out.println("Please enter Your preferred database name for CMS4talks:");
        System.out.println("Enter blank for default \"cms4talks\"");
        String DBName = in.readLine();
        if(DBName.equals(""))DBName="cms4talks";

        System.out.println("Please enter Your preferred user name for SlidePool:");
        System.out.println("Enter blank for default \"cms4talksuser\"");
        String DBUser = in.readLine();
        if(DBUser.equals(""))DBUser="cms4talksuser";

        System.out.println("Please enter Your preferred user password for user \""+DBUser+"\":");
        System.out.println("Enter blank for default \"highscreen\"");
        String DBUserPwd = in.readLine();
        if(DBUserPwd.equals(""))DBUserPwd="highscreen";
                
        System.out.println("");                
        System.out.print("conncting to "+DBMS+".");        
        InstallConnection installConnection=InstallConnection.tryConnection(DBDriverName,DBMS,DBROOTUSER,DBROOTPWD);
        
        if(null==installConnection)
        {
            System.out.println("Error during first connect to database.");
            return;
        }

        
        System.out.println("..success");                
        System.out.print("creating user '"+DBUser+"' .");        
        
        installConnection.doSqlUpdate("GRANT all privileges on "+DBName+
                                      ".* to "+DBUser+"@localhost identified by '"+DBUserPwd+
                                      "';");
        System.out.print(".");        
                                      
        installConnection.doSqlUpdate("GRANT all privileges on "+DBName+
                                      ".* to "+DBUser+"@\"%\" identified by '"+DBUserPwd+
                                      "';");
        System.out.print(".");        
        
        installConnection.doSqlUpdate("flush privileges;");
        
        System.out.println("success");               
        System.out.print("reconncting to "+DBMS+" using user '"+DBUser+"'.");        
        
        installConnection=null;
        
        installConnection=InstallConnection.tryConnection(DBDriverName,DBMS,DBUser,DBUserPwd);

        if(null==installConnection)
        {
            System.out.println("Error during second connect to database");
            return;
        }

        System.out.println("..success");               

        System.out.print("creating database '"+DBName+"'.");        
        installConnection.doSqlUpdate("create database "+DBName+";");
        System.out.println("..success");               
        System.out.print("using database '"+DBName+"'.");        
        installConnection.doSqlUpdate("use "+DBName+";");
        System.out.println("..success");  
        
                     
        System.out.print("setting up database '"+DBName+"'.");        
        installConnection.doSqlUpdate(FOS.readFromFile("setupdatabase.ddl"));
        System.out.println("..success");                       
        
        if(installConnection==null)
        {
          System.out.println("The data You provided were wrong or Your system is malconfigured.");
          System.out.println("Installation was not successfull and is now being aborted.");
          java.lang.System.exit(1);
        };
        
        DES.writeDEStoFile("SlidePool.ini",DBDriverName+"\n"+DBMS+"\n"+DBName+"\n"+DBUser+"\n"+DBUserPwd);
        System.out.println("");  
        System.out.println("");  
        System.out.println("Congratulations! Everything is set up properly.");  


    }
}
