changecom(`//')
%// M4 preprocessor include file for natural compounds
%// 17-JAN-2000 IK	change opening comment marker

%// TERPEN_(`bond list for ring', `C2 chain') 
%// stored points: 1: C1,2: C8, 3: C3
define(`TERPEN_',
       `ring(,,$1)
	{ 3: saveXY(#1);
	  5: saveXY(#3);
	  ifelse($2,`', `', `4: $2;')
	  0: bond(-90) saveXY(#2)
	     bond(-150) restoreXY(#2) bond(-30);
	}')


%// ANTHRACHEN_(`C9', `C10', `bond list for A', `bond list for B') 
%// stored points: 1: C3, 2: C6
define(`ANTHRACEN_',
       `ring(,,H){
          vertex(,1,4,ifelse($3,`',`H0=2=4=',`$3')){ 1: saveXY(#1); };
          vertex(,4,1,ifelse($4,`',`H0=2=4=',`$4')){ 5: saveXY(#2); };
	  ifelse($1,`',`',`3: $1;')
	  ifelse($2,`',`',`0: $2;')
	}')


%// ANTHRAQUINONE_(`1' ... hydroxy on C1, C2, C4) 
%// stored points: 1: C1, 2: C2, 4: C4
define(`ANTHRAQUINONE_',
       `ring(,,H1=4=)
	{ 
	  vertex(,1,4,H0=2=){};
	  vertex(,4,1,H3=5=){
            ifelse($1, `', `3: saveXY(#1);', `3: bond(r) atom("O",C,R) atom("H",L);')
            ifelse($2, `', `4: saveXY(#2);', `4: bond(r) atom("O",C,R) atom("H",L);')
            ifelse($3, `', `0: saveXY(#4);', `0: bond(r) atom("O",C,R) atom("H",L);')
	  };
	  0: bond(r,=C) atom("O");
	  3: bond(r,=C) atom("O");
	}')


%// FLAVAN_('1'=4-oxo, '1'=delta(1,2),
%//    `1' .. hydroxy on C5, C7, C3', C4', C5', C3) 
%// stored points: 3: C5, 4: C7, 5: C3', 6: C4', 7: C5', 8: C3
define(`FLAVAN_',
	`ring(,,H){
	  vertex(,1,4,H0=2=4=){
            ifelse($3, `', `0: saveXY(#3);', `0: bond(r) atom("O",C,R) atom("H",L);')
            ifelse($4, `', `2: saveXY(#4);', `2: bond(r) atom("O",C,L) atom("H",R);')
	  };
	  ifelse($1, `', `', `0: bond(r,=C) atom("O");')
	  ifelse($2, `', `', `4: bond(v(4),=); ')
          ifelse($8, `', `5: saveXY(#8);', `5: bond(r) atom("O",C,R) atom("H",L);')
	  3: atom("O");
	  4: bond(r) ring(,1,H0=2=4=,,,r){
            ifelse($5, `', `3: saveXY(#5);', `3: bond(r) atom("O",C,R) atom("H",L);')
            ifelse($6, `', `4: saveXY(#6);', `4: bond(r) atom("O",C,R) atom("H",L);')
            ifelse($7, `', `5: saveXY(#7);', `5: bond(r) atom("O",C,R) atom("H",L);')
		};
	}
	')


%// STEROID_(`bond list for A',`cholane')
%// stored points: 1: C3, 2: C10, 3: C13, 4: C5, 5: C14, 6: C17
%// 7: C11
define(`STEROID_',
       `saveXY(#2)
	ring(,4,$1){1: saveXY(#1);
		    5: saveXY(#4); }
	ring(,2,H){3: ring(,1,H)
		      { 4: ring("cpentane",2,H)
			   { 3: saveXY(#6);
			     ifelse($2,`pregnane',
			       `3: bond(30;-30);')
			     ifelse($2,`cholane',
			       `3: bond(30) branch{bond(90);}
				   bond(-30;30;-30);')
			     ifelse($2,`cholestane',
			       `3: bond(30) branch{bond(90);}
				   bond(-30;30;-30;30)
				   branch{bond(90);} bond(-30);')
			     ifelse($2,`ergostane',
			       `3: bond(30) branch{bond(90);}
				   bond(-30;30;-30)
				   branch{bond(-90);} bond(30)
				   branch{bond(90);} bond(-30);')
			   };
			2: saveXY(#7);
			4: saveXY(#3);
			5: saveXY(#5);
		      };
		  }
       ifelse($2,`estrane',`restoreXY(#3) bond(90,<<) ')
       ifelse($2,`androstane',
		 `restoreXY(#2) bond(90,<<) restoreXY(#3) bond(90,<<) ')
       ')

%// two isopren units (C5) 
%// ISOPREN_(<bond_len0>)
%// ISOPREN1_(<bond_len0>, <bondtype>)
define(`ISOPREN_', 
       `bond(r,,$1; r/,=; r)
	branch{ bond(rt); } bond(r/,=) ')
define(`ISOPREN1_', 
       `bond(r/,=) branch{ bond(r/t); }
	bond(r) ifelse($2,`', `bond(r/,=)', `bond(r/,$2)') 
	bond(r,,$1) ')

%// text formula for amino acids H2N-CH-COOH
%// AA_(H,,<side chain>) AA_(,OH,<side chain>)
define(`AA_', 
       ` ifelse($1,`H', `atom("H$_2$N",L,R) ', 
		   `$1 atom("NH",L,R) ') 
	bond(0) branch{bond(-90) $3;} 
	atom("C",C,R) atom("H",L,C) bond(0)
	atom("CO",L,R)
	ifelse($2,`OH', `atom("OH",L) ', $2 ) ')

define(`AA3D_', 
       ` ifelse($1,`H', `atom("H$_2$N",L,R) ', 
		   `$1 atom("NH",L,R) ') 
	 bond(-30) branch{bond(-120,<<) $3;bond(-30,<.) atom("H");} 
	 bond(30) branch{bond(90,=C) atom("O");} bond(0)
	 ifelse($2,`OH', `bond(-30) atom("OH",L) ', $2 ) ')
