/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.TopologyMember;

public class BackwardsCompatibilityUtils {
    private static int INITIAL_ACTIVEMQ_INCREMENTING_VERSION = 126;
    public static final String SSL_ENABLED_PROP_NAME = "ssl-enabled";
    public static final String HTTP_ENABLED_PROP_NAME = "http-enabled";
    public static final String HTTP_CLIENT_IDLE_PROP_NAME = "http-client-idle-time";
    public static final String HTTP_CLIENT_IDLE_SCAN_PERIOD = "http-client-idle-scan-period";
    public static final String HTTP_RESPONSE_TIME_PROP_NAME = "http-response-time";
    public static final String HTTP_SERVER_SCAN_PERIOD_PROP_NAME = "http-server-scan-period";
    public static final String HTTP_REQUIRES_SESSION_ID = "http-requires-session-id";
    public static final String USE_SERVLET_PROP_NAME = "use-servlet";
    public static final String SERVLET_PATH = "servlet-path";
    public static final String USE_NIO_PROP_NAME = "use-nio";
    public static final String USE_NIO_GLOBAL_WORKER_POOL_PROP_NAME = "use-nio-global-worker-pool";
    public static final String USE_INVM_PROP_NAME = "use-invm";
    public static final String PROTOCOL_PROP_NAME = "protocol";
    public static final String HOST_PROP_NAME = "host";
    public static final String PORT_PROP_NAME = "port";
    public static final String LOCAL_ADDRESS_PROP_NAME = "local-address";
    public static final String LOCAL_PORT_PROP_NAME = "local-port";
    public static final String KEYSTORE_PROVIDER_PROP_NAME = "key-store-provider";
    public static final String KEYSTORE_PATH_PROP_NAME = "key-store-path";
    public static final String KEYSTORE_PASSWORD_PROP_NAME = "key-store-password";
    public static final String TRUSTSTORE_PROVIDER_PROP_NAME = "trust-store-provider";
    public static final String TRUSTSTORE_PATH_PROP_NAME = "trust-store-path";
    public static final String TRUSTSTORE_PASSWORD_PROP_NAME = "trust-store-password";
    public static final String NEED_CLIENT_AUTH_PROP_NAME = "need-client-auth";
    public static final String BACKLOG_PROP_NAME = "backlog";
    public static final String TCP_NODELAY_PROPNAME = "tcp-no-delay";
    public static final String TCP_SENDBUFFER_SIZE_PROPNAME = "tcp-send-buffer-size";
    public static final String TCP_RECEIVEBUFFER_SIZE_PROPNAME = "tcp-receive-buffer-size";
    public static final String NIO_REMOTING_THREADS_PROPNAME = "nio-remoting-threads";
    public static final String BATCH_DELAY = "batch-delay";
    public static final String DIRECT_DELIVER = "direct-deliver";
    public static final String CLUSTER_CONNECTION = "cluster-connection";
    public static final String STOMP_CONSUMERS_CREDIT = "stomp-consumer-credits";
    public static final Map<String, String> OLD_PARAMETERS_MAP = new HashMap<String, String>();

    public static String convertParameter(String name) {
        String oldParameter = OLD_PARAMETERS_MAP.get(name);
        if (oldParameter != null) {
            return oldParameter;
        }
        return name;
    }

    public static Pair<TransportConfiguration, TransportConfiguration> checkTCPPairConversion(int clientIncrementingVersion, TopologyMember member) {
        if (clientIncrementingVersion < INITIAL_ACTIVEMQ_INCREMENTING_VERSION) {
            return new Pair((Object)BackwardsCompatibilityUtils.convertTransport(member.getLive()), (Object)BackwardsCompatibilityUtils.convertTransport(member.getBackup()));
        }
        return new Pair((Object)member.getLive(), (Object)member.getBackup());
    }

    private static TransportConfiguration convertTransport(TransportConfiguration tc) {
        if (tc != null) {
            String className = tc.getFactoryClassName().replace("org.apache.activemq.artemis", "org.hornetq").replace("ActiveMQ", "HornetQ");
            return new TransportConfiguration(className, BackwardsCompatibilityUtils.convertParameters(tc.getParams()), tc.getName());
        }
        return tc;
    }

    private static Map<String, Object> convertParameters(Map<String, Object> params) {
        if (params == null) {
            return null;
        }
        HashMap<String, Object> convertedParams = new HashMap<String, Object>(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            convertedParams.put(BackwardsCompatibilityUtils.convertParameter(entry.getKey()), entry.getValue());
        }
        return convertedParams;
    }

    static {
        OLD_PARAMETERS_MAP.put("sslEnabled", SSL_ENABLED_PROP_NAME);
        OLD_PARAMETERS_MAP.put("httpEnabled", HTTP_ENABLED_PROP_NAME);
        OLD_PARAMETERS_MAP.put("httpClientIdleTime", HTTP_CLIENT_IDLE_PROP_NAME);
        OLD_PARAMETERS_MAP.put("httpClientIdleScanPeriod", HTTP_CLIENT_IDLE_SCAN_PERIOD);
        OLD_PARAMETERS_MAP.put("httpResponseTime", HTTP_RESPONSE_TIME_PROP_NAME);
        OLD_PARAMETERS_MAP.put("httpServerScanPeriod", HTTP_SERVER_SCAN_PERIOD_PROP_NAME);
        OLD_PARAMETERS_MAP.put("httpRequiresSessionId", HTTP_REQUIRES_SESSION_ID);
        OLD_PARAMETERS_MAP.put("useServlet", USE_SERVLET_PROP_NAME);
        OLD_PARAMETERS_MAP.put("servletPath", SERVLET_PATH);
        OLD_PARAMETERS_MAP.put("useNio", USE_NIO_PROP_NAME);
        OLD_PARAMETERS_MAP.put("useNioGlobalWorkerPool", USE_NIO_GLOBAL_WORKER_POOL_PROP_NAME);
        OLD_PARAMETERS_MAP.put("useInvm", USE_INVM_PROP_NAME);
        OLD_PARAMETERS_MAP.put(PROTOCOL_PROP_NAME, PROTOCOL_PROP_NAME);
        OLD_PARAMETERS_MAP.put(HOST_PROP_NAME, HOST_PROP_NAME);
        OLD_PARAMETERS_MAP.put(PORT_PROP_NAME, PORT_PROP_NAME);
        OLD_PARAMETERS_MAP.put("localAddress", LOCAL_ADDRESS_PROP_NAME);
        OLD_PARAMETERS_MAP.put("localPort", LOCAL_PORT_PROP_NAME);
        OLD_PARAMETERS_MAP.put("keyStoreProvider", KEYSTORE_PROVIDER_PROP_NAME);
        OLD_PARAMETERS_MAP.put("keyStorePath", KEYSTORE_PATH_PROP_NAME);
        OLD_PARAMETERS_MAP.put("keyStorePassword", KEYSTORE_PASSWORD_PROP_NAME);
        OLD_PARAMETERS_MAP.put("trustStoreProvider", TRUSTSTORE_PROVIDER_PROP_NAME);
        OLD_PARAMETERS_MAP.put("trustStorePath", TRUSTSTORE_PATH_PROP_NAME);
        OLD_PARAMETERS_MAP.put("trustStorePassword", TRUSTSTORE_PASSWORD_PROP_NAME);
        OLD_PARAMETERS_MAP.put("needClientAuth", NEED_CLIENT_AUTH_PROP_NAME);
        OLD_PARAMETERS_MAP.put(BACKLOG_PROP_NAME, BACKLOG_PROP_NAME);
        OLD_PARAMETERS_MAP.put("tcpNoDelay", TCP_NODELAY_PROPNAME);
        OLD_PARAMETERS_MAP.put("tcpSendBufferSize", TCP_SENDBUFFER_SIZE_PROPNAME);
        OLD_PARAMETERS_MAP.put("tcpReceiveBufferSize", TCP_RECEIVEBUFFER_SIZE_PROPNAME);
        OLD_PARAMETERS_MAP.put("nioRemotingThreads", NIO_REMOTING_THREADS_PROPNAME);
        OLD_PARAMETERS_MAP.put("batchDelay", BATCH_DELAY);
        OLD_PARAMETERS_MAP.put("directDeliver", DIRECT_DELIVER);
        OLD_PARAMETERS_MAP.put("clusterConnection", CLUSTER_CONNECTION);
        OLD_PARAMETERS_MAP.put("stompConsumerCredits", STOMP_CONSUMERS_CREDIT);
    }
}

