/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.JMSRuntimeException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import org.apache.qpid.jms.JmsMessageProducer;
import org.apache.qpid.jms.JmsSession;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.message.JmsMessagePropertySupport;
import org.apache.qpid.jms.message.JmsMessageTransformation;

public class JmsProducer
implements JMSProducer {
    private final JmsSession session;
    private final JmsMessageProducer producer;
    private CompletionListener completionListener;
    private String correlationId;
    private String type;
    private Destination replyTo;
    private byte[] correlationIdBytes;
    private long deliveryDelay = 0L;
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    private boolean disableMessageId;
    private boolean disableTimestamp;
    private final Map<String, Object> messageProperties = new HashMap<String, Object>();

    public JmsProducer(JmsSession session, JmsMessageProducer producer) {
        this.session = session;
        this.producer = producer;
    }

    public JMSProducer send(Destination destination, Message message) {
        try {
            this.doSend(destination, message);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
        return this;
    }

    public JMSProducer send(Destination destination, byte[] body) {
        try {
            BytesMessage message = this.session.createBytesMessage();
            message.writeBytes(body);
            this.doSend(destination, (Message)message);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
        return this;
    }

    public JMSProducer send(Destination destination, Map<String, Object> body) {
        try {
            MapMessage message = this.session.createMapMessage();
            for (Map.Entry<String, Object> entry : body.entrySet()) {
                message.setObject(entry.getKey(), entry.getValue());
            }
            this.doSend(destination, (Message)message);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
        return this;
    }

    public JMSProducer send(Destination destination, Serializable body) {
        try {
            ObjectMessage message = this.session.createObjectMessage();
            message.setObject(body);
            this.doSend(destination, (Message)message);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
        return this;
    }

    public JMSProducer send(Destination destination, String body) {
        try {
            TextMessage message = this.session.createTextMessage(body);
            this.doSend(destination, (Message)message);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
        return this;
    }

    private void doSend(Destination destination, Message message) throws JMSException {
        if (message == null) {
            throw new MessageFormatException("Message must not be null");
        }
        for (Map.Entry<String, Object> entry : this.messageProperties.entrySet()) {
            message.setObjectProperty(entry.getKey(), entry.getValue());
        }
        if (this.correlationId != null) {
            message.setJMSCorrelationID(this.correlationId);
        }
        if (this.correlationIdBytes != null) {
            message.setJMSCorrelationIDAsBytes(this.correlationIdBytes);
        }
        if (this.type != null) {
            message.setJMSType(this.type);
        }
        if (this.replyTo != null) {
            message.setJMSReplyTo(this.replyTo);
        }
        this.session.send(this.producer, destination, message, this.deliveryMode, this.priority, this.timeToLive, this.disableMessageId, this.disableTimestamp, this.deliveryDelay, this.completionListener);
    }

    public JMSProducer clearProperties() {
        this.messageProperties.clear();
        return this;
    }

    public Set<String> getPropertyNames() {
        return new HashSet<String>(this.messageProperties.keySet());
    }

    public boolean propertyExists(String name) {
        return this.messageProperties.containsKey(name);
    }

    public boolean getBooleanProperty(String name) {
        try {
            return JmsMessagePropertySupport.convertPropertyTo(name, this.messageProperties.get(name), Boolean.class);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public byte getByteProperty(String name) {
        try {
            return JmsMessagePropertySupport.convertPropertyTo(name, this.messageProperties.get(name), Byte.class);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public double getDoubleProperty(String name) {
        try {
            return JmsMessagePropertySupport.convertPropertyTo(name, this.messageProperties.get(name), Double.class);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public float getFloatProperty(String name) {
        try {
            return JmsMessagePropertySupport.convertPropertyTo(name, this.messageProperties.get(name), Float.class).floatValue();
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public int getIntProperty(String name) {
        try {
            return JmsMessagePropertySupport.convertPropertyTo(name, this.messageProperties.get(name), Integer.class);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public long getLongProperty(String name) {
        try {
            return JmsMessagePropertySupport.convertPropertyTo(name, this.messageProperties.get(name), Long.class);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public Object getObjectProperty(String name) {
        return this.messageProperties.get(name);
    }

    public short getShortProperty(String name) {
        try {
            return JmsMessagePropertySupport.convertPropertyTo(name, this.messageProperties.get(name), Short.class);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public String getStringProperty(String name) {
        try {
            return JmsMessagePropertySupport.convertPropertyTo(name, this.messageProperties.get(name), String.class);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public JMSProducer setProperty(String name, boolean value) {
        return this.setObjectProperty(name, value);
    }

    public JMSProducer setProperty(String name, byte value) {
        return this.setObjectProperty(name, value);
    }

    public JMSProducer setProperty(String name, double value) {
        return this.setObjectProperty(name, value);
    }

    public JMSProducer setProperty(String name, float value) {
        return this.setObjectProperty(name, Float.valueOf(value));
    }

    public JMSProducer setProperty(String name, int value) {
        return this.setObjectProperty(name, value);
    }

    public JMSProducer setProperty(String name, long value) {
        return this.setObjectProperty(name, value);
    }

    public JMSProducer setProperty(String name, Object value) {
        return this.setObjectProperty(name, value);
    }

    public JMSProducer setProperty(String name, short value) {
        return this.setObjectProperty(name, value);
    }

    public JMSProducer setProperty(String name, String value) {
        return this.setObjectProperty(name, value);
    }

    public String getJMSCorrelationID() {
        return this.correlationId;
    }

    public JMSProducer setJMSCorrelationID(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return this.correlationIdBytes;
    }

    public JMSProducer setJMSCorrelationIDAsBytes(byte[] correlationIdBytes) {
        this.correlationIdBytes = correlationIdBytes;
        return this;
    }

    public Destination getJMSReplyTo() {
        return this.replyTo;
    }

    public JMSProducer setJMSReplyTo(Destination replyTo) {
        try {
            this.replyTo = JmsMessageTransformation.transformDestination(this.session.getConnection(), replyTo);
        }
        catch (JMSException e) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)e));
        }
        return this;
    }

    public String getJMSType() {
        return this.type;
    }

    public JMSProducer setJMSType(String type) {
        this.type = type;
        return this;
    }

    public CompletionListener getAsync() {
        return this.completionListener;
    }

    public JMSProducer setAsync(CompletionListener completionListener) {
        this.completionListener = completionListener;
        return this;
    }

    public long getDeliveryDelay() {
        return this.deliveryDelay;
    }

    public JMSProducer setDeliveryDelay(long deliveryDelay) {
        this.deliveryDelay = deliveryDelay;
        return this;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public JMSProducer setDeliveryMode(int deliveryMode) {
        switch (deliveryMode) {
            case 1: 
            case 2: {
                this.deliveryMode = deliveryMode;
                return this;
            }
        }
        throw new JMSRuntimeException(String.format("Invalid DeliveryMode specified: %d", deliveryMode));
    }

    public boolean getDisableMessageID() {
        return this.disableMessageId;
    }

    public JMSProducer setDisableMessageID(boolean disableMessageId) {
        this.disableMessageId = disableMessageId;
        return this;
    }

    public boolean getDisableMessageTimestamp() {
        return this.disableTimestamp;
    }

    public JMSProducer setDisableMessageTimestamp(boolean disableTimestamp) {
        this.disableTimestamp = disableTimestamp;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public JMSProducer setPriority(int priority) {
        if (priority < 0 || priority > 9) {
            throw new JMSRuntimeException(String.format("Priority value given {%d} is out of range (0..9)", priority));
        }
        this.priority = priority;
        return this;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public JMSProducer setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    private JMSProducer setObjectProperty(String name, Object value) {
        try {
            JmsMessagePropertySupport.checkPropertyNameIsValid(name, this.session.getConnection().isValidatePropertyNames());
            JmsMessagePropertySupport.checkValidObject(value);
            this.messageProperties.put(name, value);
            return this;
        }
        catch (JMSException e) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)e));
        }
    }
}

