/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.protocol.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;

public class WebSocketFrameEncoder
extends ChannelOutboundHandlerAdapter {
    private int maxFramePayloadLength;

    public WebSocketFrameEncoder(int maxFramePayloadLength) {
        this.maxFramePayloadLength = maxFramePayloadLength;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            this.writeContinuationFrame(ctx, (ByteBuf)msg, promise);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    private void writeContinuationFrame(ChannelHandlerContext ctx, ByteBuf byteBuf, ChannelPromise promise) {
        int count = byteBuf.readableBytes();
        int length = Math.min(count, this.maxFramePayloadLength);
        boolean finalFragment = length == count;
        ByteBuf fragment = Unpooled.buffer((int)length);
        byteBuf.readBytes(fragment, length);
        ctx.writeAndFlush((Object)new BinaryWebSocketFrame(finalFragment, 0, fragment), promise);
        while ((count = byteBuf.readableBytes()) > 0) {
            length = Math.min(count, this.maxFramePayloadLength);
            finalFragment = length == count;
            fragment = Unpooled.buffer((int)length);
            byteBuf.readBytes(fragment, length);
            ctx.writeAndFlush((Object)new ContinuationWebSocketFrame(finalFragment, 0, fragment), promise);
        }
    }
}

