/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json.gson;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.json.gson.GsonXMLStreamReader;
import org.apache.axis2.json.gson.rpc.JsonInOnlyRPCMessageReceiver;
import org.apache.axis2.json.gson.rpc.JsonRpcMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JSONMessageHandler
extends AbstractHandler {
    Log log = LogFactory.getLog(JSONMessageHandler.class);

    /*
     * Enabled aggressive block sorting
     */
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        AxisOperation axisOperation = msgContext.getAxisOperation();
        if (axisOperation == null) {
            this.log.debug((Object)"Axis operation is null, message hasn't been dispatched to operation, ignore it");
            return Handler.InvocationResponse.CONTINUE;
        }
        this.log.debug((Object)"Axis operation has been found from the MessageContext, proceeding with the JSON request");
        MessageReceiver messageReceiver = axisOperation.getMessageReceiver();
        if (messageReceiver instanceof JsonRpcMessageReceiver) return Handler.InvocationResponse.CONTINUE;
        if (messageReceiver instanceof JsonInOnlyRPCMessageReceiver) {
            return Handler.InvocationResponse.CONTINUE;
        }
        this.log.debug((Object)"JSON MessageReceiver found, proceeding with the JSON request");
        Object tempObj = msgContext.getProperty("isJsonStream");
        if (tempObj == null) return Handler.InvocationResponse.CONTINUE;
        this.log.debug((Object)"JSON MessageReceiver found JSON stream, proceeding with the JSON request");
        boolean isJSON = Boolean.valueOf(tempObj.toString());
        Object o = msgContext.getProperty("GsonXMLStreamReader");
        if (o != null) {
            GsonXMLStreamReader gsonXMLStreamReader = (GsonXMLStreamReader)o;
            QName elementQname = msgContext.getAxisOperation().getMessage("In").getElementQName();
            ArrayList schemas = msgContext.getAxisService().getSchema();
            gsonXMLStreamReader.initXmlStreamReader(elementQname, schemas, msgContext.getConfigurationContext());
            OMXMLParserWrapper stAXOMBuilder = OMXMLBuilderFactory.createStAXOMBuilder((XMLStreamReader)gsonXMLStreamReader);
            OMElement omElement = stAXOMBuilder.getDocumentElement();
            this.log.debug((Object)("GsonXMLStreamReader found elementQname: " + elementQname));
            msgContext.getEnvelope().getBody().addChild((OMNode)omElement);
            return Handler.InvocationResponse.CONTINUE;
        }
        this.log.error((Object)"GsonXMLStreamReader is null");
        throw new AxisFault("GsonXMLStreamReader should not be null");
    }
}

