/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.tree;

import java.util.Iterator;
import org.openjdk.source.tree.MemberReferenceTree;
import org.openjdk.source.tree.ModuleTree;
import org.openjdk.tools.javac.code.Attribute;
import org.openjdk.tools.javac.code.BoundKind;
import org.openjdk.tools.javac.code.Kinds;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Symtab;
import org.openjdk.tools.javac.code.Type;
import org.openjdk.tools.javac.code.TypeTag;
import org.openjdk.tools.javac.code.Types;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javac.util.ListBuffer;
import org.openjdk.tools.javac.util.Name;
import org.openjdk.tools.javac.util.Names;
import org.openjdk.tools.javac.util.Pair;

public class TreeMaker
implements JCTree.Factory {
    protected static final Context.Key<TreeMaker> treeMakerKey = new Context.Key();
    public int pos = -1;
    public JCTree.JCCompilationUnit toplevel;
    Names names;
    Types types;
    Symtab syms;
    AnnotationBuilder annotationBuilder = new AnnotationBuilder();

    public static TreeMaker instance(Context context) {
        TreeMaker treeMaker = context.get(treeMakerKey);
        if (treeMaker == null) {
            treeMaker = new TreeMaker(context);
        }
        return treeMaker;
    }

    protected TreeMaker(Context context) {
        context.put(treeMakerKey, this);
        this.pos = -1;
        this.toplevel = null;
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
    }

    protected TreeMaker(JCTree.JCCompilationUnit jCCompilationUnit, Names names, Types types, Symtab symtab) {
        this.pos = 0;
        this.toplevel = jCCompilationUnit;
        this.names = names;
        this.types = types;
        this.syms = symtab;
    }

    public TreeMaker forToplevel(JCTree.JCCompilationUnit jCCompilationUnit) {
        return new TreeMaker(jCCompilationUnit, this.names, this.types, this.syms);
    }

    public TreeMaker at(int n) {
        this.pos = n;
        return this;
    }

    public TreeMaker at(JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        this.pos = diagnosticPosition == null ? -1 : diagnosticPosition.getStartPosition();
        return this;
    }

    @Override
    public JCTree.JCCompilationUnit TopLevel(List<JCTree> list) {
        for (JCTree jCTree : list) {
            Assert.check(jCTree instanceof JCTree.JCClassDecl || jCTree instanceof JCTree.JCPackageDecl || jCTree instanceof JCTree.JCImport || jCTree instanceof JCTree.JCModuleDecl || jCTree instanceof JCTree.JCSkip || jCTree instanceof JCTree.JCErroneous || jCTree instanceof JCTree.JCExpressionStatement && ((JCTree.JCExpressionStatement)jCTree).expr instanceof JCTree.JCErroneous, () -> jCTree.getClass().getSimpleName());
        }
        JCTree.JCCompilationUnit jCCompilationUnit = new JCTree.JCCompilationUnit(list);
        jCCompilationUnit.pos = this.pos;
        return jCCompilationUnit;
    }

    @Override
    public JCTree.JCPackageDecl PackageDecl(List<JCTree.JCAnnotation> list, JCTree.JCExpression jCExpression) {
        Assert.checkNonNull(list);
        Assert.checkNonNull(jCExpression);
        JCTree.JCPackageDecl jCPackageDecl = new JCTree.JCPackageDecl(list, jCExpression);
        jCPackageDecl.pos = this.pos;
        return jCPackageDecl;
    }

    @Override
    public JCTree.JCImport Import(JCTree jCTree, boolean bl) {
        JCTree.JCImport jCImport = new JCTree.JCImport(jCTree, bl);
        jCImport.pos = this.pos;
        return jCImport;
    }

    @Override
    public JCTree.JCClassDecl ClassDef(JCTree.JCModifiers jCModifiers, Name name, List<JCTree.JCTypeParameter> list, JCTree.JCExpression jCExpression, List<JCTree.JCExpression> list2, List<JCTree> list3) {
        JCTree.JCClassDecl jCClassDecl = new JCTree.JCClassDecl(jCModifiers, name, list, jCExpression, list2, list3, null);
        jCClassDecl.pos = this.pos;
        return jCClassDecl;
    }

    public JCTree.JCMethodDecl MethodDef(JCTree.JCModifiers jCModifiers, Name name, JCTree.JCExpression jCExpression, List<JCTree.JCTypeParameter> list, List<JCTree.JCVariableDecl> list2, List<JCTree.JCExpression> list3, JCTree.JCBlock jCBlock, JCTree.JCExpression jCExpression2) {
        return this.MethodDef(jCModifiers, name, jCExpression, list, null, list2, list3, jCBlock, jCExpression2);
    }

    @Override
    public JCTree.JCMethodDecl MethodDef(JCTree.JCModifiers jCModifiers, Name name, JCTree.JCExpression jCExpression, List<JCTree.JCTypeParameter> list, JCTree.JCVariableDecl jCVariableDecl, List<JCTree.JCVariableDecl> list2, List<JCTree.JCExpression> list3, JCTree.JCBlock jCBlock, JCTree.JCExpression jCExpression2) {
        JCTree.JCMethodDecl jCMethodDecl = new JCTree.JCMethodDecl(jCModifiers, name, jCExpression, list, jCVariableDecl, list2, list3, jCBlock, jCExpression2, null);
        jCMethodDecl.pos = this.pos;
        return jCMethodDecl;
    }

    @Override
    public JCTree.JCVariableDecl VarDef(JCTree.JCModifiers jCModifiers, Name name, JCTree.JCExpression jCExpression, JCTree.JCExpression jCExpression2) {
        JCTree.JCVariableDecl jCVariableDecl = new JCTree.JCVariableDecl(jCModifiers, name, jCExpression, jCExpression2, null);
        jCVariableDecl.pos = this.pos;
        return jCVariableDecl;
    }

    public JCTree.JCVariableDecl ReceiverVarDef(JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression, JCTree.JCExpression jCExpression2) {
        JCTree.JCVariableDecl jCVariableDecl = new JCTree.JCVariableDecl(jCModifiers, jCExpression, jCExpression2);
        jCVariableDecl.pos = this.pos;
        return jCVariableDecl;
    }

    @Override
    public JCTree.JCSkip Skip() {
        JCTree.JCSkip jCSkip = new JCTree.JCSkip();
        jCSkip.pos = this.pos;
        return jCSkip;
    }

    @Override
    public JCTree.JCBlock Block(long l, List<JCTree.JCStatement> list) {
        JCTree.JCBlock jCBlock = new JCTree.JCBlock(l, list);
        jCBlock.pos = this.pos;
        return jCBlock;
    }

    @Override
    public JCTree.JCDoWhileLoop DoLoop(JCTree.JCStatement jCStatement, JCTree.JCExpression jCExpression) {
        JCTree.JCDoWhileLoop jCDoWhileLoop = new JCTree.JCDoWhileLoop(jCStatement, jCExpression);
        jCDoWhileLoop.pos = this.pos;
        return jCDoWhileLoop;
    }

    @Override
    public JCTree.JCWhileLoop WhileLoop(JCTree.JCExpression jCExpression, JCTree.JCStatement jCStatement) {
        JCTree.JCWhileLoop jCWhileLoop = new JCTree.JCWhileLoop(jCExpression, jCStatement);
        jCWhileLoop.pos = this.pos;
        return jCWhileLoop;
    }

    @Override
    public JCTree.JCForLoop ForLoop(List<JCTree.JCStatement> list, JCTree.JCExpression jCExpression, List<JCTree.JCExpressionStatement> list2, JCTree.JCStatement jCStatement) {
        JCTree.JCForLoop jCForLoop = new JCTree.JCForLoop(list, jCExpression, list2, jCStatement);
        jCForLoop.pos = this.pos;
        return jCForLoop;
    }

    @Override
    public JCTree.JCEnhancedForLoop ForeachLoop(JCTree.JCVariableDecl jCVariableDecl, JCTree.JCExpression jCExpression, JCTree.JCStatement jCStatement) {
        JCTree.JCEnhancedForLoop jCEnhancedForLoop = new JCTree.JCEnhancedForLoop(jCVariableDecl, jCExpression, jCStatement);
        jCEnhancedForLoop.pos = this.pos;
        return jCEnhancedForLoop;
    }

    @Override
    public JCTree.JCLabeledStatement Labelled(Name name, JCTree.JCStatement jCStatement) {
        JCTree.JCLabeledStatement jCLabeledStatement = new JCTree.JCLabeledStatement(name, jCStatement);
        jCLabeledStatement.pos = this.pos;
        return jCLabeledStatement;
    }

    @Override
    public JCTree.JCSwitch Switch(JCTree.JCExpression jCExpression, List<JCTree.JCCase> list) {
        JCTree.JCSwitch jCSwitch = new JCTree.JCSwitch(jCExpression, list);
        jCSwitch.pos = this.pos;
        return jCSwitch;
    }

    @Override
    public JCTree.JCCase Case(JCTree.JCExpression jCExpression, List<JCTree.JCStatement> list) {
        JCTree.JCCase jCCase = new JCTree.JCCase(jCExpression, list);
        jCCase.pos = this.pos;
        return jCCase;
    }

    @Override
    public JCTree.JCSynchronized Synchronized(JCTree.JCExpression jCExpression, JCTree.JCBlock jCBlock) {
        JCTree.JCSynchronized jCSynchronized = new JCTree.JCSynchronized(jCExpression, jCBlock);
        jCSynchronized.pos = this.pos;
        return jCSynchronized;
    }

    @Override
    public JCTree.JCTry Try(JCTree.JCBlock jCBlock, List<JCTree.JCCatch> list, JCTree.JCBlock jCBlock2) {
        return this.Try(List.nil(), jCBlock, list, jCBlock2);
    }

    @Override
    public JCTree.JCTry Try(List<JCTree> list, JCTree.JCBlock jCBlock, List<JCTree.JCCatch> list2, JCTree.JCBlock jCBlock2) {
        JCTree.JCTry jCTry = new JCTree.JCTry(list, jCBlock, list2, jCBlock2);
        jCTry.pos = this.pos;
        return jCTry;
    }

    @Override
    public JCTree.JCCatch Catch(JCTree.JCVariableDecl jCVariableDecl, JCTree.JCBlock jCBlock) {
        JCTree.JCCatch jCCatch = new JCTree.JCCatch(jCVariableDecl, jCBlock);
        jCCatch.pos = this.pos;
        return jCCatch;
    }

    @Override
    public JCTree.JCConditional Conditional(JCTree.JCExpression jCExpression, JCTree.JCExpression jCExpression2, JCTree.JCExpression jCExpression3) {
        JCTree.JCConditional jCConditional = new JCTree.JCConditional(jCExpression, jCExpression2, jCExpression3);
        jCConditional.pos = this.pos;
        return jCConditional;
    }

    @Override
    public JCTree.JCIf If(JCTree.JCExpression jCExpression, JCTree.JCStatement jCStatement, JCTree.JCStatement jCStatement2) {
        JCTree.JCIf jCIf = new JCTree.JCIf(jCExpression, jCStatement, jCStatement2);
        jCIf.pos = this.pos;
        return jCIf;
    }

    @Override
    public JCTree.JCExpressionStatement Exec(JCTree.JCExpression jCExpression) {
        JCTree.JCExpressionStatement jCExpressionStatement = new JCTree.JCExpressionStatement(jCExpression);
        jCExpressionStatement.pos = this.pos;
        return jCExpressionStatement;
    }

    @Override
    public JCTree.JCBreak Break(Name name) {
        JCTree.JCBreak jCBreak = new JCTree.JCBreak(name, null);
        jCBreak.pos = this.pos;
        return jCBreak;
    }

    @Override
    public JCTree.JCContinue Continue(Name name) {
        JCTree.JCContinue jCContinue = new JCTree.JCContinue(name, null);
        jCContinue.pos = this.pos;
        return jCContinue;
    }

    @Override
    public JCTree.JCReturn Return(JCTree.JCExpression jCExpression) {
        JCTree.JCReturn jCReturn = new JCTree.JCReturn(jCExpression);
        jCReturn.pos = this.pos;
        return jCReturn;
    }

    @Override
    public JCTree.JCThrow Throw(JCTree.JCExpression jCExpression) {
        JCTree.JCThrow jCThrow = new JCTree.JCThrow(jCExpression);
        jCThrow.pos = this.pos;
        return jCThrow;
    }

    @Override
    public JCTree.JCAssert Assert(JCTree.JCExpression jCExpression, JCTree.JCExpression jCExpression2) {
        JCTree.JCAssert jCAssert = new JCTree.JCAssert(jCExpression, jCExpression2);
        jCAssert.pos = this.pos;
        return jCAssert;
    }

    @Override
    public JCTree.JCMethodInvocation Apply(List<JCTree.JCExpression> list, JCTree.JCExpression jCExpression, List<JCTree.JCExpression> list2) {
        JCTree.JCMethodInvocation jCMethodInvocation = new JCTree.JCMethodInvocation(list, jCExpression, list2);
        jCMethodInvocation.pos = this.pos;
        return jCMethodInvocation;
    }

    @Override
    public JCTree.JCNewClass NewClass(JCTree.JCExpression jCExpression, List<JCTree.JCExpression> list, JCTree.JCExpression jCExpression2, List<JCTree.JCExpression> list2, JCTree.JCClassDecl jCClassDecl) {
        JCTree.JCNewClass jCNewClass = new JCTree.JCNewClass(jCExpression, list, jCExpression2, list2, jCClassDecl);
        jCNewClass.pos = this.pos;
        return jCNewClass;
    }

    @Override
    public JCTree.JCNewArray NewArray(JCTree.JCExpression jCExpression, List<JCTree.JCExpression> list, List<JCTree.JCExpression> list2) {
        JCTree.JCNewArray jCNewArray = new JCTree.JCNewArray(jCExpression, list, list2);
        jCNewArray.pos = this.pos;
        return jCNewArray;
    }

    public JCTree.JCLambda Lambda(List<JCTree.JCVariableDecl> list, JCTree jCTree) {
        JCTree.JCLambda jCLambda = new JCTree.JCLambda(list, jCTree);
        jCLambda.pos = this.pos;
        return jCLambda;
    }

    @Override
    public JCTree.JCParens Parens(JCTree.JCExpression jCExpression) {
        JCTree.JCParens jCParens = new JCTree.JCParens(jCExpression);
        jCParens.pos = this.pos;
        return jCParens;
    }

    @Override
    public JCTree.JCAssign Assign(JCTree.JCExpression jCExpression, JCTree.JCExpression jCExpression2) {
        JCTree.JCAssign jCAssign = new JCTree.JCAssign(jCExpression, jCExpression2);
        jCAssign.pos = this.pos;
        return jCAssign;
    }

    @Override
    public JCTree.JCAssignOp Assignop(JCTree.Tag tag, JCTree jCTree, JCTree jCTree2) {
        JCTree.JCAssignOp jCAssignOp = new JCTree.JCAssignOp(tag, jCTree, jCTree2, null);
        jCAssignOp.pos = this.pos;
        return jCAssignOp;
    }

    @Override
    public JCTree.JCUnary Unary(JCTree.Tag tag, JCTree.JCExpression jCExpression) {
        JCTree.JCUnary jCUnary = new JCTree.JCUnary(tag, jCExpression);
        jCUnary.pos = this.pos;
        return jCUnary;
    }

    @Override
    public JCTree.JCBinary Binary(JCTree.Tag tag, JCTree.JCExpression jCExpression, JCTree.JCExpression jCExpression2) {
        JCTree.JCBinary jCBinary = new JCTree.JCBinary(tag, jCExpression, jCExpression2, null);
        jCBinary.pos = this.pos;
        return jCBinary;
    }

    @Override
    public JCTree.JCTypeCast TypeCast(JCTree jCTree, JCTree.JCExpression jCExpression) {
        JCTree.JCTypeCast jCTypeCast = new JCTree.JCTypeCast(jCTree, jCExpression);
        jCTypeCast.pos = this.pos;
        return jCTypeCast;
    }

    @Override
    public JCTree.JCInstanceOf TypeTest(JCTree.JCExpression jCExpression, JCTree jCTree) {
        JCTree.JCInstanceOf jCInstanceOf = new JCTree.JCInstanceOf(jCExpression, jCTree);
        jCInstanceOf.pos = this.pos;
        return jCInstanceOf;
    }

    @Override
    public JCTree.JCArrayAccess Indexed(JCTree.JCExpression jCExpression, JCTree.JCExpression jCExpression2) {
        JCTree.JCArrayAccess jCArrayAccess = new JCTree.JCArrayAccess(jCExpression, jCExpression2);
        jCArrayAccess.pos = this.pos;
        return jCArrayAccess;
    }

    @Override
    public JCTree.JCFieldAccess Select(JCTree.JCExpression jCExpression, Name name) {
        JCTree.JCFieldAccess jCFieldAccess = new JCTree.JCFieldAccess(jCExpression, name, null);
        jCFieldAccess.pos = this.pos;
        return jCFieldAccess;
    }

    public JCTree.JCMemberReference Reference(MemberReferenceTree.ReferenceMode referenceMode, Name name, JCTree.JCExpression jCExpression, List<JCTree.JCExpression> list) {
        JCTree.JCMemberReference jCMemberReference = new JCTree.JCMemberReference(referenceMode, name, jCExpression, list);
        jCMemberReference.pos = this.pos;
        return jCMemberReference;
    }

    @Override
    public JCTree.JCIdent Ident(Name name) {
        JCTree.JCIdent jCIdent = new JCTree.JCIdent(name, null);
        jCIdent.pos = this.pos;
        return jCIdent;
    }

    @Override
    public JCTree.JCLiteral Literal(TypeTag typeTag, Object object) {
        JCTree.JCLiteral jCLiteral = new JCTree.JCLiteral(typeTag, object);
        jCLiteral.pos = this.pos;
        return jCLiteral;
    }

    @Override
    public JCTree.JCPrimitiveTypeTree TypeIdent(TypeTag typeTag) {
        JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree = new JCTree.JCPrimitiveTypeTree(typeTag);
        jCPrimitiveTypeTree.pos = this.pos;
        return jCPrimitiveTypeTree;
    }

    @Override
    public JCTree.JCArrayTypeTree TypeArray(JCTree.JCExpression jCExpression) {
        JCTree.JCArrayTypeTree jCArrayTypeTree = new JCTree.JCArrayTypeTree(jCExpression);
        jCArrayTypeTree.pos = this.pos;
        return jCArrayTypeTree;
    }

    @Override
    public JCTree.JCTypeApply TypeApply(JCTree.JCExpression jCExpression, List<JCTree.JCExpression> list) {
        JCTree.JCTypeApply jCTypeApply = new JCTree.JCTypeApply(jCExpression, list);
        jCTypeApply.pos = this.pos;
        return jCTypeApply;
    }

    public JCTree.JCTypeUnion TypeUnion(List<JCTree.JCExpression> list) {
        JCTree.JCTypeUnion jCTypeUnion = new JCTree.JCTypeUnion(list);
        jCTypeUnion.pos = this.pos;
        return jCTypeUnion;
    }

    public JCTree.JCTypeIntersection TypeIntersection(List<JCTree.JCExpression> list) {
        JCTree.JCTypeIntersection jCTypeIntersection = new JCTree.JCTypeIntersection(list);
        jCTypeIntersection.pos = this.pos;
        return jCTypeIntersection;
    }

    @Override
    public JCTree.JCTypeParameter TypeParameter(Name name, List<JCTree.JCExpression> list) {
        return this.TypeParameter(name, list, List.nil());
    }

    public JCTree.JCTypeParameter TypeParameter(Name name, List<JCTree.JCExpression> list, List<JCTree.JCAnnotation> list2) {
        JCTree.JCTypeParameter jCTypeParameter = new JCTree.JCTypeParameter(name, list, list2);
        jCTypeParameter.pos = this.pos;
        return jCTypeParameter;
    }

    @Override
    public JCTree.JCWildcard Wildcard(JCTree.TypeBoundKind typeBoundKind, JCTree jCTree) {
        JCTree.JCWildcard jCWildcard = new JCTree.JCWildcard(typeBoundKind, jCTree);
        jCWildcard.pos = this.pos;
        return jCWildcard;
    }

    @Override
    public JCTree.TypeBoundKind TypeBoundKind(BoundKind boundKind) {
        JCTree.TypeBoundKind typeBoundKind = new JCTree.TypeBoundKind(boundKind);
        typeBoundKind.pos = this.pos;
        return typeBoundKind;
    }

    @Override
    public JCTree.JCAnnotation Annotation(JCTree jCTree, List<JCTree.JCExpression> list) {
        JCTree.JCAnnotation jCAnnotation = new JCTree.JCAnnotation(JCTree.Tag.ANNOTATION, jCTree, list);
        jCAnnotation.pos = this.pos;
        return jCAnnotation;
    }

    public JCTree.JCAnnotation TypeAnnotation(JCTree jCTree, List<JCTree.JCExpression> list) {
        JCTree.JCAnnotation jCAnnotation = new JCTree.JCAnnotation(JCTree.Tag.TYPE_ANNOTATION, jCTree, list);
        jCAnnotation.pos = this.pos;
        return jCAnnotation;
    }

    @Override
    public JCTree.JCModifiers Modifiers(long l, List<JCTree.JCAnnotation> list) {
        JCTree.JCModifiers jCModifiers = new JCTree.JCModifiers(l, list);
        boolean bl = (l & 0x80000002DFFL) == 0L;
        jCModifiers.pos = bl && list.isEmpty() ? -1 : this.pos;
        return jCModifiers;
    }

    public JCTree.JCModifiers Modifiers(long l) {
        return this.Modifiers(l, List.nil());
    }

    @Override
    public JCTree.JCModuleDecl ModuleDef(JCTree.JCModifiers jCModifiers, ModuleTree.ModuleKind moduleKind, JCTree.JCExpression jCExpression, List<JCTree.JCDirective> list) {
        JCTree.JCModuleDecl jCModuleDecl = new JCTree.JCModuleDecl(jCModifiers, moduleKind, jCExpression, list);
        jCModuleDecl.pos = this.pos;
        return jCModuleDecl;
    }

    @Override
    public JCTree.JCExports Exports(JCTree.JCExpression jCExpression, List<JCTree.JCExpression> list) {
        JCTree.JCExports jCExports = new JCTree.JCExports(jCExpression, list);
        jCExports.pos = this.pos;
        return jCExports;
    }

    @Override
    public JCTree.JCOpens Opens(JCTree.JCExpression jCExpression, List<JCTree.JCExpression> list) {
        JCTree.JCOpens jCOpens = new JCTree.JCOpens(jCExpression, list);
        jCOpens.pos = this.pos;
        return jCOpens;
    }

    @Override
    public JCTree.JCProvides Provides(JCTree.JCExpression jCExpression, List<JCTree.JCExpression> list) {
        JCTree.JCProvides jCProvides = new JCTree.JCProvides(jCExpression, list);
        jCProvides.pos = this.pos;
        return jCProvides;
    }

    @Override
    public JCTree.JCRequires Requires(boolean bl, boolean bl2, JCTree.JCExpression jCExpression) {
        JCTree.JCRequires jCRequires = new JCTree.JCRequires(bl, bl2, jCExpression);
        jCRequires.pos = this.pos;
        return jCRequires;
    }

    @Override
    public JCTree.JCUses Uses(JCTree.JCExpression jCExpression) {
        JCTree.JCUses jCUses = new JCTree.JCUses(jCExpression);
        jCUses.pos = this.pos;
        return jCUses;
    }

    public JCTree.JCAnnotatedType AnnotatedType(List<JCTree.JCAnnotation> list, JCTree.JCExpression jCExpression) {
        JCTree.JCAnnotatedType jCAnnotatedType = new JCTree.JCAnnotatedType(list, jCExpression);
        jCAnnotatedType.pos = this.pos;
        return jCAnnotatedType;
    }

    public JCTree.JCErroneous Erroneous() {
        return this.Erroneous(List.nil());
    }

    @Override
    public JCTree.JCErroneous Erroneous(List<? extends JCTree> list) {
        JCTree.JCErroneous jCErroneous = new JCTree.JCErroneous(list);
        jCErroneous.pos = this.pos;
        return jCErroneous;
    }

    @Override
    public JCTree.LetExpr LetExpr(List<JCTree.JCVariableDecl> list, JCTree.JCExpression jCExpression) {
        JCTree.LetExpr letExpr = new JCTree.LetExpr(list, jCExpression);
        letExpr.pos = this.pos;
        return letExpr;
    }

    public JCTree.JCClassDecl AnonymousClassDef(JCTree.JCModifiers jCModifiers, List<JCTree> list) {
        return this.ClassDef(jCModifiers, this.names.empty, List.nil(), null, List.nil(), list);
    }

    public JCTree.LetExpr LetExpr(JCTree.JCVariableDecl jCVariableDecl, JCTree.JCExpression jCExpression) {
        JCTree.LetExpr letExpr = new JCTree.LetExpr(List.of(jCVariableDecl), jCExpression);
        letExpr.pos = this.pos;
        return letExpr;
    }

    public JCTree.JCIdent Ident(Symbol symbol) {
        return (JCTree.JCIdent)new JCTree.JCIdent(symbol.name != this.names.empty ? symbol.name : symbol.flatName(), symbol).setPos(this.pos).setType(symbol.type);
    }

    public JCTree.JCExpression Select(JCTree.JCExpression jCExpression, Symbol symbol) {
        return new JCTree.JCFieldAccess(jCExpression, symbol.name, symbol).setPos(this.pos).setType(symbol.type);
    }

    public JCTree.JCExpression QualIdent(Symbol symbol) {
        return this.isUnqualifiable(symbol) ? this.Ident(symbol) : this.Select(this.QualIdent(symbol.owner), symbol);
    }

    public JCTree.JCExpression Ident(JCTree.JCVariableDecl jCVariableDecl) {
        return this.Ident(jCVariableDecl.sym);
    }

    public List<JCTree.JCExpression> Idents(List<JCTree.JCVariableDecl> list) {
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        List<JCTree.JCVariableDecl> list2 = list;
        while (list2.nonEmpty()) {
            listBuffer.append(this.Ident((JCTree.JCVariableDecl)list2.head));
            list2 = list2.tail;
        }
        return listBuffer.toList();
    }

    public JCTree.JCExpression This(Type type) {
        return this.Ident(new Symbol.VarSymbol(16L, this.names._this, type, type.tsym));
    }

    public JCTree.JCExpression QualThis(Type type) {
        return this.Select(this.Type(type), new Symbol.VarSymbol(16L, this.names._this, type, type.tsym));
    }

    public JCTree.JCExpression ClassLiteral(Symbol.ClassSymbol classSymbol) {
        return this.ClassLiteral(classSymbol.type);
    }

    public JCTree.JCExpression ClassLiteral(Type type) {
        Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(25L, this.names._class, type, type.tsym);
        return this.Select(this.Type(type), varSymbol);
    }

    public JCTree.JCIdent Super(Type type, Symbol.TypeSymbol typeSymbol) {
        return this.Ident(new Symbol.VarSymbol(16L, this.names._super, type, typeSymbol));
    }

    public JCTree.JCMethodInvocation App(JCTree.JCExpression jCExpression, List<JCTree.JCExpression> list) {
        return this.Apply(null, jCExpression, list).setType(jCExpression.type.getReturnType());
    }

    public JCTree.JCMethodInvocation App(JCTree.JCExpression jCExpression) {
        return this.Apply(null, jCExpression, List.nil()).setType(jCExpression.type.getReturnType());
    }

    public JCTree.JCExpression Create(Symbol symbol, List<JCTree.JCExpression> list) {
        Type type = symbol.owner.erasure(this.types);
        JCTree.JCNewClass jCNewClass = this.NewClass(null, null, this.Type(type), list, null);
        jCNewClass.constructor = symbol;
        jCNewClass.setType(type);
        return jCNewClass;
    }

    public JCTree.JCExpression Type(Type type) {
        JCTree.JCExpression jCExpression;
        if (type == null) {
            return null;
        }
        block0 : switch (type.getTag()) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case VOID: {
                jCExpression = this.TypeIdent(type.getTag());
                break;
            }
            case TYPEVAR: {
                jCExpression = this.Ident(type.tsym);
                break;
            }
            case WILDCARD: {
                Type.WildcardType wildcardType = (Type.WildcardType)type;
                jCExpression = this.Wildcard(this.TypeBoundKind(wildcardType.kind), wildcardType.kind == BoundKind.UNBOUND ? null : this.Type(wildcardType.type));
                break;
            }
            case CLASS: {
                switch (type.getKind()) {
                    case UNION: {
                        Type.UnionClassType unionClassType = (Type.UnionClassType)type;
                        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
                        for (Type type2 : unionClassType.getAlternativeTypes()) {
                            listBuffer.add(this.Type(type2));
                        }
                        jCExpression = this.TypeUnion(listBuffer.toList());
                        break block0;
                    }
                    case INTERSECTION: {
                        Type.IntersectionClassType intersectionClassType = (Type.IntersectionClassType)type;
                        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
                        for (Type type3 : intersectionClassType.getExplicitComponents()) {
                            listBuffer.add(this.Type(type3));
                        }
                        jCExpression = this.TypeIntersection(listBuffer.toList());
                        break block0;
                    }
                }
                Type type4 = type.getEnclosingType();
                JCTree.JCExpression jCExpression2 = type4.hasTag(TypeTag.CLASS) && type.tsym.owner.kind == Kinds.Kind.TYP ? this.Select(this.Type(type4), type.tsym) : this.QualIdent(type.tsym);
                jCExpression = type.getTypeArguments().isEmpty() ? jCExpression2 : this.TypeApply(jCExpression2, this.Types(type.getTypeArguments()));
                break;
            }
            case ARRAY: {
                jCExpression = this.TypeArray(this.Type(this.types.elemtype(type)));
                break;
            }
            case ERROR: {
                jCExpression = this.TypeIdent(TypeTag.ERROR);
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected type: " + type));
            }
        }
        return jCExpression.setType(type);
    }

    public List<JCTree.JCExpression> Types(List<Type> list) {
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            listBuffer.append(this.Type((Type)list2.head));
            list2 = list2.tail;
        }
        return listBuffer.toList();
    }

    public JCTree.JCVariableDecl VarDef(Symbol.VarSymbol varSymbol, JCTree.JCExpression jCExpression) {
        return (JCTree.JCVariableDecl)new JCTree.JCVariableDecl(this.Modifiers(varSymbol.flags(), this.Annotations(varSymbol.getRawAttributes())), varSymbol.name, this.Type(varSymbol.type), jCExpression, varSymbol).setPos(this.pos).setType(varSymbol.type);
    }

    public List<JCTree.JCAnnotation> Annotations(List<Attribute.Compound> list) {
        if (list == null) {
            return List.nil();
        }
        ListBuffer<JCTree.JCAnnotation> listBuffer = new ListBuffer<JCTree.JCAnnotation>();
        List<Attribute.Compound> list2 = list;
        while (list2.nonEmpty()) {
            Attribute attribute = (Attribute)list2.head;
            listBuffer.append(this.Annotation(attribute));
            list2 = list2.tail;
        }
        return listBuffer.toList();
    }

    public JCTree.JCLiteral Literal(Object object) {
        JCTree.JCLiteral jCLiteral = null;
        if (object instanceof String) {
            jCLiteral = this.Literal(TypeTag.CLASS, object).setType(this.syms.stringType.constType(object));
        } else if (object instanceof Integer) {
            jCLiteral = this.Literal(TypeTag.INT, object).setType(this.syms.intType.constType(object));
        } else if (object instanceof Long) {
            jCLiteral = this.Literal(TypeTag.LONG, object).setType(this.syms.longType.constType(object));
        } else if (object instanceof Byte) {
            jCLiteral = this.Literal(TypeTag.BYTE, object).setType(this.syms.byteType.constType(object));
        } else if (object instanceof Character) {
            char c = ((Character)object).toString().charAt(0);
            jCLiteral = this.Literal(TypeTag.CHAR, c).setType(this.syms.charType.constType(c));
        } else if (object instanceof Double) {
            jCLiteral = this.Literal(TypeTag.DOUBLE, object).setType(this.syms.doubleType.constType(object));
        } else if (object instanceof Float) {
            jCLiteral = this.Literal(TypeTag.FLOAT, object).setType(this.syms.floatType.constType(object));
        } else if (object instanceof Short) {
            jCLiteral = this.Literal(TypeTag.SHORT, object).setType(this.syms.shortType.constType(object));
        } else if (object instanceof Boolean) {
            int n = (Boolean)object != false ? 1 : 0;
            jCLiteral = this.Literal(TypeTag.BOOLEAN, n).setType(this.syms.booleanType.constType(n));
        } else {
            throw new AssertionError(object);
        }
        return jCLiteral;
    }

    public JCTree.JCAnnotation Annotation(Attribute attribute) {
        return this.annotationBuilder.translate((Attribute.Compound)attribute);
    }

    public JCTree.JCAnnotation TypeAnnotation(Attribute attribute) {
        return this.annotationBuilder.translate((Attribute.TypeCompound)attribute);
    }

    public JCTree.JCMethodDecl MethodDef(Symbol.MethodSymbol methodSymbol, JCTree.JCBlock jCBlock) {
        return this.MethodDef(methodSymbol, methodSymbol.type, jCBlock);
    }

    public JCTree.JCMethodDecl MethodDef(Symbol.MethodSymbol methodSymbol, Type type, JCTree.JCBlock jCBlock) {
        return (JCTree.JCMethodDecl)new JCTree.JCMethodDecl(this.Modifiers(methodSymbol.flags(), this.Annotations(methodSymbol.getRawAttributes())), methodSymbol.name, this.Type(type.getReturnType()), this.TypeParams(type.getTypeArguments()), null, this.Params(type.getParameterTypes(), methodSymbol), this.Types(type.getThrownTypes()), jCBlock, null, methodSymbol).setPos(this.pos).setType(type);
    }

    public JCTree.JCTypeParameter TypeParam(Name name, Type.TypeVar typeVar) {
        return (JCTree.JCTypeParameter)this.TypeParameter(name, this.Types(this.types.getBounds(typeVar))).setPos(this.pos).setType(typeVar);
    }

    public List<JCTree.JCTypeParameter> TypeParams(List<Type> list) {
        ListBuffer<JCTree.JCTypeParameter> listBuffer = new ListBuffer<JCTree.JCTypeParameter>();
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            listBuffer.append(this.TypeParam(((Type)list2.head).tsym.name, (Type.TypeVar)list2.head));
            list2 = list2.tail;
        }
        return listBuffer.toList();
    }

    public JCTree.JCVariableDecl Param(Name name, Type type, Symbol symbol) {
        return this.VarDef(new Symbol.VarSymbol(0x200000000L, name, type, symbol), null);
    }

    public List<JCTree.JCVariableDecl> Params(List<Type> list, Symbol symbol) {
        Symbol.MethodSymbol methodSymbol;
        ListBuffer<JCTree.JCVariableDecl> listBuffer = new ListBuffer<JCTree.JCVariableDecl>();
        Symbol.MethodSymbol methodSymbol2 = methodSymbol = symbol.kind == Kinds.Kind.MTH ? (Symbol.MethodSymbol)symbol : null;
        if (methodSymbol != null && methodSymbol.params != null && list.length() == methodSymbol.params.length()) {
            for (Symbol.VarSymbol varSymbol : ((Symbol.MethodSymbol)symbol).params) {
                listBuffer.append(this.VarDef(varSymbol, null));
            }
        } else {
            int n = 0;
            List<Type> list2 = list;
            while (list2.nonEmpty()) {
                listBuffer.append(this.Param(this.paramName(n++), (Type)list2.head, symbol));
                list2 = list2.tail;
            }
        }
        return listBuffer.toList();
    }

    public JCTree.JCStatement Call(JCTree.JCExpression jCExpression) {
        return jCExpression.type.hasTag(TypeTag.VOID) ? this.Exec(jCExpression) : this.Return(jCExpression);
    }

    public JCTree.JCStatement Assignment(Symbol symbol, JCTree.JCExpression jCExpression) {
        return this.Exec(this.Assign(this.Ident(symbol), jCExpression).setType(symbol.type));
    }

    public JCTree.JCArrayAccess Indexed(Symbol symbol, JCTree.JCExpression jCExpression) {
        JCTree.JCArrayAccess jCArrayAccess = new JCTree.JCArrayAccess(this.QualIdent(symbol), jCExpression);
        jCArrayAccess.type = ((Type.ArrayType)symbol.type).elemtype;
        return jCArrayAccess;
    }

    public JCTree.JCTypeCast TypeCast(Type type, JCTree.JCExpression jCExpression) {
        return (JCTree.JCTypeCast)this.TypeCast(this.Type(type), jCExpression).setType(type);
    }

    boolean isUnqualifiable(Symbol symbol) {
        if (symbol.name == this.names.empty || symbol.owner == null || symbol.owner == this.syms.rootPackage || symbol.owner.kind == Kinds.Kind.MTH || symbol.owner.kind == Kinds.Kind.VAR) {
            return true;
        }
        if (symbol.kind == Kinds.Kind.TYP && this.toplevel != null) {
            Iterator<Symbol> iterator = this.toplevel.namedImportScope.getSymbolsByName(symbol.name).iterator();
            if (iterator.hasNext()) {
                Symbol symbol2 = iterator.next();
                return symbol2 == symbol && !iterator.hasNext();
            }
            iterator = this.toplevel.packge.members().getSymbolsByName(symbol.name).iterator();
            if (iterator.hasNext()) {
                Symbol symbol3 = iterator.next();
                return symbol3 == symbol && !iterator.hasNext();
            }
            iterator = this.toplevel.starImportScope.getSymbolsByName(symbol.name).iterator();
            if (iterator.hasNext()) {
                Symbol symbol4 = iterator.next();
                return symbol4 == symbol && !iterator.hasNext();
            }
        }
        return false;
    }

    public Name paramName(int n) {
        return this.names.fromString("x" + n);
    }

    public Name typaramName(int n) {
        return this.names.fromString("A" + n);
    }

    class AnnotationBuilder
    implements Attribute.Visitor {
        JCTree.JCExpression result = null;

        AnnotationBuilder() {
        }

        @Override
        public void visitConstant(Attribute.Constant constant) {
            this.result = TreeMaker.this.Literal(constant.type.getTag(), constant.value);
        }

        @Override
        public void visitClass(Attribute.Class clazz) {
            this.result = TreeMaker.this.ClassLiteral(clazz.classType).setType(TreeMaker.this.syms.classType);
        }

        @Override
        public void visitEnum(Attribute.Enum enum_) {
            this.result = TreeMaker.this.QualIdent(enum_.value);
        }

        @Override
        public void visitError(Attribute.Error error) {
            this.result = TreeMaker.this.Erroneous();
        }

        @Override
        public void visitCompound(Attribute.Compound compound) {
            this.result = compound instanceof Attribute.TypeCompound ? this.visitTypeCompoundInternal((Attribute.TypeCompound)compound) : this.visitCompoundInternal(compound);
        }

        public JCTree.JCAnnotation visitCompoundInternal(Attribute.Compound compound) {
            ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
            List<Pair<Symbol.MethodSymbol, Attribute>> list = compound.values;
            while (list.nonEmpty()) {
                Pair pair = (Pair)list.head;
                JCTree.JCExpression jCExpression = this.translate((Attribute)pair.snd);
                listBuffer.append(TreeMaker.this.Assign(TreeMaker.this.Ident((Symbol)pair.fst), jCExpression).setType(jCExpression.type));
                list = list.tail;
            }
            return TreeMaker.this.Annotation(TreeMaker.this.Type(compound.type), listBuffer.toList());
        }

        public JCTree.JCAnnotation visitTypeCompoundInternal(Attribute.TypeCompound typeCompound) {
            ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
            List list = typeCompound.values;
            while (list.nonEmpty()) {
                Pair pair = (Pair)list.head;
                JCTree.JCExpression jCExpression = this.translate((Attribute)pair.snd);
                listBuffer.append(TreeMaker.this.Assign(TreeMaker.this.Ident((Symbol)pair.fst), jCExpression).setType(jCExpression.type));
                list = list.tail;
            }
            return TreeMaker.this.TypeAnnotation(TreeMaker.this.Type(typeCompound.type), listBuffer.toList());
        }

        @Override
        public void visitArray(Attribute.Array array) {
            ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
            for (int i = 0; i < array.values.length; ++i) {
                listBuffer.append(this.translate(array.values[i]));
            }
            this.result = TreeMaker.this.NewArray(null, List.nil(), listBuffer.toList()).setType(array.type);
        }

        JCTree.JCExpression translate(Attribute attribute) {
            attribute.accept(this);
            return this.result;
        }

        JCTree.JCAnnotation translate(Attribute.Compound compound) {
            return this.visitCompoundInternal(compound);
        }

        JCTree.JCAnnotation translate(Attribute.TypeCompound typeCompound) {
            return this.visitTypeCompoundInternal(typeCompound);
        }
    }
}

