/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.sjavac;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;

public class Log {
    private static Log stdOutErr = new Log(new PrintWriter(System.out), new PrintWriter(System.err));
    private static ThreadLocal<Log> loggers = new ThreadLocal();
    protected PrintWriter err;
    protected PrintWriter out;
    protected Level level = Level.INFO;

    public Log(Writer writer, Writer writer2) {
        this.out = writer == null ? null : new PrintWriter(writer, true);
        this.err = writer2 == null ? null : new PrintWriter(writer2, true);
    }

    public static void setLogForCurrentThread(Log log) {
        loggers.set(log);
    }

    public static void setLogLevel(String string) {
        Log.setLogLevel(Level.valueOf(string.toUpperCase(Locale.US)));
    }

    public static void setLogLevel(Level level) {
        Log.get().level = level;
    }

    public static void trace(String string) {
        Log.log(Level.TRACE, string);
    }

    public static void debug(String string) {
        Log.log(Level.DEBUG, string);
    }

    public static void info(String string) {
        Log.log(Level.INFO, string);
    }

    public static void warn(String string) {
        Log.log(Level.WARN, string);
    }

    public static void error(String string) {
        Log.log(Level.ERROR, string);
    }

    public static void error(Throwable throwable) {
        Log.log(Level.ERROR, throwable);
    }

    public static void log(Level level, String string) {
        Log.get().printLogMsg(level, string);
    }

    public static void debug(Throwable throwable) {
        Log.log(Level.DEBUG, throwable);
    }

    public static void log(Level level, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        Log.log(level, stringWriter.toString());
    }

    public static boolean isDebugging() {
        return Log.get().isLevelLogged(Level.DEBUG);
    }

    protected boolean isLevelLogged(Level level) {
        return level.ordinal() <= this.level.ordinal();
    }

    public static Log get() {
        Log log = loggers.get();
        return log != null ? log : stdOutErr;
    }

    protected void printLogMsg(Level level, String string) {
        if (this.isLevelLogged(level)) {
            PrintWriter printWriter = level.ordinal() <= Level.WARN.ordinal() ? this.err : this.out;
            printWriter.println(string);
        }
    }

    public static enum Level {
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

