/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealLinearOperator;
import org.apache.commons.math3.linear.RealVector;

public class HilbertMatrix
extends RealLinearOperator {
    private final int n;

    public HilbertMatrix(int n) {
        this.n = n;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public int getRowDimension() {
        return this.n;
    }

    public RealVector operate(RealVector x) {
        if (x.getDimension() != this.n) {
            throw new DimensionMismatchException(x.getDimension(), this.n);
        }
        double[] y = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            double pos = 0.0;
            double neg = 0.0;
            for (int j = 0; j < this.n; ++j) {
                double xj = x.getEntry(j);
                double coeff = 1.0 / ((double)(i + j) + 1.0);
                if (xj > 0.0) {
                    pos += coeff * xj;
                    continue;
                }
                neg += coeff * xj;
            }
            y[i] = pos + neg;
        }
        return new ArrayRealVector(y, false);
    }
}

