/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.AbstractIntegrator;
import org.apache.commons.math3.ode.EquationsMapper;
import org.apache.commons.math3.ode.ExpandableStatefulODE;
import org.apache.commons.math3.ode.FieldEquationsMapper;
import org.apache.commons.math3.ode.FieldExpandableODE;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.FirstOrderFieldDifferentialEquations;
import org.apache.commons.math3.ode.nonstiff.FieldButcherArrayProvider;
import org.apache.commons.math3.ode.nonstiff.RungeKuttaFieldStepInterpolator;
import org.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import org.apache.commons.math3.ode.sampling.AbstractFieldStepInterpolator;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RungeKuttaFieldStepInterpolatorAbstractTest {
    protected abstract <T extends RealFieldElement<T>> RungeKuttaFieldStepInterpolator<T> createInterpolator(Field<T> var1, boolean var2, T[][] var3, FieldODEStateAndDerivative<T> var4, FieldODEStateAndDerivative<T> var5, FieldODEStateAndDerivative<T> var6, FieldODEStateAndDerivative<T> var7, FieldEquationsMapper<T> var8);

    protected abstract <T extends RealFieldElement<T>> FieldButcherArrayProvider<T> createButcherArrayProvider(Field<T> var1);

    @Test
    public abstract void interpolationAtBounds();

    protected <T extends RealFieldElement<T>> void doInterpolationAtBounds(Field<T> field, double epsilon) {
        int i;
        RungeKuttaFieldStepInterpolator<T> interpolator = this.setUpInterpolator(field, new SinCos<T>(field), 0.0, new double[]{0.0, 1.0}, 0.125);
        Assert.assertEquals((double)0.0, (double)interpolator.getPreviousState().getTime().getReal(), (double)1.0E-15);
        for (i = 0; i < 2; ++i) {
            Assert.assertEquals((double)interpolator.getPreviousState().getState()[i].getReal(), (double)interpolator.getInterpolatedState(interpolator.getPreviousState().getTime()).getState()[i].getReal(), (double)epsilon);
        }
        Assert.assertEquals((double)0.125, (double)interpolator.getCurrentState().getTime().getReal(), (double)1.0E-15);
        for (i = 0; i < 2; ++i) {
            Assert.assertEquals((double)interpolator.getCurrentState().getState()[i].getReal(), (double)interpolator.getInterpolatedState(interpolator.getCurrentState().getTime()).getState()[i].getReal(), (double)epsilon);
        }
    }

    @Test
    public abstract void interpolationInside();

    protected <T extends RealFieldElement<T>> void doInterpolationInside(Field<T> field, double epsilonSin, double epsilonCos) {
        RungeKuttaFieldStepInterpolator<T> interpolator = this.setUpInterpolator(field, new SinCos<T>(field), 0.0, new double[]{0.0, 1.0}, 0.0125);
        int n = 100;
        double maxErrorSin = 0.0;
        double maxErrorCos = 0.0;
        for (int i = 0; i <= n; ++i) {
            RealFieldElement t = (RealFieldElement)((RealFieldElement)((RealFieldElement)interpolator.getPreviousState().getTime().multiply(n - i)).add(interpolator.getCurrentState().getTime().multiply(i))).divide((double)n);
            FieldODEStateAndDerivative state = interpolator.getInterpolatedState(t);
            maxErrorSin = FastMath.max((double)maxErrorSin, (double)((RealFieldElement)((RealFieldElement)state.getState()[0].subtract(t.sin())).abs()).getReal());
            maxErrorCos = FastMath.max((double)maxErrorCos, (double)((RealFieldElement)((RealFieldElement)state.getState()[1].subtract(t.cos())).abs()).getReal());
        }
        Assert.assertEquals((double)0.0, (double)maxErrorSin, (double)epsilonSin);
        Assert.assertEquals((double)0.0, (double)maxErrorCos, (double)epsilonCos);
    }

    @Test
    public abstract void nonFieldInterpolatorConsistency();

    protected <T extends RealFieldElement<T>> void doNonFieldInterpolatorConsistency(Field<T> field, double epsilonSin, double epsilonCos, double epsilonSinDot, double epsilonCosDot) {
        SinCos<T> eqn = new SinCos<T>(field);
        RungeKuttaFieldStepInterpolator<T> fieldInterpolator = this.setUpInterpolator(field, eqn, 0.0, new double[]{0.0, 1.0}, 0.125);
        RungeKuttaStepInterpolator regularInterpolator = this.convertInterpolator(fieldInterpolator, eqn);
        int n = 100;
        double maxErrorSin = 0.0;
        double maxErrorCos = 0.0;
        double maxErrorSinDot = 0.0;
        double maxErrorCosDot = 0.0;
        for (int i = 0; i <= n; ++i) {
            RealFieldElement t = (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldInterpolator.getPreviousState().getTime().multiply(n - i)).add(fieldInterpolator.getCurrentState().getTime().multiply(i))).divide((double)n);
            FieldODEStateAndDerivative state = fieldInterpolator.getInterpolatedState(t);
            RealFieldElement[] fieldY = state.getState();
            RealFieldElement[] fieldYDot = state.getDerivative();
            regularInterpolator.setInterpolatedTime(t.getReal());
            double[] regularY = regularInterpolator.getInterpolatedState();
            double[] regularYDot = regularInterpolator.getInterpolatedDerivatives();
            maxErrorSin = FastMath.max((double)maxErrorSin, (double)((RealFieldElement)((RealFieldElement)fieldY[0].subtract(regularY[0])).abs()).getReal());
            maxErrorCos = FastMath.max((double)maxErrorCos, (double)((RealFieldElement)((RealFieldElement)fieldY[1].subtract(regularY[1])).abs()).getReal());
            maxErrorSinDot = FastMath.max((double)maxErrorSinDot, (double)((RealFieldElement)((RealFieldElement)fieldYDot[0].subtract(regularYDot[0])).abs()).getReal());
            maxErrorCosDot = FastMath.max((double)maxErrorCosDot, (double)((RealFieldElement)((RealFieldElement)fieldYDot[1].subtract(regularYDot[1])).abs()).getReal());
        }
        Assert.assertEquals((double)0.0, (double)maxErrorSin, (double)epsilonSin);
        Assert.assertEquals((double)0.0, (double)maxErrorCos, (double)epsilonCos);
        Assert.assertEquals((double)0.0, (double)maxErrorSinDot, (double)epsilonSinDot);
        Assert.assertEquals((double)0.0, (double)maxErrorCosDot, (double)epsilonCosDot);
    }

    private <T extends RealFieldElement<T>> RungeKuttaFieldStepInterpolator<T> setUpInterpolator(Field<T> field, FirstOrderFieldDifferentialEquations<T> eqn, double t0, double[] y0, double t1) {
        FieldButcherArrayProvider<T> provider = this.createButcherArrayProvider(field);
        RealFieldElement[][] a = provider.getA();
        RealFieldElement[] b = provider.getB();
        RealFieldElement[] c = provider.getC();
        RealFieldElement t = (RealFieldElement)((RealFieldElement)field.getZero()).add(t0);
        RealFieldElement[] fieldY = (RealFieldElement[])MathArrays.buildArray(field, (int)eqn.getDimension());
        RealFieldElement[][] fieldYDotK = (RealFieldElement[][])MathArrays.buildArray(field, (int)b.length, (int)-1);
        for (int i = 0; i < y0.length; ++i) {
            fieldY[i] = (RealFieldElement)((RealFieldElement)field.getZero()).add(y0[i]);
        }
        fieldYDotK[0] = eqn.computeDerivatives(t, fieldY);
        FieldODEStateAndDerivative s0 = new FieldODEStateAndDerivative(t, fieldY, fieldYDotK[0]);
        RealFieldElement h = (RealFieldElement)((RealFieldElement)field.getZero()).add(t1 - t0);
        for (int k = 0; k < a.length; ++k) {
            for (int i = 0; i < y0.length; ++i) {
                fieldY[i] = (RealFieldElement)((RealFieldElement)field.getZero()).add(y0[i]);
                for (int s = 0; s <= k; ++s) {
                    fieldY[i] = (RealFieldElement)fieldY[i].add(h.multiply(a[k][s].multiply((Object)fieldYDotK[s][i])));
                }
            }
            fieldYDotK[k + 1] = eqn.computeDerivatives((RealFieldElement)((RealFieldElement)h.multiply((Object)c[k])).add(t0), fieldY);
        }
        t = (RealFieldElement)((RealFieldElement)field.getZero()).add(t1);
        for (int i = 0; i < y0.length; ++i) {
            fieldY[i] = (RealFieldElement)((RealFieldElement)field.getZero()).add(y0[i]);
            for (int s = 0; s < b.length; ++s) {
                fieldY[i] = (RealFieldElement)fieldY[i].add(h.multiply(b[s].multiply((Object)fieldYDotK[s][i])));
            }
        }
        FieldODEStateAndDerivative s1 = new FieldODEStateAndDerivative(t, fieldY, eqn.computeDerivatives(t, fieldY));
        return this.createInterpolator(field, t1 > t0, fieldYDotK, s0, s1, s0, s1, new FieldExpandableODE(eqn).getMapper());
    }

    private <T extends RealFieldElement<T>> RungeKuttaStepInterpolator convertInterpolator(final RungeKuttaFieldStepInterpolator<T> fieldInterpolator, final FirstOrderFieldDifferentialEquations<T> eqn) {
        RungeKuttaStepInterpolator regularInterpolator = null;
        try {
            String interpolatorName = fieldInterpolator.getClass().getName();
            String integratorName = interpolatorName.replaceAll("Field", "");
            Class<?> clz = Class.forName(integratorName);
            regularInterpolator = (RungeKuttaStepInterpolator)clz.newInstance();
            Object yDotArray = null;
            java.lang.reflect.Field fYD = RungeKuttaFieldStepInterpolator.class.getDeclaredField("yDotK");
            fYD.setAccessible(true);
            RealFieldElement[][] fieldYDotk = (RealFieldElement[][])fYD.get(fieldInterpolator);
            yDotArray = new double[fieldYDotk.length][];
            for (int i = 0; i < ((double[][])yDotArray).length; ++i) {
                yDotArray[i] = new double[fieldYDotk[i].length];
                for (int j = 0; j < yDotArray[i].length; ++j) {
                    yDotArray[i][j] = fieldYDotk[i][j].getReal();
                }
            }
            double[] y = new double[yDotArray[0].length];
            EquationsMapper primaryMapper = null;
            EquationsMapper[] secondaryMappers = null;
            java.lang.reflect.Field fMapper = AbstractFieldStepInterpolator.class.getDeclaredField("mapper");
            fMapper.setAccessible(true);
            FieldEquationsMapper mapper = (FieldEquationsMapper)fMapper.get(fieldInterpolator);
            java.lang.reflect.Field fStart = FieldEquationsMapper.class.getDeclaredField("start");
            fStart.setAccessible(true);
            int[] start = (int[])fStart.get(mapper);
            primaryMapper = new EquationsMapper(start[0], start[1]);
            secondaryMappers = new EquationsMapper[mapper.getNumberOfEquations() - 1];
            for (int i = 0; i < secondaryMappers.length; ++i) {
                secondaryMappers[i] = new EquationsMapper(start[i + 1], start[i + 2]);
            }
            AbstractIntegrator dummyIntegrator = new AbstractIntegrator("dummy"){

                public void integrate(ExpandableStatefulODE equations, double t) {
                    Assert.fail((String)"this method should not be called");
                }

                public void computeDerivatives(double t, double[] y, double[] yDot) {
                    RealFieldElement fieldT = (RealFieldElement)((RealFieldElement)fieldInterpolator.getCurrentState().getTime().getField().getZero()).add(t);
                    RealFieldElement[] fieldY = (RealFieldElement[])MathArrays.buildArray((Field)fieldInterpolator.getCurrentState().getTime().getField(), (int)y.length);
                    for (int i = 0; i < y.length; ++i) {
                        fieldY[i] = (RealFieldElement)((RealFieldElement)fieldInterpolator.getCurrentState().getTime().getField().getZero()).add(y[i]);
                    }
                    RealFieldElement[] fieldYDot = eqn.computeDerivatives(fieldT, fieldY);
                    for (int i = 0; i < yDot.length; ++i) {
                        yDot[i] = fieldYDot[i].getReal();
                    }
                }
            };
            regularInterpolator.reinitialize(dummyIntegrator, y, yDotArray, fieldInterpolator.isForward(), primaryMapper, secondaryMappers);
            RealFieldElement[] fieldPreviousY = fieldInterpolator.getPreviousState().getState();
            for (int i = 0; i < y.length; ++i) {
                y[i] = fieldPreviousY[i].getReal();
            }
            regularInterpolator.storeTime(fieldInterpolator.getPreviousState().getTime().getReal());
            regularInterpolator.shift();
            RealFieldElement[] fieldCurrentY = fieldInterpolator.getCurrentState().getState();
            for (int i = 0; i < y.length; ++i) {
                y[i] = fieldCurrentY[i].getReal();
            }
            regularInterpolator.storeTime(fieldInterpolator.getCurrentState().getTime().getReal());
        }
        catch (ClassNotFoundException cnfe) {
            Assert.fail((String)cnfe.getLocalizedMessage());
        }
        catch (InstantiationException ie) {
            Assert.fail((String)ie.getLocalizedMessage());
        }
        catch (IllegalAccessException iae) {
            Assert.fail((String)iae.getLocalizedMessage());
        }
        catch (NoSuchFieldException nsfe) {
            Assert.fail((String)nsfe.getLocalizedMessage());
        }
        catch (IllegalArgumentException iae) {
            Assert.fail((String)iae.getLocalizedMessage());
        }
        return regularInterpolator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SinCos<T extends RealFieldElement<T>>
    implements FirstOrderFieldDifferentialEquations<T> {
        private final Field<T> field;

        protected SinCos(Field<T> field) {
            this.field = field;
        }

        public int getDimension() {
            return 2;
        }

        public void init(T t0, T[] y0, T finalTime) {
        }

        public T[] computeDerivatives(T t, T[] y) {
            RealFieldElement[] yDot = (RealFieldElement[])MathArrays.buildArray(this.field, (int)2);
            yDot[0] = y[1];
            yDot[1] = (RealFieldElement)y[0].negate();
            return yDot;
        }
    }
}

