/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive;

import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.junit.Assert;
import org.junit.Test;

public class AbstractUnivariateStatisticTest {
    protected double[] testArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
    protected double[] testWeightsArray = new double[]{0.3, 0.2, 1.3, 1.1, 1.0, 1.8};
    protected double[] testNegativeWeightsArray = new double[]{-0.3, 0.2, -1.3, 1.1, 1.0, 1.8};
    protected double[] nullArray = null;
    protected double[] singletonArray = new double[]{0.0};
    protected Mean testStatistic = new Mean();

    @Test
    public void testTestPositive() {
        for (int j = 0; j < 6; ++j) {
            for (int i = 1; i < 7 - j; ++i) {
                Assert.assertTrue((boolean)this.testStatistic.test(this.testArray, 0, i));
            }
        }
        Assert.assertTrue((boolean)this.testStatistic.test(this.singletonArray, 0, 1));
        Assert.assertTrue((boolean)this.testStatistic.test(this.singletonArray, 0, 0, true));
    }

    @Test
    public void testTestNegative() {
        Assert.assertFalse((boolean)this.testStatistic.test(this.singletonArray, 0, 0));
        Assert.assertFalse((boolean)this.testStatistic.test(this.testArray, 0, 0));
        try {
            this.testStatistic.test(this.singletonArray, 2, 1);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.test(this.testArray, 0, 7);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.test(this.testArray, -1, 1);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.test(this.testArray, 0, -1);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.test(this.nullArray, 0, 1);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.test(this.testArray, this.nullArray, 0, 1);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.test(this.singletonArray, this.testWeightsArray, 0, 1);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.test(this.testArray, this.testNegativeWeightsArray, 0, 6);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }
}

