/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.io;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ExtendedBaseRules;
import org.apache.commons.digester.NodeCreateRule;
import org.apache.commons.digester.ObjectCreateRule;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.SetNextRule;
import org.apache.commons.digester.SetPropertiesRule;
import org.apache.commons.digester.WithDefaultsRulesWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.PathResolver;
import org.apache.commons.scxml.SCXMLHelper;
import org.apache.commons.scxml.env.URLResolver;
import org.apache.commons.scxml.io.ModelUpdater;
import org.apache.commons.scxml.model.Action;
import org.apache.commons.scxml.model.Assign;
import org.apache.commons.scxml.model.Cancel;
import org.apache.commons.scxml.model.CustomAction;
import org.apache.commons.scxml.model.Data;
import org.apache.commons.scxml.model.Datamodel;
import org.apache.commons.scxml.model.Else;
import org.apache.commons.scxml.model.ElseIf;
import org.apache.commons.scxml.model.Event;
import org.apache.commons.scxml.model.Executable;
import org.apache.commons.scxml.model.Exit;
import org.apache.commons.scxml.model.ExternalContent;
import org.apache.commons.scxml.model.Final;
import org.apache.commons.scxml.model.Finalize;
import org.apache.commons.scxml.model.History;
import org.apache.commons.scxml.model.If;
import org.apache.commons.scxml.model.Initial;
import org.apache.commons.scxml.model.Invoke;
import org.apache.commons.scxml.model.ModelException;
import org.apache.commons.scxml.model.NamespacePrefixesHolder;
import org.apache.commons.scxml.model.OnEntry;
import org.apache.commons.scxml.model.OnExit;
import org.apache.commons.scxml.model.Parallel;
import org.apache.commons.scxml.model.Param;
import org.apache.commons.scxml.model.PathResolverHolder;
import org.apache.commons.scxml.model.SCXML;
import org.apache.commons.scxml.model.Send;
import org.apache.commons.scxml.model.State;
import org.apache.commons.scxml.model.Transition;
import org.apache.commons.scxml.model.TransitionTarget;
import org.apache.commons.scxml.model.Var;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class SCXMLParser {
    private static final String NAMESPACE_SCXML = "http://www.w3.org/2005/07/scxml";
    private static final String NAMESPACE_COMMONS_SCXML = "http://commons.apache.org/scxml";
    private static final String XP_SM = "scxml";
    private static final String XP_SM_ST = "scxml/state";
    private static final String XP_SM_PAR = "scxml/parallel";
    private static final String XP_SM_FIN = "scxml/final";
    private static final String XPU_ST_ST = "!*/state/state";
    private static final String XPU_ST_FIN = "!*/state/final";
    private static final String XPU_PAR_ST = "!*/parallel/state";
    private static final String XPU_ST_PAR = "!*/state/parallel";
    private static final String XPU_IF = "!*/if";
    private static final String XPU_ONEN = "!*/onentry";
    private static final String XPU_ONEX = "!*/onexit";
    private static final String XPU_TR = "!*/transition";
    private static final String XPU_FIN = "!*/finalize";
    private static final String XPF_ONEN = "/onentry";
    private static final String XPF_ONEX = "/onexit";
    private static final String XPF_DM = "/datamodel";
    private static final String XPF_DATA = "/data";
    private static final String XPF_INI = "/initial";
    private static final String XPF_INV = "/invoke";
    private static final String XPF_PRM = "/param";
    private static final String XPF_FIN = "/finalize";
    private static final String XPF_HIST = "/history";
    private static final String XPF_TR = "/transition";
    private static final String XPF_EXT = "/exit";
    private static final String XPF_ASN = "/assign";
    private static final String XPF_EVT = "/event";
    private static final String XPF_SND = "/send";
    private static final String XPF_CAN = "/cancel";
    private static final String XPF_EIF = "/elseif";
    private static final String XPF_ELS = "/else";
    private static final String XPF_VAR = "/var";
    private static final String XPF_LOG = "/log";
    private static final String ERR_NULL_URL = "Cannot parse null URL";
    private static final String ERR_NULL_PATH = "Cannot parse null URL";
    private static final String ERR_NULL_ISRC = "Cannot parse null URL";
    private static final String ERR_DOC_PARSE_FAIL = "Error parsing SCXML document: \"{0}\", with message: \"{1}\"\n";
    private static final String ERR_ISRC_PARSE_FAIL = "Could not parse SCXML InputSource";
    private static final String ERR_PARSER_CFG_DATA = "XML Parser misconfiguration, error registering <data> element rule";
    private static final String ERR_PARSER_CFG_SEND = "XML Parser misconfiguration, error registering <send> element rule";
    private static final String ERR_PARSER_CFG_CUSTOM = "XML Parser misconfiguration, error registering custom action rules";
    private static final String ERR_CUSTOM_ACTION_TYPE = "Custom actions list contained unknown object (not a Commons SCXML Action subtype)";
    private static final String ERR_STATE_SRC = "Source attribute in <state src=\"{0}\"> cannot be parsed";
    private static final String ERR_STATE_SRC_FRAGMENT = "URI Fragment in <state src=\"{0}\"> is an unknown state in referenced document";
    private static final String ERR_STATE_SRC_FRAGMENT_TARGET = "URI Fragment in <state src=\"{0}\"> does not point to a <state> or <final>";
    private static final String STR_SLASH = "/";
    static /* synthetic */ Class class$org$apache$commons$scxml$model$ExternalContent;

    public static SCXML parse(URL scxmlURL, ErrorHandler errHandler) throws IOException, SAXException, ModelException {
        if (scxmlURL == null) {
            throw new IllegalArgumentException("Cannot parse null URL");
        }
        return SCXMLParser.parse(scxmlURL, errHandler, null);
    }

    public static SCXML parse(String documentRealPath, ErrorHandler errHandler, PathResolver pathResolver) throws IOException, SAXException, ModelException {
        return SCXMLParser.parse(documentRealPath, errHandler, pathResolver, null);
    }

    public static SCXML parse(InputSource documentInputSource, ErrorHandler errHandler) throws IOException, SAXException, ModelException {
        if (documentInputSource == null) {
            throw new IllegalArgumentException("Cannot parse null URL");
        }
        return SCXMLParser.parse(documentInputSource, errHandler, null);
    }

    public static SCXML parse(URL scxmlURL, ErrorHandler errHandler, List customActions) throws IOException, SAXException, ModelException {
        SCXML scxml = null;
        Digester scxmlParser = SCXMLParser.newInstance(null, new URLResolver(scxmlURL), customActions);
        scxmlParser.setErrorHandler(errHandler);
        try {
            scxml = (SCXML)scxmlParser.parse(scxmlURL.toString());
        }
        catch (RuntimeException rte) {
            MessageFormat msgFormat = new MessageFormat(ERR_DOC_PARSE_FAIL);
            String errMsg = msgFormat.format(new Object[]{String.valueOf(scxmlURL), rte.getMessage()});
            Log log = LogFactory.getLog((Class)SCXMLParser.class);
            log.error((Object)errMsg, (Throwable)rte);
            throw rte;
        }
        if (scxml != null) {
            ModelUpdater.updateSCXML(scxml);
        }
        return scxml;
    }

    public static SCXML parse(String documentRealPath, ErrorHandler errHandler, PathResolver pathResolver, List customActions) throws IOException, SAXException, ModelException {
        if (documentRealPath == null) {
            throw new IllegalArgumentException("Cannot parse null URL");
        }
        SCXML scxml = null;
        Digester scxmlParser = SCXMLParser.newInstance(null, pathResolver, customActions);
        scxmlParser.setErrorHandler(errHandler);
        try {
            scxml = (SCXML)scxmlParser.parse(documentRealPath);
        }
        catch (RuntimeException rte) {
            MessageFormat msgFormat = new MessageFormat(ERR_DOC_PARSE_FAIL);
            String errMsg = msgFormat.format(new Object[]{documentRealPath, rte.getMessage()});
            Log log = LogFactory.getLog((Class)SCXMLParser.class);
            log.error((Object)errMsg, (Throwable)rte);
            throw rte;
        }
        if (scxml != null) {
            ModelUpdater.updateSCXML(scxml);
        }
        return scxml;
    }

    public static SCXML parse(InputSource documentInputSource, ErrorHandler errHandler, List customActions) throws IOException, SAXException, ModelException {
        Digester scxmlParser = SCXMLParser.newInstance(null, null, customActions);
        scxmlParser.setErrorHandler(errHandler);
        SCXML scxml = null;
        try {
            scxml = (SCXML)scxmlParser.parse(documentInputSource);
        }
        catch (RuntimeException rte) {
            Log log = LogFactory.getLog((Class)SCXMLParser.class);
            log.error((Object)ERR_ISRC_PARSE_FAIL, (Throwable)rte);
            throw rte;
        }
        if (scxml != null) {
            ModelUpdater.updateSCXML(scxml);
        }
        return scxml;
    }

    public static Digester newInstance() {
        return SCXMLParser.newInstance(null, null, null);
    }

    public static Digester newInstance(PathResolver pr) {
        return SCXMLParser.newInstance(null, pr, null);
    }

    public static Digester newInstance(SCXML scxml, PathResolver pr) {
        return SCXMLParser.newInstance(scxml, pr, null);
    }

    public static Digester newInstance(SCXML scxml, PathResolver pr, List customActions) {
        Digester digester = new Digester();
        digester.setNamespaceAware(true);
        WithDefaultsRulesWrapper rules = new WithDefaultsRulesWrapper((Rules)SCXMLParser.initRules(scxml, pr, customActions));
        rules.addDefault((Rule)new IgnoredElementRule());
        digester.setRules((Rules)rules);
        return digester;
    }

    public static void updateSCXML(SCXML scxml) throws ModelException {
        ModelUpdater.updateSCXML(scxml);
    }

    private static ExtendedBaseRules initRules(SCXML scxml, PathResolver pr, List customActions) {
        ExtendedBaseRules scxmlRules = new ExtendedBaseRules();
        scxmlRules.setNamespaceURI(NAMESPACE_SCXML);
        scxmlRules.add(XP_SM, (Rule)new ObjectCreateRule(SCXML.class));
        scxmlRules.add(XP_SM, (Rule)new SetPropertiesRule());
        scxmlRules.add(XP_SM, (Rule)new SetCurrentNamespacesRule());
        SCXMLParser.addDatamodelRules("scxml/datamodel", scxmlRules, scxml, pr);
        SCXMLParser.addStateRules(XP_SM_ST, scxmlRules, customActions, scxml, pr);
        SCXMLParser.addStateRules(XPU_ST_ST, scxmlRules, customActions, scxml, pr);
        SCXMLParser.addStateRules(XPU_PAR_ST, scxmlRules, customActions, scxml, pr);
        SCXMLParser.addParallelRules(XP_SM_PAR, scxmlRules, customActions, scxml, pr);
        SCXMLParser.addParallelRules(XPU_ST_PAR, scxmlRules, customActions, scxml, pr);
        SCXMLParser.addFinalRules(XP_SM_FIN, scxmlRules, customActions, scxml, pr);
        SCXMLParser.addFinalRules(XPU_ST_FIN, scxmlRules, customActions, scxml, pr);
        SCXMLParser.addIfRules(XPU_IF, scxmlRules, pr, customActions);
        SCXMLParser.addCustomActionRules(XPU_ONEN, scxmlRules, customActions);
        SCXMLParser.addCustomActionRules(XPU_ONEX, scxmlRules, customActions);
        SCXMLParser.addCustomActionRules(XPU_TR, scxmlRules, customActions);
        SCXMLParser.addCustomActionRules(XPU_IF, scxmlRules, customActions);
        SCXMLParser.addCustomActionRules(XPU_FIN, scxmlRules, customActions);
        return scxmlRules;
    }

    private static void addStateRules(String xp, ExtendedBaseRules scxmlRules, List customActions, SCXML scxml, PathResolver pr) {
        scxmlRules.add(xp, (Rule)new ObjectCreateRule(State.class));
        SCXMLParser.addStatePropertiesRules(xp, scxmlRules, customActions, pr, scxml);
        SCXMLParser.addDatamodelRules(xp + XPF_DM, scxmlRules, scxml, pr);
        SCXMLParser.addInvokeRules(xp + XPF_INV, scxmlRules, customActions, pr, scxml);
        SCXMLParser.addInitialRules(xp + XPF_INI, scxmlRules, customActions, pr, scxml);
        SCXMLParser.addHistoryRules(xp + XPF_HIST, scxmlRules, customActions, pr, scxml);
        SCXMLParser.addTransitionRules(xp + XPF_TR, scxmlRules, "addTransition", pr, customActions);
        SCXMLParser.addHandlerRules(xp, scxmlRules, pr, customActions);
        scxmlRules.add(xp, (Rule)new UpdateModelRule(scxml));
        scxmlRules.add(xp, (Rule)new SetNextRule("addChild"));
    }

    private static void addParallelRules(String xp, ExtendedBaseRules scxmlRules, List customActions, SCXML scxml, PathResolver pr) {
        SCXMLParser.addSimpleRulesTuple(xp, scxmlRules, Parallel.class, null, null, "addChild");
        SCXMLParser.addDatamodelRules(xp + XPF_DM, scxmlRules, scxml, pr);
        SCXMLParser.addTransitionRules(xp + XPF_TR, scxmlRules, "addTransition", pr, customActions);
        SCXMLParser.addHandlerRules(xp, scxmlRules, pr, customActions);
        scxmlRules.add(xp, (Rule)new UpdateModelRule(scxml));
    }

    private static void addFinalRules(String xp, ExtendedBaseRules scxmlRules, List customActions, SCXML scxml, PathResolver pr) {
        SCXMLParser.addSimpleRulesTuple(xp, scxmlRules, Final.class, null, null, "addChild");
        SCXMLParser.addHandlerRules(xp, scxmlRules, pr, customActions);
        scxmlRules.add(xp, (Rule)new UpdateModelRule(scxml));
    }

    private static void addStatePropertiesRules(String xp, ExtendedBaseRules scxmlRules, List customActions, PathResolver pr, SCXML scxml) {
        scxmlRules.add(xp, (Rule)new SetPropertiesRule(new String[]{"id", "final", "initial"}, new String[]{"id", "final", "first"}));
        scxmlRules.add(xp, (Rule)new DigestSrcAttributeRule(scxml, customActions, pr));
    }

    private static void addDatamodelRules(String xp, ExtendedBaseRules scxmlRules, SCXML scxml, PathResolver pr) {
        scxmlRules.add(xp, (Rule)new ObjectCreateRule(Datamodel.class));
        scxmlRules.add(xp + XPF_DATA, (Rule)new ObjectCreateRule(Data.class));
        scxmlRules.add(xp + XPF_DATA, (Rule)new SetPropertiesRule());
        scxmlRules.add(xp + XPF_DATA, (Rule)new SetCurrentNamespacesRule());
        scxmlRules.add(xp + XPF_DATA, (Rule)new SetNextRule("addData"));
        try {
            scxmlRules.add(xp + XPF_DATA, (Rule)new ParseDataRule(pr));
        }
        catch (ParserConfigurationException pce) {
            Log log = LogFactory.getLog((Class)SCXMLParser.class);
            log.error((Object)ERR_PARSER_CFG_DATA, (Throwable)pce);
        }
        scxmlRules.add(xp, (Rule)new SetNextRule("setDatamodel"));
    }

    private static void addInvokeRules(String xp, ExtendedBaseRules scxmlRules, List customActions, PathResolver pr, SCXML scxml) {
        scxmlRules.add(xp, (Rule)new ObjectCreateRule(Invoke.class));
        scxmlRules.add(xp, (Rule)new SetPropertiesRule());
        scxmlRules.add(xp, (Rule)new SetCurrentNamespacesRule());
        scxmlRules.add(xp, (Rule)new SetPathResolverRule(pr));
        scxmlRules.add(xp + XPF_PRM, (Rule)new ObjectCreateRule(Param.class));
        scxmlRules.add(xp + XPF_PRM, (Rule)new SetPropertiesRule());
        scxmlRules.add(xp + XPF_PRM, (Rule)new SetCurrentNamespacesRule());
        scxmlRules.add(xp + XPF_PRM, (Rule)new SetNextRule("addParam"));
        scxmlRules.add(xp + XPF_FIN, (Rule)new ObjectCreateRule(Finalize.class));
        scxmlRules.add(xp + XPF_FIN, (Rule)new UpdateFinalizeRule());
        SCXMLParser.addActionRules(xp + XPF_FIN, scxmlRules, pr, customActions);
        scxmlRules.add(xp + XPF_FIN, (Rule)new SetNextRule("setFinalize"));
        scxmlRules.add(xp, (Rule)new SetNextRule("setInvoke"));
    }

    private static void addInitialRules(String xp, ExtendedBaseRules scxmlRules, List customActions, PathResolver pr, SCXML scxml) {
        scxmlRules.add(xp, (Rule)new ObjectCreateRule(Initial.class));
        SCXMLParser.addPseudoStatePropertiesRules(xp, scxmlRules, customActions, pr, scxml);
        scxmlRules.add(xp, (Rule)new UpdateModelRule(scxml));
        SCXMLParser.addTransitionRules(xp + XPF_TR, scxmlRules, "setTransition", pr, customActions);
        scxmlRules.add(xp, (Rule)new SetNextRule("setInitial"));
    }

    private static void addHistoryRules(String xp, ExtendedBaseRules scxmlRules, List customActions, PathResolver pr, SCXML scxml) {
        scxmlRules.add(xp, (Rule)new ObjectCreateRule(History.class));
        SCXMLParser.addPseudoStatePropertiesRules(xp, scxmlRules, customActions, pr, scxml);
        scxmlRules.add(xp, (Rule)new UpdateModelRule(scxml));
        scxmlRules.add(xp, (Rule)new SetPropertiesRule(new String[]{"type"}, new String[]{"type"}));
        SCXMLParser.addTransitionRules(xp + XPF_TR, scxmlRules, "setTransition", pr, customActions);
        scxmlRules.add(xp, (Rule)new SetNextRule("addHistory"));
    }

    private static void addPseudoStatePropertiesRules(String xp, ExtendedBaseRules scxmlRules, List customActions, PathResolver pr, SCXML scxml) {
        scxmlRules.add(xp, (Rule)new SetPropertiesRule(new String[]{"id"}, new String[]{"id"}));
        scxmlRules.add(xp, (Rule)new DigestSrcAttributeRule(scxml, customActions, pr));
    }

    private static void addTransitionRules(String xp, ExtendedBaseRules scxmlRules, String setNextMethod, PathResolver pr, List customActions) {
        scxmlRules.add(xp, (Rule)new ObjectCreateRule(Transition.class));
        scxmlRules.add(xp, (Rule)new SetPropertiesRule(new String[]{"event", "cond", "target"}, new String[]{"event", "cond", "next"}));
        scxmlRules.add(xp, (Rule)new SetCurrentNamespacesRule());
        SCXMLParser.addActionRules(xp, scxmlRules, pr, customActions);
        scxmlRules.setNamespaceURI(NAMESPACE_COMMONS_SCXML);
        scxmlRules.add(xp + XPF_EXT, new Rule(){

            public void end(String namespace, String name) {
                Transition t = (Transition)this.getDigester().peek(1);
                TransitionTarget tt = (TransitionTarget)this.getDigester().peek(2);
                if (tt instanceof Initial) {
                    Log log = LogFactory.getLog((Class)(class$org$apache$commons$scxml$io$SCXMLParser == null ? (class$org$apache$commons$scxml$io$SCXMLParser = SCXMLParser.class$("org.apache.commons.scxml.io.SCXMLParser")) : class$org$apache$commons$scxml$io$SCXMLParser));
                    log.warn((Object)"Ignored <exit> action in <initial>");
                } else {
                    State exitState = new State();
                    exitState.setFinal(true);
                    t.getTargets().add(exitState);
                }
            }
        });
        scxmlRules.setNamespaceURI(NAMESPACE_SCXML);
        scxmlRules.add(xp, (Rule)new SetNextRule(setNextMethod));
    }

    private static void addHandlerRules(String xp, ExtendedBaseRules scxmlRules, PathResolver pr, List customActions) {
        scxmlRules.add(xp + XPF_ONEN, (Rule)new ObjectCreateRule(OnEntry.class));
        SCXMLParser.addActionRules(xp + XPF_ONEN, scxmlRules, pr, customActions);
        scxmlRules.add(xp + XPF_ONEN, (Rule)new SetNextRule("setOnEntry"));
        scxmlRules.add(xp + XPF_ONEX, (Rule)new ObjectCreateRule(OnExit.class));
        SCXMLParser.addActionRules(xp + XPF_ONEX, scxmlRules, pr, customActions);
        scxmlRules.add(xp + XPF_ONEX, (Rule)new SetNextRule("setOnExit"));
    }

    private static void addActionRules(String xp, ExtendedBaseRules scxmlRules, PathResolver pr, List customActions) {
        SCXMLParser.addActionRulesTuple(xp + XPF_ASN, scxmlRules, Assign.class);
        scxmlRules.add(xp + XPF_ASN, (Rule)new SetPathResolverRule(pr));
        SCXMLParser.addActionRulesTuple(xp + XPF_EVT, scxmlRules, Event.class);
        SCXMLParser.addSendRulesTuple(xp + XPF_SND, scxmlRules);
        SCXMLParser.addActionRulesTuple(xp + XPF_CAN, scxmlRules, Cancel.class);
        SCXMLParser.addActionRulesTuple(xp + XPF_LOG, scxmlRules, org.apache.commons.scxml.model.Log.class);
        scxmlRules.setNamespaceURI(NAMESPACE_COMMONS_SCXML);
        SCXMLParser.addActionRulesTuple(xp + XPF_VAR, scxmlRules, Var.class);
        SCXMLParser.addActionRulesTuple(xp + XPF_EXT, scxmlRules, Exit.class);
        scxmlRules.setNamespaceURI(NAMESPACE_SCXML);
    }

    private static void addCustomActionRules(String xp, ExtendedBaseRules scxmlRules, List customActions) {
        if (customActions == null || customActions.size() == 0) {
            return;
        }
        for (int i = 0; i < customActions.size(); ++i) {
            Object item = customActions.get(i);
            if (item == null || !(item instanceof CustomAction)) {
                Log log = LogFactory.getLog((Class)(class$org$apache$commons$scxml$io$SCXMLParser == null ? SCXMLParser.class$("org.apache.commons.scxml.io.SCXMLParser") : class$org$apache$commons$scxml$io$SCXMLParser));
                log.warn((Object)ERR_CUSTOM_ACTION_TYPE);
                continue;
            }
            CustomAction ca = (CustomAction)item;
            scxmlRules.setNamespaceURI(ca.getNamespaceURI());
            String xpfLocalName = STR_SLASH + ca.getLocalName();
            Class klass = ca.getActionClass();
            if (SCXMLHelper.implementationOf(klass, class$org$apache$commons$scxml$model$ExternalContent == null ? SCXMLParser.class$("org.apache.commons.scxml.model.ExternalContent") : class$org$apache$commons$scxml$model$ExternalContent)) {
                SCXMLParser.addCustomActionRulesTuple(xp + xpfLocalName, scxmlRules, klass, true);
                continue;
            }
            SCXMLParser.addCustomActionRulesTuple(xp + xpfLocalName, scxmlRules, klass, false);
        }
        scxmlRules.setNamespaceURI(NAMESPACE_SCXML);
    }

    private static void addSendRulesTuple(String xp, ExtendedBaseRules scxmlRules) {
        SCXMLParser.addActionRulesTuple(xp, scxmlRules, Send.class);
        try {
            scxmlRules.add(xp, (Rule)new ParseExternalContentRule());
        }
        catch (ParserConfigurationException pce) {
            Log log = LogFactory.getLog((Class)SCXMLParser.class);
            log.error((Object)ERR_PARSER_CFG_SEND, (Throwable)pce);
        }
    }

    private static void addCustomActionRulesTuple(String xp, ExtendedBaseRules scxmlRules, Class klass, boolean bodyContent) {
        SCXMLParser.addActionRulesTuple(xp, scxmlRules, klass);
        if (bodyContent) {
            try {
                scxmlRules.add(xp, (Rule)new ParseExternalContentRule());
            }
            catch (ParserConfigurationException pce) {
                Log log = LogFactory.getLog((Class)SCXMLParser.class);
                log.error((Object)ERR_PARSER_CFG_CUSTOM, (Throwable)pce);
            }
        }
    }

    private static void addIfRules(String xp, ExtendedBaseRules scxmlRules, PathResolver pr, List customActions) {
        SCXMLParser.addActionRulesTuple(xp, scxmlRules, If.class);
        SCXMLParser.addActionRules(xp, scxmlRules, pr, customActions);
        SCXMLParser.addActionRulesTuple(xp + XPF_EIF, scxmlRules, ElseIf.class);
        SCXMLParser.addActionRulesTuple(xp + XPF_ELS, scxmlRules, Else.class);
    }

    private static void addActionRulesTuple(String xp, ExtendedBaseRules scxmlRules, Class klass) {
        SCXMLParser.addSimpleRulesTuple(xp, scxmlRules, klass, null, null, "addAction");
        scxmlRules.add(xp, (Rule)new SetExecutableParentRule());
        scxmlRules.add(xp, (Rule)new SetCurrentNamespacesRule());
    }

    private static void addSimpleRulesTuple(String xp, ExtendedBaseRules scxmlRules, Class klass, String[] args, String[] props, String addMethod) {
        scxmlRules.add(xp, (Rule)new ObjectCreateRule(klass));
        if (args == null) {
            scxmlRules.add(xp, (Rule)new SetPropertiesRule());
        } else {
            scxmlRules.add(xp, (Rule)new SetPropertiesRule(args, props));
        }
        scxmlRules.add(xp, (Rule)new SetNextRule(addMethod));
    }

    private SCXMLParser() {
    }

    private static class IgnoredElementRule
    extends Rule {
        private IgnoredElementRule() {
        }

        public final void begin(String namespace, String name, Attributes attributes) {
            Log log = LogFactory.getLog((Class)(class$org$apache$commons$scxml$io$SCXMLParser == null ? (class$org$apache$commons$scxml$io$SCXMLParser = SCXMLParser.class$("org.apache.commons.scxml.io.SCXMLParser")) : class$org$apache$commons$scxml$io$SCXMLParser));
            Locator l = this.digester.getDocumentLocator();
            String identifier = l.getSystemId();
            if (identifier == null) {
                identifier = l.getPublicId();
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Ignoring element <").append(name).append("> in namespace \"").append(namespace).append("\" at ").append(identifier).append(":").append(l.getLineNumber()).append(":").append(l.getColumnNumber()).append(" and digester match \"").append(this.digester.getMatch()).append("\"");
            log.warn((Object)sb.toString());
        }
    }

    private static class SetCurrentNamespacesRule
    extends Rule {
        private SetCurrentNamespacesRule() {
        }

        public final void begin(String namespace, String name, Attributes attributes) {
            NamespacePrefixesHolder nsHolder = (NamespacePrefixesHolder)this.getDigester().peek();
            nsHolder.setNamespaces(this.getDigester().getCurrentNamespaces());
        }
    }

    private static class UpdateFinalizeRule
    extends Rule {
        private UpdateFinalizeRule() {
        }

        public final void begin(String namespace, String name, Attributes attributes) {
            Finalize finalize = (Finalize)this.getDigester().peek();
            TransitionTarget tt = (TransitionTarget)this.getDigester().peek(2);
            finalize.setParent(tt);
        }
    }

    private static class SetPathResolverRule
    extends Rule {
        private PathResolver pr;

        SetPathResolverRule(PathResolver pr) {
            this.pr = pr;
        }

        public final void begin(String namespace, String name, Attributes attributes) {
            PathResolverHolder prHolder = (PathResolverHolder)this.getDigester().peek();
            prHolder.setPathResolver(this.pr);
        }
    }

    private static class DigestSrcAttributeRule
    extends Rule {
        private PathResolver pr;
        private SCXML root;
        private List customActions;

        DigestSrcAttributeRule(List customActions, PathResolver pr) {
            this.customActions = customActions;
            this.pr = pr;
        }

        DigestSrcAttributeRule(SCXML root, List customActions, PathResolver pr) {
            this.root = root;
            this.customActions = customActions;
            this.pr = pr;
        }

        public final void begin(String namespace, String name, Attributes attributes) throws ModelException {
            String path;
            String src = attributes.getValue("src");
            if (SCXMLHelper.isStringEmpty(src)) {
                return;
            }
            Digester digester = this.getDigester();
            SCXML scxml = (SCXML)digester.peek(digester.getCount() - 1);
            SCXML parent = this.root;
            if (parent == null) {
                parent = scxml;
            }
            PathResolver nextpr = null;
            if (this.pr == null) {
                path = src;
            } else {
                path = this.pr.resolvePath(src);
                nextpr = this.pr.getResolver(src);
            }
            String[] fragments = path.split("#", 2);
            String location = fragments[0];
            String fragment = null;
            if (fragments.length > 1) {
                fragment = fragments[1];
            }
            Digester externalSrcDigester = fragment != null ? SCXMLParser.newInstance(null, nextpr, this.customActions) : SCXMLParser.newInstance(parent, nextpr, this.customActions);
            SCXML externalSCXML = null;
            try {
                externalSCXML = (SCXML)externalSrcDigester.parse(location);
            }
            catch (Exception e) {
                MessageFormat msgFormat = new MessageFormat(SCXMLParser.ERR_STATE_SRC);
                String errMsg = msgFormat.format(new Object[]{path});
                throw new ModelException(errMsg + " : " + e.getMessage(), e);
            }
            if (externalSCXML == null) {
                return;
            }
            State s = (State)digester.peek();
            if (fragment == null) {
                Initial ini = new Initial();
                Transition t = new Transition();
                t.setNext(externalSCXML.getInitial());
                ini.setTransition(t);
                s.setInitial(ini);
                Map children = externalSCXML.getChildren();
                Iterator childIter = children.values().iterator();
                while (childIter.hasNext()) {
                    s.addChild((TransitionTarget)childIter.next());
                }
                s.setDatamodel(externalSCXML.getDatamodel());
            } else {
                Object source = externalSCXML.getTargets().get(fragment);
                if (source == null) {
                    MessageFormat msgFormat = new MessageFormat(SCXMLParser.ERR_STATE_SRC_FRAGMENT);
                    String errMsg = msgFormat.format(new Object[]{path});
                    throw new ModelException(errMsg);
                }
                if (source instanceof State) {
                    State include = (State)source;
                    s.setOnEntry(include.getOnEntry());
                    s.setOnExit(include.getOnExit());
                    s.setDatamodel(include.getDatamodel());
                    List histories = include.getHistory();
                    for (int i = 0; i < histories.size(); ++i) {
                        History h = (History)histories.get(i);
                        s.addHistory(h);
                        parent.addTarget(h);
                    }
                    Iterator childIter = include.getChildren().values().iterator();
                    while (childIter.hasNext()) {
                        TransitionTarget tt = (TransitionTarget)childIter.next();
                        s.addChild(tt);
                        parent.addTarget(tt);
                        DigestSrcAttributeRule.addTargets(parent, tt);
                    }
                    s.setInvoke(include.getInvoke());
                    s.setFinal(include.isFinal());
                    if (include.getInitial() != null) {
                        s.setInitial(include.getInitial());
                    }
                    Iterator transIter = include.getTransitionsList().iterator();
                    while (transIter.hasNext()) {
                        s.addTransition((Transition)transIter.next());
                    }
                } else {
                    MessageFormat msgFormat = new MessageFormat(SCXMLParser.ERR_STATE_SRC_FRAGMENT_TARGET);
                    String errMsg = msgFormat.format(new Object[]{path});
                    throw new ModelException(errMsg);
                }
            }
        }

        private static void addTargets(SCXML parent, TransitionTarget tt) {
            block4: {
                Iterator<Object> childIter;
                block3: {
                    Iterator histIter = tt.getHistory().iterator();
                    while (histIter.hasNext()) {
                        History h = (History)histIter.next();
                        parent.addTarget(h);
                    }
                    if (!(tt instanceof State)) break block3;
                    childIter = ((State)tt).getChildren().values().iterator();
                    while (childIter.hasNext()) {
                        TransitionTarget child = (TransitionTarget)childIter.next();
                        parent.addTarget(child);
                        DigestSrcAttributeRule.addTargets(parent, child);
                    }
                    break block4;
                }
                if (!(tt instanceof Parallel)) break block4;
                childIter = ((Parallel)tt).getChildren().iterator();
                while (childIter.hasNext()) {
                    TransitionTarget child = (TransitionTarget)childIter.next();
                    parent.addTarget(child);
                    DigestSrcAttributeRule.addTargets(parent, child);
                }
            }
        }
    }

    private static class ParseDataRule
    extends NodeCreateRule {
        private PathResolver pr;
        private String src;
        private String expr;
        private Node attrNode;

        ParseDataRule(PathResolver pr) throws ParserConfigurationException {
            this.pr = pr;
        }

        public final void begin(String namespace, String name, Attributes attributes) throws Exception {
            super.begin(namespace, name, attributes);
            this.src = attributes.getValue("src");
            this.expr = attributes.getValue("expr");
            if (!SCXMLHelper.isStringEmpty(this.src)) {
                String path = null;
                path = this.pr == null ? this.src : this.pr.resolvePath(this.src);
                try {
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbFactory.newDocumentBuilder();
                    this.attrNode = db.parse(path);
                }
                catch (Throwable t) {
                    Log log = LogFactory.getLog((Class)(class$org$apache$commons$scxml$io$SCXMLParser == null ? (class$org$apache$commons$scxml$io$SCXMLParser = SCXMLParser.class$("org.apache.commons.scxml.io.SCXMLParser")) : class$org$apache$commons$scxml$io$SCXMLParser));
                    log.error((Object)t.getMessage(), t);
                }
                return;
            }
        }

        public final void end(String namespace, String name) {
            Node bodyNode = (Node)this.getDigester().pop();
            Data data = (Data)this.getDigester().peek();
            if (!SCXMLHelper.isStringEmpty(this.src)) {
                data.setNode(this.attrNode);
            } else if (SCXMLHelper.isStringEmpty(this.expr)) {
                data.setNode(bodyNode);
            }
        }
    }

    private static class ParseExternalContentRule
    extends NodeCreateRule {
        ParseExternalContentRule() throws ParserConfigurationException {
        }

        public final void end(String namespace, String name) {
            Element bodyElement = (Element)this.getDigester().pop();
            NodeList childNodes = bodyElement.getChildNodes();
            List externalNodes = ((ExternalContent)this.getDigester().peek()).getExternalNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                externalNodes.add(childNodes.item(i));
            }
        }
    }

    private static class SetExecutableParentRule
    extends Rule {
        SetExecutableParentRule() {
        }

        public final void end(String namespace, String name) {
            Action child = (Action)this.getDigester().peek();
            for (int i = 1; i < this.getDigester().getCount() - 1; ++i) {
                Object ancestor = this.getDigester().peek(i);
                if (!(ancestor instanceof Executable)) continue;
                child.setParent((Executable)ancestor);
                return;
            }
        }
    }

    private static class UpdateModelRule
    extends Rule {
        private SCXML scxml;

        UpdateModelRule(SCXML scxml) {
            this.scxml = scxml;
        }

        public final void end(String namespace, String name) {
            if (this.scxml == null) {
                this.scxml = (SCXML)this.getDigester().peek(this.getDigester().getCount() - 1);
            }
            TransitionTarget tt = (TransitionTarget)this.getDigester().peek();
            this.scxml.addTarget(tt);
        }
    }
}

