/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import org.osgi.framework.BundleContext;

public class DeploymentAdminConfig {
    private static final String PREFIX = "org.apache.felix.deploymentadmin.";
    static final String KEY_STOP_UNAFFECTED_BUNDLE = "org.apache.felix.deploymentadmin.".concat("stopUnaffectedBundle");
    static final String KEY_STOP_UNAFFECTED_BUNDLES = "org.apache.felix.deploymentadmin.".concat("stopUnaffectedBundles");
    static final String KEY_ALLOW_FOREIGN_CUSTOMIZERS = "org.apache.felix.deploymentadmin.".concat("allowForeignCustomizers");
    static final boolean DEFAULT_STOP_UNAFFECTED_BUNDLES = true;
    static final boolean DEFAULT_ALLOW_FOREIGN_CUSTOMIZERS = false;
    private final boolean m_stopUnaffectedBundles;
    private final boolean m_allowForeignCustomizers;

    public DeploymentAdminConfig(BundleContext context) {
        String value = DeploymentAdminConfig.getFrameworkProperty(context, KEY_STOP_UNAFFECTED_BUNDLE);
        if (value == null) {
            value = DeploymentAdminConfig.getFrameworkProperty(context, KEY_STOP_UNAFFECTED_BUNDLES);
        }
        this.m_stopUnaffectedBundles = DeploymentAdminConfig.parseBoolean(value, true);
        value = DeploymentAdminConfig.getFrameworkProperty(context, KEY_ALLOW_FOREIGN_CUSTOMIZERS);
        this.m_allowForeignCustomizers = DeploymentAdminConfig.parseBoolean(value, false);
    }

    public boolean isAllowForeignCustomizers() {
        return this.m_allowForeignCustomizers;
    }

    public boolean isStopUnaffectedBundles() {
        return this.m_stopUnaffectedBundles;
    }

    private static boolean parseBoolean(String value, boolean dflt) {
        if (value == null || "".equals(value.trim())) {
            return dflt;
        }
        return Boolean.parseBoolean(value);
    }

    private static String getFrameworkProperty(BundleContext context, String key) {
        String prop = context.getProperty(key);
        if (prop == null) {
            prop = context.getProperty(key.toLowerCase());
        }
        return prop;
    }
}

