/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.threaddump.internal;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Date;

public final class ThreadWriter {
    public static final short NEW = 0;
    public static final short RUNNABLE = 1;
    public static final short BLOCKED = 2;
    public static final short WAITING = 3;
    public static final short TIMED_WAITING = 4;
    public static final short TERMINATED = 5;
    private static final String DATE = "{0,date,yyyy-MM-dd HH:mm:ss}";
    private static final String HEADER = "Full thread dump {0} ({1} {2}):";
    private static final String THREAD = "\"{0}\" {1}prio={2} tid=0x{3} nid=0x{4} {5,choice,0#new|1#runnable|2#waiting for monitor entry|3#in Object.wait()|4#timed_waiting|5#terminated}";
    private static final String THREAD_STATUS = "   java.lang.Thread.State: {0,choice,0#NEW|1#RUNNABLE|2#BLOCKED|3#WAITING (on object monitor)|4#TIMED_WAITING|5#TERMINATED}";
    private static final String STACKTRACE_ELEMENT = "\tat {0}";
    private final PrintWriter writer;

    public ThreadWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void printHeader() {
        this.println(DATE, new Object[]{new Date()});
        this.println(HEADER, ThreadWriter.getSystemProperties(new String[]{"java.vm.name", "java.runtime.version", "java.vm.info"}));
        this.printEmptyLine();
    }

    public void printThread(String name, boolean isDaemon, long priority, long id, short status) {
        String daemon = isDaemon ? "daemon " : "";
        this.println(THREAD, new Object[]{name, daemon, String.valueOf(priority), Long.toHexString(id), Integer.toHexString(-1), new Short(status)});
        this.println(THREAD_STATUS, new Object[]{new Short(status)});
    }

    public void printStackTrace(StackTraceElement[] stackTrace) {
        if (stackTrace != null) {
            for (int i = 0; i < stackTrace.length; ++i) {
                this.printStackTraceElement(stackTrace[i]);
            }
        }
    }

    public void printStackTraceElement(StackTraceElement element) {
        this.println(STACKTRACE_ELEMENT, new Object[]{element});
    }

    public void printEmptyLine() {
        this.writer.println();
    }

    public void println(String message) {
        this.writer.println(message);
    }

    public void println(String pattern, Object[] arguments) {
        String result = MessageFormat.format(pattern, arguments);
        this.writer.println(result);
    }

    private static Object[] getSystemProperties(String[] keys) {
        Object[] values = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            values[i] = System.getProperty(keys[i]);
        }
        return values;
    }
}

