/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.scriptconsole.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.IOUtils;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.plugins.scriptconsole.internal.LogWriter;
import org.apache.felix.webconsole.plugins.scriptconsole.internal.Logger;
import org.apache.felix.webconsole.plugins.scriptconsole.internal.ScriptEngineManager;
import org.apache.felix.webconsole.plugins.scriptconsole.internal.ScriptHelper;
import org.json.JSONException;
import org.json.JSONWriter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

class ScriptConsolePlugin
extends SimpleWebConsolePlugin {
    public static final String NAME = "sc";
    private static final String TITLE = "%script.title";
    private static final String CATEGORY = "Web Console";
    private static final String[] CSS = new String[]{"/res/ui/codemirror/lib/codemirror.css", "/res/ui/script-console.css"};
    private final String TEMPLATE;
    private final Logger log;
    private final ScriptEngineManager scriptEngineManager;
    private final ServiceRegistration registration;

    public ScriptConsolePlugin(BundleContext bundleContext, Logger logger, ScriptEngineManager scriptEngineManager) {
        super(NAME, TITLE, ScriptConsolePlugin.processFileNames(CSS));
        this.log = logger;
        this.scriptEngineManager = scriptEngineManager;
        this.TEMPLATE = this.readTemplateFile("/templates/script-console.html");
        super.activate(bundleContext);
        Properties props = new Properties();
        props.put("service.vendor", "Apache Software Foundation");
        props.put("service.description", "Script Console Web Console Plugin");
        props.put("felix.webconsole.label", NAME);
        props.put("felix.webconsole.title", "Script Console");
        this.registration = this.getBundleContext().registerService(Servlet.class.getName(), (Object)this, (Dictionary)props);
    }

    public String getCategory() {
        return CATEGORY;
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        DefaultVariableResolver varResolver = (DefaultVariableResolver)WebConsoleUtil.getVariableResolver((ServletRequest)request);
        varResolver.put((Object)"__scriptConfig__", (Object)this.getScriptConfig());
        pw.println(this.TEMPLATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String contentType = this.getContentType(req);
        resp.setContentType(contentType);
        if (contentType.startsWith("text/")) {
            resp.setCharacterEncoding("UTF-8");
        }
        String script = this.getCodeValue(req);
        SimpleBindings bindings = new SimpleBindings();
        PrintWriter pw = resp.getWriter();
        ScriptHelper osgi = new ScriptHelper(this.getBundleContext());
        LogWriter errorWriter = new LogWriter(this.log);
        StringReader reader = new StringReader(script);
        bindings.put("request", (Object)req);
        bindings.put("reader", (Object)reader);
        bindings.put("response", (Object)resp);
        bindings.put("out", (Object)pw);
        bindings.put("osgi", (Object)osgi);
        bindings.put("bundleContext", (Object)this.getBundleContext());
        String lang = WebConsoleUtil.getParameter((HttpServletRequest)req, (String)"lang");
        boolean webClient = "webconsole".equals(WebConsoleUtil.getParameter((HttpServletRequest)req, (String)"client"));
        SimpleScriptContext sc = new SimpleScriptContext();
        sc.setBindings(bindings, 100);
        sc.setWriter(pw);
        sc.setErrorWriter(errorWriter);
        sc.setReader(reader);
        try {
            this.log.log(4, "Executing script" + script);
            this.eval(script, lang, sc);
        }
        catch (Throwable t) {
            if (!webClient) {
                resp.setStatus(500);
            }
            pw.println(this.exceptionToString(t));
            this.log.log(1, "Error in executing script", t);
        }
        finally {
            osgi.cleanup();
        }
    }

    private void eval(String script, String lang, ScriptContext ctx) throws ScriptException, IOException {
        ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByExtension(lang);
        if (scriptEngine == null) {
            throw new IllegalArgumentException("No ScriptEngineFactory found for extension " + lang);
        }
        Object ignored = scriptEngine.eval(script, ctx);
        ctx.getErrorWriter().flush();
    }

    private String getCodeValue(HttpServletRequest req) throws IOException {
        String script = WebConsoleUtil.getParameter((HttpServletRequest)req, (String)"code");
        if (script == null) {
            script = this.getContentFromFilePart(req, "code");
        }
        if (script == null) {
            throw new IllegalArgumentException("'code' parameter not passed");
        }
        return script;
    }

    private String getContentType(HttpServletRequest req) {
        String passedContentType = WebConsoleUtil.getParameter((HttpServletRequest)req, (String)"responseContentType");
        if (passedContentType != null) {
            return passedContentType;
        }
        return req.getPathInfo().endsWith(".json") ? "application/json" : "text/plain";
    }

    private String exceptionToString(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private static String[] processFileNames(String[] cssFiles) {
        String[] css = new String[cssFiles.length];
        for (int i = 0; i < cssFiles.length; ++i) {
            css[i] = "/sc" + CSS[i];
        }
        return css;
    }

    private String getScriptConfig() {
        try {
            return this.getScriptConfig0();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private String getScriptConfig0() throws JSONException {
        StringWriter sw = new StringWriter();
        JSONWriter jw = new JSONWriter((Writer)sw);
        jw.array();
        for (ScriptEngineFactory sef : this.scriptEngineManager.getEngineFactories()) {
            jw.object();
            if (sef.getExtensions().isEmpty()) continue;
            jw.key("langName").value((Object)sef.getLanguageName());
            jw.key("langCode").value((Object)sef.getExtensions().get(0));
            String mode = this.determineMode(sef.getExtensions());
            if (mode != null) {
                jw.key("mode").value((Object)mode);
            }
            jw.endObject();
        }
        jw.endArray();
        return sw.toString();
    }

    private String determineMode(List<String> extensions) {
        if (extensions.contains("groovy")) {
            return "groovy";
        }
        if (extensions.contains("esp")) {
            return "javascript";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContentFromFilePart(HttpServletRequest req, String paramName) throws IOException {
        String string;
        String value = WebConsoleUtil.getParameter((HttpServletRequest)req, (String)paramName);
        if (value != null) {
            return value;
        }
        Map params = (Map)req.getAttribute("org.apache.felix.webconsole.fileupload");
        if (params == null) {
            return null;
        }
        FileItem[] codeFile = this.getFileItems(params, paramName);
        if (codeFile.length == 0) {
            return null;
        }
        InputStream is = null;
        try {
            is = codeFile[0].getInputStream();
            StringWriter sw = new StringWriter();
            IOUtils.copy((InputStream)is, (Writer)sw, (String)"utf-8");
            string = sw.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return string;
    }

    private FileItem[] getFileItems(Map params, String name) {
        ArrayList<FileItem> files = new ArrayList<FileItem>();
        FileItem[] items = (FileItem[])params.get(name);
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i].isFormField() || items[i].getSize() <= 0L) continue;
                files.add(items[i]);
            }
        }
        return files.toArray(new FileItem[files.size()]);
    }

    public void dispose() {
        super.deactivate();
        if (this.registration != null) {
            this.registration.unregister();
        }
    }
}

