/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.WritableByteChannelMock;
import org.apache.hc.core5.http.nio.BasicDataStreamChannel;
import org.apache.hc.core5.http.nio.StreamChannel;
import org.apache.hc.core5.http.nio.entity.AbstractCharAsyncEntityProducer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestAbstractCharAsyncEntityProducer {
    TestAbstractCharAsyncEntityProducer() {
    }

    @Test
    void testProduceDataNoBuffering() throws Exception {
        ChunkCharAsyncEntityProducer producer = new ChunkCharAsyncEntityProducer(256, 0, ContentType.TEXT_PLAIN, "this", "this and that");
        Assertions.assertEquals((long)-1L, (long)producer.getContentLength());
        Assertions.assertEquals((Object)ContentType.TEXT_PLAIN.toString(), (Object)producer.getContentType());
        Assertions.assertNull((Object)producer.getContentEncoding());
        WritableByteChannelMock byteChannel = new WritableByteChannelMock(1024);
        BasicDataStreamChannel streamChannel = new BasicDataStreamChannel(byteChannel);
        producer.produce(streamChannel);
        Assertions.assertTrue((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"this", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
        producer.produce(streamChannel);
        Assertions.assertFalse((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"this and that", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
    }

    @Test
    void testProduceDataWithBuffering() throws Exception {
        ChunkCharAsyncEntityProducer producer = new ChunkCharAsyncEntityProducer(256, 5, ContentType.TEXT_PLAIN, "this", " and that", "all", " sorts of stuff");
        WritableByteChannelMock byteChannel = new WritableByteChannelMock(1024);
        BasicDataStreamChannel streamChannel = new BasicDataStreamChannel(byteChannel);
        producer.produce(streamChannel);
        Assertions.assertTrue((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
        producer.produce(streamChannel);
        Assertions.assertTrue((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"this and that", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
        producer.produce(streamChannel);
        Assertions.assertTrue((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
        producer.produce(streamChannel);
        Assertions.assertFalse((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"all sorts of stuff", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
    }

    private static class ChunkCharAsyncEntityProducer
    extends AbstractCharAsyncEntityProducer {
        private final String[] content;
        private int count = 0;

        public ChunkCharAsyncEntityProducer(int bufferSize, int fragmentSizeHint, ContentType contentType, String ... content) {
            super(bufferSize, fragmentSizeHint, contentType);
            this.content = content;
        }

        public boolean isRepeatable() {
            return false;
        }

        protected int availableData() {
            return Integer.MAX_VALUE;
        }

        protected void produceData(StreamChannel<CharBuffer> channel) throws IOException {
            if (this.count < this.content.length) {
                channel.write((Buffer)CharBuffer.wrap(this.content[this.count]));
            }
            ++this.count;
            if (this.count >= this.content.length) {
                channel.endStream();
            }
        }

        public void failed(Exception cause) {
        }
    }
}

