/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.recover;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.iotdb.db.sync.sender.recover.ISyncSenderLogger;

public class SyncSenderLogger
implements ISyncSenderLogger {
    private BufferedWriter bw;

    public SyncSenderLogger(File file) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        this.bw = new BufferedWriter(new FileWriter(file.getAbsolutePath()));
    }

    @Override
    public void startSyncDeletedFilesName() throws IOException {
        this.bw.write("sync deleted file names start");
        this.bw.newLine();
        this.bw.flush();
    }

    @Override
    public void finishSyncDeletedFileName(File file) throws IOException {
        this.bw.write(file.getAbsolutePath());
        this.bw.newLine();
        this.bw.flush();
    }

    @Override
    public void startSyncTsFiles() throws IOException {
        this.bw.write("sync tsfile start");
        this.bw.newLine();
        this.bw.flush();
    }

    @Override
    public void finishSyncTsfile(File file) throws IOException {
        this.bw.write(file.getAbsolutePath());
        this.bw.newLine();
        this.bw.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.bw != null) {
            this.bw.close();
            this.bw = null;
        }
    }
}

