/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics.client;

import com.librato.metrics.client.Authorization;
import com.librato.metrics.client.Duration;
import com.librato.metrics.client.Futures;
import com.librato.metrics.client.HttpResponse;
import com.librato.metrics.client.IBuildsPayload;
import com.librato.metrics.client.IMeasure;
import com.librato.metrics.client.IPoster;
import com.librato.metrics.client.IResponseConverter;
import com.librato.metrics.client.Json;
import com.librato.metrics.client.LibratoClientAttributes;
import com.librato.metrics.client.LibratoClientBuilder;
import com.librato.metrics.client.MDResponseConverter;
import com.librato.metrics.client.Maps;
import com.librato.metrics.client.Measures;
import com.librato.metrics.client.PostMeasuresResult;
import com.librato.metrics.client.PostResult;
import com.librato.metrics.client.SDResponseConverter;
import com.librato.metrics.client.Sanitizer;
import com.librato.metrics.client.Tags;
import com.librato.metrics.client.URIs;
import com.librato.metrics.client.Versions;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class LibratoClient {
    private static final String LIB_VERSION = Versions.getVersion("META-INF/maven/com.librato.metrics/librato-java/pom.properties", LibratoClient.class);
    private final URI uri;
    private final int batchSize;
    private final Duration connectTimeout;
    private final Duration readTimeout;
    private final IPoster poster;
    private final ExecutorService executor;
    private final SDResponseConverter sdResponseConverter = new SDResponseConverter();
    private final MDResponseConverter mdResponseConverter = new MDResponseConverter();
    private final Map<String, String> measurementPostHeaders = new HashMap<String, String>();

    public static LibratoClientBuilder builder(String email, String token) {
        return new LibratoClientBuilder(email, token);
    }

    LibratoClient(LibratoClientAttributes attrs) {
        this.uri = URIs.removePath(attrs.uri);
        this.batchSize = attrs.batchSize;
        this.connectTimeout = attrs.connectTimeout;
        this.readTimeout = attrs.readTimeout;
        this.poster = attrs.poster;
        SynchronousQueue<Runnable> queue = new SynchronousQueue<Runnable>();
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("librato-client");
                thread.setDaemon(true);
                return thread;
            }
        };
        this.executor = new ThreadPoolExecutor(0, attrs.maxInflightRequests, 10L, TimeUnit.SECONDS, queue, threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
        this.measurementPostHeaders.put("Content-Type", "application/json");
        this.measurementPostHeaders.put("Authorization", Authorization.buildAuthHeader(attrs.email, attrs.token));
        this.measurementPostHeaders.put("User-Agent", String.format("%s librato-java/%s", attrs.agentIdentifier, LIB_VERSION));
    }

    public PostMeasuresResult postMeasures(Measures measures) {
        PostMeasuresResult result = new PostMeasuresResult();
        if (measures.isEmpty()) {
            return result;
        }
        Future<List<PostResult>> sdFuture = null;
        Measures sdMeasures = measures.toSD();
        Measures mdMeasures = measures.toMD();
        if (!sdMeasures.isEmpty()) {
            sdFuture = this.postMeasures("/v1/metrics", sdMeasures, this.sdResponseConverter, new IBuildsPayload(){

                @Override
                public byte[] build(Measures measures) {
                    return LibratoClient.this.buildSDPayload(measures);
                }
            });
        }
        Future<List<PostResult>> mdFuture = null;
        if (!mdMeasures.isEmpty()) {
            mdFuture = this.postMeasures("/v1/measurements", mdMeasures, this.mdResponseConverter, new IBuildsPayload(){

                @Override
                public byte[] build(Measures measures) {
                    return LibratoClient.this.buildMDPayload(measures);
                }
            });
        }
        if (sdFuture != null) {
            result.results.addAll((Collection<PostResult>)Futures.get(sdFuture));
        }
        if (mdFuture != null) {
            result.results.addAll((Collection)Futures.get(mdFuture));
        }
        return result;
    }

    private Future<List<PostResult>> postMeasures(final String uri, final Measures measures, final IResponseConverter responseConverter, final IBuildsPayload payloadBuilder) {
        return this.executor.submit(new Callable<List<PostResult>>(){

            @Override
            public List<PostResult> call() throws Exception {
                LinkedList<PostResult> results = new LinkedList<PostResult>();
                for (Measures batch : measures.partition(LibratoClient.this.batchSize)) {
                    byte[] payload = payloadBuilder.build(batch);
                    try {
                        HttpResponse response = LibratoClient.this.poster.post(LibratoClient.this.fullUrl(uri), LibratoClient.this.connectTimeout, LibratoClient.this.readTimeout, LibratoClient.this.measurementPostHeaders, payload);
                        results.add(responseConverter.convert(payload, response));
                    }
                    catch (Exception e) {
                        results.add(responseConverter.convert(payload, e));
                    }
                }
                return results;
            }
        });
    }

    private byte[] buildSDPayload(Measures measures) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        Maps.putIfNotNull(payload, "measure_time", measures.getEpoch());
        Maps.putIfNotNull(payload, "source", Sanitizer.LAST_PASS.apply(measures.getSource()));
        Maps.putIfNotNull(payload, "period", measures.getPeriod());
        LinkedList<Map<String, Object>> gauges = new LinkedList<Map<String, Object>>();
        LinkedList<Map<String, Object>> counters = new LinkedList<Map<String, Object>>();
        for (IMeasure measure : measures.getMeasures()) {
            Map<String, Object> measureMap = measure.toMap();
            if (measure.isGauge()) {
                gauges.add(measureMap);
                continue;
            }
            counters.add(measureMap);
        }
        Maps.putIfNotEmpty(payload, "counters", counters);
        Maps.putIfNotEmpty(payload, "gauges", gauges);
        return Json.serialize(payload);
    }

    private byte[] buildMDPayload(Measures measures) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        Maps.putIfNotNull(payload, "time", measures.getEpoch());
        Maps.putIfNotNull(payload, "period", measures.getPeriod());
        if (!measures.getTags().isEmpty()) {
            payload.put("tags", Tags.toMap(measures.getTags()));
        }
        LinkedList<Map<String, Object>> gauges = new LinkedList<Map<String, Object>>();
        for (IMeasure measure : measures.getMeasures()) {
            Map<String, Object> measureMap = measure.toMap();
            gauges.add(measureMap);
        }
        Maps.putIfNotEmpty(payload, "measurements", gauges);
        return Json.serialize(payload);
    }

    private String fullUrl(String path) {
        return this.uri.toString() + path;
    }
}

