/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.callbacks;

import com.bugsnag.Report;
import com.bugsnag.callbacks.Callback;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DeviceCallback
implements Callback {
    private static volatile String hostname;
    private static volatile boolean hostnameInitialised;
    private static final Object LOCK;
    private static final int HOSTNAME_LOOKUP_TIMEOUT = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHostnameValue() {
        if (!hostnameInitialised) {
            Object object = LOCK;
            synchronized (object) {
                if (!hostnameInitialised) {
                    hostname = DeviceCallback.lookupHostname();
                    hostnameInitialised = true;
                }
            }
        }
        return hostname;
    }

    private static String lookupHostname() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return System.getenv("COMPUTERNAME");
        }
        String hostname = System.getenv("HOSTNAME");
        if (hostname != null) {
            return hostname;
        }
        FutureTask<String> future = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws UnknownHostException {
                return InetAddress.getLocalHost().getHostName();
            }
        });
        Thread resolverThread = new Thread(future, "Hostname Resolver");
        resolverThread.setDaemon(true);
        resolverThread.start();
        try {
            return future.get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return null;
    }

    public static void initializeCache() {
        Thread hostnameLookup = new Thread("Hostname Lookup"){

            @Override
            public void run() {
                DeviceCallback.getHostnameValue();
            }
        };
        hostnameLookup.setDaemon(true);
        hostnameLookup.start();
    }

    @Override
    public void beforeNotify(Report report) {
        report.addToTab("device", "osArch", System.getProperty("os.arch")).addToTab("device", "locale", Locale.getDefault()).setDeviceInfo("hostname", DeviceCallback.getHostnameValue()).setDeviceInfo("osName", System.getProperty("os.name")).setDeviceInfo("osVersion", System.getProperty("os.version"));
    }

    static {
        LOCK = new Object();
    }
}

