/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog.manager;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.writelog.manager.WriteLogNodeManager;
import org.apache.iotdb.db.writelog.node.ExclusiveWriteLogNode;
import org.apache.iotdb.db.writelog.node.WriteLogNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiFileLogNodeManager
implements WriteLogNodeManager,
IService {
    private static final Logger logger = LoggerFactory.getLogger(MultiFileLogNodeManager.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final long REGISTER_BUFFER_SLEEP_INTERVAL_IN_MS = config.getRegisterBufferSleepIntervalInMs();
    private static final long REGISTER_BUFFER_REJECT_THRESHOLD_IN_MS = config.getRegisterBufferRejectThresholdInMs();
    private final Map<String, WriteLogNode> nodeMap = new ConcurrentHashMap<String, WriteLogNode>();
    private ScheduledExecutorService executorService;
    private boolean firstReadOnly = true;

    private void forceTask() {
        if (IoTDBDescriptor.getInstance().getConfig().isReadOnly()) {
            if (this.firstReadOnly) {
                logger.warn("system mode is read-only, the force flush WAL task is stopped");
                this.firstReadOnly = false;
            }
            return;
        }
        this.firstReadOnly = true;
        if (Thread.interrupted()) {
            logger.info("WAL force thread exits.");
            return;
        }
        for (WriteLogNode node : this.nodeMap.values()) {
            try {
                node.forceSync();
            }
            catch (IOException e) {
                logger.error("Cannot force {}, because ", (Object)node, (Object)e);
            }
        }
    }

    private MultiFileLogNodeManager() {
    }

    public static MultiFileLogNodeManager getInstance() {
        return InstanceHolder.instance;
    }

    @Override
    public WriteLogNode getNode(String identifier, Supplier<ByteBuffer[]> supplier) {
        WriteLogNode node = this.nodeMap.get(identifier);
        if (node == null) {
            node = new ExclusiveWriteLogNode(identifier);
            WriteLogNode oldNode = this.nodeMap.putIfAbsent(identifier, node);
            if (oldNode != null) {
                node = oldNode;
            } else {
                ByteBuffer[] buffers = supplier.get();
                int sleepTimeInMs = 0;
                while (buffers == null) {
                    if (sleepTimeInMs == 0) {
                        logger.error("Cannot allocate bytebuffer for wal, please reduce wal_buffer_size or storage groups number");
                    }
                    try {
                        Thread.sleep(REGISTER_BUFFER_SLEEP_INTERVAL_IN_MS);
                        sleepTimeInMs = (int)((long)sleepTimeInMs + REGISTER_BUFFER_SLEEP_INTERVAL_IN_MS);
                    }
                    catch (InterruptedException e) {
                        this.nodeMap.remove(identifier);
                    }
                    if ((long)sleepTimeInMs >= REGISTER_BUFFER_REJECT_THRESHOLD_IN_MS) {
                        this.nodeMap.remove(identifier);
                        throw new RuntimeException("Cannot allocate bytebuffer for wal, please reduce wal_buffer_size or storage groups number");
                    }
                    buffers = supplier.get();
                }
                node.initBuffer(buffers);
            }
        }
        return node;
    }

    @Override
    public void deleteNode(String identifier, Consumer<ByteBuffer[]> consumer) throws IOException {
        WriteLogNode node = this.nodeMap.remove(identifier);
        if (node != null) {
            consumer.accept(node.delete());
        }
    }

    public void closeNode(String identifier) throws IOException {
        WriteLogNode node = this.nodeMap.remove(identifier);
        if (node != null) {
            try {
                node.close();
            }
            catch (IOException e) {
                logger.error("failed to close {}", (Object)node, (Object)e);
            }
            node.release();
        }
    }

    @Override
    public void close() {
        logger.info("{} nodes to be closed", (Object)this.nodeMap.size());
        for (WriteLogNode node : this.nodeMap.values()) {
            try {
                node.close();
            }
            catch (IOException e) {
                logger.error("failed to close {}", (Object)node, (Object)e);
            }
            node.release();
        }
        this.nodeMap.clear();
        logger.info("LogNodeManager closed.");
    }

    @Override
    public void start() throws StartupException {
        try {
            if (!config.isEnableWal()) {
                return;
            }
            if (config.getForceWalPeriodInMs() > 0L) {
                this.executorService = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor("WAL-ForceSync");
                this.executorService.scheduleWithFixedDelay(this::forceTask, config.getForceWalPeriodInMs(), config.getForceWalPeriodInMs(), TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    @Override
    public void stop() {
        if (!config.isEnableWal()) {
            return;
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("force flush wal thread still doesn't exit after 30s");
                Thread.currentThread().interrupt();
            }
        }
        this.close();
    }

    @Override
    public ServiceType getID() {
        return ServiceType.WAL_SERVICE;
    }

    private static class InstanceHolder {
        private static final MultiFileLogNodeManager instance = new MultiFileLogNodeManager();

        private InstanceHolder() {
        }
    }
}

